/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SetUtils {
    private SetUtils() {
    }

    public static final <X> Set<X> concurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    public static <T> Set<T> intersection(Set<? extends T> setLeft, Set<? extends T> setRight) {
        HashSet<T> results = new HashSet<T>(setLeft);
        results.retainAll(setRight);
        return results;
    }

    public static <T> boolean intersectionP(Set<? extends T> s1, Set<? extends T> s2) {
        return s1.stream().anyMatch(s2::contains);
    }

    public static <T> Set<T> union(Set<? extends T> s1, Set<? extends T> s2) {
        HashSet<T> s3 = new HashSet<T>(s1);
        s3.addAll(s2);
        return s3;
    }

    public static <T> Set<T> symmetricDifference(Set<? extends T> s1, Set<? extends T> s2) {
        HashSet s3 = new HashSet();
        s1.forEach(x -> {
            if (!s2.contains(x)) {
                s3.add(x);
            }
        });
        s2.forEach(x -> {
            if (!s1.contains(x)) {
                s3.add(x);
            }
        });
        return s3;
    }

    public static <T> Set<T> difference(Set<? extends T> s1, Set<? extends T> s2) {
        HashSet<T> s3 = new HashSet<T>(s1);
        s3.removeAll(s2);
        return s3;
    }
}

