/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.ModelAssembler;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.GenericRuleReasonerFactory;

public class InfModelAssembler
extends ModelAssembler {
    @Override
    protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.InfModel);
        Model base = this.getBase(a, root, mode);
        Reasoner reasoner = this.getReasoner(a, root);
        InfModel result = ModelFactory.createInfModel(reasoner, base);
        return result;
    }

    protected Model getBase(Assembler a, Resource root, Mode mode) {
        Resource base = InfModelAssembler.getUniqueResource(root, JA.baseModel);
        return base == null ? ModelFactory.createDefaultModel() : a.openModel(base, mode);
    }

    protected Reasoner getReasoner(Assembler a, Resource root) {
        return this.getReasonerFactory(a, root).create(root);
    }

    protected ReasonerFactory getReasonerFactory(Assembler a, Resource root) {
        Resource factory = InfModelAssembler.getUniqueResource(root, JA.reasoner);
        return factory == null ? GenericRuleReasonerFactory.theInstance() : (ReasonerFactory)a.open(factory);
    }
}

