/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "./ibus-portal-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.IBus.Portal
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IBusDbusPortal
 * @title: IBusDbusPortal
 * @short_description: Generated C code for the org.freedesktop.IBus.Portal D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.IBus.Portal ---- */

static const _ExtendedGDBusArgInfo _ibus_dbus_portal_method_info_create_input_context_IN_ARG_client_name =
{
  {
    -1,
    (gchar *) "client_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_portal_method_info_create_input_context_IN_ARG_pointers[] =
{
  &_ibus_dbus_portal_method_info_create_input_context_IN_ARG_client_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ibus_dbus_portal_method_info_create_input_context_OUT_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_portal_method_info_create_input_context_OUT_ARG_pointers[] =
{
  &_ibus_dbus_portal_method_info_create_input_context_OUT_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_portal_method_info_create_input_context =
{
  {
    -1,
    (gchar *) "CreateInputContext",
    (GDBusArgInfo **) &_ibus_dbus_portal_method_info_create_input_context_IN_ARG_pointers,
    (GDBusArgInfo **) &_ibus_dbus_portal_method_info_create_input_context_OUT_ARG_pointers,
    NULL
  },
  "handle-create-input-context",
  FALSE
};

static const GDBusMethodInfo * const _ibus_dbus_portal_method_info_pointers[] =
{
  &_ibus_dbus_portal_method_info_create_input_context.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ibus_dbus_portal_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.IBus.Portal",
    (GDBusMethodInfo **) &_ibus_dbus_portal_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "portal",
};


/**
 * ibus_dbus_portal_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ibus_dbus_portal_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct;
}

/**
 * ibus_dbus_portal_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IBusDbusPortal interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ibus_dbus_portal_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * IBusDbusPortal:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link>.
 */

/**
 * IBusDbusPortalIface:
 * @parent_iface: The parent interface.
 * @handle_create_input_context: Handler for the #IBusDbusPortal::handle-create-input-context signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link>.
 */

typedef IBusDbusPortalIface IBusDbusPortalInterface;
G_DEFINE_INTERFACE (IBusDbusPortal, ibus_dbus_portal, G_TYPE_OBJECT)

static void
ibus_dbus_portal_default_init (IBusDbusPortalIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IBusDbusPortal::handle-create-input-context:
   * @object: A #IBusDbusPortal.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_client_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-Portal.CreateInputContext">CreateInputContext()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_portal_complete_create_input_context() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-input-context",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusPortalIface, handle_create_input_context),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

}

/**
 * ibus_dbus_portal_call_create_input_context:
 * @proxy: A #IBusDbusPortalProxy.
 * @arg_client_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-Portal.CreateInputContext">CreateInputContext()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_portal_call_create_input_context_finish() to get the result of the operation.
 *
 * See ibus_dbus_portal_call_create_input_context_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_portal_call_create_input_context (
    IBusDbusPortal *proxy,
    const gchar *arg_client_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateInputContext",
    g_variant_new ("(s)",
                   arg_client_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_portal_call_create_input_context_finish:
 * @proxy: A #IBusDbusPortalProxy.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_portal_call_create_input_context().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_portal_call_create_input_context().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_portal_call_create_input_context_finish (
    IBusDbusPortal *proxy,
    gchar **out_object_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_portal_call_create_input_context_sync:
 * @proxy: A #IBusDbusPortalProxy.
 * @arg_client_name: Argument to pass with the method invocation.
 * @out_object_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-Portal.CreateInputContext">CreateInputContext()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_portal_call_create_input_context() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_portal_call_create_input_context_sync (
    IBusDbusPortal *proxy,
    const gchar *arg_client_name,
    gchar **out_object_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateInputContext",
    g_variant_new ("(s)",
                   arg_client_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_object_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_portal_complete_create_input_context:
 * @object: A #IBusDbusPortal.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @object_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-Portal.CreateInputContext">CreateInputContext()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_portal_complete_create_input_context (
    IBusDbusPortal *object,
    GDBusMethodInvocation *invocation,
    const gchar *object_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   object_path));
}

/* ------------------------------------------------------------------------ */

/**
 * IBusDbusPortalProxy:
 *
 * The #IBusDbusPortalProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusPortalProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusPortalProxy.
 */

struct _IBusDbusPortalProxyPrivate
{
  GData *qdata;
};

static void ibus_dbus_portal_proxy_iface_init (IBusDbusPortalIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusPortalProxy, ibus_dbus_portal_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IBusDbusPortalProxy)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_PORTAL, ibus_dbus_portal_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusPortalProxy, ibus_dbus_portal_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_PORTAL, ibus_dbus_portal_proxy_iface_init))

#endif
static void
ibus_dbus_portal_proxy_finalize (GObject *object)
{
  IBusDbusPortalProxy *proxy = IBUS_DBUS_PORTAL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ibus_dbus_portal_proxy_parent_class)->finalize (object);
}

static void
ibus_dbus_portal_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ibus_dbus_portal_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ibus_dbus_portal_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IBUS_DBUS_TYPE_PORTAL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_PORTAL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ibus_dbus_portal_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IBusDbusPortalProxy *proxy = IBUS_DBUS_PORTAL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ibus_dbus_portal_proxy_init (IBusDbusPortalProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ibus_dbus_portal_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IBUS_DBUS_TYPE_PORTAL_PROXY, IBusDbusPortalProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ibus_dbus_portal_interface_info ());
}

static void
ibus_dbus_portal_proxy_class_init (IBusDbusPortalProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ibus_dbus_portal_proxy_finalize;
  gobject_class->get_property = ibus_dbus_portal_proxy_get_property;
  gobject_class->set_property = ibus_dbus_portal_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ibus_dbus_portal_proxy_g_signal;
  proxy_class->g_properties_changed = ibus_dbus_portal_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusPortalProxyPrivate));
#endif
}

static void
ibus_dbus_portal_proxy_iface_init (IBusDbusPortalIface *iface)
{
}

/**
 * ibus_dbus_portal_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_portal_proxy_new_finish() to get the result of the operation.
 *
 * See ibus_dbus_portal_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_portal_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_PORTAL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Portal", NULL);
}

/**
 * ibus_dbus_portal_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_portal_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_portal_proxy_new().
 *
 * Returns: (transfer full) (type IBusDbusPortalProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusPortal *
ibus_dbus_portal_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_PORTAL (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_portal_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_portal_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusPortalProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusPortal *
ibus_dbus_portal_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_PORTAL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Portal", NULL);
  if (ret != NULL)
    return IBUS_DBUS_PORTAL (ret);
  else
    return NULL;
}


/**
 * ibus_dbus_portal_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ibus_dbus_portal_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_portal_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ibus_dbus_portal_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_portal_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_PORTAL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Portal", NULL);
}

/**
 * ibus_dbus_portal_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_portal_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_portal_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IBusDbusPortalProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusPortal *
ibus_dbus_portal_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_PORTAL (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_portal_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ibus_dbus_portal_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_portal_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusPortalProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusPortal *
ibus_dbus_portal_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_PORTAL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Portal", NULL);
  if (ret != NULL)
    return IBUS_DBUS_PORTAL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IBusDbusPortalSkeleton:
 *
 * The #IBusDbusPortalSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusPortalSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusPortalSkeleton.
 */

struct _IBusDbusPortalSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ibus_dbus_portal_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IBusDbusPortalSkeleton *skeleton = IBUS_DBUS_PORTAL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IBUS_DBUS_TYPE_PORTAL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_PORTAL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ibus_dbus_portal_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IBusDbusPortalSkeleton *skeleton = IBUS_DBUS_PORTAL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ibus_dbus_portal_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IBusDbusPortalSkeleton *skeleton = IBUS_DBUS_PORTAL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_portal_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ibus_dbus_portal_skeleton_vtable =
{
  _ibus_dbus_portal_skeleton_handle_method_call,
  _ibus_dbus_portal_skeleton_handle_get_property,
  _ibus_dbus_portal_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ibus_dbus_portal_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ibus_dbus_portal_interface_info ();
}

static GDBusInterfaceVTable *
ibus_dbus_portal_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ibus_dbus_portal_skeleton_vtable;
}

static GVariant *
ibus_dbus_portal_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IBusDbusPortalSkeleton *skeleton = IBUS_DBUS_PORTAL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ibus_dbus_portal_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ibus_dbus_portal_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ibus_dbus_portal_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ibus_dbus_portal_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.Portal", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ibus_dbus_portal_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void ibus_dbus_portal_skeleton_iface_init (IBusDbusPortalIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusPortalSkeleton, ibus_dbus_portal_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IBusDbusPortalSkeleton)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_PORTAL, ibus_dbus_portal_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusPortalSkeleton, ibus_dbus_portal_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_PORTAL, ibus_dbus_portal_skeleton_iface_init))

#endif
static void
ibus_dbus_portal_skeleton_finalize (GObject *object)
{
  IBusDbusPortalSkeleton *skeleton = IBUS_DBUS_PORTAL_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ibus_dbus_portal_skeleton_parent_class)->finalize (object);
}

static void
ibus_dbus_portal_skeleton_init (IBusDbusPortalSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ibus_dbus_portal_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IBUS_DBUS_TYPE_PORTAL_SKELETON, IBusDbusPortalSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ibus_dbus_portal_skeleton_class_init (IBusDbusPortalSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ibus_dbus_portal_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ibus_dbus_portal_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ibus_dbus_portal_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ibus_dbus_portal_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ibus_dbus_portal_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusPortalSkeletonPrivate));
#endif
}

static void
ibus_dbus_portal_skeleton_iface_init (IBusDbusPortalIface *iface)
{
}

/**
 * ibus_dbus_portal_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Portal.top_of_page">org.freedesktop.IBus.Portal</link>.
 *
 * Returns: (transfer full) (type IBusDbusPortalSkeleton): The skeleton object.
 */
IBusDbusPortal *
ibus_dbus_portal_skeleton_new (void)
{
  return IBUS_DBUS_PORTAL (g_object_new (IBUS_DBUS_TYPE_PORTAL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.IBus.InputContext
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IBusDbusInputContext
 * @title: IBusDbusInputContext
 * @short_description: Generated C code for the org.freedesktop.IBus.InputContext D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.IBus.InputContext ---- */

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_process_key_event_IN_ARG_keyval =
{
  {
    -1,
    (gchar *) "keyval",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_process_key_event_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_process_key_event_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_process_key_event_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_process_key_event_IN_ARG_keyval.parent_struct,
  &_ibus_dbus_input_context_method_info_process_key_event_IN_ARG_keycode.parent_struct,
  &_ibus_dbus_input_context_method_info_process_key_event_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_process_key_event_OUT_ARG_handled =
{
  {
    -1,
    (gchar *) "handled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_process_key_event_OUT_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_process_key_event_OUT_ARG_handled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_process_key_event =
{
  {
    -1,
    (gchar *) "ProcessKeyEvent",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_process_key_event_IN_ARG_pointers,
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_process_key_event_OUT_ARG_pointers,
    NULL
  },
  "handle-process-key-event",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_w =
{
  {
    -1,
    (gchar *) "w",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_h =
{
  {
    -1,
    (gchar *) "h",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_x.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_y.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_w.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_h.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_set_cursor_location =
{
  {
    -1,
    (gchar *) "SetCursorLocation",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_set_cursor_location_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-cursor-location",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_w =
{
  {
    -1,
    (gchar *) "w",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_h =
{
  {
    -1,
    (gchar *) "h",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_x.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_y.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_w.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_h.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_set_cursor_location_relative =
{
  {
    -1,
    (gchar *) "SetCursorLocationRelative",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_set_cursor_location_relative_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-cursor-location-relative",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_process_hand_writing_event_IN_ARG_coordinates =
{
  {
    -1,
    (gchar *) "coordinates",
    (gchar *) "ad",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_process_hand_writing_event_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_process_hand_writing_event_IN_ARG_coordinates.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_process_hand_writing_event =
{
  {
    -1,
    (gchar *) "ProcessHandWritingEvent",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_process_hand_writing_event_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-process-hand-writing-event",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_cancel_hand_writing_IN_ARG_n_strokes =
{
  {
    -1,
    (gchar *) "n_strokes",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_cancel_hand_writing_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_cancel_hand_writing_IN_ARG_n_strokes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_cancel_hand_writing =
{
  {
    -1,
    (gchar *) "CancelHandWriting",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_cancel_hand_writing_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel-hand-writing",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_focus_in =
{
  {
    -1,
    (gchar *) "FocusIn",
    NULL,
    NULL,
    NULL
  },
  "handle-focus-in",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_focus_out =
{
  {
    -1,
    (gchar *) "FocusOut",
    NULL,
    NULL,
    NULL
  },
  "handle-focus-out",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_reset =
{
  {
    -1,
    (gchar *) "Reset",
    NULL,
    NULL,
    NULL
  },
  "handle-reset",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_capabilities_IN_ARG_caps =
{
  {
    -1,
    (gchar *) "caps",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_set_capabilities_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_set_capabilities_IN_ARG_caps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_set_capabilities =
{
  {
    -1,
    (gchar *) "SetCapabilities",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_set_capabilities_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-capabilities",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_property_activate_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_property_activate_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_property_activate_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_property_activate_IN_ARG_name.parent_struct,
  &_ibus_dbus_input_context_method_info_property_activate_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_property_activate =
{
  {
    -1,
    (gchar *) "PropertyActivate",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_property_activate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-property-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_engine_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_set_engine_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_set_engine_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_set_engine =
{
  {
    -1,
    (gchar *) "SetEngine",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_set_engine_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-engine",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_get_engine_OUT_ARG_desc =
{
  {
    -1,
    (gchar *) "desc",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_get_engine_OUT_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_get_engine_OUT_ARG_desc.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_get_engine =
{
  {
    -1,
    (gchar *) "GetEngine",
    NULL,
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_get_engine_OUT_ARG_pointers,
    NULL
  },
  "handle-get-engine",
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_cursor_pos =
{
  {
    -1,
    (gchar *) "cursor_pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_anchor_pos =
{
  {
    -1,
    (gchar *) "anchor_pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_pointers[] =
{
  &_ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_text.parent_struct,
  &_ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_cursor_pos.parent_struct,
  &_ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_anchor_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ibus_dbus_input_context_method_info_set_surrounding_text =
{
  {
    -1,
    (gchar *) "SetSurroundingText",
    (GDBusArgInfo **) &_ibus_dbus_input_context_method_info_set_surrounding_text_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-surrounding-text",
  FALSE
};

static const GDBusMethodInfo * const _ibus_dbus_input_context_method_info_pointers[] =
{
  &_ibus_dbus_input_context_method_info_process_key_event.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location.parent_struct,
  &_ibus_dbus_input_context_method_info_set_cursor_location_relative.parent_struct,
  &_ibus_dbus_input_context_method_info_process_hand_writing_event.parent_struct,
  &_ibus_dbus_input_context_method_info_cancel_hand_writing.parent_struct,
  &_ibus_dbus_input_context_method_info_focus_in.parent_struct,
  &_ibus_dbus_input_context_method_info_focus_out.parent_struct,
  &_ibus_dbus_input_context_method_info_reset.parent_struct,
  &_ibus_dbus_input_context_method_info_set_capabilities.parent_struct,
  &_ibus_dbus_input_context_method_info_property_activate.parent_struct,
  &_ibus_dbus_input_context_method_info_set_engine.parent_struct,
  &_ibus_dbus_input_context_method_info_get_engine.parent_struct,
  &_ibus_dbus_input_context_method_info_set_surrounding_text.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_commit_text_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_commit_text_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_commit_text_ARG_text.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_commit_text =
{
  {
    -1,
    (gchar *) "CommitText",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_commit_text_ARG_pointers,
    NULL
  },
  "commit-text"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_forward_key_event_ARG_keyval =
{
  {
    -1,
    (gchar *) "keyval",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_forward_key_event_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_forward_key_event_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_forward_key_event_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_forward_key_event_ARG_keyval.parent_struct,
  &_ibus_dbus_input_context_signal_info_forward_key_event_ARG_keycode.parent_struct,
  &_ibus_dbus_input_context_signal_info_forward_key_event_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_forward_key_event =
{
  {
    -1,
    (gchar *) "ForwardKeyEvent",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_forward_key_event_ARG_pointers,
    NULL
  },
  "forward-key-event"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_ARG_cursor_pos =
{
  {
    -1,
    (gchar *) "cursor_pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_ARG_visible =
{
  {
    -1,
    (gchar *) "visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_update_preedit_text_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_update_preedit_text_ARG_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_ARG_cursor_pos.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_ARG_visible.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_update_preedit_text =
{
  {
    -1,
    (gchar *) "UpdatePreeditText",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_update_preedit_text_ARG_pointers,
    NULL
  },
  "update-preedit-text"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_cursor_pos =
{
  {
    -1,
    (gchar *) "cursor_pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_visible =
{
  {
    -1,
    (gchar *) "visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_cursor_pos.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_visible.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_update_preedit_text_with_mode =
{
  {
    -1,
    (gchar *) "UpdatePreeditTextWithMode",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode_ARG_pointers,
    NULL
  },
  "update-preedit-text-with-mode"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_show_preedit_text =
{
  {
    -1,
    (gchar *) "ShowPreeditText",
    NULL,
    NULL
  },
  "show-preedit-text"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_hide_preedit_text =
{
  {
    -1,
    (gchar *) "HidePreeditText",
    NULL,
    NULL
  },
  "hide-preedit-text"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_visible =
{
  {
    -1,
    (gchar *) "visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_visible.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_update_auxiliary_text =
{
  {
    -1,
    (gchar *) "UpdateAuxiliaryText",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_update_auxiliary_text_ARG_pointers,
    NULL
  },
  "update-auxiliary-text"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_show_auxiliary_text =
{
  {
    -1,
    (gchar *) "ShowAuxiliaryText",
    NULL,
    NULL
  },
  "show-auxiliary-text"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_hide_auxiliary_text =
{
  {
    -1,
    (gchar *) "HideAuxiliaryText",
    NULL,
    NULL
  },
  "hide-auxiliary-text"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_lookup_table_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_lookup_table_ARG_visible =
{
  {
    -1,
    (gchar *) "visible",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_update_lookup_table_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_update_lookup_table_ARG_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_lookup_table_ARG_visible.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_update_lookup_table =
{
  {
    -1,
    (gchar *) "UpdateLookupTable",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_update_lookup_table_ARG_pointers,
    NULL
  },
  "update-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_show_lookup_table =
{
  {
    -1,
    (gchar *) "ShowLookupTable",
    NULL,
    NULL
  },
  "show-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_hide_lookup_table =
{
  {
    -1,
    (gchar *) "HideLookupTable",
    NULL,
    NULL
  },
  "hide-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_page_up_lookup_table =
{
  {
    -1,
    (gchar *) "PageUpLookupTable",
    NULL,
    NULL
  },
  "page-up-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_page_down_lookup_table =
{
  {
    -1,
    (gchar *) "PageDownLookupTable",
    NULL,
    NULL
  },
  "page-down-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_cursor_up_lookup_table =
{
  {
    -1,
    (gchar *) "CursorUpLookupTable",
    NULL,
    NULL
  },
  "cursor-up-lookup-table"
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_cursor_down_lookup_table =
{
  {
    -1,
    (gchar *) "CursorDownLookupTable",
    NULL,
    NULL
  },
  "cursor-down-lookup-table"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_register_properties_ARG_props =
{
  {
    -1,
    (gchar *) "props",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_register_properties_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_register_properties_ARG_props.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_register_properties =
{
  {
    -1,
    (gchar *) "RegisterProperties",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_register_properties_ARG_pointers,
    NULL
  },
  "register-properties"
};

static const _ExtendedGDBusArgInfo _ibus_dbus_input_context_signal_info_update_property_ARG_prop =
{
  {
    -1,
    (gchar *) "prop",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ibus_dbus_input_context_signal_info_update_property_ARG_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_update_property_ARG_prop.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ibus_dbus_input_context_signal_info_update_property =
{
  {
    -1,
    (gchar *) "UpdateProperty",
    (GDBusArgInfo **) &_ibus_dbus_input_context_signal_info_update_property_ARG_pointers,
    NULL
  },
  "update-property"
};

static const GDBusSignalInfo * const _ibus_dbus_input_context_signal_info_pointers[] =
{
  &_ibus_dbus_input_context_signal_info_commit_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_forward_key_event.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_preedit_text_with_mode.parent_struct,
  &_ibus_dbus_input_context_signal_info_show_preedit_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_hide_preedit_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_auxiliary_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_show_auxiliary_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_hide_auxiliary_text.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_show_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_hide_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_page_up_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_page_down_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_cursor_up_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_cursor_down_lookup_table.parent_struct,
  &_ibus_dbus_input_context_signal_info_register_properties.parent_struct,
  &_ibus_dbus_input_context_signal_info_update_property.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ibus_dbus_input_context_property_info_content_type =
{
  {
    -1,
    (gchar *) "ContentType",
    (gchar *) "(uu)",
    G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "content-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ibus_dbus_input_context_property_info_client_commit_preedit =
{
  {
    -1,
    (gchar *) "ClientCommitPreedit",
    (gchar *) "(b)",
    G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "client-commit-preedit",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ibus_dbus_input_context_property_info_pointers[] =
{
  &_ibus_dbus_input_context_property_info_content_type.parent_struct,
  &_ibus_dbus_input_context_property_info_client_commit_preedit.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ibus_dbus_input_context_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.IBus.InputContext",
    (GDBusMethodInfo **) &_ibus_dbus_input_context_method_info_pointers,
    (GDBusSignalInfo **) &_ibus_dbus_input_context_signal_info_pointers,
    (GDBusPropertyInfo **) &_ibus_dbus_input_context_property_info_pointers,
    NULL
  },
  "input-context",
};


/**
 * ibus_dbus_input_context_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ibus_dbus_input_context_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct;
}

/**
 * ibus_dbus_input_context_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IBusDbusInputContext interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ibus_dbus_input_context_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "content-type");
  g_object_class_override_property (klass, property_id_begin++, "client-commit-preedit");
  return property_id_begin - 1;
}



/**
 * IBusDbusInputContext:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link>.
 */

/**
 * IBusDbusInputContextIface:
 * @parent_iface: The parent interface.
 * @handle_cancel_hand_writing: Handler for the #IBusDbusInputContext::handle-cancel-hand-writing signal.
 * @handle_focus_in: Handler for the #IBusDbusInputContext::handle-focus-in signal.
 * @handle_focus_out: Handler for the #IBusDbusInputContext::handle-focus-out signal.
 * @handle_get_engine: Handler for the #IBusDbusInputContext::handle-get-engine signal.
 * @handle_process_hand_writing_event: Handler for the #IBusDbusInputContext::handle-process-hand-writing-event signal.
 * @handle_process_key_event: Handler for the #IBusDbusInputContext::handle-process-key-event signal.
 * @handle_property_activate: Handler for the #IBusDbusInputContext::handle-property-activate signal.
 * @handle_reset: Handler for the #IBusDbusInputContext::handle-reset signal.
 * @handle_set_capabilities: Handler for the #IBusDbusInputContext::handle-set-capabilities signal.
 * @handle_set_cursor_location: Handler for the #IBusDbusInputContext::handle-set-cursor-location signal.
 * @handle_set_cursor_location_relative: Handler for the #IBusDbusInputContext::handle-set-cursor-location-relative signal.
 * @handle_set_engine: Handler for the #IBusDbusInputContext::handle-set-engine signal.
 * @handle_set_surrounding_text: Handler for the #IBusDbusInputContext::handle-set-surrounding-text signal.
 * @get_client_commit_preedit: Getter for the #IBusDbusInputContext:client-commit-preedit property.
 * @get_content_type: Getter for the #IBusDbusInputContext:content-type property.
 * @commit_text: Handler for the #IBusDbusInputContext::commit-text signal.
 * @cursor_down_lookup_table: Handler for the #IBusDbusInputContext::cursor-down-lookup-table signal.
 * @cursor_up_lookup_table: Handler for the #IBusDbusInputContext::cursor-up-lookup-table signal.
 * @forward_key_event: Handler for the #IBusDbusInputContext::forward-key-event signal.
 * @hide_auxiliary_text: Handler for the #IBusDbusInputContext::hide-auxiliary-text signal.
 * @hide_lookup_table: Handler for the #IBusDbusInputContext::hide-lookup-table signal.
 * @hide_preedit_text: Handler for the #IBusDbusInputContext::hide-preedit-text signal.
 * @page_down_lookup_table: Handler for the #IBusDbusInputContext::page-down-lookup-table signal.
 * @page_up_lookup_table: Handler for the #IBusDbusInputContext::page-up-lookup-table signal.
 * @register_properties: Handler for the #IBusDbusInputContext::register-properties signal.
 * @show_auxiliary_text: Handler for the #IBusDbusInputContext::show-auxiliary-text signal.
 * @show_lookup_table: Handler for the #IBusDbusInputContext::show-lookup-table signal.
 * @show_preedit_text: Handler for the #IBusDbusInputContext::show-preedit-text signal.
 * @update_auxiliary_text: Handler for the #IBusDbusInputContext::update-auxiliary-text signal.
 * @update_lookup_table: Handler for the #IBusDbusInputContext::update-lookup-table signal.
 * @update_preedit_text: Handler for the #IBusDbusInputContext::update-preedit-text signal.
 * @update_preedit_text_with_mode: Handler for the #IBusDbusInputContext::update-preedit-text-with-mode signal.
 * @update_property: Handler for the #IBusDbusInputContext::update-property signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link>.
 */

typedef IBusDbusInputContextIface IBusDbusInputContextInterface;
G_DEFINE_INTERFACE (IBusDbusInputContext, ibus_dbus_input_context, G_TYPE_OBJECT)

static void
ibus_dbus_input_context_default_init (IBusDbusInputContextIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IBusDbusInputContext::handle-process-key-event:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keyval: Argument passed by remote caller.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessKeyEvent">ProcessKeyEvent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_process_key_event() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-process-key-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_process_key_event),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::handle-set-cursor-location:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_w: Argument passed by remote caller.
   * @arg_h: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocation">SetCursorLocation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_set_cursor_location() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-cursor-location",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_set_cursor_location),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * IBusDbusInputContext::handle-set-cursor-location-relative:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_w: Argument passed by remote caller.
   * @arg_h: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocationRelative">SetCursorLocationRelative()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_set_cursor_location_relative() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-cursor-location-relative",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_set_cursor_location_relative),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * IBusDbusInputContext::handle-process-hand-writing-event:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_coordinates: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessHandWritingEvent">ProcessHandWritingEvent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_process_hand_writing_event() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-process-hand-writing-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_process_hand_writing_event),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * IBusDbusInputContext::handle-cancel-hand-writing:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_n_strokes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.CancelHandWriting">CancelHandWriting()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_cancel_hand_writing() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-hand-writing",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_cancel_hand_writing),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::handle-focus-in:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusIn">FocusIn()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_focus_in() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-focus-in",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_focus_in),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IBusDbusInputContext::handle-focus-out:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusOut">FocusOut()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_focus_out() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-focus-out",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_focus_out),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IBusDbusInputContext::handle-reset:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.Reset">Reset()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_reset() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_reset),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IBusDbusInputContext::handle-set-capabilities:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_caps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCapabilities">SetCapabilities()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_set_capabilities() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-capabilities",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_set_capabilities),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::handle-property-activate:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.PropertyActivate">PropertyActivate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_property_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-property-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_property_activate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::handle-set-engine:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetEngine">SetEngine()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_set_engine() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-engine",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_set_engine),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IBusDbusInputContext::handle-get-engine:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.GetEngine">GetEngine()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_get_engine() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-engine",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_get_engine),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IBusDbusInputContext::handle-set-surrounding-text:
   * @object: A #IBusDbusInputContext.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_text: Argument passed by remote caller.
   * @arg_cursor_pos: Argument passed by remote caller.
   * @arg_anchor_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetSurroundingText">SetSurroundingText()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_input_context_complete_set_surrounding_text() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-surrounding-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, handle_set_surrounding_text),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * IBusDbusInputContext::commit-text:
   * @object: A #IBusDbusInputContext.
   * @arg_text: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CommitText">"CommitText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("commit-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, commit_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * IBusDbusInputContext::forward-key-event:
   * @object: A #IBusDbusInputContext.
   * @arg_keyval: Argument.
   * @arg_keycode: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ForwardKeyEvent">"ForwardKeyEvent"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("forward-key-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, forward_key_event),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::update-preedit-text:
   * @object: A #IBusDbusInputContext.
   * @arg_text: Argument.
   * @arg_cursor_pos: Argument.
   * @arg_visible: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdatePreeditText">"UpdatePreeditText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-preedit-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, update_preedit_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * IBusDbusInputContext::update-preedit-text-with-mode:
   * @object: A #IBusDbusInputContext.
   * @arg_text: Argument.
   * @arg_cursor_pos: Argument.
   * @arg_visible: Argument.
   * @arg_mode: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdatePreeditTextWithMode">"UpdatePreeditTextWithMode"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-preedit-text-with-mode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, update_preedit_text_with_mode),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    4, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_BOOLEAN, G_TYPE_UINT);

  /**
   * IBusDbusInputContext::show-preedit-text:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowPreeditText">"ShowPreeditText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("show-preedit-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, show_preedit_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::hide-preedit-text:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HidePreeditText">"HidePreeditText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("hide-preedit-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, hide_preedit_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::update-auxiliary-text:
   * @object: A #IBusDbusInputContext.
   * @arg_text: Argument.
   * @arg_visible: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateAuxiliaryText">"UpdateAuxiliaryText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-auxiliary-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, update_auxiliary_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_VARIANT, G_TYPE_BOOLEAN);

  /**
   * IBusDbusInputContext::show-auxiliary-text:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowAuxiliaryText">"ShowAuxiliaryText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("show-auxiliary-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, show_auxiliary_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::hide-auxiliary-text:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HideAuxiliaryText">"HideAuxiliaryText"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("hide-auxiliary-text",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, hide_auxiliary_text),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::update-lookup-table:
   * @object: A #IBusDbusInputContext.
   * @arg_table: Argument.
   * @arg_visible: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateLookupTable">"UpdateLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, update_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_VARIANT, G_TYPE_BOOLEAN);

  /**
   * IBusDbusInputContext::show-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowLookupTable">"ShowLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("show-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, show_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::hide-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HideLookupTable">"HideLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("hide-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, hide_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::page-up-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.PageUpLookupTable">"PageUpLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("page-up-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, page_up_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::page-down-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.PageDownLookupTable">"PageDownLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("page-down-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, page_down_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::cursor-up-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CursorUpLookupTable">"CursorUpLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("cursor-up-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, cursor_up_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::cursor-down-lookup-table:
   * @object: A #IBusDbusInputContext.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CursorDownLookupTable">"CursorDownLookupTable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("cursor-down-lookup-table",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, cursor_down_lookup_table),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IBusDbusInputContext::register-properties:
   * @object: A #IBusDbusInputContext.
   * @arg_props: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.RegisterProperties">"RegisterProperties"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("register-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, register_properties),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * IBusDbusInputContext::update-property:
   * @object: A #IBusDbusInputContext.
   * @arg_prop: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateProperty">"UpdateProperty"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusInputContextIface, update_property),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * IBusDbusInputContext:content-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ContentType">"ContentType"</link>.
   *
   * Since the D-Bus property for this #GObject property is writable but not readable, it is meaningful to write to it on both the client- and service-side. It is only meaningful, however, to read from it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("content-type", "ContentType", "ContentType", G_VARIANT_TYPE ("(uu)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IBusDbusInputContext:client-commit-preedit:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ClientCommitPreedit">"ClientCommitPreedit"</link>.
   *
   * Since the D-Bus property for this #GObject property is writable but not readable, it is meaningful to write to it on both the client- and service-side. It is only meaningful, however, to read from it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("client-commit-preedit", "ClientCommitPreedit", "ClientCommitPreedit", G_VARIANT_TYPE ("(b)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ibus_dbus_input_context_get_content_type: (skip)
 * @object: A #IBusDbusInputContext.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ContentType">"ContentType"</link> D-Bus property.
 *
 * Since this D-Bus property is not readable, it is only meaningful to use this function on the service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ibus_dbus_input_context_dup_content_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
ibus_dbus_input_context_get_content_type (IBusDbusInputContext *object)
{
  return IBUS_DBUS_INPUT_CONTEXT_GET_IFACE (object)->get_content_type (object);
}

/**
 * ibus_dbus_input_context_dup_content_type: (skip)
 * @object: A #IBusDbusInputContext.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ContentType">"ContentType"</link> D-Bus property.
 *
 * Since this D-Bus property is not readable, it is only meaningful to use this function on the service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
ibus_dbus_input_context_dup_content_type (IBusDbusInputContext *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "content-type", &value, NULL);
  return value;
}

/**
 * ibus_dbus_input_context_set_content_type: (skip)
 * @object: A #IBusDbusInputContext.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ContentType">"ContentType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ibus_dbus_input_context_set_content_type (IBusDbusInputContext *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "content-type", value, NULL);
}

/**
 * ibus_dbus_input_context_get_client_commit_preedit: (skip)
 * @object: A #IBusDbusInputContext.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ClientCommitPreedit">"ClientCommitPreedit"</link> D-Bus property.
 *
 * Since this D-Bus property is not readable, it is only meaningful to use this function on the service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ibus_dbus_input_context_dup_client_commit_preedit() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
ibus_dbus_input_context_get_client_commit_preedit (IBusDbusInputContext *object)
{
  return IBUS_DBUS_INPUT_CONTEXT_GET_IFACE (object)->get_client_commit_preedit (object);
}

/**
 * ibus_dbus_input_context_dup_client_commit_preedit: (skip)
 * @object: A #IBusDbusInputContext.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ClientCommitPreedit">"ClientCommitPreedit"</link> D-Bus property.
 *
 * Since this D-Bus property is not readable, it is only meaningful to use this function on the service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
ibus_dbus_input_context_dup_client_commit_preedit (IBusDbusInputContext *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "client-commit-preedit", &value, NULL);
  return value;
}

/**
 * ibus_dbus_input_context_set_client_commit_preedit: (skip)
 * @object: A #IBusDbusInputContext.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-IBus-InputContext.ClientCommitPreedit">"ClientCommitPreedit"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ibus_dbus_input_context_set_client_commit_preedit (IBusDbusInputContext *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "client-commit-preedit", value, NULL);
}

/**
 * ibus_dbus_input_context_emit_commit_text:
 * @object: A #IBusDbusInputContext.
 * @arg_text: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CommitText">"CommitText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_commit_text (
    IBusDbusInputContext *object,
    GVariant *arg_text)
{
  g_signal_emit_by_name (object, "commit-text", arg_text);
}

/**
 * ibus_dbus_input_context_emit_forward_key_event:
 * @object: A #IBusDbusInputContext.
 * @arg_keyval: Argument to pass with the signal.
 * @arg_keycode: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ForwardKeyEvent">"ForwardKeyEvent"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_forward_key_event (
    IBusDbusInputContext *object,
    guint arg_keyval,
    guint arg_keycode,
    guint arg_state)
{
  g_signal_emit_by_name (object, "forward-key-event", arg_keyval, arg_keycode, arg_state);
}

/**
 * ibus_dbus_input_context_emit_update_preedit_text:
 * @object: A #IBusDbusInputContext.
 * @arg_text: Argument to pass with the signal.
 * @arg_cursor_pos: Argument to pass with the signal.
 * @arg_visible: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdatePreeditText">"UpdatePreeditText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_update_preedit_text (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    guint arg_cursor_pos,
    gboolean arg_visible)
{
  g_signal_emit_by_name (object, "update-preedit-text", arg_text, arg_cursor_pos, arg_visible);
}

/**
 * ibus_dbus_input_context_emit_update_preedit_text_with_mode:
 * @object: A #IBusDbusInputContext.
 * @arg_text: Argument to pass with the signal.
 * @arg_cursor_pos: Argument to pass with the signal.
 * @arg_visible: Argument to pass with the signal.
 * @arg_mode: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdatePreeditTextWithMode">"UpdatePreeditTextWithMode"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_update_preedit_text_with_mode (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    guint arg_cursor_pos,
    gboolean arg_visible,
    guint arg_mode)
{
  g_signal_emit_by_name (object, "update-preedit-text-with-mode", arg_text, arg_cursor_pos, arg_visible, arg_mode);
}

/**
 * ibus_dbus_input_context_emit_show_preedit_text:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowPreeditText">"ShowPreeditText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_show_preedit_text (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "show-preedit-text");
}

/**
 * ibus_dbus_input_context_emit_hide_preedit_text:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HidePreeditText">"HidePreeditText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_hide_preedit_text (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "hide-preedit-text");
}

/**
 * ibus_dbus_input_context_emit_update_auxiliary_text:
 * @object: A #IBusDbusInputContext.
 * @arg_text: Argument to pass with the signal.
 * @arg_visible: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateAuxiliaryText">"UpdateAuxiliaryText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_update_auxiliary_text (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    gboolean arg_visible)
{
  g_signal_emit_by_name (object, "update-auxiliary-text", arg_text, arg_visible);
}

/**
 * ibus_dbus_input_context_emit_show_auxiliary_text:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowAuxiliaryText">"ShowAuxiliaryText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_show_auxiliary_text (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "show-auxiliary-text");
}

/**
 * ibus_dbus_input_context_emit_hide_auxiliary_text:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HideAuxiliaryText">"HideAuxiliaryText"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_hide_auxiliary_text (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "hide-auxiliary-text");
}

/**
 * ibus_dbus_input_context_emit_update_lookup_table:
 * @object: A #IBusDbusInputContext.
 * @arg_table: Argument to pass with the signal.
 * @arg_visible: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateLookupTable">"UpdateLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_update_lookup_table (
    IBusDbusInputContext *object,
    GVariant *arg_table,
    gboolean arg_visible)
{
  g_signal_emit_by_name (object, "update-lookup-table", arg_table, arg_visible);
}

/**
 * ibus_dbus_input_context_emit_show_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.ShowLookupTable">"ShowLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_show_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "show-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_hide_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.HideLookupTable">"HideLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_hide_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "hide-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_page_up_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.PageUpLookupTable">"PageUpLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_page_up_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "page-up-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_page_down_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.PageDownLookupTable">"PageDownLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_page_down_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "page-down-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_cursor_up_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CursorUpLookupTable">"CursorUpLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_cursor_up_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "cursor-up-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_cursor_down_lookup_table:
 * @object: A #IBusDbusInputContext.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.CursorDownLookupTable">"CursorDownLookupTable"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_cursor_down_lookup_table (
    IBusDbusInputContext *object)
{
  g_signal_emit_by_name (object, "cursor-down-lookup-table");
}

/**
 * ibus_dbus_input_context_emit_register_properties:
 * @object: A #IBusDbusInputContext.
 * @arg_props: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.RegisterProperties">"RegisterProperties"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_register_properties (
    IBusDbusInputContext *object,
    GVariant *arg_props)
{
  g_signal_emit_by_name (object, "register-properties", arg_props);
}

/**
 * ibus_dbus_input_context_emit_update_property:
 * @object: A #IBusDbusInputContext.
 * @arg_prop: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-IBus-InputContext.UpdateProperty">"UpdateProperty"</link> D-Bus signal.
 */
void
ibus_dbus_input_context_emit_update_property (
    IBusDbusInputContext *object,
    GVariant *arg_prop)
{
  g_signal_emit_by_name (object, "update-property", arg_prop);
}

/**
 * ibus_dbus_input_context_call_process_key_event:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_keyval: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessKeyEvent">ProcessKeyEvent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_process_key_event_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_process_key_event_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_process_key_event (
    IBusDbusInputContext *proxy,
    guint arg_keyval,
    guint arg_keycode,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ProcessKeyEvent",
    g_variant_new ("(uuu)",
                   arg_keyval,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_process_key_event_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @out_handled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_process_key_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_process_key_event().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_process_key_event_finish (
    IBusDbusInputContext *proxy,
    gboolean *out_handled,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_handled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_process_key_event_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_keyval: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @out_handled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessKeyEvent">ProcessKeyEvent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_process_key_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_process_key_event_sync (
    IBusDbusInputContext *proxy,
    guint arg_keyval,
    guint arg_keycode,
    guint arg_state,
    gboolean *out_handled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ProcessKeyEvent",
    g_variant_new ("(uuu)",
                   arg_keyval,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_handled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_cursor_location:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_w: Argument to pass with the method invocation.
 * @arg_h: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocation">SetCursorLocation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_set_cursor_location_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_set_cursor_location_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_set_cursor_location (
    IBusDbusInputContext *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_w,
    gint arg_h,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCursorLocation",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_w,
                   arg_h),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_set_cursor_location_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_set_cursor_location().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_set_cursor_location().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_cursor_location_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_cursor_location_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_w: Argument to pass with the method invocation.
 * @arg_h: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocation">SetCursorLocation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_set_cursor_location() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_cursor_location_sync (
    IBusDbusInputContext *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_w,
    gint arg_h,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCursorLocation",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_w,
                   arg_h),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_cursor_location_relative:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_w: Argument to pass with the method invocation.
 * @arg_h: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocationRelative">SetCursorLocationRelative()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_set_cursor_location_relative_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_set_cursor_location_relative_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_set_cursor_location_relative (
    IBusDbusInputContext *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_w,
    gint arg_h,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCursorLocationRelative",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_w,
                   arg_h),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_set_cursor_location_relative_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_set_cursor_location_relative().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_set_cursor_location_relative().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_cursor_location_relative_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_cursor_location_relative_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_w: Argument to pass with the method invocation.
 * @arg_h: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocationRelative">SetCursorLocationRelative()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_set_cursor_location_relative() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_cursor_location_relative_sync (
    IBusDbusInputContext *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_w,
    gint arg_h,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCursorLocationRelative",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_w,
                   arg_h),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_process_hand_writing_event:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_coordinates: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessHandWritingEvent">ProcessHandWritingEvent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_process_hand_writing_event_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_process_hand_writing_event_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_process_hand_writing_event (
    IBusDbusInputContext *proxy,
    GVariant *arg_coordinates,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ProcessHandWritingEvent",
    g_variant_new ("(@ad)",
                   arg_coordinates),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_process_hand_writing_event_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_process_hand_writing_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_process_hand_writing_event().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_process_hand_writing_event_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_process_hand_writing_event_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_coordinates: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessHandWritingEvent">ProcessHandWritingEvent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_process_hand_writing_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_process_hand_writing_event_sync (
    IBusDbusInputContext *proxy,
    GVariant *arg_coordinates,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ProcessHandWritingEvent",
    g_variant_new ("(@ad)",
                   arg_coordinates),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_cancel_hand_writing:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_n_strokes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.CancelHandWriting">CancelHandWriting()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_cancel_hand_writing_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_cancel_hand_writing_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_cancel_hand_writing (
    IBusDbusInputContext *proxy,
    guint arg_n_strokes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelHandWriting",
    g_variant_new ("(u)",
                   arg_n_strokes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_cancel_hand_writing_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_cancel_hand_writing().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_cancel_hand_writing().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_cancel_hand_writing_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_cancel_hand_writing_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_n_strokes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.CancelHandWriting">CancelHandWriting()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_cancel_hand_writing() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_cancel_hand_writing_sync (
    IBusDbusInputContext *proxy,
    guint arg_n_strokes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelHandWriting",
    g_variant_new ("(u)",
                   arg_n_strokes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_focus_in:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusIn">FocusIn()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_focus_in_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_focus_in_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_focus_in (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FocusIn",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_focus_in_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_focus_in().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_focus_in().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_focus_in_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_focus_in_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusIn">FocusIn()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_focus_in() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_focus_in_sync (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FocusIn",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_focus_out:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusOut">FocusOut()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_focus_out_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_focus_out_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_focus_out (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FocusOut",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_focus_out_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_focus_out().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_focus_out().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_focus_out_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_focus_out_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusOut">FocusOut()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_focus_out() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_focus_out_sync (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FocusOut",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_reset:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.Reset">Reset()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_reset_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_reset_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_reset (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_reset_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_reset().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_reset().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_reset_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_reset_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.Reset">Reset()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_reset() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_reset_sync (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_capabilities:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_caps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCapabilities">SetCapabilities()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_set_capabilities_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_set_capabilities_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_set_capabilities (
    IBusDbusInputContext *proxy,
    guint arg_caps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCapabilities",
    g_variant_new ("(u)",
                   arg_caps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_set_capabilities_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_set_capabilities().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_set_capabilities().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_capabilities_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_capabilities_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_caps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCapabilities">SetCapabilities()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_set_capabilities() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_capabilities_sync (
    IBusDbusInputContext *proxy,
    guint arg_caps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCapabilities",
    g_variant_new ("(u)",
                   arg_caps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_property_activate:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.PropertyActivate">PropertyActivate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_property_activate_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_property_activate_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_property_activate (
    IBusDbusInputContext *proxy,
    const gchar *arg_name,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PropertyActivate",
    g_variant_new ("(su)",
                   arg_name,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_property_activate_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_property_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_property_activate().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_property_activate_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_property_activate_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.PropertyActivate">PropertyActivate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_property_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_property_activate_sync (
    IBusDbusInputContext *proxy,
    const gchar *arg_name,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PropertyActivate",
    g_variant_new ("(su)",
                   arg_name,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_engine:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetEngine">SetEngine()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_set_engine_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_set_engine_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_set_engine (
    IBusDbusInputContext *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEngine",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_set_engine_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_set_engine().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_set_engine().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_engine_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_engine_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetEngine">SetEngine()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_set_engine() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_engine_sync (
    IBusDbusInputContext *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEngine",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_get_engine:
 * @proxy: A #IBusDbusInputContextProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.GetEngine">GetEngine()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_get_engine_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_get_engine_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_get_engine (
    IBusDbusInputContext *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetEngine",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_get_engine_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @out_desc: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_get_engine().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_get_engine().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_get_engine_finish (
    IBusDbusInputContext *proxy,
    GVariant **out_desc,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_desc);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_get_engine_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @out_desc: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.GetEngine">GetEngine()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_get_engine() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_get_engine_sync (
    IBusDbusInputContext *proxy,
    GVariant **out_desc,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetEngine",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_desc);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_surrounding_text:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_cursor_pos: Argument to pass with the method invocation.
 * @arg_anchor_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetSurroundingText">SetSurroundingText()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_call_set_surrounding_text_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_call_set_surrounding_text_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_input_context_call_set_surrounding_text (
    IBusDbusInputContext *proxy,
    GVariant *arg_text,
    guint arg_cursor_pos,
    guint arg_anchor_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSurroundingText",
    g_variant_new ("(@vuu)",
                   arg_text,
                   arg_cursor_pos,
                   arg_anchor_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_input_context_call_set_surrounding_text_finish:
 * @proxy: A #IBusDbusInputContextProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_call_set_surrounding_text().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_input_context_call_set_surrounding_text().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_surrounding_text_finish (
    IBusDbusInputContext *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_call_set_surrounding_text_sync:
 * @proxy: A #IBusDbusInputContextProxy.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_cursor_pos: Argument to pass with the method invocation.
 * @arg_anchor_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetSurroundingText">SetSurroundingText()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_call_set_surrounding_text() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_input_context_call_set_surrounding_text_sync (
    IBusDbusInputContext *proxy,
    GVariant *arg_text,
    guint arg_cursor_pos,
    guint arg_anchor_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSurroundingText",
    g_variant_new ("(@vuu)",
                   arg_text,
                   arg_cursor_pos,
                   arg_anchor_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_input_context_complete_process_key_event:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handled: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessKeyEvent">ProcessKeyEvent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_process_key_event (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation,
    gboolean handled)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   handled));
}

/**
 * ibus_dbus_input_context_complete_set_cursor_location:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocation">SetCursorLocation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_set_cursor_location (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_set_cursor_location_relative:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCursorLocationRelative">SetCursorLocationRelative()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_set_cursor_location_relative (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_process_hand_writing_event:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.ProcessHandWritingEvent">ProcessHandWritingEvent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_process_hand_writing_event (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_cancel_hand_writing:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.CancelHandWriting">CancelHandWriting()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_cancel_hand_writing (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_focus_in:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusIn">FocusIn()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_focus_in (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_focus_out:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.FocusOut">FocusOut()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_focus_out (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_reset:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.Reset">Reset()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_reset (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_set_capabilities:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetCapabilities">SetCapabilities()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_set_capabilities (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_property_activate:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.PropertyActivate">PropertyActivate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_property_activate (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_set_engine:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetEngine">SetEngine()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_set_engine (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ibus_dbus_input_context_complete_get_engine:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @desc: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.GetEngine">GetEngine()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_get_engine (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation,
    GVariant *desc)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   desc));
}

/**
 * ibus_dbus_input_context_complete_set_surrounding_text:
 * @object: A #IBusDbusInputContext.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-InputContext.SetSurroundingText">SetSurroundingText()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_input_context_complete_set_surrounding_text (
    IBusDbusInputContext *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * IBusDbusInputContextProxy:
 *
 * The #IBusDbusInputContextProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusInputContextProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusInputContextProxy.
 */

struct _IBusDbusInputContextProxyPrivate
{
  GData *qdata;
};

static void ibus_dbus_input_context_proxy_iface_init (IBusDbusInputContextIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusInputContextProxy, ibus_dbus_input_context_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IBusDbusInputContextProxy)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_INPUT_CONTEXT, ibus_dbus_input_context_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusInputContextProxy, ibus_dbus_input_context_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_INPUT_CONTEXT, ibus_dbus_input_context_proxy_iface_init))

#endif
static void
ibus_dbus_input_context_proxy_finalize (GObject *object)
{
  IBusDbusInputContextProxy *proxy = IBUS_DBUS_INPUT_CONTEXT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ibus_dbus_input_context_proxy_parent_class)->finalize (object);
}

static void
ibus_dbus_input_context_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ibus_dbus_input_context_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ibus_dbus_input_context_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.IBus.InputContext: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ibus_dbus_input_context_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ibus_dbus_input_context_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.IBus.InputContext", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ibus_dbus_input_context_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ibus_dbus_input_context_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IBUS_DBUS_TYPE_INPUT_CONTEXT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_INPUT_CONTEXT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ibus_dbus_input_context_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IBusDbusInputContextProxy *proxy = IBUS_DBUS_INPUT_CONTEXT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
ibus_dbus_input_context_proxy_get_content_type (IBusDbusInputContext *object)
{
  IBusDbusInputContextProxy *proxy = IBUS_DBUS_INPUT_CONTEXT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ContentType");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
ibus_dbus_input_context_proxy_get_client_commit_preedit (IBusDbusInputContext *object)
{
  IBusDbusInputContextProxy *proxy = IBUS_DBUS_INPUT_CONTEXT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ClientCommitPreedit");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
ibus_dbus_input_context_proxy_init (IBusDbusInputContextProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ibus_dbus_input_context_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IBUS_DBUS_TYPE_INPUT_CONTEXT_PROXY, IBusDbusInputContextProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ibus_dbus_input_context_interface_info ());
}

static void
ibus_dbus_input_context_proxy_class_init (IBusDbusInputContextProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ibus_dbus_input_context_proxy_finalize;
  gobject_class->get_property = ibus_dbus_input_context_proxy_get_property;
  gobject_class->set_property = ibus_dbus_input_context_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ibus_dbus_input_context_proxy_g_signal;
  proxy_class->g_properties_changed = ibus_dbus_input_context_proxy_g_properties_changed;

  ibus_dbus_input_context_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusInputContextProxyPrivate));
#endif
}

static void
ibus_dbus_input_context_proxy_iface_init (IBusDbusInputContextIface *iface)
{
  iface->get_content_type = ibus_dbus_input_context_proxy_get_content_type;
  iface->get_client_commit_preedit = ibus_dbus_input_context_proxy_get_client_commit_preedit;
}

/**
 * ibus_dbus_input_context_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_proxy_new_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_input_context_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_INPUT_CONTEXT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.InputContext", NULL);
}

/**
 * ibus_dbus_input_context_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_input_context_proxy_new().
 *
 * Returns: (transfer full) (type IBusDbusInputContextProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusInputContext *
ibus_dbus_input_context_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_INPUT_CONTEXT (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_input_context_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusInputContextProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusInputContext *
ibus_dbus_input_context_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_INPUT_CONTEXT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.InputContext", NULL);
  if (ret != NULL)
    return IBUS_DBUS_INPUT_CONTEXT (ret);
  else
    return NULL;
}


/**
 * ibus_dbus_input_context_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ibus_dbus_input_context_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_input_context_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ibus_dbus_input_context_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_input_context_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_INPUT_CONTEXT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.InputContext", NULL);
}

/**
 * ibus_dbus_input_context_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_input_context_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_input_context_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IBusDbusInputContextProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusInputContext *
ibus_dbus_input_context_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_INPUT_CONTEXT (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_input_context_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ibus_dbus_input_context_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_input_context_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusInputContextProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusInputContext *
ibus_dbus_input_context_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_INPUT_CONTEXT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.InputContext", NULL);
  if (ret != NULL)
    return IBUS_DBUS_INPUT_CONTEXT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IBusDbusInputContextSkeleton:
 *
 * The #IBusDbusInputContextSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusInputContextSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusInputContextSkeleton.
 */

struct _IBusDbusInputContextSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ibus_dbus_input_context_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IBUS_DBUS_TYPE_INPUT_CONTEXT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_INPUT_CONTEXT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ibus_dbus_input_context_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ibus_dbus_input_context_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_input_context_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ibus_dbus_input_context_skeleton_vtable =
{
  _ibus_dbus_input_context_skeleton_handle_method_call,
  _ibus_dbus_input_context_skeleton_handle_get_property,
  _ibus_dbus_input_context_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ibus_dbus_input_context_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ibus_dbus_input_context_interface_info ();
}

static GDBusInterfaceVTable *
ibus_dbus_input_context_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ibus_dbus_input_context_skeleton_vtable;
}

static GVariant *
ibus_dbus_input_context_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ibus_dbus_input_context_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ibus_dbus_input_context_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ibus_dbus_input_context_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ibus_dbus_input_context_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ibus_dbus_input_context_emit_changed (gpointer user_data);

static void
ibus_dbus_input_context_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ibus_dbus_input_context_emit_changed (skeleton);
}

static void
_ibus_dbus_input_context_on_signal_commit_text (
    IBusDbusInputContext *object,
    GVariant *arg_text)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@v)",
                   arg_text));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "CommitText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_forward_key_event (
    IBusDbusInputContext *object,
    guint arg_keyval,
    guint arg_keycode,
    guint arg_state)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uuu)",
                   arg_keyval,
                   arg_keycode,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "ForwardKeyEvent",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_update_preedit_text (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    guint arg_cursor_pos,
    gboolean arg_visible)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@vub)",
                   arg_text,
                   arg_cursor_pos,
                   arg_visible));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "UpdatePreeditText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_update_preedit_text_with_mode (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    guint arg_cursor_pos,
    gboolean arg_visible,
    guint arg_mode)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@vubu)",
                   arg_text,
                   arg_cursor_pos,
                   arg_visible,
                   arg_mode));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "UpdatePreeditTextWithMode",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_show_preedit_text (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "ShowPreeditText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_hide_preedit_text (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "HidePreeditText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_update_auxiliary_text (
    IBusDbusInputContext *object,
    GVariant *arg_text,
    gboolean arg_visible)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@vb)",
                   arg_text,
                   arg_visible));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "UpdateAuxiliaryText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_show_auxiliary_text (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "ShowAuxiliaryText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_hide_auxiliary_text (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "HideAuxiliaryText",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_update_lookup_table (
    IBusDbusInputContext *object,
    GVariant *arg_table,
    gboolean arg_visible)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@vb)",
                   arg_table,
                   arg_visible));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "UpdateLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_show_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "ShowLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_hide_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "HideLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_page_up_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "PageUpLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_page_down_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "PageDownLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_cursor_up_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "CursorUpLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_cursor_down_lookup_table (
    IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "CursorDownLookupTable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_register_properties (
    IBusDbusInputContext *object,
    GVariant *arg_props)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@v)",
                   arg_props));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "RegisterProperties",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ibus_dbus_input_context_on_signal_update_property (
    IBusDbusInputContext *object,
    GVariant *arg_prop)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@v)",
                   arg_prop));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.InputContext", "UpdateProperty",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ibus_dbus_input_context_skeleton_iface_init (IBusDbusInputContextIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusInputContextSkeleton, ibus_dbus_input_context_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IBusDbusInputContextSkeleton)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_INPUT_CONTEXT, ibus_dbus_input_context_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusInputContextSkeleton, ibus_dbus_input_context_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_INPUT_CONTEXT, ibus_dbus_input_context_skeleton_iface_init))

#endif
static void
ibus_dbus_input_context_skeleton_finalize (GObject *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ibus_dbus_input_context_skeleton_parent_class)->finalize (object);
}

static void
ibus_dbus_input_context_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ibus_dbus_input_context_emit_changed (gpointer user_data)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.IBus.InputContext",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ibus_dbus_input_context_schedule_emit_changed (IBusDbusInputContextSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ibus_dbus_input_context_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ibus_dbus_input_context_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ibus_dbus_input_context_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ibus_dbus_input_context_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ibus_dbus_input_context_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ibus_dbus_input_context_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ibus_dbus_input_context_skeleton_init (IBusDbusInputContextSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ibus_dbus_input_context_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IBUS_DBUS_TYPE_INPUT_CONTEXT_SKELETON, IBusDbusInputContextSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
}

static GVariant *
ibus_dbus_input_context_skeleton_get_content_type (IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
ibus_dbus_input_context_skeleton_get_client_commit_preedit (IBusDbusInputContext *object)
{
  IBusDbusInputContextSkeleton *skeleton = IBUS_DBUS_INPUT_CONTEXT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ibus_dbus_input_context_skeleton_class_init (IBusDbusInputContextSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ibus_dbus_input_context_skeleton_finalize;
  gobject_class->get_property = ibus_dbus_input_context_skeleton_get_property;
  gobject_class->set_property = ibus_dbus_input_context_skeleton_set_property;
  gobject_class->notify       = ibus_dbus_input_context_skeleton_notify;


  ibus_dbus_input_context_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ibus_dbus_input_context_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ibus_dbus_input_context_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ibus_dbus_input_context_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ibus_dbus_input_context_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusInputContextSkeletonPrivate));
#endif
}

static void
ibus_dbus_input_context_skeleton_iface_init (IBusDbusInputContextIface *iface)
{
  iface->commit_text = _ibus_dbus_input_context_on_signal_commit_text;
  iface->forward_key_event = _ibus_dbus_input_context_on_signal_forward_key_event;
  iface->update_preedit_text = _ibus_dbus_input_context_on_signal_update_preedit_text;
  iface->update_preedit_text_with_mode = _ibus_dbus_input_context_on_signal_update_preedit_text_with_mode;
  iface->show_preedit_text = _ibus_dbus_input_context_on_signal_show_preedit_text;
  iface->hide_preedit_text = _ibus_dbus_input_context_on_signal_hide_preedit_text;
  iface->update_auxiliary_text = _ibus_dbus_input_context_on_signal_update_auxiliary_text;
  iface->show_auxiliary_text = _ibus_dbus_input_context_on_signal_show_auxiliary_text;
  iface->hide_auxiliary_text = _ibus_dbus_input_context_on_signal_hide_auxiliary_text;
  iface->update_lookup_table = _ibus_dbus_input_context_on_signal_update_lookup_table;
  iface->show_lookup_table = _ibus_dbus_input_context_on_signal_show_lookup_table;
  iface->hide_lookup_table = _ibus_dbus_input_context_on_signal_hide_lookup_table;
  iface->page_up_lookup_table = _ibus_dbus_input_context_on_signal_page_up_lookup_table;
  iface->page_down_lookup_table = _ibus_dbus_input_context_on_signal_page_down_lookup_table;
  iface->cursor_up_lookup_table = _ibus_dbus_input_context_on_signal_cursor_up_lookup_table;
  iface->cursor_down_lookup_table = _ibus_dbus_input_context_on_signal_cursor_down_lookup_table;
  iface->register_properties = _ibus_dbus_input_context_on_signal_register_properties;
  iface->update_property = _ibus_dbus_input_context_on_signal_update_property;
  iface->get_content_type = ibus_dbus_input_context_skeleton_get_content_type;
  iface->get_client_commit_preedit = ibus_dbus_input_context_skeleton_get_client_commit_preedit;
}

/**
 * ibus_dbus_input_context_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-InputContext.top_of_page">org.freedesktop.IBus.InputContext</link>.
 *
 * Returns: (transfer full) (type IBusDbusInputContextSkeleton): The skeleton object.
 */
IBusDbusInputContext *
ibus_dbus_input_context_skeleton_new (void)
{
  return IBUS_DBUS_INPUT_CONTEXT (g_object_new (IBUS_DBUS_TYPE_INPUT_CONTEXT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.IBus.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IBusDbusService
 * @title: IBusDbusService
 * @short_description: Generated C code for the org.freedesktop.IBus.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.IBus.Service ---- */

static const _ExtendedGDBusMethodInfo _ibus_dbus_service_method_info_destroy =
{
  {
    -1,
    (gchar *) "Destroy",
    NULL,
    NULL,
    NULL
  },
  "handle-destroy",
  FALSE
};

static const GDBusMethodInfo * const _ibus_dbus_service_method_info_pointers[] =
{
  &_ibus_dbus_service_method_info_destroy.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ibus_dbus_service_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.IBus.Service",
    (GDBusMethodInfo **) &_ibus_dbus_service_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "service",
};


/**
 * ibus_dbus_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ibus_dbus_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct;
}

/**
 * ibus_dbus_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IBusDbusService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ibus_dbus_service_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * IBusDbusService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link>.
 */

/**
 * IBusDbusServiceIface:
 * @parent_iface: The parent interface.
 * @handle_destroy: Handler for the #IBusDbusService::handle-destroy signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link>.
 */

typedef IBusDbusServiceIface IBusDbusServiceInterface;
G_DEFINE_INTERFACE (IBusDbusService, ibus_dbus_service, G_TYPE_OBJECT)

static void
ibus_dbus_service_default_init (IBusDbusServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IBusDbusService::handle-destroy:
   * @object: A #IBusDbusService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-IBus-Service.Destroy">Destroy()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ibus_dbus_service_complete_destroy() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-destroy",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IBusDbusServiceIface, handle_destroy),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * ibus_dbus_service_call_destroy:
 * @proxy: A #IBusDbusServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-Service.Destroy">Destroy()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_service_call_destroy_finish() to get the result of the operation.
 *
 * See ibus_dbus_service_call_destroy_sync() for the synchronous, blocking version of this method.
 */
void
ibus_dbus_service_call_destroy (
    IBusDbusService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Destroy",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ibus_dbus_service_call_destroy_finish:
 * @proxy: A #IBusDbusServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_service_call_destroy().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ibus_dbus_service_call_destroy().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_service_call_destroy_finish (
    IBusDbusService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_service_call_destroy_sync:
 * @proxy: A #IBusDbusServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-IBus-Service.Destroy">Destroy()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_service_call_destroy() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
ibus_dbus_service_call_destroy_sync (
    IBusDbusService *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Destroy",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ibus_dbus_service_complete_destroy:
 * @object: A #IBusDbusService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-IBus-Service.Destroy">Destroy()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ibus_dbus_service_complete_destroy (
    IBusDbusService *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * IBusDbusServiceProxy:
 *
 * The #IBusDbusServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusServiceProxy.
 */

struct _IBusDbusServiceProxyPrivate
{
  GData *qdata;
};

static void ibus_dbus_service_proxy_iface_init (IBusDbusServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusServiceProxy, ibus_dbus_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IBusDbusServiceProxy)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_SERVICE, ibus_dbus_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusServiceProxy, ibus_dbus_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_SERVICE, ibus_dbus_service_proxy_iface_init))

#endif
static void
ibus_dbus_service_proxy_finalize (GObject *object)
{
  IBusDbusServiceProxy *proxy = IBUS_DBUS_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ibus_dbus_service_proxy_parent_class)->finalize (object);
}

static void
ibus_dbus_service_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ibus_dbus_service_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ibus_dbus_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IBUS_DBUS_TYPE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ibus_dbus_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IBusDbusServiceProxy *proxy = IBUS_DBUS_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ibus_dbus_service_proxy_init (IBusDbusServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ibus_dbus_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IBUS_DBUS_TYPE_SERVICE_PROXY, IBusDbusServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ibus_dbus_service_interface_info ());
}

static void
ibus_dbus_service_proxy_class_init (IBusDbusServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ibus_dbus_service_proxy_finalize;
  gobject_class->get_property = ibus_dbus_service_proxy_get_property;
  gobject_class->set_property = ibus_dbus_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ibus_dbus_service_proxy_g_signal;
  proxy_class->g_properties_changed = ibus_dbus_service_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusServiceProxyPrivate));
#endif
}

static void
ibus_dbus_service_proxy_iface_init (IBusDbusServiceIface *iface)
{
}

/**
 * ibus_dbus_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_service_proxy_new_finish() to get the result of the operation.
 *
 * See ibus_dbus_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Service", NULL);
}

/**
 * ibus_dbus_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_service_proxy_new().
 *
 * Returns: (transfer full) (type IBusDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusService *
ibus_dbus_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_SERVICE (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusService *
ibus_dbus_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Service", NULL);
  if (ret != NULL)
    return IBUS_DBUS_SERVICE (ret);
  else
    return NULL;
}


/**
 * ibus_dbus_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ibus_dbus_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ibus_dbus_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ibus_dbus_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ibus_dbus_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IBUS_DBUS_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Service", NULL);
}

/**
 * ibus_dbus_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ibus_dbus_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ibus_dbus_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IBusDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusService *
ibus_dbus_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IBUS_DBUS_SERVICE (ret);
  else
    return NULL;
}

/**
 * ibus_dbus_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ibus_dbus_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ibus_dbus_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IBusDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IBusDbusService *
ibus_dbus_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IBUS_DBUS_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.IBus.Service", NULL);
  if (ret != NULL)
    return IBUS_DBUS_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IBusDbusServiceSkeleton:
 *
 * The #IBusDbusServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IBusDbusServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IBusDbusServiceSkeleton.
 */

struct _IBusDbusServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ibus_dbus_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IBusDbusServiceSkeleton *skeleton = IBUS_DBUS_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IBUS_DBUS_TYPE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IBUS_DBUS_TYPE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ibus_dbus_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IBusDbusServiceSkeleton *skeleton = IBUS_DBUS_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ibus_dbus_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IBusDbusServiceSkeleton *skeleton = IBUS_DBUS_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ibus_dbus_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ibus_dbus_service_skeleton_vtable =
{
  _ibus_dbus_service_skeleton_handle_method_call,
  _ibus_dbus_service_skeleton_handle_get_property,
  _ibus_dbus_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ibus_dbus_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ibus_dbus_service_interface_info ();
}

static GDBusInterfaceVTable *
ibus_dbus_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ibus_dbus_service_skeleton_vtable;
}

static GVariant *
ibus_dbus_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IBusDbusServiceSkeleton *skeleton = IBUS_DBUS_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ibus_dbus_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ibus_dbus_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ibus_dbus_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ibus_dbus_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.IBus.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ibus_dbus_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void ibus_dbus_service_skeleton_iface_init (IBusDbusServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IBusDbusServiceSkeleton, ibus_dbus_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IBusDbusServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_SERVICE, ibus_dbus_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IBusDbusServiceSkeleton, ibus_dbus_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IBUS_DBUS_TYPE_SERVICE, ibus_dbus_service_skeleton_iface_init))

#endif
static void
ibus_dbus_service_skeleton_finalize (GObject *object)
{
  IBusDbusServiceSkeleton *skeleton = IBUS_DBUS_SERVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ibus_dbus_service_skeleton_parent_class)->finalize (object);
}

static void
ibus_dbus_service_skeleton_init (IBusDbusServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ibus_dbus_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IBUS_DBUS_TYPE_SERVICE_SKELETON, IBusDbusServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ibus_dbus_service_skeleton_class_init (IBusDbusServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ibus_dbus_service_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ibus_dbus_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ibus_dbus_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ibus_dbus_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ibus_dbus_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IBusDbusServiceSkeletonPrivate));
#endif
}

static void
ibus_dbus_service_skeleton_iface_init (IBusDbusServiceIface *iface)
{
}

/**
 * ibus_dbus_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-IBus-Service.top_of_page">org.freedesktop.IBus.Service</link>.
 *
 * Returns: (transfer full) (type IBusDbusServiceSkeleton): The skeleton object.
 */
IBusDbusService *
ibus_dbus_service_skeleton_new (void)
{
  return IBUS_DBUS_SERVICE (g_object_new (IBUS_DBUS_TYPE_SERVICE_SKELETON, NULL));
}

