# FONTLOG for Manjari

This file provides detailed information on the Manjari font software. This
information should be distributed along with the Manjari fonts and any derivative
works.

## Basic Font Information

Manjari is a Malayalam typeface with regular, bold, thin variants. Manjari means pearl. It is also the name of a poetic metre in Malayalam. This is the second font after Chilanka handwriting font by Santhosh Thottingal. This is a multipurpose font suitable for body and titles.

The glyph shapes follow a spiral theme, true to the beautiful curves of Malayalam. The glyphs are equal width with rounded terminals. The font has comprehensive glyph set including all widely used ligatures. Apart from Malayalam, latin character set is also included.

* Designer: Santhosh Thottingal
* Opentype Engineering: Santhosh Thottingal & Kavya Manohar

The Spiral curve based design of Manjari used the Spiro library from Raph Levien along with its Inkscape integration. The design theory is documented in detail in this paper: https://thottingal.in/documents/Spiral-Splines-Manjari.pdf

Manjari belongs to the typefaces released by [Swathanthra Malayalam Computing](smc.org.in), a volunteer driven organization for developing and promoting free and opensource software for Malayalam computing. It shares the experience and expertise by the organization in its more than a decade effort in standardizing and improving opentype Malayalam typeface technology.

Manjari inherits the traditional orthography style opentype font development practices pioneered by Rachana by K H Hussain and Rachana Aksharavedi. This includes glyph naming conventions, the supported ligature collection, a significant parts of opentype rules.

Manjari development is currently hosted at:
http://gitlab.com/smc/fonts/manjari

Released versions of this font is available at [smc.org.in/fonts](smc.org.in/fonts) for download. For old versions and detailed changelog, see https://gitlab.com/smc/fonts/manjari/-/releases. Feature requests, bug reports and patches should be directed to our issue
tracker.

## Acknowledgements

(in alphabetical order)

* K H Hussain, Designer of Rachana font.
* Raph Levien, Author of Spiro library.
* Rajeesh K V, Opentype engineering.
* Swathanthra Malayalam computing and its volunteers for all help and support.

For a complete list of authors who contributed to the project, see CONTRIBUTORS.md

## Information for Contributors

Manjari is released under the OFL 1.1 - https://scripts.sil.org/OFL For information on what you're allowed to change or modify, consult the OFL.txt. The [OFL-FAQ](https://scripts.sil.org/OFL-FAQ_web) also gives a very general rationale and various recommendations regarding why you would want to contribute to the project or make your own version of the font.

When you are submitting patches, please add your name to CONTRIBUTORS.md if you wish to be listed there.

See the project website for the current master and the various branches:
http://gitlab.com/smc/fonts/manjari
