// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRDMLSH_4H_TRACE_AARCH64_H_
#define VIXL_SIM_SQRDMLSH_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqrdmlsh_4H[] = {
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xcccf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffcf, 0xddee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x2224, 0x2233, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0056, 0x147d, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x0034, 0x0035, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0001, 0x0035, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0034, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0033, 0x0055, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0033, 0x000d, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0007, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff7, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffae, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffad, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xeb86, 0xc71f, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x3334, 0x5556, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x2223, 0x2225, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x147c, 0x0057, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0034, 0x0057, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0034, 0x0056, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0055, 0x007f, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0054, 0x0012, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x000c, 0x0005, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x0003, 0x0004, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff6, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffae, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffad, 0xff83, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeb85, 0xc71e, 0x8008, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x5556, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2224, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x147b, 0x0056, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0056, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x007f, 0x007f, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x007e, 0x0012, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0053, 0x0011, 0x0005, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000b, 0x0004, 0x0004, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc71d, 0x8007, 0x8006, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x5555, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x38e4, 0x3334, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2223, 0x0081, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x0080, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x007f, 0x007f, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x0012, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0011, 0x0005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0004, 0x0004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0xff85, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0xff84, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0xff83, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xcccf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xcccf, 0xaaae, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x8006, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaad, 0x8006, 0x8005, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8005, 0x8004, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8005, 0x8004, 0x7fff, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x7fff, 0x7fff, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x5557, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5556, 0x3336, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3334, 0x0082, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0x0081, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0x0080, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x007f, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0011, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0004, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xccce, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x8005, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8005, 0x8004, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x8003, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x7fff, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5556, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x3335, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x0001, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x0001, 0x0003, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0004, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0004, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff7, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0012, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0003, 0x0012, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0003, 0x000d, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0008, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff6, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0xff85, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0x007f, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0011, 0x007f, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0011, 0x0055, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x000c, 0x0034, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0007, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffae, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffae, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0xff84, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0x0080, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x007e, 0x0080, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007e, 0x0056, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0054, 0x0034, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000b, 0x0033, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xeb95, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffcf, 0xddee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffad, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffad, 0xff83, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0xff83, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0x0081, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0x007f, 0x0081, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007f, 0x0057, 0x148b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0055, 0x0035, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0053, 0x0033, 0x0002, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0001, 0x0002, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0034, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0008, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xffcf, 0xddee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x2224, 0x2233, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0056, 0x147d, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x0034, 0x0035, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0001, 0x0035, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0034, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0033, 0x0055, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0033, 0x000d, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0007, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff7, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffae, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffcf, 0xffad, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xeb86, 0xc71f, 0x8016, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x3334, 0x5556, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x2223, 0x2225, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x147c, 0x0057, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0034, 0x0057, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0034, 0x0056, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0055, 0x007f, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0054, 0x0012, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x000c, 0x0005, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x0003, 0x0004, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff6, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffae, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffad, 0xff83, 0xccde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeb85, 0xc71e, 0x8008, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x5556, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2224, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x147b, 0x0056, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0056, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x007f, 0x007f, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x007e, 0x0012, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0053, 0x0011, 0x0005, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000b, 0x0004, 0x0004, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc71d, 0x8007, 0x8006, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x5555, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x38e4, 0x3334, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2223, 0x0081, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x0080, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x007f, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x0012, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0011, 0x0005, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0004, 0x0004, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0xff85, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0xff84, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0xff83, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x8005, 0x8004, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8005, 0x8004, 0x7fff, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x7fff, 0x7fff, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x5557, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5556, 0x3336, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3334, 0x0082, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0x0081, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0x0080, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x007f, 0xff85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0xfff2, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0011, 0xffff, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0004, 0x0000, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0003, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0004, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0012, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfff1, 0x007f, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xff84, 0x0080, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff83, 0x0081, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8005, 0x8004, 0x7fff, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x8003, 0x8002, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x7fff, 0x8003, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0xaaac, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5556, 0xccce, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x3335, 0xff82, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0xff83, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0xff84, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0xff83, 0xff85, 0x0005, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0xff84, 0xfff2, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0xfff1, 0xffff, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0xfffe, 0x0000, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0xffff, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0000, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0004, 0x001b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0003, 0x0012, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0011, 0x007f, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0x007e, 0x0080, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0x007f, 0x0081, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x3334, 0x5556, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8004, 0x7fff, 0x7fff, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0x7fff, 0x8003, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8001, 0x8004, 0xc72c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8002, 0xaaad, 0xdded, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xaaab, 0xccce, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xcccd, 0xff82, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0xff81, 0xff83, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0xff82, 0xff84, 0xffbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff83, 0xffaf, 0x000a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff84, 0xfff7, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xfff1, 0x0000, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xfffe, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0003, 0x000d, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0011, 0x0055, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007e, 0x0056, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007f, 0x0057, 0x148b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x2224, 0x2233, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x5556, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x5557, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0xaaac, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8002, 0xaaad, 0xdded, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8003, 0xc71e, 0xeb94, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaac, 0xdddf, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccd, 0xffad, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff81, 0xffad, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff82, 0xffae, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xffad, 0xffd0, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xffae, 0xfffc, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xfff6, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xffff, 0x0001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0003, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0008, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x000c, 0x0034, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0054, 0x0034, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0055, 0x0035, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0056, 0x147d, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x2223, 0x2225, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x5555, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5556, 0x3336, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5556, 0xccce, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xaaab, 0xccce, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaac, 0xdddf, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0xc71d, 0xeb86, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xddde, 0xffcf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xffac, 0xffcf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xffac, 0xffd0, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xffcf, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffac, 0xffcf, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffad, 0xfffb, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff5, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0007, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000b, 0x0033, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0053, 0x0033, 0x0002, 0x0043, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0054, 0x0034, 0x0035, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x147c, 0x0057, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2224, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x38e4, 0x3334, 0x0082, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3334, 0x0082, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x3335, 0xff82, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xcccd, 0xff82, 0xffbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccd, 0xffad, 0xffdd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xddde, 0xffcf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc71c, 0xeb85, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xdddd, 0xffce, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xffce, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffce, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0001, 0x0002, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0032, 0x0001, 0x0035, 0x0064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0034, 0x0057, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x147b, 0x0056, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2223, 0x0081, 0x0081, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0x0081, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0xff83, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0xff81, 0xff83, 0xffbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff81, 0xffad, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xffac, 0xffcf, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xdddd, 0xffce, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeb84, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0042, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0034, 0x0063, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0034, 0x0056, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0033, 0x0056, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0055, 0x0080, 0x0080, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0x0080, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0080, 0xff84, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0xff82, 0xff84, 0xffbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff82, 0xffae, 0xffde, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xffac, 0xffd0, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffab, 0xffce, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_sqrdmlsh_4H = 576;

#endif  // VIXL_SIM_SQRDMLSH_4H_TRACE_AARCH64_H_
