// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLSL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLSL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlsl2_2D[] = {
  0xffff8005ffee0000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xfffffffffe000c00, 0x0000000000000001,
  0xffffffffe000c000, 0x0000000000000001,
  0xffffffff8302ee00, 0x0000000000000001,
  0xffffffff8202f400, 0x0000000000000001,
  0xffffffff8102fa00, 0x0000000000000001,
  0xffffff8005ffee00, 0x0000000000000001,
  0xffffff8004fff400, 0x0000000000000001,
  0xffffff8003fffa00, 0x0000000000000001,
  0xffccce0000333200, 0x0000000000000001,
  0xffaaacaaaafffe00, 0x0000000000000001,
  0xff80030002ffee00, 0x0000000000000001,
  0xff80030001fff400, 0x0000000000000001,
  0xff80030000fffa00, 0x0000000000000001,
  0x007ffd0000000000, 0x0000000000000001,
  0x007ffcffff000600, 0x0000000000000001,
  0x0055535555fffc00, 0x0000000000000001,
  0x0033320000ccc800, 0x0000000000000001,
  0x0000007ffd000000, 0x0000000000000001,
  0x0000007ffc000600, 0x0000000000000001,
  0x0000007ffb000c00, 0x0000000000000001,
  0x0000007ffa001200, 0x0000000000000001,
  0x000000007ffd0000, 0x0000000000000001,
  0x000000007efd0600, 0x0000000000000001,
  0x000000007dfd0c00, 0x0000000000000001,
  0x000000007cfd1200, 0x0000000000000001,
  0x000000001fff4000, 0x0000000000000001,
  0x0000000002ffee00, 0x0000000000000001,
  0x0000000001fff400, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xffffffffffffffc1,
  0x0000000000000000, 0xffffffffffffff07,
  0x0000000000000000, 0xffffffffffffff05,
  0x0000000000000000, 0xffffffffffffff03,
  0x0000000000000000, 0xffffffffffff0007,
  0x0000000000000000, 0xffffffffffff0005,
  0x0000000000000000, 0xffffffffffff0003,
  0x0000000000000000, 0xffffffff9999999b,
  0x0000000000000000, 0xffffffff55555557,
  0x0000000000000000, 0xffffffff00000007,
  0x0000000000000000, 0xffffffff00000005,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0x0000000100000001,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0x00000000aaaaaaad,
  0x0000000000000000, 0x0000000066666669,
  0x0000000000000000, 0x0000000000010001,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000000000, 0x000000000000fffd,
  0x0000000000000000, 0x000000000000fffb,
  0x0000000000000000, 0x0000000000000101,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000000, 0x00000000000000fd,
  0x0000000000000000, 0x00000000000000fb,
  0x0000000000000000, 0x0000000000000041,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0xfffffffffffffff9,
  0xfffffffffffffffc, 0xffffffffffffff81,
  0xffffffffffffffc0, 0xfffffffffffffe0d,
  0xffffffffffffff06, 0xfffffffffffffe09,
  0xffffffffffffff04, 0xfffffffffffffe05,
  0xffffffffffffff02, 0xfffffffffffe000d,
  0xffffffffffff0006, 0xfffffffffffe0009,
  0xffffffffffff0004, 0xfffffffffffe0005,
  0xffffffffffff0002, 0xffffffff33333335,
  0xffffffff9999999a, 0xfffffffeaaaaaaad,
  0xffffffff55555556, 0xfffffffe0000000d,
  0xffffffff00000006, 0xfffffffe00000009,
  0xffffffff00000004, 0xfffffffe00000005,
  0xffffffff00000002, 0x0000000200000001,
  0x0000000100000000, 0x00000001fffffffd,
  0x00000000fffffffe, 0x0000000155555559,
  0x00000000aaaaaaac, 0x00000000ccccccd1,
  0x0000000066666668, 0x0000000000020001,
  0x0000000000010000, 0x000000000001fffd,
  0x000000000000fffe, 0x000000000001fff9,
  0x000000000000fffc, 0x000000000001fff5,
  0x000000000000fffa, 0x0000000000000201,
  0x0000000000000100, 0x00000000000001fd,
  0x00000000000000fe, 0x00000000000001f9,
  0x00000000000000fc, 0x00000000000001f5,
  0x00000000000000fa, 0x0000000000000081,
  0x0000000000000040, 0x000000000000000d,
  0x0000000000000006, 0x0000000000000009,
  0x0000000000000004, 0x0000000000000005,
  0x0000000000000004, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffc1,
  0xfffffffffffffffc, 0xffffffffffffff81,
  0xfffffffffffffff8, 0xfffffffffffff801,
  0xffffffffffffff80, 0xffffffffffffe0c1,
  0xfffffffffffffe0c, 0xffffffffffffe081,
  0xfffffffffffffe08, 0xffffffffffffe041,
  0xfffffffffffffe04, 0xffffffffffe000c1,
  0xfffffffffffe000c, 0xffffffffffe00081,
  0xfffffffffffe0008, 0xffffffffffe00041,
  0xfffffffffffe0004, 0xfffffff333333341,
  0xffffffff33333334, 0xffffffeaaaaaaac1,
  0xfffffffeaaaaaaac, 0xffffffe0000000c1,
  0xfffffffe0000000c, 0xffffffe000000081,
  0xfffffffe00000008, 0xffffffe000000041,
  0xfffffffe00000004, 0x0000002000000001,
  0x0000000200000000, 0x0000001fffffffc1,
  0x00000001fffffffc, 0x0000001555555581,
  0x0000000155555558, 0x0000000ccccccd01,
  0x00000000ccccccd0, 0x0000000000200001,
  0x0000000000020000, 0x00000000001fffc1,
  0x000000000001fffc, 0x00000000001fff81,
  0x000000000001fff8, 0x00000000001fff41,
  0x000000000001fff4, 0x0000000000002001,
  0x0000000000000200, 0x0000000000001fc1,
  0x00000000000001fc, 0x0000000000001f81,
  0x00000000000001f8, 0x0000000000001f41,
  0x00000000000001f4, 0x0000000000000801,
  0x0000000000000080, 0x00000000000000c1,
  0x000000000000000c, 0x0000000000000081,
  0x0000000000000008, 0x0000000000000041,
  0x0000000000000040, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff07,
  0xffffffffffffffc0, 0xfffffffffffffe0d,
  0xffffffffffffff80, 0xffffffffffffe0c1,
  0xfffffffffffff800, 0xffffffffffff85ef,
  0xffffffffffffe0c0, 0xffffffffffff84f5,
  0xffffffffffffe080, 0xffffffffffff83fb,
  0xffffffffffffe040, 0xffffffffff8302ef,
  0xffffffffffe000c0, 0xffffffffff8301f5,
  0xffffffffffe00080, 0xffffffffff8300fb,
  0xffffffffffe00040, 0xffffffce00000033,
  0xfffffff333333340, 0xffffffacaaaaaaff,
  0xffffffeaaaaaaac0, 0xffffff83000002ef,
  0xffffffe0000000c0, 0xffffff83000001f5,
  0xffffffe000000080, 0xffffff83000000fb,
  0xffffffe000000040, 0x0000007d00000001,
  0x0000002000000000, 0x0000007cffffff07,
  0x0000001fffffffc0, 0x00000053555555fd,
  0x0000001555555580, 0x00000032000000c9,
  0x0000000ccccccd00, 0x00000000007d0001,
  0x0000000000200000, 0x00000000007cff07,
  0x00000000001fffc0, 0x00000000007cfe0d,
  0x00000000001fff80, 0x00000000007cfd13,
  0x00000000001fff40, 0x0000000000007d01,
  0x0000000000002000, 0x0000000000007c07,
  0x0000000000001fc0, 0x0000000000007b0d,
  0x0000000000001f80, 0x0000000000007a13,
  0x0000000000001f40, 0x0000000000001f41,
  0x0000000000000800, 0x00000000000002ef,
  0x00000000000000c0, 0x00000000000001f5,
  0x0000000000000080, 0x00000000000000fb,
  0x00000000000000fa, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff05,
  0xffffffffffffff06, 0xfffffffffffffe09,
  0xfffffffffffffe0c, 0xffffffffffffe081,
  0xffffffffffffe0c0, 0xffffffffffff84f5,
  0xffffffffffff85ee, 0xffffffffffff83f9,
  0xffffffffffff84f4, 0xffffffffffff82fd,
  0xffffffffffff83fa, 0xffffffffff8202f5,
  0xffffffffff8302ee, 0xffffffffff8201f9,
  0xffffffffff8301f4, 0xffffffffff8200fd,
  0xffffffffff8300fa, 0xffffffcd999999cd,
  0xffffffce00000032, 0xffffffac00000055,
  0xffffffacaaaaaafe, 0xffffff82000002f5,
  0xffffff83000002ee, 0xffffff82000001f9,
  0xffffff83000001f4, 0xffffff82000000fd,
  0xffffff83000000fa, 0x0000007e00000001,
  0x0000007d00000000, 0x0000007dffffff05,
  0x0000007cffffff06, 0x00000054000000a9,
  0x00000053555555fc, 0x0000003266666731,
  0x00000032000000c8, 0x00000000007e0001,
  0x00000000007d0000, 0x00000000007dff05,
  0x00000000007cff06, 0x00000000007dfe09,
  0x00000000007cfe0c, 0x00000000007dfd0d,
  0x00000000007cfd12, 0x0000000000007e01,
  0x0000000000007d00, 0x0000000000007d05,
  0x0000000000007c06, 0x0000000000007c09,
  0x0000000000007b0c, 0x0000000000007b0d,
  0x0000000000007a12, 0x0000000000001f81,
  0x0000000000001f40, 0x00000000000002f5,
  0x00000000000002ee, 0x00000000000001f9,
  0x00000000000001f4, 0x00000000000000fd,
  0x00000000000000fc, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff03,
  0xffffffffffffff04, 0xfffffffffffffe05,
  0xfffffffffffffe08, 0xffffffffffffe041,
  0xffffffffffffe080, 0xffffffffffff83fb,
  0xffffffffffff84f4, 0xffffffffffff82fd,
  0xffffffffffff83f8, 0xffffffffffff81ff,
  0xffffffffffff82fc, 0xffffffffff8102fb,
  0xffffffffff8202f4, 0xffffffffff8101fd,
  0xffffffffff8201f8, 0xffffffffff8100ff,
  0xffffffffff8200fc, 0xffffffcd33333367,
  0xffffffcd999999cc, 0xffffffab555555ab,
  0xffffffac00000054, 0xffffff81000002fb,
  0xffffff82000002f4, 0xffffff81000001fd,
  0xffffff82000001f8, 0xffffff81000000ff,
  0xffffff82000000fc, 0x0000007f00000001,
  0x0000007e00000000, 0x0000007effffff03,
  0x0000007dffffff04, 0x00000054aaaaab55,
  0x00000054000000a8, 0x00000032cccccd99,
  0x0000003266666730, 0x00000000007f0001,
  0x00000000007e0000, 0x00000000007eff03,
  0x00000000007dff04, 0x00000000007efe05,
  0x00000000007dfe08, 0x00000000007efd07,
  0x00000000007dfd0c, 0x0000000000007f01,
  0x0000000000007e00, 0x0000000000007e03,
  0x0000000000007d04, 0x0000000000007d05,
  0x0000000000007c08, 0x0000000000007c07,
  0x0000000000007b0c, 0x0000000000001fc1,
  0x0000000000001f80, 0x00000000000002fb,
  0x00000000000002f4, 0x00000000000001fd,
  0x00000000000001f8, 0x00000000000000ff,
  0x00000000000000fe, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0007,
  0xffffffffffffff02, 0xfffffffffffe000d,
  0xfffffffffffffe04, 0xffffffffffe000c1,
  0xffffffffffffe040, 0xffffffffff8302ef,
  0xffffffffffff83fa, 0xffffffffff8202f5,
  0xffffffffffff82fc, 0xffffffffff8102fb,
  0xffffffffffff81fe, 0xffffffff8005ffef,
  0xffffffffff8102fa, 0xffffffff8004fff5,
  0xffffffffff8101fc, 0xffffffff8003fffb,
  0xffffffffff8100fe, 0xffffccce00003333,
  0xffffffcd33333366, 0xffffaaacaaaaffff,
  0xffffffab555555aa, 0xffff80030002ffef,
  0xffffff81000002fa, 0xffff80030001fff5,
  0xffffff81000001fc, 0xffff80030000fffb,
  0xffffff81000000fe, 0x00007ffd00000001,
  0x0000007f00000000, 0x00007ffcffff0007,
  0x0000007effffff02, 0x000055535555fffd,
  0x00000054aaaaab54, 0x000033320000ccc9,
  0x00000032cccccd98, 0x000000007ffd0001,
  0x00000000007f0000, 0x000000007ffc0007,
  0x00000000007eff02, 0x000000007ffb000d,
  0x00000000007efe04, 0x000000007ffa0013,
  0x00000000007efd06, 0x00000000007ffd01,
  0x0000000000007f00, 0x00000000007efd07,
  0x0000000000007e02, 0x00000000007dfd0d,
  0x0000000000007d04, 0x00000000007cfd13,
  0x0000000000007c06, 0x00000000001fff41,
  0x0000000000001fc0, 0x000000000002ffef,
  0x00000000000002fa, 0x000000000001fff5,
  0x00000000000001fc, 0x000000000000fffb,
  0x000000000000fffa, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0005,
  0xffffffffffff0006, 0xfffffffffffe0009,
  0xfffffffffffe000c, 0xffffffffffe00081,
  0xffffffffffe000c0, 0xffffffffff8301f5,
  0xffffffffff8302ee, 0xffffffffff8201f9,
  0xffffffffff8202f4, 0xffffffffff8101fd,
  0xffffffffff8102fa, 0xffffffff8004fff5,
  0xffffffff8005ffee, 0xffffffff8003fff9,
  0xffffffff8004fff4, 0xffffffff8002fffd,
  0xffffffff8003fffa, 0xffffcccd9999cccd,
  0xffffccce00003332, 0xffffaaac00005555,
  0xffffaaacaaaafffe, 0xffff80020002fff5,
  0xffff80030002ffee, 0xffff80020001fff9,
  0xffff80030001fff4, 0xffff80020000fffd,
  0xffff80030000fffa, 0x00007ffe00000001,
  0x00007ffd00000000, 0x00007ffdffff0005,
  0x00007ffcffff0006, 0x000055540000aaa9,
  0x000055535555fffc, 0x0000333266673331,
  0x000033320000ccc8, 0x000000007ffe0001,
  0x000000007ffd0000, 0x000000007ffd0005,
  0x000000007ffc0006, 0x000000007ffc0009,
  0x000000007ffb000c, 0x000000007ffb000d,
  0x000000007ffa0012, 0x00000000007ffe01,
  0x00000000007ffd00, 0x00000000007efe05,
  0x00000000007efd06, 0x00000000007dfe09,
  0x00000000007dfd0c, 0x00000000007cfe0d,
  0x00000000007cfd12, 0x00000000001fff81,
  0x00000000001fff40, 0x000000000002fff5,
  0x000000000002ffee, 0x000000000001fff9,
  0x000000000001fff4, 0x000000000000fffd,
  0x000000000000fffc, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0003,
  0xffffffffffff0004, 0xfffffffffffe0005,
  0xfffffffffffe0008, 0xffffffffffe00041,
  0xffffffffffe00080, 0xffffffffff8300fb,
  0xffffffffff8301f4, 0xffffffffff8200fd,
  0xffffffffff8201f8, 0xffffffffff8100ff,
  0xffffffffff8101fc, 0xffffffff8003fffb,
  0xffffffff8004fff4, 0xffffffff8002fffd,
  0xffffffff8003fff8, 0xffffffff8001ffff,
  0xffffffff8002fffc, 0xffffcccd33336667,
  0xffffcccd9999cccc, 0xffffaaab5555aaab,
  0xffffaaac00005554, 0xffff80010002fffb,
  0xffff80020002fff4, 0xffff80010001fffd,
  0xffff80020001fff8, 0xffff80010000ffff,
  0xffff80020000fffc, 0x00007fff00000001,
  0x00007ffe00000000, 0x00007ffeffff0003,
  0x00007ffdffff0004, 0x00005554aaab5555,
  0x000055540000aaa8, 0x00003332cccd9999,
  0x0000333266673330, 0x000000007fff0001,
  0x000000007ffe0000, 0x000000007ffe0003,
  0x000000007ffd0004, 0x000000007ffd0005,
  0x000000007ffc0008, 0x000000007ffc0007,
  0x000000007ffb000c, 0x00000000007fff01,
  0x00000000007ffe00, 0x00000000007eff03,
  0x00000000007efe04, 0x00000000007dff05,
  0x00000000007dfe08, 0x00000000007cff07,
  0x00000000007cfe0c, 0x00000000001fffc1,
  0x00000000001fff80, 0x000000000002fffb,
  0x000000000002fff4, 0x000000000001fffd,
  0x000000000001fff8, 0x000000000000ffff,
  0x000000000000fffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffff9999999b,
  0xffffffffffff0002, 0xffffffff33333335,
  0xfffffffffffe0004, 0xfffffff333333341,
  0xffffffffffe00040, 0xffffffce00000033,
  0xffffffffff8300fa, 0xffffffcd999999cd,
  0xffffffffff8200fc, 0xffffffcd33333367,
  0xffffffffff8100fe, 0xffffccce00003333,
  0xffffffff8003fffa, 0xffffcccd9999cccd,
  0xffffffff8002fffc, 0xffffcccd33336667,
  0xffffffff8001fffe, 0xeb851eb87ae147af,
  0xffffcccd33336666, 0xddddddde22222223,
  0xffffaaab5555aaaa, 0xccccccce33333333,
  0xffff80010002fffa, 0xcccccccdcccccccd,
  0xffff80010001fffc, 0xcccccccd66666667,
  0xffff80010000fffe, 0x3333333300000001,
  0x00007fff00000000, 0x333333329999999b,
  0x00007ffeffff0002, 0x2222222244444445,
  0x00005554aaab5554, 0x147ae147eb851eb9,
  0x00003332cccd9998, 0x0000333333330001,
  0x000000007fff0000, 0x00003332cccc999b,
  0x000000007ffe0002, 0x0000333266663335,
  0x000000007ffd0004, 0x00003331ffffcccf,
  0x000000007ffc0006, 0x0000003333333301,
  0x00000000007fff00, 0x00000032cccccc9b,
  0x00000000007eff02, 0x0000003266666635,
  0x00000000007dff04, 0x00000031ffffffcf,
  0x00000000007cff06, 0x0000000cccccccc1,
  0x00000000001fffc0, 0x0000000133333333,
  0x000000000002fffa, 0x00000000cccccccd,
  0x000000000001fffc, 0x0000000066666667,
  0x0000000066666666, 0x0000000000000001,
  0x0000000000000000, 0xffffffff55555557,
  0xffffffff9999999a, 0xfffffffeaaaaaaad,
  0xffffffff33333334, 0xffffffeaaaaaaac1,
  0xfffffff333333340, 0xffffffacaaaaaaff,
  0xffffffce00000032, 0xffffffac00000055,
  0xffffffcd999999cc, 0xffffffab555555ab,
  0xffffffcd33333366, 0xffffaaacaaaaffff,
  0xffffccce00003332, 0xffffaaac00005555,
  0xffffcccd9999cccc, 0xffffaaab5555aaab,
  0xffffcccd33336666, 0xddddddde22222223,
  0xeb851eb87ae147ae, 0xc71c71c78e38e38f,
  0xddddddde22222222, 0xaaaaaaacffffffff,
  0xccccccce33333332, 0xaaaaaaac55555555,
  0xcccccccdcccccccc, 0xaaaaaaabaaaaaaab,
  0xcccccccd66666666, 0x5555555500000001,
  0x3333333300000000, 0x5555555455555557,
  0x333333329999999a, 0x38e38e391c71c71d,
  0x2222222244444444, 0x2222222288888889,
  0x147ae147eb851eb8, 0x0000555555550001,
  0x0000333333330000, 0x00005554aaaa5557,
  0x00003332cccc999a, 0x00005553ffffaaad,
  0x0000333266663334, 0x0000555355550003,
  0x00003331ffffccce, 0x0000005555555501,
  0x0000003333333300, 0x00000054aaaaaa57,
  0x00000032cccccc9a, 0x00000053ffffffad,
  0x0000003266666634, 0x0000005355555503,
  0x00000031ffffffce, 0x0000001555555541,
  0x0000000cccccccc0, 0x00000001ffffffff,
  0x0000000133333332, 0x0000000155555555,
  0x00000000cccccccc, 0x00000000aaaaaaab,
  0x00000000aaaaaaaa, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000007,
  0xffffffff55555556, 0xfffffffe0000000d,
  0xfffffffeaaaaaaac, 0xffffffe0000000c1,
  0xffffffeaaaaaaac0, 0xffffff83000002ef,
  0xffffffacaaaaaafe, 0xffffff82000002f5,
  0xffffffac00000054, 0xffffff81000002fb,
  0xffffffab555555aa, 0xffff80030002ffef,
  0xffffaaacaaaafffe, 0xffff80020002fff5,
  0xffffaaac00005554, 0xffff80010002fffb,
  0xffffaaab5555aaaa, 0xccccccce33333333,
  0xddddddde22222222, 0xaaaaaaacffffffff,
  0xc71c71c78e38e38e, 0x80000005ffffffef,
  0xaaaaaaacfffffffe, 0x80000004fffffff5,
  0xaaaaaaac55555554, 0x80000003fffffffb,
  0xaaaaaaabaaaaaaaa, 0x7ffffffd00000001,
  0x5555555500000000, 0x7ffffffc00000007,
  0x5555555455555556, 0x55555553fffffffd,
  0x38e38e391c71c71c, 0x33333332ccccccc9,
  0x2222222288888888, 0x00007ffffffd0001,
  0x0000555555550000, 0x00007ffefffd0007,
  0x00005554aaaa5556, 0x00007ffdfffd000d,
  0x00005553ffffaaac, 0x00007ffcfffd0013,
  0x0000555355550002, 0x0000007ffffffd01,
  0x0000005555555500, 0x0000007efffffd07,
  0x00000054aaaaaa56, 0x0000007dfffffd0d,
  0x00000053ffffffac, 0x0000007cfffffd13,
  0x0000005355555502, 0x0000001fffffff41,
  0x0000001555555540, 0x00000002ffffffef,
  0x00000001fffffffe, 0x00000001fffffff5,
  0x0000000155555554, 0x00000000fffffffb,
  0x00000000fffffffa, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000005,
  0xffffffff00000006, 0xfffffffe00000009,
  0xfffffffe0000000c, 0xffffffe000000081,
  0xffffffe0000000c0, 0xffffff83000001f5,
  0xffffff83000002ee, 0xffffff82000001f9,
  0xffffff82000002f4, 0xffffff81000001fd,
  0xffffff81000002fa, 0xffff80030001fff5,
  0xffff80030002ffee, 0xffff80020001fff9,
  0xffff80020002fff4, 0xffff80010001fffd,
  0xffff80010002fffa, 0xcccccccdcccccccd,
  0xccccccce33333332, 0xaaaaaaac55555555,
  0xaaaaaaacfffffffe, 0x80000004fffffff5,
  0x80000005ffffffee, 0x80000003fffffff9,
  0x80000004fffffff4, 0x80000002fffffffd,
  0x80000003fffffffa, 0x7ffffffe00000001,
  0x7ffffffd00000000, 0x7ffffffd00000005,
  0x7ffffffc00000006, 0x55555554aaaaaaa9,
  0x55555553fffffffc, 0x3333333333333331,
  0x33333332ccccccc8, 0x00007ffffffe0001,
  0x00007ffffffd0000, 0x00007ffefffe0005,
  0x00007ffefffd0006, 0x00007ffdfffe0009,
  0x00007ffdfffd000c, 0x00007ffcfffe000d,
  0x00007ffcfffd0012, 0x0000007ffffffe01,
  0x0000007ffffffd00, 0x0000007efffffe05,
  0x0000007efffffd06, 0x0000007dfffffe09,
  0x0000007dfffffd0c, 0x0000007cfffffe0d,
  0x0000007cfffffd12, 0x0000001fffffff81,
  0x0000001fffffff40, 0x00000002fffffff5,
  0x00000002ffffffee, 0x00000001fffffff9,
  0x00000001fffffff4, 0x00000000fffffffd,
  0x00000000fffffffc, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000003,
  0xffffffff00000004, 0xfffffffe00000005,
  0xfffffffe00000008, 0xffffffe000000041,
  0xffffffe000000080, 0xffffff83000000fb,
  0xffffff83000001f4, 0xffffff82000000fd,
  0xffffff82000001f8, 0xffffff81000000ff,
  0xffffff81000001fc, 0xffff80030000fffb,
  0xffff80030001fff4, 0xffff80020000fffd,
  0xffff80020001fff8, 0xffff80010000ffff,
  0xffff80010001fffc, 0xcccccccd66666667,
  0xcccccccdcccccccc, 0xaaaaaaabaaaaaaab,
  0xaaaaaaac55555554, 0x80000003fffffffb,
  0x80000004fffffff4, 0x80000002fffffffd,
  0x80000003fffffff8, 0x80000001ffffffff,
  0x80000002fffffffc, 0x7fffffff00000001,
  0x7ffffffe00000000, 0x7ffffffe00000003,
  0x7ffffffd00000004, 0x5555555555555555,
  0x55555554aaaaaaa8, 0x3333333399999999,
  0x3333333333333330, 0x00007fffffff0001,
  0x00007ffffffe0000, 0x00007ffeffff0003,
  0x00007ffefffe0004, 0x00007ffdffff0005,
  0x00007ffdfffe0008, 0x00007ffcffff0007,
  0x00007ffcfffe000c, 0x0000007fffffff01,
  0x0000007ffffffe00, 0x0000007effffff03,
  0x0000007efffffe04, 0x0000007dffffff05,
  0x0000007dfffffe08, 0x0000007cffffff07,
  0x0000007cfffffe0c, 0x0000001fffffffc1,
  0x0000001fffffff80, 0x00000002fffffffb,
  0x00000002fffffff4, 0x00000001fffffffd,
  0x00000001fffffff8, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000000000001,
  0x0000000000000000, 0x0000000100000001,
  0xffffffff00000002, 0x0000000200000001,
  0xfffffffe00000004, 0x0000002000000001,
  0xffffffe000000040, 0x0000007d00000001,
  0xffffff83000000fa, 0x0000007e00000001,
  0xffffff82000000fc, 0x0000007f00000001,
  0xffffff81000000fe, 0x00007ffd00000001,
  0xffff80030000fffa, 0x00007ffe00000001,
  0xffff80020000fffc, 0x00007fff00000001,
  0xffff80010000fffe, 0x3333333300000001,
  0xcccccccd66666666, 0x5555555500000001,
  0xaaaaaaabaaaaaaaa, 0x7ffffffd00000001,
  0x80000003fffffffa, 0x7ffffffe00000001,
  0x80000002fffffffc, 0x7fffffff00000001,
  0x80000001fffffffe, 0x8000000000000002,
  0x7fffffff00000000, 0x8000000100000001,
  0x7ffffffe00000002, 0xaaaaaaaa00000001,
  0x5555555555555554, 0xcccccccc00000001,
  0x3333333399999998, 0xffff800000000001,
  0x00007fffffff0000, 0xffff800100000001,
  0x00007ffeffff0002, 0xffff800200000001,
  0x00007ffdffff0004, 0xffff800300000001,
  0x00007ffcffff0006, 0xffffff8000000001,
  0x0000007fffffff00, 0xffffff8100000001,
  0x0000007effffff02, 0xffffff8200000001,
  0x0000007dffffff04, 0xffffff8300000001,
  0x0000007cffffff06, 0xffffffe000000001,
  0x0000001fffffffc0, 0xfffffffd00000001,
  0x00000002fffffffa, 0xfffffffe00000001,
  0x00000001fffffffc, 0xffffffff00000001,
  0xffffffff00000000, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000100000000, 0x00000001fffffffd,
  0x0000000200000000, 0x0000001fffffffc1,
  0x0000002000000000, 0x0000007cffffff07,
  0x0000007d00000000, 0x0000007dffffff05,
  0x0000007e00000000, 0x0000007effffff03,
  0x0000007f00000000, 0x00007ffcffff0007,
  0x00007ffd00000000, 0x00007ffdffff0005,
  0x00007ffe00000000, 0x00007ffeffff0003,
  0x00007fff00000000, 0x333333329999999b,
  0x3333333300000000, 0x5555555455555557,
  0x5555555500000000, 0x7ffffffc00000007,
  0x7ffffffd00000000, 0x7ffffffd00000005,
  0x7ffffffe00000000, 0x7ffffffe00000003,
  0x7fffffff00000000, 0x8000000100000001,
  0x8000000000000001, 0x80000001ffffffff,
  0x8000000100000000, 0xaaaaaaaaaaaaaaad,
  0xaaaaaaaa00000000, 0xcccccccc66666669,
  0xcccccccc00000000, 0xffff800000010001,
  0xffff800000000000, 0xffff80010000ffff,
  0xffff800100000000, 0xffff80020000fffd,
  0xffff800200000000, 0xffff80030000fffb,
  0xffff800300000000, 0xffffff8000000101,
  0xffffff8000000000, 0xffffff81000000ff,
  0xffffff8100000000, 0xffffff82000000fd,
  0xffffff8200000000, 0xffffff83000000fb,
  0xffffff8300000000, 0xffffffe000000041,
  0xffffffe000000000, 0xfffffffd00000007,
  0xfffffffd00000000, 0xfffffffe00000005,
  0xfffffffe00000000, 0xffffffff00000003,
  0xffffffff00000002, 0x0000000000000001,
  0x0000000000000000, 0x00000000aaaaaaad,
  0x00000000fffffffe, 0x0000000155555559,
  0x00000001fffffffc, 0x0000001555555581,
  0x0000001fffffffc0, 0x00000053555555fd,
  0x0000007cffffff06, 0x00000054000000a9,
  0x0000007dffffff04, 0x00000054aaaaab55,
  0x0000007effffff02, 0x000055535555fffd,
  0x00007ffcffff0006, 0x000055540000aaa9,
  0x00007ffdffff0004, 0x00005554aaab5555,
  0x00007ffeffff0002, 0x2222222244444445,
  0x333333329999999a, 0x38e38e391c71c71d,
  0x5555555455555556, 0x55555553fffffffd,
  0x7ffffffc00000006, 0x55555554aaaaaaa9,
  0x7ffffffd00000004, 0x5555555555555555,
  0x7ffffffe00000002, 0xaaaaaaaa00000001,
  0x8000000100000000, 0xaaaaaaaaaaaaaaad,
  0x80000001fffffffe, 0xc71c71c638e38e39,
  0xaaaaaaaaaaaaaaac, 0xdddddddd11111111,
  0xcccccccc66666668, 0xffffaaaaaaaa0001,
  0xffff800000010000, 0xffffaaab5554aaad,
  0xffff80010000fffe, 0xffffaaabffff5559,
  0xffff80020000fffc, 0xffffaaacaaaa0005,
  0xffff80030000fffa, 0xffffffaaaaaaaa01,
  0xffffff8000000100, 0xffffffab555554ad,
  0xffffff81000000fe, 0xffffffabffffff59,
  0xffffff82000000fc, 0xffffffacaaaaaa05,
  0xffffff83000000fa, 0xffffffeaaaaaaa81,
  0xffffffe000000040, 0xfffffffdfffffffd,
  0xfffffffd00000006, 0xfffffffeaaaaaaa9,
  0xfffffffe00000004, 0xffffffff55555555,
  0xffffffff55555554, 0x0000000000000001,
  0x0000000000000000, 0x0000000066666669,
  0x00000000aaaaaaac, 0x00000000ccccccd1,
  0x0000000155555558, 0x0000000ccccccd01,
  0x0000001555555580, 0x00000032000000c9,
  0x00000053555555fc, 0x0000003266666731,
  0x00000054000000a8, 0x00000032cccccd99,
  0x00000054aaaaab54, 0x000033320000ccc9,
  0x000055535555fffc, 0x0000333266673331,
  0x000055540000aaa8, 0x00003332cccd9999,
  0x00005554aaab5554, 0x147ae147eb851eb9,
  0x2222222244444444, 0x2222222288888889,
  0x38e38e391c71c71c, 0x33333332ccccccc9,
  0x55555553fffffffc, 0x3333333333333331,
  0x55555554aaaaaaa8, 0x3333333399999999,
  0x5555555555555554, 0xcccccccc00000001,
  0xaaaaaaaa00000000, 0xcccccccc66666669,
  0xaaaaaaaaaaaaaaac, 0xdddddddd11111111,
  0xc71c71c638e38e38, 0xeb851eb7ae147ae1,
  0xdddddddd11111110, 0xffffcccccccc0001,
  0xffffaaaaaaaa0000, 0xffffcccd33326669,
  0xffffaaab5554aaac, 0xffffcccd9998ccd1,
  0xffffaaabffff5558, 0xffffcccdffff3339,
  0xffffaaacaaaa0004, 0xffffffcccccccc01,
  0xffffffaaaaaaaa00, 0xffffffcd33333269,
  0xffffffab555554ac, 0xffffffcd999998d1,
  0xffffffabffffff58, 0xffffffcdffffff39,
  0xffffffacaaaaaa04, 0xfffffff333333301,
  0xffffffeaaaaaaa80, 0xfffffffeccccccc9,
  0xfffffffdfffffffc, 0xffffffff33333331,
  0xfffffffeaaaaaaa8, 0xffffffff99999999,
  0xffffffff99999998, 0x0000000000000001,
  0x0000000000000000, 0x0000000000010001,
  0x0000000066666668, 0x0000000000020001,
  0x00000000ccccccd0, 0x0000000000200001,
  0x0000000ccccccd00, 0x00000000007d0001,
  0x00000032000000c8, 0x00000000007e0001,
  0x0000003266666730, 0x00000000007f0001,
  0x00000032cccccd98, 0x000000007ffd0001,
  0x000033320000ccc8, 0x000000007ffe0001,
  0x0000333266673330, 0x000000007fff0001,
  0x00003332cccd9998, 0x0000333333330001,
  0x147ae147eb851eb8, 0x0000555555550001,
  0x2222222288888888, 0x00007ffffffd0001,
  0x33333332ccccccc8, 0x00007ffffffe0001,
  0x3333333333333330, 0x00007fffffff0001,
  0x3333333399999998, 0xffff800000000001,
  0xcccccccc00000000, 0xffff800000010001,
  0xcccccccc66666668, 0xffffaaaaaaaa0001,
  0xdddddddd11111110, 0xffffcccccccc0001,
  0xeb851eb7ae147ae0, 0xffffffff80000001,
  0xffffcccccccc0000, 0xffffffff80010001,
  0xffffcccd33326668, 0xffffffff80020001,
  0xffffcccd9998ccd0, 0xffffffff80030001,
  0xffffcccdffff3338, 0xffffffffff800001,
  0xffffffcccccccc00, 0xffffffffff810001,
  0xffffffcd33333268, 0xffffffffff820001,
  0xffffffcd999998d0, 0xffffffffff830001,
  0xffffffcdffffff38, 0xffffffffffe00001,
  0xfffffff333333300, 0xfffffffffffd0001,
  0xfffffffeccccccc8, 0xfffffffffffe0001,
  0xffffffff33333330, 0xffffffffffff0001,
  0xffffffffffff0000, 0x0000000000000001,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000010000, 0x000000000001fffd,
  0x0000000000020000, 0x00000000001fffc1,
  0x0000000000200000, 0x00000000007cff07,
  0x00000000007d0000, 0x00000000007dff05,
  0x00000000007e0000, 0x00000000007eff03,
  0x00000000007f0000, 0x000000007ffc0007,
  0x000000007ffd0000, 0x000000007ffd0005,
  0x000000007ffe0000, 0x000000007ffe0003,
  0x000000007fff0000, 0x00003332cccc999b,
  0x0000333333330000, 0x00005554aaaa5557,
  0x0000555555550000, 0x00007ffefffd0007,
  0x00007ffffffd0000, 0x00007ffefffe0005,
  0x00007ffffffe0000, 0x00007ffeffff0003,
  0x00007fffffff0000, 0xffff800100000001,
  0xffff800000000000, 0xffff80010000ffff,
  0xffff800000010000, 0xffffaaab5554aaad,
  0xffffaaaaaaaa0000, 0xffffcccd33326669,
  0xffffcccccccc0000, 0xffffffff80010001,
  0xffffffff80000000, 0xffffffff8001ffff,
  0xffffffff80010000, 0xffffffff8002fffd,
  0xffffffff80020000, 0xffffffff8003fffb,
  0xffffffff80030000, 0xffffffffff800101,
  0xffffffffff800000, 0xffffffffff8100ff,
  0xffffffffff810000, 0xffffffffff8200fd,
  0xffffffffff820000, 0xffffffffff8300fb,
  0xffffffffff830000, 0xffffffffffe00041,
  0xffffffffffe00000, 0xfffffffffffd0007,
  0xfffffffffffd0000, 0xfffffffffffe0005,
  0xfffffffffffe0000, 0xffffffffffff0003,
  0xffffffffffff0002, 0x0000000000000001,
  0x0000000000000000, 0x000000000000fffd,
  0x000000000000fffe, 0x000000000001fff9,
  0x000000000001fffc, 0x00000000001fff81,
  0x00000000001fffc0, 0x00000000007cfe0d,
  0x00000000007cff06, 0x00000000007dfe09,
  0x00000000007dff04, 0x00000000007efe05,
  0x00000000007eff02, 0x000000007ffb000d,
  0x000000007ffc0006, 0x000000007ffc0009,
  0x000000007ffd0004, 0x000000007ffd0005,
  0x000000007ffe0002, 0x0000333266663335,
  0x00003332cccc999a, 0x00005553ffffaaad,
  0x00005554aaaa5556, 0x00007ffdfffd000d,
  0x00007ffefffd0006, 0x00007ffdfffe0009,
  0x00007ffefffe0004, 0x00007ffdffff0005,
  0x00007ffeffff0002, 0xffff800200000001,
  0xffff800100000000, 0xffff80020000fffd,
  0xffff80010000fffe, 0xffffaaabffff5559,
  0xffffaaab5554aaac, 0xffffcccd9998ccd1,
  0xffffcccd33326668, 0xffffffff80020001,
  0xffffffff80010000, 0xffffffff8002fffd,
  0xffffffff8001fffe, 0xffffffff8003fff9,
  0xffffffff8002fffc, 0xffffffff8004fff5,
  0xffffffff8003fffa, 0xffffffffff800201,
  0xffffffffff800100, 0xffffffffff8101fd,
  0xffffffffff8100fe, 0xffffffffff8201f9,
  0xffffffffff8200fc, 0xffffffffff8301f5,
  0xffffffffff8300fa, 0xffffffffffe00081,
  0xffffffffffe00040, 0xfffffffffffd000d,
  0xfffffffffffd0006, 0xfffffffffffe0009,
  0xfffffffffffe0004, 0xffffffffffff0005,
  0xffffffffffff0004, 0x0000000000000001,
  0x0000000000000000, 0x000000000000fffb,
  0x000000000000fffc, 0x000000000001fff5,
  0x000000000001fff8, 0x00000000001fff41,
  0x00000000001fff80, 0x00000000007cfd13,
  0x00000000007cfe0c, 0x00000000007dfd0d,
  0x00000000007dfe08, 0x00000000007efd07,
  0x00000000007efe04, 0x000000007ffa0013,
  0x000000007ffb000c, 0x000000007ffb000d,
  0x000000007ffc0008, 0x000000007ffc0007,
  0x000000007ffd0004, 0x00003331ffffcccf,
  0x0000333266663334, 0x0000555355550003,
  0x00005553ffffaaac, 0x00007ffcfffd0013,
  0x00007ffdfffd000c, 0x00007ffcfffe000d,
  0x00007ffdfffe0008, 0x00007ffcffff0007,
  0x00007ffdffff0004, 0xffff800300000001,
  0xffff800200000000, 0xffff80030000fffb,
  0xffff80020000fffc, 0xffffaaacaaaa0005,
  0xffffaaabffff5558, 0xffffcccdffff3339,
  0xffffcccd9998ccd0, 0xffffffff80030001,
  0xffffffff80020000, 0xffffffff8003fffb,
  0xffffffff8002fffc, 0xffffffff8004fff5,
  0xffffffff8003fff8, 0xffffffff8005ffef,
  0xffffffff8004fff4, 0xffffffffff800301,
  0xffffffffff800200, 0xffffffffff8102fb,
  0xffffffffff8101fc, 0xffffffffff8202f5,
  0xffffffffff8201f8, 0xffffffffff8302ef,
  0xffffffffff8301f4, 0xffffffffffe000c1,
  0xffffffffffe00080, 0xfffffffffffd0013,
  0xfffffffffffd000c, 0xfffffffffffe000d,
  0xfffffffffffe0008, 0xffffffffffff0007,
  0xffffffffffff0006, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000101,
  0x000000000000fffa, 0x0000000000000201,
  0x000000000001fff4, 0x0000000000002001,
  0x00000000001fff40, 0x0000000000007d01,
  0x00000000007cfd12, 0x0000000000007e01,
  0x00000000007dfd0c, 0x0000000000007f01,
  0x00000000007efd06, 0x00000000007ffd01,
  0x000000007ffa0012, 0x00000000007ffe01,
  0x000000007ffb000c, 0x00000000007fff01,
  0x000000007ffc0006, 0x0000003333333301,
  0x00003331ffffccce, 0x0000005555555501,
  0x0000555355550002, 0x0000007ffffffd01,
  0x00007ffcfffd0012, 0x0000007ffffffe01,
  0x00007ffcfffe000c, 0x0000007fffffff01,
  0x00007ffcffff0006, 0xffffff8000000001,
  0xffff800300000000, 0xffffff8000000101,
  0xffff80030000fffa, 0xffffffaaaaaaaa01,
  0xffffaaacaaaa0004, 0xffffffcccccccc01,
  0xffffcccdffff3338, 0xffffffffff800001,
  0xffffffff80030000, 0xffffffffff800101,
  0xffffffff8003fffa, 0xffffffffff800201,
  0xffffffff8004fff4, 0xffffffffff800301,
  0xffffffff8005ffee, 0xffffffffffff8001,
  0xffffffffff800300, 0xffffffffffff8101,
  0xffffffffff8102fa, 0xffffffffffff8201,
  0xffffffffff8202f4, 0xffffffffffff8301,
  0xffffffffff8302ee, 0xffffffffffffe001,
  0xffffffffffe000c0, 0xfffffffffffffd01,
  0xfffffffffffd0012, 0xfffffffffffffe01,
  0xfffffffffffe000c, 0xffffffffffffff01,
  0xffffffffffffff00, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000100, 0x00000000000001fd,
  0x0000000000000200, 0x0000000000001fc1,
  0x0000000000002000, 0x0000000000007c07,
  0x0000000000007d00, 0x0000000000007d05,
  0x0000000000007e00, 0x0000000000007e03,
  0x0000000000007f00, 0x00000000007efd07,
  0x00000000007ffd00, 0x00000000007efe05,
  0x00000000007ffe00, 0x00000000007eff03,
  0x00000000007fff00, 0x00000032cccccc9b,
  0x0000003333333300, 0x00000054aaaaaa57,
  0x0000005555555500, 0x0000007efffffd07,
  0x0000007ffffffd00, 0x0000007efffffe05,
  0x0000007ffffffe00, 0x0000007effffff03,
  0x0000007fffffff00, 0xffffff8100000001,
  0xffffff8000000000, 0xffffff81000000ff,
  0xffffff8000000100, 0xffffffab555554ad,
  0xffffffaaaaaaaa00, 0xffffffcd33333269,
  0xffffffcccccccc00, 0xffffffffff810001,
  0xffffffffff800000, 0xffffffffff8100ff,
  0xffffffffff800100, 0xffffffffff8101fd,
  0xffffffffff800200, 0xffffffffff8102fb,
  0xffffffffff800300, 0xffffffffffff8101,
  0xffffffffffff8000, 0xffffffffffff81ff,
  0xffffffffffff8100, 0xffffffffffff82fd,
  0xffffffffffff8200, 0xffffffffffff83fb,
  0xffffffffffff8300, 0xffffffffffffe041,
  0xffffffffffffe000, 0xfffffffffffffd07,
  0xfffffffffffffd00, 0xfffffffffffffe05,
  0xfffffffffffffe00, 0xffffffffffffff03,
  0xffffffffffffff02, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000fd,
  0x00000000000000fe, 0x00000000000001f9,
  0x00000000000001fc, 0x0000000000001f81,
  0x0000000000001fc0, 0x0000000000007b0d,
  0x0000000000007c06, 0x0000000000007c09,
  0x0000000000007d04, 0x0000000000007d05,
  0x0000000000007e02, 0x00000000007dfd0d,
  0x00000000007efd06, 0x00000000007dfe09,
  0x00000000007efe04, 0x00000000007dff05,
  0x00000000007eff02, 0x0000003266666635,
  0x00000032cccccc9a, 0x00000053ffffffad,
  0x00000054aaaaaa56, 0x0000007dfffffd0d,
  0x0000007efffffd06, 0x0000007dfffffe09,
  0x0000007efffffe04, 0x0000007dffffff05,
  0x0000007effffff02, 0xffffff8200000001,
  0xffffff8100000000, 0xffffff82000000fd,
  0xffffff81000000fe, 0xffffffabffffff59,
  0xffffffab555554ac, 0xffffffcd999998d1,
  0xffffffcd33333268, 0xffffffffff820001,
  0xffffffffff810000, 0xffffffffff8200fd,
  0xffffffffff8100fe, 0xffffffffff8201f9,
  0xffffffffff8101fc, 0xffffffffff8202f5,
  0xffffffffff8102fa, 0xffffffffffff8201,
  0xffffffffffff8100, 0xffffffffffff82fd,
  0xffffffffffff81fe, 0xffffffffffff83f9,
  0xffffffffffff82fc, 0xffffffffffff84f5,
  0xffffffffffff83fa, 0xffffffffffffe081,
  0xffffffffffffe040, 0xfffffffffffffd0d,
  0xfffffffffffffd06, 0xfffffffffffffe09,
  0xfffffffffffffe04, 0xffffffffffffff05,
  0xffffffffffffff04, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000fb,
  0x00000000000000fc, 0x00000000000001f5,
  0x00000000000001f8, 0x0000000000001f41,
  0x0000000000001f80, 0x0000000000007a13,
  0x0000000000007b0c, 0x0000000000007b0d,
  0x0000000000007c08, 0x0000000000007c07,
  0x0000000000007d04, 0x00000000007cfd13,
  0x00000000007dfd0c, 0x00000000007cfe0d,
  0x00000000007dfe08, 0x00000000007cff07,
  0x00000000007dff04, 0x00000031ffffffcf,
  0x0000003266666634, 0x0000005355555503,
  0x00000053ffffffac, 0x0000007cfffffd13,
  0x0000007dfffffd0c, 0x0000007cfffffe0d,
  0x0000007dfffffe08, 0x0000007cffffff07,
  0x0000007dffffff04, 0xffffff8300000001,
  0xffffff8200000000, 0xffffff83000000fb,
  0xffffff82000000fc, 0xffffffacaaaaaa05,
  0xffffffabffffff58, 0xffffffcdffffff39,
  0xffffffcd999998d0, 0xffffffffff830001,
  0xffffffffff820000, 0xffffffffff8300fb,
  0xffffffffff8200fc, 0xffffffffff8301f5,
  0xffffffffff8201f8, 0xffffffffff8302ef,
  0xffffffffff8202f4, 0xffffffffffff8301,
  0xffffffffffff8200, 0xffffffffffff83fb,
  0xffffffffffff82fc, 0xffffffffffff84f5,
  0xffffffffffff83f8, 0xffffffffffff85ef,
  0xffffffffffff84f4, 0xffffffffffffe0c1,
  0xffffffffffffe080, 0xfffffffffffffd13,
  0xfffffffffffffd0c, 0xfffffffffffffe0d,
  0xfffffffffffffe08, 0xffffffffffffff07,
  0xffffffffffffff06, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000041,
  0x00000000000000fa, 0x0000000000000081,
  0x00000000000001f4, 0x0000000000000801,
  0x0000000000001f40, 0x0000000000001f41,
  0x0000000000007a12, 0x0000000000001f81,
  0x0000000000007b0c, 0x0000000000001fc1,
  0x0000000000007c06, 0x00000000001fff41,
  0x00000000007cfd12, 0x00000000001fff81,
  0x00000000007cfe0c, 0x00000000001fffc1,
  0x00000000007cff06, 0x0000000cccccccc1,
  0x00000031ffffffce, 0x0000001555555541,
  0x0000005355555502, 0x0000001fffffff41,
  0x0000007cfffffd12, 0x0000001fffffff81,
  0x0000007cfffffe0c, 0x0000001fffffffc1,
  0x0000007cffffff06, 0xffffffe000000001,
  0xffffff8300000000, 0xffffffe000000041,
  0xffffff83000000fa, 0xffffffeaaaaaaa81,
  0xffffffacaaaaaa04, 0xfffffff333333301,
  0xffffffcdffffff38, 0xffffffffffe00001,
  0xffffffffff830000, 0xffffffffffe00041,
  0xffffffffff8300fa, 0xffffffffffe00081,
  0xffffffffff8301f4, 0xffffffffffe000c1,
  0xffffffffff8302ee, 0xffffffffffffe001,
  0xffffffffffff8300, 0xffffffffffffe041,
  0xffffffffffff83fa, 0xffffffffffffe081,
  0xffffffffffff84f4, 0xffffffffffffe0c1,
  0xffffffffffff85ee, 0xfffffffffffff801,
  0xffffffffffffe0c0, 0xffffffffffffff41,
  0xfffffffffffffd12, 0xffffffffffffff81,
  0xfffffffffffffe0c, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000040, 0x000000000000000d,
  0x0000000000000080, 0x00000000000000c1,
  0x0000000000000800, 0x00000000000002ef,
  0x0000000000001f40, 0x00000000000002f5,
  0x0000000000001f80, 0x00000000000002fb,
  0x0000000000001fc0, 0x000000000002ffef,
  0x00000000001fff40, 0x000000000002fff5,
  0x00000000001fff80, 0x000000000002fffb,
  0x00000000001fffc0, 0x0000000133333333,
  0x0000000cccccccc0, 0x00000001ffffffff,
  0x0000001555555540, 0x00000002ffffffef,
  0x0000001fffffff40, 0x00000002fffffff5,
  0x0000001fffffff80, 0x00000002fffffffb,
  0x0000001fffffffc0, 0xfffffffd00000001,
  0xffffffe000000000, 0xfffffffd00000007,
  0xffffffe000000040, 0xfffffffdfffffffd,
  0xffffffeaaaaaaa80, 0xfffffffeccccccc9,
  0xfffffff333333300, 0xfffffffffffd0001,
  0xffffffffffe00000, 0xfffffffffffd0007,
  0xffffffffffe00040, 0xfffffffffffd000d,
  0xffffffffffe00080, 0xfffffffffffd0013,
  0xffffffffffe000c0, 0xfffffffffffffd01,
  0xffffffffffffe000, 0xfffffffffffffd07,
  0xffffffffffffe040, 0xfffffffffffffd0d,
  0xffffffffffffe080, 0xfffffffffffffd13,
  0xffffffffffffe0c0, 0xffffffffffffff41,
  0xfffffffffffff800, 0xffffffffffffffef,
  0xffffffffffffff40, 0xfffffffffffffff5,
  0xffffffffffffff80, 0xfffffffffffffffb,
  0xfffffffffffffffa, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000006, 0x0000000000000009,
  0x000000000000000c, 0x0000000000000081,
  0x00000000000000c0, 0x00000000000001f5,
  0x00000000000002ee, 0x00000000000001f9,
  0x00000000000002f4, 0x00000000000001fd,
  0x00000000000002fa, 0x000000000001fff5,
  0x000000000002ffee, 0x000000000001fff9,
  0x000000000002fff4, 0x000000000001fffd,
  0x000000000002fffa, 0x00000000cccccccd,
  0x0000000133333332, 0x0000000155555555,
  0x00000001fffffffe, 0x00000001fffffff5,
  0x00000002ffffffee, 0x00000001fffffff9,
  0x00000002fffffff4, 0x00000001fffffffd,
  0x00000002fffffffa, 0xfffffffe00000001,
  0xfffffffd00000000, 0xfffffffe00000005,
  0xfffffffd00000006, 0xfffffffeaaaaaaa9,
  0xfffffffdfffffffc, 0xffffffff33333331,
  0xfffffffeccccccc8, 0xfffffffffffe0001,
  0xfffffffffffd0000, 0xfffffffffffe0005,
  0xfffffffffffd0006, 0xfffffffffffe0009,
  0xfffffffffffd000c, 0xfffffffffffe000d,
  0xfffffffffffd0012, 0xfffffffffffffe01,
  0xfffffffffffffd00, 0xfffffffffffffe05,
  0xfffffffffffffd06, 0xfffffffffffffe09,
  0xfffffffffffffd0c, 0xfffffffffffffe0d,
  0xfffffffffffffd12, 0xffffffffffffff81,
  0xffffffffffffff40, 0xfffffffffffffff5,
  0xffffffffffffffee, 0xfffffffffffffff9,
  0xfffffffffffffff4, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000005,
  0x0000000000000008, 0x0000000000000041,
  0x0000000000000080, 0x00000000000000fb,
  0x00000000000001f4, 0x00000000000000fd,
  0x00000000000001f8, 0x00000000000000ff,
  0x00000000000001fc, 0x000000000000fffb,
  0x000000000001fff4, 0x000000000000fffd,
  0x000000000001fff8, 0x000000000000ffff,
  0x000000000001fffc, 0x0000000066666667,
  0x00000000cccccccc, 0x00000000aaaaaaab,
  0x0000000155555554, 0x00000000fffffffb,
  0x00000001fffffff4, 0x00000000fffffffd,
  0x00000001fffffff8, 0x00000000ffffffff,
  0x00000001fffffffc, 0xffffffff00000001,
  0xfffffffe00000000, 0xffffffff00000003,
  0xfffffffe00000004, 0xffffffff55555555,
  0xfffffffeaaaaaaa8, 0xffffffff99999999,
  0xffffffff33333330, 0xffffffffffff0001,
  0xfffffffffffe0000, 0xffffffffffff0003,
  0xfffffffffffe0004, 0xffffffffffff0005,
  0xfffffffffffe0008, 0xffffffffffff0007,
  0xfffffffffffe000c, 0xffffffffffffff01,
  0xfffffffffffffe00, 0xffffffffffffff03,
  0xfffffffffffffe04, 0xffffffffffffff05,
  0xfffffffffffffe08, 0xffffffffffffff07,
  0xfffffffffffffe0c, 0xffffffffffffffc1,
  0xffffffffffffff80, 0xfffffffffffffffb,
  0xfffffffffffffff4, 0xfffffffffffffffd,
  0xfffffffffffffff8, 0xffffffffffffffff,
};
const unsigned kExpectedCount_NEON_sqdmlsl2_2D = 961;

#endif  // VIXL_SIM_SQDMLSL2_2D_TRACE_AARCH64_H_
