// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABA_4H_TRACE_AARCH64_H_
#define VIXL_SIM_SABA_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_saba_4H[] = {
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0xb335, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8080, 0xb334, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x888b, 0x8899, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x55d6, 0x6669, 0x55e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0x33b4, 0x33b5, 0x55e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x0100, 0x33b4, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x00ff, 0x33b3, 0x55e2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x33b2, 0x55d4, 0x801d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b1, 0x5567, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x3344, 0x555a, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x3337, 0x5559, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0082, 0x3336, 0x5558, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x3335, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0xd557, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0xb334, 0xd556, 0xd563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb333, 0xaaad, 0xb341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x888a, 0x888b, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x6668, 0x55d7, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x33b4, 0x55d6, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0x33b3, 0x55d5, 0x808a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x55d4, 0x807c, 0x801e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d3, 0x800f, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b0, 0x5566, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3343, 0x5559, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3336, 0x5558, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x5557, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0xffff, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0xd556, 0xfffe, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd555, 0xd555, 0xb342, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xaaac, 0xb333, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x888a, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x55d6, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x55d5, 0x807d, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0x807c, 0x807d, 0x801f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807b, 0x8010, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d2, 0x800e, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5565, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5558, 0x8000, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x7fff, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0xfffe, 0xffff, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffd, 0xd556, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xd554, 0xb334, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xb332, 0x8080, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x807e, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x807d, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807d, 0x807e, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807c, 0x8011, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807a, 0x800f, 0x8004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800d, 0x8002, 0x8003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xffff, 0x0000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffe, 0xd557, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xd555, 0xb335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xb333, 0x8081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0x807f, 0x8080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x807f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x007f, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807d, 0x0012, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x8010, 0x0005, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800e, 0x8003, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0004, 0x001f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x0012, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x0081, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x8001, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0000, 0x8001, 0x5567, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x5558, 0x3345, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xd556, 0x3336, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xb334, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0x8080, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x007f, 0x0080, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x007e, 0x0013, 0x0015, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x0011, 0x0006, 0x0014, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x0004, 0x0005, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x0003, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0002, 0x0003, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x0003, 0x0011, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x0011, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x007f, 0x0080, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x7fff, 0x8000, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x8000, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x8002, 0x5568, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x8000, 0x5559, 0x3346, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x5557, 0x3337, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x3335, 0x0083, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x0081, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x0080, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0080, 0x0081, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x0014, 0x0023, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x0012, 0x0007, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x0005, 0x0006, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0004, 0x0005, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0004, 0x001f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x001e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8004, 0x801f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8002, 0x8003, 0x5576, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x555a, 0x3354, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x5558, 0x3338, 0x00a0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x3336, 0x0084, 0x009f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0082, 0x0083, 0x009e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0081, 0x0082, 0x009d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0081, 0x008f, 0x009d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0080, 0x0022, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0013, 0x0015, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0011, 0x0006, 0x0014, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0005, 0x0013, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0004, 0x0012, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0011, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000f, 0x006f, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007c, 0x0070, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007d, 0x0071, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x8012, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8003, 0x8011, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x5568, 0x33c1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x5559, 0x3346, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x3337, 0x0092, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x0083, 0x0091, 0x010b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x0082, 0x0090, 0x010a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x008f, 0x00fc, 0x009e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x008e, 0x008f, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0021, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x0014, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0005, 0x0013, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0012, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0011, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000f, 0x006f, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006e, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006f, 0x0004, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x8011, 0x807e, 0x55e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8010, 0x55d5, 0x33c2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x5567, 0x33b3, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5558, 0x3345, 0x00ff, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3336, 0x0091, 0x00fe, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0082, 0x0090, 0x00fd, 0x010b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x00fc, 0x00fd, 0x009f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008e, 0x00fb, 0x0090, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x008e, 0x0083, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x0081, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0013, 0x0080, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x007f, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0011, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007c, 0x0070, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006e, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0002, 0x0003, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x8080, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x807e, 0x807f, 0x55e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8010, 0x807d, 0x55d6, 0x33c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x55d4, 0x33b4, 0x010f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5566, 0x33b2, 0x0100, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3344, 0x00fe, 0x00ff, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0090, 0x00fd, 0x00fe, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x00fd, 0x00fe, 0x3353, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x00fc, 0x0091, 0x3346, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fa, 0x008f, 0x0084, 0x3345, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x0082, 0x0083, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0081, 0x0082, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0080, 0x0081, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x0080, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007d, 0x0071, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006f, 0x0004, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0002, 0x0003, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x8081, 0xb342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x807f, 0x8080, 0x8899, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x55d7, 0x6677, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x55d5, 0x33b5, 0x33c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x33b3, 0x0101, 0x33c2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x00ff, 0x0100, 0x33c1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x00fe, 0x00ff, 0x33c0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x00fe, 0x33b2, 0x5575, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x00fd, 0x3345, 0x5568, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x0090, 0x3338, 0x5567, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008e, 0x0083, 0x3337, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x0082, 0x3336, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0081, 0x3335, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0080, 0x3334, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x3325, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x0070, 0x32b8, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0003, 0x32b7, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x32b6, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0xb335, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8080, 0xb334, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x888b, 0x8899, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x55d6, 0x6669, 0x55e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0x33b4, 0x33b5, 0x55e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x0100, 0x33b4, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x00ff, 0x33b3, 0x55e2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x33b2, 0x55d4, 0x801d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b1, 0x5567, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x3344, 0x555a, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x3337, 0x5559, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0082, 0x3336, 0x5558, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x3335, 0x5557, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x3334, 0x5556, 0x800b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3332, 0x5547, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3324, 0x54da, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b7, 0x54d9, 0x7f8e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b6, 0x54d8, 0x4cda, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b5, 0x2224, 0x2ab8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0xd557, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0xb334, 0xd556, 0xd563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb333, 0xaaad, 0xb341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x888a, 0x888b, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x6668, 0x55d7, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x33b4, 0x55d6, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0x33b3, 0x55d5, 0x808a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x55d4, 0x807c, 0x801e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d3, 0x800f, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b0, 0x5566, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3343, 0x5559, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3336, 0x5558, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x5557, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x5556, 0x7ffe, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5554, 0x7fef, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5546, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d9, 0x7f81, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d8, 0x7f80, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d7, 0x4ccc, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2223, 0x2aaa, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0xffff, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0xd556, 0xfffe, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd555, 0xd555, 0xb342, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xaaac, 0xb333, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x888a, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x55d6, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x55d5, 0x807d, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0x807c, 0x807d, 0x801f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807b, 0x8010, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d2, 0x800e, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5565, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5558, 0x8000, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x7fff, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x7ffe, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffc, 0x7ff0, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fee, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f81, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f80, 0x7f81, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7f, 0x4ccd, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4ccb, 0x2aab, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa9, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0xfffe, 0xffff, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffd, 0xd556, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xd554, 0xb334, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xb332, 0x8080, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x807e, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x807d, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807d, 0x807e, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807c, 0x8011, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807a, 0x800f, 0x8004, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800d, 0x8002, 0x8003, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x8012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffd, 0x7ff1, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fef, 0x7f84, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f82, 0x7f83, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x7f82, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f80, 0x4cce, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccc, 0x2aac, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aaa, 0x0004, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0002, 0x0003, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0001, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xffff, 0x0000, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffe, 0xd557, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xd555, 0xb335, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xb333, 0x8081, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0x807f, 0x8080, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x807f, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x7f85, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807d, 0x7ff2, 0x800c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x8010, 0x7fff, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800e, 0x8003, 0x8000, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x8001, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8003, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8004, 0x801f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x8012, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ff0, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f83, 0x8080, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x8081, 0xb342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0xb335, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccd, 0xd557, 0x000c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aab, 0xffff, 0x000d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0003, 0x0000, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0001, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0000, 0x0003, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x2aac, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xd556, 0x4cce, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xb334, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0x8080, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x7f83, 0x7f84, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x7f84, 0x7ff1, 0x5563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x7ff1, 0x7ffe, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x7ffe, 0x7fff, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x7fff, 0x8000, 0x5566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8000, 0x8001, 0x5567, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x8002, 0x5568, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8002, 0x8003, 0x5576, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8003, 0x8011, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x8011, 0x807e, 0x55e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x807e, 0x807f, 0x55e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x807f, 0x8080, 0x8899, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x8080, 0xb334, 0xaabb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0xb334, 0xd556, 0xd563, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0xd556, 0xfffe, 0xd564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0xfffe, 0xffff, 0xd565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xffff, 0x0000, 0x2aba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0000, 0x0003, 0x2ab9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0002, 0x2aab, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x2aab, 0x4ccd, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x4ccd, 0x7f81, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x7f81, 0x7f82, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x7f82, 0x7f83, 0x54e9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f82, 0x54db, 0x3334, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f83, 0x5548, 0x3341, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7ff0, 0x5555, 0x3342, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7ffd, 0x5556, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x5557, 0x3344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x5558, 0x3345, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x5559, 0x3346, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x555a, 0x3354, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8002, 0x5568, 0x33c1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8010, 0x55d5, 0x33c2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8010, 0x807d, 0x55d6, 0x33c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x55d7, 0x6677, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x888b, 0x8899, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb333, 0xaaad, 0xb341, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd555, 0xd555, 0xb342, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffd, 0xd556, 0xb343, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffe, 0xd557, 0x4cdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x2aac, 0x4cdb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0002, 0x2aab, 0x2232, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aaa, 0x2224, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccc, 0x54d8, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f80, 0x54d9, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x54da, 0x32c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x54d9, 0x32b9, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x54da, 0x3326, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x5547, 0x3333, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x5554, 0x3334, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5555, 0x3335, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5556, 0x3336, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x5557, 0x3337, 0x0092, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x5558, 0x3338, 0x00a0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x5559, 0x3346, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x5567, 0x33b3, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x55d4, 0x33b4, 0x010f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x55d5, 0x33b5, 0x33c3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x55d6, 0x6669, 0x55e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x888a, 0x888b, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xaaac, 0xb333, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xd554, 0xb334, 0x808f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xd555, 0xb335, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xd556, 0x4cce, 0x7f8f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x2aab, 0x4ccd, 0x54e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aaa, 0x2224, 0x32c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2223, 0x32b6, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d7, 0x32b7, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d8, 0x32b8, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x32b7, 0x0005, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x32b8, 0x0072, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d9, 0x3325, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5546, 0x3332, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x3333, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3334, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x3335, 0x0083, 0x0091, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x3336, 0x0084, 0x009f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x3337, 0x0092, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5558, 0x3345, 0x00ff, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5566, 0x33b2, 0x0100, 0x010e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x33b3, 0x0101, 0x33c2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0x33b4, 0x33b5, 0x55e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x6668, 0x55d7, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x888a, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xb332, 0x8080, 0x808e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xb333, 0x8081, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xb334, 0x7f82, 0x7f90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x4ccd, 0x7f81, 0x54e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccc, 0x54d8, 0x32c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2223, 0x32b6, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b5, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b6, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x0003, 0x0004, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x0004, 0x0071, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b7, 0x0071, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3324, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x007f, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x0080, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x0081, 0x0082, 0x0090, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x0082, 0x0083, 0x009e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x0083, 0x0091, 0x010b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3336, 0x0091, 0x00fe, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3344, 0x00fe, 0x00ff, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x00ff, 0x0100, 0x33c1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x0100, 0x33b4, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x33b4, 0x55d6, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x55d6, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8889, 0x807e, 0x807f, 0x808d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0x807f, 0x8080, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0x8080, 0x7f83, 0x7f91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0x7f81, 0x7f82, 0x54e8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f80, 0x54d9, 0x32c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d7, 0x32b7, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b5, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0003, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0003, 0x0070, 0x008a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0070, 0x007d, 0x008b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0070, 0x007d, 0x007e, 0x008c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x0080, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0080, 0x0081, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x0081, 0x0082, 0x009d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x0082, 0x0090, 0x010a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0082, 0x0090, 0x00fd, 0x010b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0090, 0x00fd, 0x00fe, 0x010c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x00fe, 0x00ff, 0x33c0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x00ff, 0x33b3, 0x55e2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0x33b3, 0x55d5, 0x808a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b3, 0x55d5, 0x807d, 0x808b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d5, 0x807d, 0x807e, 0x808c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807e, 0x807f, 0x7f93, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807f, 0x7f84, 0x7f92, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x7f82, 0x7f83, 0x54e9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f81, 0x54da, 0x32c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d8, 0x32b8, 0x0013, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b6, 0x0004, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0002, 0x0003, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_saba_4H = 576;

#endif  // VIXL_SIM_SABA_4H_TRACE_AARCH64_H_
