// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_NewtonFunctionSetRoot_HeaderFile
#define _math_NewtonFunctionSetRoot_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _math_IntegerVector_HeaderFile
#include <math_IntegerVector.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_DimensionError;
class math_FunctionSetWithDerivatives;
class math_Vector;
class math_Matrix;



//! This class computes the root of a set of N functions of N variables, <br>
//! knowing an initial guess at the solution and using the <br>
//! Newton Raphson algorithm. Knowledge of all the partial <br>
//! derivatives (Jacobian) is required. <br>
class math_NewtonFunctionSetRoot  {
public:

  DEFINE_STANDARD_ALLOC

  
//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
//! The range (1, F.NbVariables()) must be especially respected for <br>
//! all vectors and matrix declarations. <br>
  Standard_EXPORT   math_NewtonFunctionSetRoot(math_FunctionSetWithDerivatives& F,const math_Vector& XTol,const Standard_Real FTol,const Standard_Integer NbIterations = 100);
  
//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
//! The range (1, F.NbVariables()) must be especially respected for <br>
//! all vectors and matrix declarations. <br>
//! The method SetTolerance must be called before performing the <br>
//! algorithm. <br>
  Standard_EXPORT   math_NewtonFunctionSetRoot(math_FunctionSetWithDerivatives& F,const Standard_Real FTol,const Standard_Integer NbIterations = 100);
  
//! The Newton method is done to improve the root of the function F <br>
//! from the initial guess StartingPoint. <br>
//! The tolerance required on the root is given by Tolerance. <br>
//! The solution is found when : <br>
//!    abs(Xj - Xj-1)(i) <= XTol(i) and abs(Fi) <= FTol for all i; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_NewtonFunctionSetRoot(math_FunctionSetWithDerivatives& F,const math_Vector& StartingPoint,const math_Vector& XTol,const Standard_Real FTol,const Standard_Integer NbIterations = 100);
  
//! The Newton method is done to improve the root of the function F <br>
//! from the initial guess StartingPoint. <br>
//! The tolerance required on the root is given by Tolerance. <br>
//! The solution is found when : <br>
//!    abs(Xj - Xj-1)(i) <= XTol(i) and abs(Fi) <= FTol for all i; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_NewtonFunctionSetRoot(math_FunctionSetWithDerivatives& F,const math_Vector& StartingPoint,const math_Vector& InfBound,const math_Vector& SupBound,const math_Vector& XTol,const Standard_Real FTol,const Standard_Integer NbIterations = 100);
  
  Standard_EXPORT   virtual  void Delete() ;
Standard_EXPORT virtual ~math_NewtonFunctionSetRoot(){Delete();}
  //! Initializes the tolerance values for the unknowns. <br>
  Standard_EXPORT     void SetTolerance(const math_Vector& XTol) ;
  //! Improves the root of function F from the initial guess <br>
//! StartingPoint. infBound and supBound may be given, to constrain the solution. <br>
//! Warning <br>
//! This method must be called when the solution is not computed by the constructors. <br>
  Standard_EXPORT     void Perform(math_FunctionSetWithDerivatives& F,const math_Vector& StartingPoint,const math_Vector& InfBound,const math_Vector& SupBound) ;
  
//! This method is called at the end of each iteration to check if the <br>
//! solution is found. <br>
//! Vectors DeltaX, Fvalues and Jacobian Matrix are consistent with the <br>
//! possible solution Vector Sol and can be inspected to decide whether <br>
//! the solution is reached or not. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsSolutionReached(math_FunctionSetWithDerivatives& F) ;
  //! Returns true if the computations are successful, otherwise returns false. <br>
        Standard_Boolean IsDone() const;
  //! Returns the value of the root of function F. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
       const math_Vector& Root() const;
  //! outputs the root vector in Root. <br>
//! Exception NotDone is raised if the root was not found. <br>
//! Exception DimensionError is raised if the range of Root is <br>
//! not equal to the range of the StartingPoint. <br>
        void Root(math_Vector& Root) const;
  //! Outputs the state number associated with the solution <br>
//!          vector root. <br>
        Standard_Integer StateNumber() const;
  //! Returns the matrix value of the derivative at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
       const math_Matrix& Derivative() const;
  //! Outputs the matrix value of the derivative at the root in <br>
//! Der. <br>
//! Exception NotDone is raised if the root was not found. <br>
//! Exception DimensionError is raised if the range of Der is <br>
//! not equal to the range of the StartingPoint. <br>
        void Derivative(math_Matrix& Der) const;
  //! Returns the vector value of the error done on the <br>
//! functions at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
       const math_Vector& FunctionSetErrors() const;
  //! Outputs the vector value of the error done on the <br>
//! functions at the root in Err. <br>
//! Exception NotDone is raised if the root was not found. <br>
//! Exception DimensionError is raised if the range of Err is <br>
//! not equal to the range of the StartingPoint. <br>
        void FunctionSetErrors(math_Vector& Err) const;
  //! Returns the number of iterations really done <br>
//! during the computation of the Root. <br>
//! Exception NotDone is raised if the root was not found. <br>
        Standard_Integer NbIterations() const;
  //! Prints information on the current state of the object. <br>
//!          Is used to redefine the operator <<. <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:



math_Vector TolX;
Standard_Real TolF;
math_IntegerVector Indx;
math_Vector Scratch;
math_Vector Sol;
math_Vector DeltaX;
math_Vector FValues;
math_Matrix Jacobian;


private:



Standard_Boolean Done;
Standard_Integer State;
Standard_Integer Iter;
Standard_Integer Itermax;


};


#include <math_NewtonFunctionSetRoot.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
