/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;
import org.apache.turbine.util.security.AccessControlList;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.User;
import org.chefproject.exception.EmptyException;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.InconsistentException;
import org.chefproject.exception.OverQuotaException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.realm.CHEFPrincipal;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.component.ChefParameterParser;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.service.generic.GenericUserDirectoryService;
import org.chefproject.servlet.ChefdavStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ChefdavServlet
extends HttpServlet {
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_DELETE = "DELETE";
    private static final int INFINITY = 3;
    protected int debug = 0;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected boolean readOnly = true;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    private boolean m_ready = false;
    static final String FORM_VALUE_DELIMETER = "^";
    public static String ME;
    protected static final SimpleDateFormat creationDateFormat;
    protected static final SimpleDateFormat HttpDateFormat;
    protected static final SimpleDateFormat[] formats;
    private Hashtable resourceLocks = new Hashtable();
    private Hashtable lockNullResources = new Hashtable();
    private Vector collectionLocks = new Vector();
    private String secret = "catalina";
    protected static final MD5Encoder md5Encoder;
    protected static MessageDigest md5Helper;
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;
    static /* synthetic */ Class class$org$chefproject$servlet$ChefdavServlet;

    public void init() throws ServletException {
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("readonly");
            if (value != null) {
                this.readOnly = new Boolean(value);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("secret");
            if (value != null) {
                this.secret = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_ready = false;
        this.startInit();
    }

    public void startInit() {
        new ChefdavServletInit();
    }

    public ChefdavServletInfo newInfo(HttpServletRequest req) {
        return new ChefdavServletInfo(req);
    }

    protected void showRequestInfo(HttpServletRequest req) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "DefaultServlet Request Info");
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Encoding : " + req.getCharacterEncoding());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Length : " + req.getContentLength());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Type : " + req.getContentType());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Parameters");
        }
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = req.getParameterValues(paramName);
            System.out.print(paramName + " : ");
            int i = 0;
            while (i < values.length) {
                System.out.print(values[i] + ", ");
                ++i;
            }
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Protocol : " + req.getProtocol());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Address : " + req.getRemoteAddr());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Host : " + req.getRemoteHost());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Scheme : " + req.getScheme());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Server Name : " + req.getServerName());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Server Port : " + req.getServerPort());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Attributes");
        }
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attributeName = (String)attributes.nextElement();
            System.out.print(attributeName + " : ");
            if (!Log.getLogger("chef").isDebugEnabled()) continue;
            Log.debug("chef", req.getAttribute(attributeName).toString());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "HTTP Header Info");
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Authentication Type : " + req.getAuthType());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "HTTP Method : " + req.getMethod());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Path Info : " + req.getPathInfo());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Path translated : " + req.getPathTranslated());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Query string : " + req.getQueryString());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Remote user : " + req.getRemoteUser());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Requested session id : " + req.getRequestedSessionId());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Request URI : " + req.getRequestURI());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Context path : " + req.getContextPath());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Servlet path : " + req.getServletPath());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "User principal : " + req.getUserPrincipal());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Headers : ");
        }
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            System.out.print(headerName + " : ");
            if (!Log.getLogger("chef").isDebugEnabled()) continue;
            Log.debug("chef", req.getHeader(headerName));
        }
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return this.normalize(result);
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized == null) {
            return null;
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String rewriteUrl(String path) {
        int maxBytesPerChar = 10;
        int caseDiff = 32;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < path.length()) {
            block8: {
                char c = path.charAt(i);
                if (safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        byte toEncode = ba[j];
                        rewrittenPath.append('%');
                        int low = toEncode & 0xF;
                        int high = (toEncode & 0xF0) >> 4;
                        rewrittenPath.append(hexadecimal[high]);
                        rewrittenPath.append(hexadecimal[low]);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return rewrittenPath.toString();
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("Chefdavservlet.jaxpfailed");
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) {
        RunData data;
        ChefdavServletInfo info;
        block30: {
            block29: {
                block28: {
                    String method = req.getMethod();
                    if (this.debug > 0) {
                        String path = this.getRelativePath(req);
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "CHEFDAV service [" + method + "] " + path);
                        }
                    }
                    if (!this.m_ready) {
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "CHEF m_ready is false");
                        }
                        res.setContentType("text/html");
                        Log.info("chef", ME + "ip=" + req.getRemoteAddr() + "&" + "READY=FALSE&");
                        return;
                    }
                    info = this.newInfo(req);
                    data = null;
                    try {
                        try {
                            String name = req.getRemoteUser();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "CHEFDAV remote user = " + name);
                            }
                            Principal prin = req.getUserPrincipal();
                            String prinName = prin.getName();
                            if (name == null || name.trim().length() == 0 || prin == null) {
                                if (this.debug > 999) {
                                    this.showRequestInfo(req);
                                }
                                if (Log.getLogger("chef").isDebugEnabled()) {
                                    Log.debug("chef", "CHEFDAV Requires RemoteUser and UserPrincipal");
                                }
                                res.sendError(401);
                                Object var18_10 = null;
                                this.log(req, info);
                                this.cleanup();
                                break block28;
                            }
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "Class name : " + prin.getClass().getName() + " " + Integer.toHexString(prin.hashCode()));
                            }
                            String pw = ((CHEFPrincipal)prin).getPassword();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", " principal name     = " + prinName);
                            }
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", " principal password = " + pw);
                            }
                            if (!name.equals(prinName) || pw == null || pw.trim().length() == 0) {
                                if (this.debug > 999) {
                                    this.showRequestInfo(req);
                                }
                                if (Log.getLogger("chef").isDebugEnabled()) {
                                    Log.debug("chef", "CHEFDAV Requires password");
                                }
                                res.sendError(401);
                                break block29;
                            }
                            this.setup(req);
                            data = RunDataFactory.getRunData(req, res, this.getServletConfig());
                            AccessControlList acl = (AccessControlList)req.getSession().getAttribute(AccessControlList.SESSION_KEY);
                            data.setACL(acl);
                            Object errMsg = null;
                            String path = req.getPathInfo();
                            GenericUserDirectoryService userDirectory = (GenericUserDirectoryService)((Object)TurbineServices.getInstance().getService(GenericUserDirectoryService.SERVICE_NAME));
                            User curUser = UsageSessionService.getSessionUser();
                            if (curUser == null || curUser == userDirectory.getAnonymousUser()) {
                                if (Log.getLogger("chef").isDebugEnabled()) {
                                    Log.debug("chef", "CHEF Current user is null or anonymous");
                                }
                            } else if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "CHEFDAV - Current user has a session");
                            }
                            boolean invalid = true;
                            try {
                                JetspeedUser user = JetspeedSecurity.login((String)name, (String)pw);
                                invalid = false;
                            }
                            catch (Exception e) {
                                if (Log.getLogger("chef").isDebugEnabled()) {
                                    Log.debug("chef", "CHEF Jetspeed Exception" + e);
                                }
                                res.sendError(401);
                            }
                            if (!invalid) {
                                this.doDispatch(info, req, res);
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "CHEFDAV exception: " + e);
                            }
                            Log.warn("chef", (Object)((Object)this) + ".dispatch(): exception: ", (Throwable)e);
                            Object var18_13 = null;
                            this.log(req, info);
                            this.cleanup();
                            RunDataFactory.putRunData(data);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_14 = null;
                        this.log(req, info);
                        this.cleanup();
                        RunDataFactory.putRunData(data);
                        throw throwable;
                    }
                }
                RunDataFactory.putRunData(data);
                return;
            }
            Object var18_11 = null;
            this.log(req, info);
            this.cleanup();
            RunDataFactory.putRunData(data);
            return;
        }
        Object var18_12 = null;
        this.log(req, info);
        this.cleanup();
        RunDataFactory.putRunData(data);
    }

    public void log(HttpServletRequest req, ChefdavServletInfo info) {
        Log.info("chef", ME + " from:" + req.getRemoteAddr() + " path:" + req.getPathInfo() + " options: " + info.optionsString());
    }

    private void setup(HttpServletRequest req) {
    }

    private void cleanup() {
    }

    protected void doDispatch(ChefdavServletInfo info, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (this.debug > 0) {
            String path = this.getRelativePath(req);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "CHEFDAV doDispatch [" + method + "] " + path);
            }
        }
        String remoteUser = req.getRemoteUser();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "CHEFDAV remoteuser = " + remoteUser);
        }
        if (remoteUser == null) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "CHEFDAV Requires Authorization");
            }
            resp.sendError(401);
            return;
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else if (method.equals(METHOD_GET)) {
            this.doGet(req, resp);
        } else if (method.equals(METHOD_PUT)) {
            this.doPut(req, resp);
        } else if (method.equals(METHOD_POST)) {
            this.doPost(req, resp);
        } else if (method.equals(METHOD_HEAD)) {
            this.doHead(req, resp);
        } else if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(req, resp);
        } else if (method.equals(METHOD_DELETE)) {
            this.doDelete(req, resp);
        } else {
            Log.warn("chef", "CHEFDAV:Request not supported");
            resp.sendError(501);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String contentType;
        String path = this.getRelativePathCHEF(request);
        if (path == null || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            response.sendError(404, path);
            return;
        }
        DirContextCHEF resources = this.getResourcesCHEF();
        ResourceInfoCHEF resourceInfo = new ResourceInfoCHEF(path, resources);
        if (!resourceInfo.exists) {
            response.sendError(404, path);
            return;
        }
        if (!resourceInfo.collection) {
            response.setDateHeader("Last-Modified", resourceInfo.date);
        }
        if ((contentType = this.getServletContext().getMimeType(resourceInfo.path)) != null) {
            response.setContentType(contentType);
        }
        long contentLength = resourceInfo.length;
        if (!resourceInfo.collection && contentLength >= 0L) {
            response.setContentLength((int)contentLength);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathCHEF(req);
        resp.addHeader("DAV", "1,2");
        String methodsAllowed = null;
        DirContextCHEF resources = this.getResourcesCHEF();
        if (resources == null) {
            Log.warn("chef", "CHEFDAV doOptions ERROR Resources is null");
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        Object object = null;
        try {
            object = resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            methodsAllowed = "OPTIONS, MKCOL, PUT, LOCK";
            resp.addHeader("Allow", methodsAllowed);
            return;
        }
        methodsAllowed = "OPTIONS, GET, HEAD, POST, DELETE, PROPFIND";
        if (!(object instanceof DirContext)) {
            methodsAllowed = methodsAllowed + ", PUT";
        }
        resp.addHeader("Allow", methodsAllowed);
        resp.addHeader("MS-Author-Via", "DAV");
    }

    public DirContextCHEF getResourcesCHEF() {
        return new DirContextCHEF();
    }

    public String fixDirPathCHEF(GenericContentHostingService service, String path) {
        String tmpPath = path;
        try {
            ResourceProperties props = service.getProperties(tmpPath);
        }
        catch (IdUnusedException e) {
            if (!tmpPath.endsWith("/")) {
                String newPath = tmpPath + "/";
                try {
                    ResourceProperties props = service.getProperties(newPath);
                    tmpPath = newPath;
                }
                catch (Exception x) {}
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return tmpPath;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathCHEF(req);
        this.doContent(path, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathCHEF(req);
        this.doContent(path, resp);
    }

    private String doContent(String id, HttpServletResponse res) {
        GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        if (service == null) {
            return "server configuration error: missing Content Hosting Service";
        }
        boolean isCollection = false;
        try {
            ResourceProperties props = service.getProperties(id);
            isCollection = props.getBooleanProperty("CHEF:is-collection");
        }
        catch (PermissionException e) {
            return "You do not have permission to view this resource";
        }
        catch (IdUnusedException e) {
            return "This resource does not exist";
        }
        catch (EmptyException e) {
            return "This resource does not exist";
        }
        catch (TypeException e) {
            return "This resource does not exist";
        }
        if (!isCollection) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "CHEFAccess doContent is resource " + id);
            }
            try {
                ContentResource resource = service.getResource(id);
                long len = resource.getContentLength();
                String contentType = resource.getContentType();
                byte[] content = resource.getContent();
                if (contentType.equals("text/URL")) {
                    res.sendRedirect(new String(content));
                }
                ServletOutputStream out = res.getOutputStream();
                res.setContentType(contentType);
                out.write(content);
                out.flush();
            }
            catch (PermissionException e) {
                return e.toString();
            }
            catch (IdUnusedException e) {
                return e.toString();
            }
            catch (TypeException e) {
                return e.toString();
            }
            catch (IOException e) {
                Log.warn("chef", (Object)((Object)this) + ".doContent(): exception" + e.toString());
            }
        } else if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "CHEFAccess doContent is collection " + id);
        }
        return null;
    }

    public String getRelativePathCHEF(HttpServletRequest req) {
        String path = ChefParameterParser.getPathDecoded(req);
        if (path == null) {
            path = "/";
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "getRelativePathCHEF = " + path);
        }
        return path;
    }

    public String getResourceNameCHEF(Resource mbr) {
        int lastSlash;
        String idx = mbr.getId();
        ResourceProperties props = mbr.getProperties();
        String resourceName = props.getProperty("DAV:displayname");
        if (idx.startsWith("/") && idx.endsWith("/") && idx.length() > 3) {
            int lastSlash2 = idx.lastIndexOf("/", idx.length() - 2);
            if (lastSlash2 > 0 && lastSlash2 + 1 <= idx.length() - 2) {
                resourceName = idx.substring(lastSlash2 + 1, idx.length() - 1);
            }
        } else if (idx.startsWith("/") && !idx.endsWith("/") && idx.length() > 2 && (lastSlash = idx.lastIndexOf("/")) > -1) {
            resourceName = idx.substring(lastSlash + 1);
        }
        return resourceName;
    }

    /*
     * Unable to fully structure code
     */
    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block42: {
            block41: {
                path = this.getRelativePathCHEF(req);
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
                    resp.sendError(403);
                    return;
                }
                properties = null;
                depth = 3;
                type = 1;
                depthStr = req.getHeader("Depth");
                if (depthStr == null) {
                    depth = 3;
                } else if (depthStr.equals("0")) {
                    depth = 0;
                } else if (depthStr.equals("1")) {
                    depth = 1;
                } else if (depthStr.equals("infinity")) {
                    depth = 3;
                }
                propNode = null;
                documentBuilder = this.getDocumentBuilder();
                try {
                    document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                    rootElement = document.getDocumentElement();
                    childList = rootElement.getChildNodes();
                    i = 0;
                    while (i < childList.getLength()) {
                        currentNode = childList.item(i);
                        switch (currentNode.getNodeType()) {
                            case 3: {
                                break;
                            }
                            case 1: {
                                if (currentNode.getNodeName().endsWith("prop")) {
                                    type = 0;
                                    propNode = currentNode;
                                }
                                if (currentNode.getNodeName().endsWith("propname")) {
                                    type = 2;
                                }
                                if (!currentNode.getNodeName().endsWith("allprop")) break;
                                type = 1;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (!Log.getLogger("chef").isDebugEnabled()) break block41;
                    Log.debug("chef", "CHEFDAV doPropfind exception documentBuilder");
                }
            }
            if (type == 0) {
                properties = new Vector<String>();
                childList = propNode.getChildNodes();
                i = 0;
                while (i < childList.getLength()) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            nodeName = currentNode.getNodeName();
                            propertyName = null;
                            propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                            properties.addElement(propertyName);
                        }
                    }
                    ++i;
                }
            }
            if ((resources = this.getResourcesCHEF()) == null) {
                resp.sendError(500);
                return;
            }
            exists = true;
            object = null;
            try {
                object = resources.lookup(path);
                break block42;
            }
            catch (NamingException e) {
                exists = false;
                slash = path.lastIndexOf(47);
                if (slash == -1 || (currentLockNullResources = (Vector)this.lockNullResources.get(parentPath = path.substring(0, slash))) == null) break block42;
                lockNullResourcesList = currentLockNullResources.elements();
                ** while (lockNullResourcesList.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                lockNullPath = (String)lockNullResourcesList.nextElement();
                if (!lockNullPath.equals(path)) continue;
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                generatedXML = new XMLWriter((Writer)resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                generatedXML.writeElement(null, "multistatus", 1);
                generatedXML.sendData();
                return;
            }
        }
        if (!exists) {
            resp.sendError(404, path);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        generatedXML = new XMLWriter((Writer)resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        if (depth == 0) {
            this.parseProperties(req, resources, generatedXML, path, type, properties);
        } else {
            stack = new Stack<String>();
            stack.push(path);
            stackBelow = new Stack<String>();
            while (!stack.isEmpty() && depth >= 0) {
                currentPath = (String)stack.pop();
                try {
                    object = resources.lookup(currentPath);
                }
                catch (NamingException e) {
                    continue;
                }
                this.parseProperties(req, resources, generatedXML, currentPath, type, properties);
                if (resources.isCollection && depth > 0) {
                    it = resources.list(currentPath);
                    while (it.hasNext()) {
                        mbr = (Resource)it.next();
                        resourceName = this.getResourceNameCHEF(mbr);
                        newPath = currentPath;
                        if (!newPath.endsWith("/")) {
                            newPath = newPath + "/";
                        }
                        newPath = newPath + resourceName;
                        stackBelow.push(newPath);
                    }
                    lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources = (Vector)this.lockNullResources.get(lockPath)) != null) {
                        lockNullResourcesList = currentLockNullResources.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            lockNullPath = (String)lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack<E>();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement(null, "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        resp.sendError(405);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePathCHEF(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        int slash = path.lastIndexOf(47);
        String name = path.substring(slash + 1);
        if (name.toUpperCase().startsWith("/WEB-INF") || name.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        try {
            boolean isCollection = service.getProperties(path).getBooleanProperty("CHEF:is-collection");
            if (isCollection) {
                return;
            }
            service.removeResource(path);
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (InUseException e) {
            resp.sendError(403);
            return;
        }
        catch (IdUnusedException e) {
        }
        catch (EmptyException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() - EmptyException " + path);
            resp.sendError(403);
            return;
        }
        catch (TypeException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() - TypeException " + path);
            resp.sendError(403);
            return;
        }
        ResourcePropertiesEdit resourceProperties = service.newResourceProperties();
        try {
            resourceProperties.addProperty("DAV:displayname", name);
            ContentCollection collection = service.addCollection(path, resourceProperties);
        }
        catch (IdUsedException e) {
        }
        catch (IdInvalidException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() IdInvalid:" + e.getMessage());
            resp.sendError(403);
            return;
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (InconsistentException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() InconsistentException:" + e.getMessage());
            resp.sendError(403);
            return;
        }
        this.lockNullResources.remove(path);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePathCHEF(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        if (req.getHeader("Content-Range") != null) {
            resp.sendError(501);
        }
        GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        ResourcePropertiesEdit resourceProperties = service.newResourceProperties();
        int slash = path.lastIndexOf(47);
        String name = path.substring(slash + 1);
        if (name.toUpperCase().startsWith("/WEB-INF") || name.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        try {
            boolean isCollection = service.getProperties(path).getBooleanProperty("CHEF:is-collection");
            if (isCollection) {
                service.removeCollection(path);
            } else {
                service.removeResource(path);
            }
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (InUseException e) {
            resp.sendError(403);
            return;
        }
        catch (IdUnusedException e) {
        }
        catch (EmptyException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() - EmptyException " + path);
            resp.sendError(403);
            return;
        }
        catch (TypeException e) {
            Log.warn("chef", "CHEFDavServlet.doMkcol() - TypeException " + path);
            resp.sendError(403);
            return;
        }
        String contentType = "";
        String collectionId = "";
        ServletInputStream inputStream = req.getInputStream();
        contentType = req.getContentType();
        int contentLength = req.getContentLength();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "  req.contentType() =" + contentType + " len=" + contentLength);
        }
        if (contentLength < 0) {
            Log.warn("chef", "CHEFDavServlet.doPut() content length (" + contentLength + ") less than zero " + path);
            resp.sendError(409);
            return;
        }
        byte[] byteContent = new byte[contentLength];
        if (contentLength > 0) {
            try {
                int lenRead = 0;
                while (lenRead < contentLength) {
                    int read = inputStream.read(byteContent, lenRead, contentLength - lenRead);
                    if (read > 0) {
                        lenRead += read;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Log.warn("chef", "CHEFDavServlet.doPut() IOException " + path);
                resp.sendError(409);
                return;
            }
        }
        if (contentType == null) {
            contentType = this.getServletContext().getMimeType(path);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "Lookup contentType =" + contentType);
            }
        }
        if (contentType == null) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "Unable to determine contentType");
            }
            contentType = "";
        }
        try {
            resourceProperties.addProperty("DAV:displayname", name);
            ContentResource resource = service.addResource(path, contentType, byteContent, resourceProperties);
        }
        catch (IdUsedException e) {
            Log.warn("chef", "CHEFDavServlet.doPut() IdUsedException:" + e.getMessage());
            resp.sendError(409);
            return;
        }
        catch (IdInvalidException e) {
            Log.warn("chef", "CHEFDavServlet.doPut() IdInvalidException:" + e.getMessage());
            resp.sendError(409);
            return;
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (OverQuotaException e) {
            resp.sendError(403);
            return;
        }
        catch (InconsistentException e) {
            Log.warn("chef", "CHEFDavServlet.doPut() InconsistentException:" + e.getMessage());
            resp.sendError(409);
            return;
        }
        resp.setStatus(201);
        this.lockNullResources.remove(path);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        if (this.copyResource(req, resp)) {
            this.deleteResource(path, req, resp);
        }
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock = new LockInfo();
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? 3 : (depthStr.equals("0") ? 0 : 3);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = new Integer(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (Exception e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            Node currentNode;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            int i = 0;
            while (i < childList.getLength()) {
                Node currentNode2 = childList.item(i);
                switch (currentNode2.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        String nodeName = currentNode2.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode2;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode2;
                        }
                        if (!nodeName.endsWith("owner")) break;
                        lockOwnerNode = currentNode2;
                    }
                }
                ++i;
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                int i2 = 0;
                while (i2 < childList.getLength()) {
                    currentNode = childList.item(i2);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            lock.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                    ++i2;
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                int i3 = 0;
                while (i3 < childList.getLength()) {
                    currentNode = childList.item(i3);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            lock.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                    ++i3;
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                int i4 = 0;
                while (i4 < childList.getLength()) {
                    currentNode = childList.item(i4);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            break;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter((Writer)strWriter, true);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                    ++i4;
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock.owner = new String();
            }
        }
        lock.path = path = this.getRelativePath(req);
        DirContextCHEF resources = this.getResourcesCHEF();
        if (resources == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        Object object = null;
        try {
            object = resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        Enumeration<Object> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + req.getUserPrincipal() + "-" + lock.depth + "-" + lock.owner + "-" + lock.tokens + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String lockToken = md5Encoder.encode(md5Helper.digest(lockTokenStr.getBytes()));
            if (exists && object instanceof DirContext && lock.depth == 3) {
                LockInfo currentLock;
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = (LockInfo)locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = (LockInfo)locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement(null, "response", 0);
                        generatedXML.writeElement(null, "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement(null, "href", 1);
                        generatedXML.writeElement(null, "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 " + ChefdavStatus.getStatusText(423));
                        generatedXML.writeElement(null, "status", 1);
                        generatedXML.writeElement(null, "response", 1);
                    }
                    generatedXML.writeElement(null, "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock2 = (LockInfo)locksList.nextElement();
                    if (!currentLock2.path.equals(lock.path)) continue;
                    if (currentLock2.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock2.tokens.addElement(lockToken);
                    lock = currentLock2;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = (LockInfo)this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    exists = true;
                    try {
                        object = resources.lookup(path);
                    }
                    catch (NamingException e) {
                        exists = false;
                    }
                    if (!exists) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = (Vector<String>)this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector<String>();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = (LockInfo)this.resourceLocks.get(path);
            Enumeration tokenList = null;
            if (lock != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = (String)tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = (LockInfo)collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = (String)tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "prop" + this.generateNamespaceDeclarations(), 0);
        generatedXML.writeElement(null, "lockdiscovery", 0);
        lock.toXML(generatedXML, true);
        generatedXML.writeElement(null, "lockdiscovery", 1);
        generatedXML.writeElement(null, "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        Enumeration tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = (LockInfo)collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private String generateNamespaceDeclarations() {
        return " xmlns=\"DAV:\"";
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        Enumeration tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = (LockInfo)collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DirContextCHEF resources;
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        int protocolIndex = destinationPath.indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        destinationPath = RequestUtil.URLDecode((String)this.normalize(destinationPath), (String)"UTF8");
        if (this.debug > 0 && Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Dest path :" + destinationPath);
        }
        if (destinationPath.toUpperCase().startsWith("/WEB-INF") || destinationPath.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String path = this.getRelativePath(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        if ((resources = this.getResourcesCHEF()) == null) {
            resp.sendError(500);
            return false;
        }
        boolean exists = true;
        try {
            resources.lookup(destinationPath);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (overwrite) {
            if (exists) {
                if (!this.deleteResource(destinationPath, req, resp)) {
                    return false;
                }
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else if (exists) {
            resp.sendError(412);
            return false;
        }
        Hashtable errorList = new Hashtable();
        boolean result = this.copyResource(resources, errorList, path, destinationPath);
        if (!result || !errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            return false;
        }
        this.lockNullResources.remove(destinationPath);
        return true;
    }

    private boolean copyResource(DirContextCHEF resources, Hashtable errorList, String source, String dest) {
        if (this.debug > 1 && Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Copy: " + source + " To: " + dest);
        }
        errorList.put(source, new Integer(500));
        return false;
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathCHEF(req);
        return this.deleteResource(path, req, resp);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lockTokenHeader;
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        path = this.fixDirPathCHEF(service, path);
        boolean isCollection = false;
        try {
            isCollection = service.getProperties(path).getBooleanProperty("CHEF:is-collection");
            if (isCollection) {
                service.removeCollection(path);
            } else {
                service.removeResource(path);
            }
        }
        catch (PermissionException e) {
            return false;
        }
        catch (InUseException e) {
            return false;
        }
        catch (IdUnusedException e) {
        }
        catch (EmptyException e) {
            Log.warn("chef", "CHEFDavServlet.deleteResource() - EmptyException " + path);
            return false;
        }
        catch (TypeException e) {
            Log.warn("chef", "CHEFDavServlet.deleteResource() - TypeException " + path);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void deleteCollection(HttpServletRequest req, DirContext resources, String path, Hashtable errorList) {
        if (this.debug > 1 && Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "deleteCollection:" + path);
        }
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            errorList.put(path, new Integer(403));
            return;
        }
        ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        enum = null;
        try {
            enum = resources.list(path);
            if (true) ** GOTO lbl44
        }
        catch (NamingException e) {
            errorList.put(path, new Integer(500));
            return;
        }
        do {
            ncPair = (NameClassPair)enum.nextElement();
            childName = path;
            if (!childName.equals("/")) {
                childName = childName + "/";
            }
            if (this.isLocked(childName = childName + ncPair.getName(), ifHeader + lockTokenHeader)) {
                errorList.put(childName, new Integer(423));
                continue;
            }
            try {
                object = resources.lookup(childName);
                if (object instanceof DirContext) {
                    this.deleteCollection(req, resources, childName, errorList);
                }
                try {
                    resources.unbind(childName);
                }
                catch (NamingException e) {
                    if (object instanceof DirContext) continue;
                    errorList.put(childName, new Integer(500));
                }
            }
            catch (NamingException e) {
                errorList.put(childName, new Integer(500));
            }
lbl44:
            // 6 sources

        } while (enum.hasMoreElements());
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable errorList) throws ServletException, IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = (String)pathList.nextElement();
            int errorCode = (Integer)errorList.get(errorPath);
            generatedXML.writeElement(null, "response", 0);
            generatedXML.writeElement(null, "href", 0);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(absoluteUri + toAppend);
            generatedXML.writeElement(null, "href", 1);
            generatedXML.writeElement(null, "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + ChefdavStatus.getStatusText(errorCode));
            generatedXML.writeElement(null, "status", 1);
            generatedXML.writeElement(null, "response", 1);
        }
        generatedXML.writeElement(null, "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, DirContextCHEF resources, XMLWriter generatedXML, String path, int type, Vector propertiesVector) {
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        ResourceInfoCHEF resourceInfo = new ResourceInfoCHEF(path, resources);
        generatedXML.writeElement(null, "response", 0);
        String status = new String("HTTP/1.1 200 " + ChefdavStatus.getStatusText(200));
        generatedXML.writeElement(null, "href", 0);
        String href = req.getRequestURI();
        String servletPath = req.getServletPath();
        int pos = href.indexOf(req.getServletPath());
        href = href.substring(0, pos + servletPath.length());
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (resourceInfo.collection && !href.endsWith("/")) {
            href = href + "/";
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "parserProperties href=" + href);
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                generatedXML.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                if (!resourceInfo.collection) {
                    generatedXML.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                    generatedXML.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                    generatedXML.writeProperty(null, "getcontenttype", resourceInfo.MIMEType);
                    generatedXML.writeProperty(null, "getetag", resourceInfo.eTag);
                    generatedXML.writeElement(null, "resourcetype", 2);
                } else {
                    generatedXML.writeElement(null, "resourcetype", 0);
                    generatedXML.writeElement(null, "collection", 2);
                    generatedXML.writeElement(null, "resourcetype", 1);
                }
                generatedXML.writeProperty(null, "source", "");
                String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                generatedXML.writeElement(null, "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                if (!resourceInfo.collection) {
                    generatedXML.writeElement(null, "getcontentlanguage", 2);
                    generatedXML.writeElement(null, "getcontentlength", 2);
                    generatedXML.writeElement(null, "getcontenttype", 2);
                    generatedXML.writeElement(null, "getetag", 2);
                    generatedXML.writeElement(null, "getlastmodified", 2);
                }
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = (String)properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceInfo.displayName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(resourceInfo.path));
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getetag", resourceInfo.eTag);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (resourceInfo.collection) {
                            generatedXML.writeElement(null, "resourcetype", 0);
                            generatedXML.writeElement(null, "collection", 2);
                            generatedXML.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        generatedXML.writeElement(null, "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + ChefdavStatus.getStatusText(404));
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector propertiesVector) {
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        generatedXML.writeElement(null, "response", 0);
        String status = new String("HTTP/1.1 200 " + ChefdavStatus.getStatusText(200));
        generatedXML.writeElement(null, "href", 0);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        String toAppend = path.substring(relativePath.length());
        if (!toAppend.startsWith("/")) {
            toAppend = "/" + toAppend;
        }
        generatedXML.writeText(this.rewriteUrl(this.normalize(absoluteUri + toAppend)));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                generatedXML.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                generatedXML.writeProperty(null, "getlastmodified", formats[0].format(lock.creationDate));
                generatedXML.writeProperty(null, "getcontentlength", String.valueOf(0));
                generatedXML.writeProperty(null, "getcontenttype", "");
                generatedXML.writeProperty(null, "getetag", "");
                generatedXML.writeElement(null, "resourcetype", 0);
                generatedXML.writeElement(null, "lock-null", 2);
                generatedXML.writeElement(null, "resourcetype", 1);
                generatedXML.writeProperty(null, "source", "");
                String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                generatedXML.writeElement(null, "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                generatedXML.writeElement(null, "getcontentlanguage", 2);
                generatedXML.writeElement(null, "getcontentlength", 2);
                generatedXML.writeElement(null, "getcontenttype", 2);
                generatedXML.writeElement(null, "getetag", 2);
                generatedXML.writeElement(null, "getlastmodified", 2);
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = (String)properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty(null, "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        generatedXML.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        generatedXML.writeProperty(null, "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        generatedXML.writeProperty(null, "getcontenttype", "");
                        continue;
                    }
                    if (property.equals("getetag")) {
                        generatedXML.writeProperty(null, "getetag", "");
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        generatedXML.writeProperty(null, "getlastmodified", formats[0].format(lock.creationDate));
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        generatedXML.writeElement(null, "resourcetype", 0);
                        generatedXML.writeElement(null, "lock-null", 2);
                        generatedXML.writeElement(null, "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        generatedXML.writeElement(null, "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + ChefdavStatus.getStatusText(404));
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = (LockInfo)this.resourceLocks.get(path);
        Enumeration collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement(null, "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = (LockInfo)collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement(null, "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement(null, "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        StringBuffer creationDateValue = new StringBuffer(creationDateFormat.format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    private String getHttpDate(long dateMS) {
        return HttpDateFormat.format(new Date(dateMS));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        METHOD_HEAD = METHOD_HEAD;
        METHOD_PROPFIND = METHOD_PROPFIND;
        METHOD_PROPPATCH = METHOD_PROPPATCH;
        METHOD_OPTIONS = METHOD_OPTIONS;
        METHOD_MKCOL = METHOD_MKCOL;
        METHOD_COPY = METHOD_COPY;
        METHOD_MOVE = METHOD_MOVE;
        METHOD_LOCK = METHOD_LOCK;
        METHOD_UNLOCK = METHOD_UNLOCK;
        METHOD_GET = METHOD_GET;
        METHOD_PUT = METHOD_PUT;
        METHOD_POST = METHOD_POST;
        METHOD_DELETE = METHOD_DELETE;
        INFINITY = 3;
        FIND_BY_PROPERTY = 0;
        FIND_ALL_PROP = 1;
        FIND_PROPERTY_NAMES = 2;
        LOCK_CREATION = 0;
        LOCK_REFRESH = 1;
        DEFAULT_TIMEOUT = 3600;
        MAX_TIMEOUT = 604800;
        DEFAULT_NAMESPACE = DEFAULT_NAMESPACE;
        FORM_VALUE_DELIMETER = FORM_VALUE_DELIMETER;
        ME = (class$org$chefproject$servlet$ChefdavServlet == null ? (class$org$chefproject$servlet$ChefdavServlet = ChefdavServlet.class$("org.chefproject.servlet.ChefdavServlet")) : class$org$chefproject$servlet$ChefdavServlet).getName();
        creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        HttpDateFormat = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
        HttpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        md5Encoder = new MD5Encoder();
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            safeCharacters.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeCharacters.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeCharacters.set(i);
            ++i;
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }

    private class Property {
        public String name;
        public String value;
        public String namespace;
        public String namespaceAbbrev;
        public int status = 200;

        private Property() {
        }
    }

    private class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public String toString() {
            String result = "Type:" + this.type + "\n";
            result = result + "Scope:" + this.scope + "\n";
            result = result + "Depth:" + this.depth + "\n";
            result = result + "Owner:" + this.owner + "\n";
            result = result + "Expiration:" + formats[0].format(new Date(this.expiresAt)) + "\n";
            Enumeration tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                result = result + "Token:" + tokensList.nextElement() + "\n";
            }
            return result;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            this.toXML(generatedXML, false);
        }

        public void toXML(XMLWriter generatedXML, boolean showToken) {
            generatedXML.writeElement(null, "activelock", 0);
            generatedXML.writeElement(null, "locktype", 0);
            generatedXML.writeElement(null, this.type, 2);
            generatedXML.writeElement(null, "locktype", 1);
            generatedXML.writeElement(null, "lockscope", 0);
            generatedXML.writeElement(null, this.scope, 2);
            generatedXML.writeElement(null, "lockscope", 1);
            generatedXML.writeElement(null, "depth", 0);
            if (this.depth == 3) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement(null, "depth", 1);
            generatedXML.writeElement(null, "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement(null, "owner", 1);
            generatedXML.writeElement(null, "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement(null, "timeout", 1);
            generatedXML.writeElement(null, "locktoken", 0);
            if (showToken) {
                Enumeration tokensList = this.tokens.elements();
                while (tokensList.hasMoreElements()) {
                    generatedXML.writeElement(null, "href", 0);
                    generatedXML.writeText("opaquelocktoken:" + tokensList.nextElement());
                    generatedXML.writeElement(null, "href", 1);
                }
            } else {
                generatedXML.writeElement(null, "href", 0);
                generatedXML.writeText("opaquelocktoken:dummytoken");
                generatedXML.writeElement(null, "href", 1);
            }
            generatedXML.writeElement(null, "locktoken", 1);
            generatedXML.writeElement(null, "activelock", 1);
        }
    }

    public class ResourceInfoCHEF {
        private DirContextCHEF resources;
        private ResourceProperties props = null;
        private String path;
        public boolean collection;
        public boolean exists;
        public long length;
        public String httpDate;
        public long creationDate;
        public String MIMEType;
        public long modificationDate;
        public long date;
        public String displayName;
        public String resourceName;
        public String resourceLink;
        public String eTag;

        public ResourceInfoCHEF(String our_path, DirContextCHEF parent_resources) {
            this.path = our_path;
            this.exists = false;
            this.resources = parent_resources;
            GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
            if (service == null) {
                Log.warn("chef", "ResourceInfoCHEF: Content Hosting service is null path=" + this.path);
                return;
            }
            this.collection = false;
            try {
                Resource mbr;
                this.path = ChefdavServlet.this.fixDirPathCHEF(service, this.path);
                ResourceProperties props = service.getProperties(this.path);
                this.collection = props.getBooleanProperty("CHEF:is-collection");
                this.resourceName = props.getProperty("DAV:displayname");
                this.displayName = props.getPropertyFormatted("DAV:displayname");
                this.exists = true;
                if (!this.collection) {
                    mbr = service.getResource(this.path);
                    this.length = ((ContentResource)mbr).getContentLength();
                    this.MIMEType = ((ContentResource)mbr).getContentType();
                    this.eTag = ((ContentResource)mbr).getId();
                } else {
                    mbr = service.getCollection(this.path);
                    props = mbr.getProperties();
                    this.eTag = our_path;
                }
                this.modificationDate = props.getTimeProperty("DAV:getlastmodified").getTime();
                this.eTag = this.modificationDate + "+" + this.eTag;
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", "Path=" + this.path + " eTag=" + this.eTag);
                }
                this.creationDate = props.getTimeProperty("DAV:creationdate").getTime();
                this.resourceLink = mbr.getUrl();
                String resourceName = ChefdavServlet.this.getResourceNameCHEF(mbr);
            }
            catch (PermissionException e) {
                Log.info("chef", "ResourceInfoCHEF - You do not have permission to view this resource " + this.path);
            }
            catch (IdUnusedException e) {
                Log.warn("chef", "ResourceInfoCHEF - This resource does not exist " + this.path);
            }
            catch (EmptyException e) {
                Log.warn("chef", "ResourceInfoCHEF - This resource does not exist " + this.path);
            }
            catch (TypeException e) {
                Log.warn("chef", "ResourceInfoCHEF - This resource does not exist " + this.path);
            }
            this.httpDate = ChefdavServlet.this.getHttpDate(this.modificationDate);
            if (this.creationDate == 0L) {
                this.creationDate = this.modificationDate;
            }
            this.date = this.modificationDate;
        }
    }

    public class DirContextCHEF {
        protected String path;
        private DirContext myDC;
        public boolean isCollection;
        private ContentCollection collection;
        private boolean isRootCollection;

        public DirContextCHEF() {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DirContextCHEF constructor");
            }
        }

        public Object lookup(String id) throws NamingException {
            GenericContentHostingService service;
            this.path = id;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DirContextCHEF.lookup contacting content service " + this.path);
            }
            if ((service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME))) == null) {
                Log.warn("chef", "server configuration error: missing Content Hosting Service");
                return null;
            }
            this.isCollection = false;
            this.isRootCollection = false;
            try {
                this.path = ChefdavServlet.this.fixDirPathCHEF(service, this.path);
                ResourceProperties props = service.getProperties(this.path);
                this.isCollection = props.getBooleanProperty("CHEF:is-collection");
                if (this.isCollection) {
                    this.collection = service.getCollection(this.path);
                    this.isRootCollection = service.isRootCollection(this.path);
                }
            }
            catch (PermissionException e) {
                Log.info("chef", "DirContextCHEF.lookup - You do not have permission to view this resource");
                throw new NamingException();
            }
            catch (IdUnusedException e) {
                Log.warn("chef", "DirContextCHEF.lookup - This resource does not exist");
                throw new NamingException();
            }
            catch (EmptyException e) {
                Log.warn("chef", "DirContextCHEF.lookup - This resource is empty");
                throw new NamingException();
            }
            catch (TypeException e) {
                Log.warn("chef", "DirContextCHEF.lookup - This resource has a type exception");
                throw new NamingException();
            }
            return this.myDC;
        }

        public Iterator list(String id) {
            try {
                Object object = this.lookup(id);
            }
            catch (Exception e) {
                return null;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DirContextCHEF.list getting collection members and iterator");
            }
            List members = this.collection.getMemberResources();
            Iterator it = members.iterator();
            return it;
        }
    }

    public class ChefdavServletInfo {
        protected Properties m_options = new Properties();

        public Properties getOptions() {
            return this.m_options;
        }

        public ChefdavServletInfo(HttpServletRequest req) {
            String type = req.getContentType();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] values = req.getParameterValues(key);
                if (values.length == 1) {
                    this.m_options.put(key, values[0]);
                    continue;
                }
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    buf.append(values[i] + ChefdavServlet.FORM_VALUE_DELIMETER);
                    ++i;
                }
                this.m_options.put(key, buf.toString());
            }
        }

        public String optionsString() {
            StringBuffer buf = new StringBuffer(1024);
            Enumeration<Object> e = this.m_options.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String o = this.m_options.getProperty(key);
                if (!(o instanceof String)) continue;
                buf.append(key);
                buf.append("=");
                buf.append(o.toString());
                buf.append("&");
            }
            return buf.toString();
        }
    }

    public class ChefdavServletInit
    extends Thread {
        public ChefdavServletInit() {
            ChefdavServlet.this.m_ready = false;
            this.start();
        }

        public void run() {
            ChefdavServlet.this.m_ready = true;
        }
    }
}

