/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Notification;
import org.chefproject.core.NotificationEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseNotificationService;
import org.chefproject.service.component.BaseXmlFileStorage;

public class XmlFileNotificationService
extends BaseNotificationService {
    protected String m_storagePath = null;

    public void init(RunData data) throws InitializationException {
        this.m_storagePath = data.getServletContext().getRealPath(this.getProperties().getProperty("path", "db/notification.xml"));
        super.init(data);
        Log.info("chef", this + ".init(RunData): storage path: " + this.m_storagePath);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_cache.disable();
    }

    protected BaseNotificationService.Storage newStorage() {
        return new XmlFileStorage(this);
    }

    protected class XmlFileStorage
    extends BaseXmlFileStorage
    implements BaseNotificationService.Storage {
        public XmlFileStorage(StorageUser user) {
            super(XmlFileNotificationService.this.m_storagePath, "notifications", null, "notification", user);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public Notification get(String id) {
            return (Notification)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public List getAll(String function) {
            Vector<Notification> rv = new Vector<Notification>();
            if (function == null) {
                return rv;
            }
            List all = super.getAllResources(null);
            Iterator it = all.iterator();
            while (it.hasNext()) {
                Notification notification = (Notification)it.next();
                if (!function.equals(notification.getFunction())) continue;
                rv.add(notification);
            }
            return rv;
        }

        public NotificationEdit put(String id) {
            return (NotificationEdit)super.putResource(null, id, null);
        }

        public NotificationEdit edit(String id) {
            return (NotificationEdit)super.editResource(null, id);
        }

        public void commit(NotificationEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(NotificationEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(NotificationEdit edit) {
            super.removeResource(null, edit);
        }
    }
}

