/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.convert.GroupSiteRealmConverter;
import org.chefproject.core.Site;
import org.chefproject.core.SiteEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.service.component.BaseSiteService;

public class DbSiteService
extends BaseSiteService {
    protected String m_siteTableName = "CHEF_SITE";
    protected boolean m_locksInDb = true;

    public void init() throws InitializationException {
        this.m_siteTableName = this.getProperties().getProperty("siteTable", this.m_siteTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        boolean groupConversion = new Boolean(this.getProperties().getProperty("groupConversion", "false"));
        super.init();
        if (groupConversion) {
            GroupSiteRealmConverter.convert();
        }
        Log.info("chef", this + ".init(): site table: " + this.m_siteTableName);
    }

    protected BaseSiteService.Storage newStorage() {
        return new DbStorage(this);
    }

    protected class DbStorage
    extends BaseDbSingleStorage
    implements BaseSiteService.Storage {
        public DbStorage(StorageUser user) {
            super(DbSiteService.this.m_siteTableName, "SITE_ID", null, DbSiteService.this.m_locksInDb, "site", user);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public Site get(String id) {
            return (Site)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public SiteEdit put(String id) {
            return (SiteEdit)super.putResource(id, null);
        }

        public SiteEdit edit(String id) {
            return (SiteEdit)super.editResource(id);
        }

        public void commit(SiteEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(SiteEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(SiteEdit edit) {
            super.removeResource(edit);
        }
    }
}

