/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.service.ContentTypeImageService;

public class BasicContentTypeImageService
extends TurbineBaseService
implements ContentTypeImageService {
    protected Properties m_contentTypeImages = null;
    protected Properties m_contentTypeDisplayNames = null;
    protected Properties m_contentTypes = null;
    protected static final String DEFAULT_FILE = "/chef/generic.gif";
    protected static final String UNKNOWN_TYPE = "application/octet-stream";

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
        String file = data.getServletContext().getRealPath(this.getProperties().getProperty("image_path"));
        this.m_contentTypeImages = new Properties();
        try {
            this.m_contentTypeImages.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Log.warn("chef", this + ".init(): File not found for images file: " + file);
        }
        catch (IOException e) {
            Log.warn("chef", this + ".init(): IOException with images file: " + file);
        }
        file = data.getServletContext().getRealPath(this.getProperties().getProperty("name_path"));
        this.m_contentTypeDisplayNames = new Properties();
        try {
            this.m_contentTypeDisplayNames.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Log.warn("chef", this + ".init(): File not found for names file: " + file);
        }
        catch (IOException e) {
            Log.warn("chef", this + ".init(): IOException with names file: " + file);
        }
        this.m_contentTypes = new Properties();
        file = data.getServletContext().getRealPath(this.getProperties().getProperty("ext_path"));
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            do {
                StringTokenizer st;
                if ((line = reader.readLine()) == null || line.startsWith("#") || !(st = new StringTokenizer(line, " \t", false)).hasMoreTokens()) continue;
                String type = st.nextToken();
                while (st.hasMoreTokens()) {
                    String ext = st.nextToken();
                    this.m_contentTypes.put(ext, type);
                }
            } while (line != null);
            reader.close();
        }
        catch (Exception e) {
            Log.warn("chef", this + ".init(): Exception with ext file: " + file + " : " + e.toString());
        }
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        this.m_contentTypeImages.clear();
        this.m_contentTypeImages = null;
        this.m_contentTypeDisplayNames.clear();
        this.m_contentTypeDisplayNames = null;
        this.m_contentTypes.clear();
        this.m_contentTypes = null;
        super.shutdown();
    }

    public String getContentTypeImage(String contentType) {
        String image = this.m_contentTypeImages.getProperty(contentType);
        if (image == null) {
            image = DEFAULT_FILE;
        }
        return image;
    }

    public String getContentTypeDisplayName(String contentType) {
        String name = this.m_contentTypeDisplayNames.getProperty(contentType);
        if (name == null) {
            name = contentType;
        }
        return name;
    }

    public String getContentType(String extension) {
        String type = this.m_contentTypes.getProperty(extension);
        if (type == null) {
            type = UNKNOWN_TYPE;
        }
        return type;
    }

    public boolean isUnknownType(String contentType) {
        return contentType.equals(UNKNOWN_TYPE);
    }

    static {
        DEFAULT_FILE = DEFAULT_FILE;
        UNKNOWN_TYPE = UNKNOWN_TYPE;
    }
}

