/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.ChatChannel;
import org.chefproject.core.ChatChannelEdit;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageChannelEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericChatService;

public class ChatService {
    protected static GenericChatService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericChatService)((Object)TurbineServices.getInstance().getService(GenericChatService.SERVICE_NAME))) == null) {
            Log.warn("chef", "ChatService.find: missing service: " + GenericChatService.SERVICE_NAME);
        }
    }

    public static GenericChatService getInstance() {
        ChatService.find();
        return M_service;
    }

    public static ChatChannel getChatChannel(String ref) throws IdUnusedException, PermissionException {
        ChatService.find();
        return M_service.getChatChannel(ref);
    }

    public static ChatChannelEdit addChatChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        ChatService.find();
        return M_service.addChatChannel(ref);
    }

    public static List getChannels() {
        ChatService.find();
        return M_service.getChannels();
    }

    public static boolean allowGetChannel(String ref) {
        ChatService.find();
        return M_service.allowGetChannel(ref);
    }

    public static MessageChannel getChannel(String ref) throws IdUnusedException, PermissionException {
        ChatService.find();
        return M_service.getChannel(ref);
    }

    public static boolean allowAddChannel(String ref) {
        ChatService.find();
        return M_service.allowAddChannel(ref);
    }

    public static MessageChannelEdit addChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        ChatService.find();
        return M_service.addChannel(ref);
    }

    public static boolean allowEditChannel(String ref) {
        ChatService.find();
        return M_service.allowEditChannel(ref);
    }

    public static MessageChannelEdit editChannel(String ref) throws IdUnusedException, PermissionException, InUseException {
        ChatService.find();
        return M_service.editChannel(ref);
    }

    public static void commitChannel(MessageChannelEdit edit) {
        ChatService.find();
        M_service.commitChannel(edit);
    }

    public static void cancelChannel(MessageChannelEdit edit) {
        ChatService.find();
        M_service.cancelChannel(edit);
    }

    public static boolean allowRemoveChannel(String ref) {
        ChatService.find();
        return M_service.allowRemoveChannel(ref);
    }

    public static void removeChannel(MessageChannelEdit channel) throws PermissionException {
        ChatService.find();
        M_service.removeChannel(channel);
    }

    public static String channelReference(String context, String id) {
        ChatService.find();
        return M_service.channelReference(context, id);
    }

    public static String messageReference(String context, String channelId, String id) {
        ChatService.find();
        return M_service.messageReference(context, channelId, id);
    }
}

