/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.util.Log;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;

public class ContentContainerConverter
implements Runnable {
    private void doIt(String table, String idField) {
        String sql = "select " + idField + ", IN_COLLECTION from " + table;
        List records = Sql.dbRead(sql, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    String id = result.getString(1);
                    String container = result.getString(2);
                    if (StringUtil.trimToNull(container) != null) {
                        return null;
                    }
                    return id;
                }
                catch (SQLException ignore) {
                    return null;
                }
            }
        });
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String container = StringUtil.referencePath(id);
            String statement = "update " + table + " set" + " IN_COLLECTION = '" + Validator.escapeSql(container) + "'" + " where ( " + idField + " = '" + Validator.escapeSql(id) + "' )";
            boolean ok = Sql.dbWrite(statement);
            if (ok) {
                Log.info("chef", " ** " + table + ": " + id + " updated.");
                continue;
            }
            Log.info("chef", " ** " + table + ": " + id + " update failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.info("chef", " ** Converting content records to add in_content **");
        UsageSessionService.loginThreadUser("admin");
        try {
            this.doIt("CONTENT_COLLECTION", "COLLECTION_ID");
            this.doIt("CONTENT_RESOURCE", "RESOURCE_ID");
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    public static void convert() {
        ContentContainerConverter converter = new ContentContainerConverter();
        Thread thread = new Thread((Runnable)converter, "ContentContainerConverter");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

