/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.ActionTeamlet;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.Role;
import org.chefproject.core.RoleEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.RealmService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.util.Reference;

public class PermissionsAction
extends ActionTeamlet {
    public static final String STATE_MODE = "pemissions.mode";
    public static final String STATE_REALM_ID = "permission.realmId";
    public static final String STATE_REALM_ROLES_ID = "permission.realmRolesId";
    public static final String STATE_DESCRIPTION = "permission.description";
    public static final String STATE_PREFIX = "permission.prefix";
    private static final String STATE_REALM_EDIT = "permission.realm";
    private static final String STATE_ABILITIES = "permission.abilities";
    private static final String STATE_ROLES = "permission.roles";
    private static final String STATE_ROLE_ABILITIES = "permission.rolesAbilities";
    public static final String MODE_MAIN = "main";
    private static final String TEMPLATE_MAIN = "chef_permissions";

    public static String buildHelperContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        Hashtable<String, Set> rolesAbilities;
        String realmId = (String)state.getAttribute(STATE_REALM_ID);
        String realmRolesId = (String)state.getAttribute(STATE_REALM_ROLES_ID);
        RealmEdit edit = (RealmEdit)state.getAttribute(STATE_REALM_EDIT);
        if (edit == null) {
            try {
                edit = RealmService.editRealm(realmId);
                state.setAttribute(STATE_REALM_EDIT, (Object)edit);
            }
            catch (IdUnusedException e) {
                try {
                    edit = RealmService.addRealm(realmId);
                    state.setAttribute(STATE_REALM_EDIT, (Object)edit);
                }
                catch (IdInvalidException ee) {
                    Log.warn("chef", "PermissionsAction.buildHelperContext: addRealm: " + ee);
                    PermissionsAction.cleanupState(state);
                    return null;
                }
                catch (IdUsedException ee) {
                    Log.warn("chef", "PermissionsAction.buildHelperContext: addRealm: " + ee);
                    PermissionsAction.cleanupState(state);
                    return null;
                }
                catch (PermissionException ee) {
                    Log.warn("chef", "PermissionsAction.buildHelperContext: addRealm: " + ee);
                    PermissionsAction.cleanupState(state);
                    return null;
                }
            }
            catch (PermissionException e) {
                Log.warn("chef", "PermissionsAction.buildHelperContext: editRealm: " + e);
                PermissionsAction.cleanupState(state);
                return null;
            }
            catch (InUseException e) {
                Log.warn("chef", "PermissionsAction.buildHelperContext: editRealm: " + e);
                PermissionsAction.cleanupState(state);
                return null;
            }
        }
        String prefix = (String)state.getAttribute(STATE_PREFIX);
        Vector<String> abilities = (Vector<String>)state.getAttribute(STATE_ABILITIES);
        if (abilities == null) {
            List abilitiesAll = ServerConfigurationService.getLocks();
            abilities = new Vector<String>();
            Iterator iLocks = abilitiesAll.iterator();
            while (iLocks.hasNext()) {
                String ability = (String)iLocks.next();
                if (!ability.startsWith(prefix)) continue;
                abilities.add(ability);
            }
            state.setAttribute(STATE_ABILITIES, abilities);
        }
        String description = (String)state.getAttribute(STATE_DESCRIPTION);
        Vector roles = (Vector)state.getAttribute(STATE_ROLES);
        if (roles == null) {
            Realm roleRealm = edit;
            if (realmRolesId != null) {
                try {
                    roleRealm = RealmService.getRealm(realmRolesId);
                }
                catch (Exception e) {
                    Log.warn("chef", "PermissionsAction.buildHelperContext: getRolesRealm: " + realmRolesId + " : " + e);
                }
            }
            roles = new Vector();
            roles.addAll(roleRealm.getRoles());
            Collections.sort(roles);
            state.setAttribute(STATE_ROLES, roles);
        }
        if ((rolesAbilities = (Hashtable<String, Set>)state.getAttribute(STATE_ROLE_ABILITIES)) == null) {
            rolesAbilities = new Hashtable<String, Set>();
            state.setAttribute(STATE_ROLE_ABILITIES, rolesAbilities);
            Reference ref = new Reference(edit.getId());
            List realms = ref.getRealms();
            try {
                Realm myRealm = RealmService.getRealm(edit.getId());
                if (realms.contains(myRealm)) {
                    realms.remove(myRealm);
                }
            }
            catch (IdUnusedException ignore) {
                // empty catch block
            }
            Iterator iRoles = roles.iterator();
            while (iRoles.hasNext()) {
                Role role = (Role)iRoles.next();
                rolesAbilities.put(role.getId(), PermissionsAction.roleAbilities(role.getId(), realms));
            }
        }
        context.put("realm", edit);
        context.put("prefix", prefix);
        context.put("abilities", abilities);
        context.put("description", description);
        context.put("roles", roles);
        context.put("action", "PermissionsAction");
        context.put("rolesAbilities", rolesAbilities);
        VelocityPortletPaneledAction.disableObservers(state);
        return TEMPLATE_MAIN;
    }

    private static void cleanupState(SessionState state) {
        state.removeAttribute(STATE_REALM_ID);
        state.removeAttribute(STATE_REALM_EDIT);
        state.removeAttribute(STATE_PREFIX);
        state.removeAttribute(STATE_ABILITIES);
        state.removeAttribute(STATE_DESCRIPTION);
        state.removeAttribute(STATE_ROLES);
        state.removeAttribute(STATE_ROLE_ABILITIES);
        state.removeAttribute(STATE_MODE);
        VelocityPortletPaneledAction.enableObservers(state);
    }

    public void doSave(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit edit = (RealmEdit)state.getAttribute(STATE_REALM_EDIT);
        this.readForm(data, edit, state);
        RealmService.commitEdit(edit);
        PermissionsAction.cleanupState(state);
    }

    public void doCancel(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit edit = (RealmEdit)state.getAttribute(STATE_REALM_EDIT);
        if (edit != null) {
            RealmService.cancelEdit(edit);
        }
        PermissionsAction.cleanupState(state);
    }

    private void readForm(RunData data, RealmEdit edit, SessionState state) {
        List abilities = (List)state.getAttribute(STATE_ABILITIES);
        List roles = (List)state.getAttribute(STATE_ROLES);
        Iterator iRoles = roles.iterator();
        while (iRoles.hasNext()) {
            Role role = (Role)iRoles.next();
            Iterator iLocks = abilities.iterator();
            while (iLocks.hasNext()) {
                RoleEdit myRole;
                String lock = (String)iLocks.next();
                String checked = data.getParameters().getString(role.getId() + lock);
                if (checked != null) {
                    myRole = edit.getRoleEdit(role.getId());
                    if (myRole == null) {
                        try {
                            myRole = edit.addRole(role.getId());
                        }
                        catch (IdUsedException e) {
                            Log.warn("chef", "PermissionsAction.readForm: addRole after getRoleEdit null: " + role.getId() + " : " + e);
                        }
                    }
                    myRole.addLock(lock);
                    continue;
                }
                myRole = edit.getRoleEdit(role.getId());
                if (myRole == null) continue;
                myRole.removeLock(lock);
            }
        }
    }

    private static Set roleAbilities(String roleId, List realms) {
        HashSet abilities = new HashSet();
        Iterator it = realms.iterator();
        while (it.hasNext()) {
            Realm realm = (Realm)it.next();
            Role role = realm.getRole(roleId);
            if (role == null) continue;
            abilities.addAll(role.collectLocks());
        }
        return abilities;
    }

    static {
        STATE_MODE = STATE_MODE;
        STATE_REALM_ID = STATE_REALM_ID;
        STATE_REALM_ROLES_ID = STATE_REALM_ROLES_ID;
        STATE_DESCRIPTION = STATE_DESCRIPTION;
        STATE_PREFIX = STATE_PREFIX;
        STATE_REALM_EDIT = STATE_REALM_EDIT;
        STATE_ABILITIES = STATE_ABILITIES;
        STATE_ROLES = STATE_ROLES;
        STATE_ROLE_ABILITIES = STATE_ROLE_ABILITIES;
        MODE_MAIN = MODE_MAIN;
        TEMPLATE_MAIN = TEMPLATE_MAIN;
    }
}

