/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.PermissionsAction;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.NewsChannel;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.exception.NewsConnectionException;
import org.chefproject.exception.NewsFormatException;
import org.chefproject.service.NewsService;
import org.chefproject.util.Menu;
import org.chefproject.util.StringUtil;

public class NewsAction
extends VelocityPortletPaneledAction {
    private static final String MONITOR_PANEL = "List";
    private static final String CONTROL_PANEL = "Control";
    private static final String PARAM_CHANNEL_URL = "channel-url";
    private static final String STATE_CHANNEL_TITLE = "channelTitle";
    private static final String STATE_CHANNEL_URL = "channelUrl";
    private static final String FORM_CHANNEL_TITLE = "title-of-channel";
    private static final String FORM_CHANNEL_URL = "address-of-channel";

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        PortletConfig config = portlet.getPortletConfig();
        if (state.getAttribute(STATE_CHANNEL_TITLE) == null) {
            PortletInstance instance = PersistenceManager.getInstance((Portlet)portlet, (RunData)rundata);
            Entry entry = instance.getEntry();
            state.setAttribute(STATE_CHANNEL_TITLE, (Object)entry.getTitle());
            String channelUrl = StringUtil.trimToNull(config.getInitParameter(PARAM_CHANNEL_URL));
            if (channelUrl == null) {
                channelUrl = "";
            } else {
                try {
                    NewsChannel ch = NewsService.getChannel(channelUrl);
                }
                catch (NewsConnectionException e) {
                    this.addAlert(state, e.getMessage());
                    return;
                }
                catch (NewsFormatException e) {
                    this.addAlert(state, e.getMessage());
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            state.setAttribute(STATE_CHANNEL_URL, (Object)channelUrl);
        }
        if (state.getAttribute("action") == null) {
            state.setAttribute("action", (Object)"NewsAction");
        }
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String mode;
        String helperMode = (String)state.getAttribute("pemissions.mode");
        if (helperMode != null) {
            String template = PermissionsAction.buildHelperContext(portlet, context, rundata, state);
            if (template == null) {
                this.addAlert(state, "There is a problem setting Permissions at this time.");
            } else {
                return template;
            }
        }
        if ("options".equals(mode = (String)state.getAttribute("mode"))) {
            return this.buildOptionsPanelContext(portlet, context, rundata, state);
        }
        context.put("panel-control", CONTROL_PANEL);
        context.put("panel-monitor", MONITOR_PANEL);
        Menu bar = new Menu((Portlet)portlet, rundata, (String)state.getAttribute("action"));
        this.addOptionsMenu(bar, (JetspeedRunData)rundata);
        if (bar.getItems().hasNext()) {
            context.put("menu", bar);
        }
        context.put("action", state.getAttribute("action"));
        String url = (String)state.getAttribute(STATE_CHANNEL_URL);
        NewsChannel channel = null;
        try {
            channel = NewsService.getChannel(url);
        }
        catch (NewsConnectionException e) {
            this.addAlert(state, e.getMessage());
        }
        catch (NewsFormatException e) {
            this.addAlert(state, e.getMessage());
        }
        catch (Exception e) {
            this.addAlert(state, e.getMessage());
        }
        context.put("channel", channel);
        return (String)this.getContext(rundata).get("template") + "-Layout";
    }

    public String buildListPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("panel-control", CONTROL_PANEL);
        context.put("panel-monitor", MONITOR_PANEL);
        String channel = (String)state.getAttribute(STATE_CHANNEL_URL);
        List items = new Vector();
        try {
            items = NewsService.getNewsitems(channel);
        }
        catch (NewsConnectionException e) {
            this.addAlert(state, e.getMessage());
        }
        catch (NewsFormatException e) {
            this.addAlert(state, e.getMessage());
        }
        catch (Exception e) {
            this.addAlert(state, e.getMessage());
        }
        context.put("news_items", items.iterator());
        return (String)this.getContext(rundata).get("template") + "-List";
    }

    public String buildControlPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("panel-control", CONTROL_PANEL);
        context.put("panel-monitor", MONITOR_PANEL);
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doGet_update");
        boolean updateAvailable = false;
        context.put("update_available", new Boolean(updateAvailable));
        return (String)this.getContext(rundata).get("template") + "-Control";
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("formfield_channel_title", FORM_CHANNEL_TITLE);
        context.put("current_channel_title", (String)state.getAttribute(STATE_CHANNEL_TITLE));
        context.put("formfield_channel_url", FORM_CHANNEL_URL);
        context.put("current_channel_url", (String)state.getAttribute(STATE_CHANNEL_URL));
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doUpdate");
        context.put("form-cancel", "eventSubmit_doCancel");
        String template = (String)this.getContext(rundata).get("template");
        return template + "-customize";
    }

    public void doUpdate(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        String newChannelTitle = data.getParameters().getString(FORM_CHANNEL_TITLE);
        String currentChannelTitle = (String)state.getAttribute(STATE_CHANNEL_TITLE);
        if (newChannelTitle != null && !newChannelTitle.equals(currentChannelTitle)) {
            state.setAttribute(STATE_CHANNEL_TITLE, (Object)newChannelTitle);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", (Object)((Object)this) + ".doUpdate(): newChannelTitle: " + newChannelTitle);
            }
            ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
            tool.setTitle(newChannelTitle);
        }
        String newChannelUrl = data.getParameters().getString(FORM_CHANNEL_URL);
        String currentChannelUrl = (String)state.getAttribute(STATE_CHANNEL_URL);
        if (newChannelUrl == null && currentChannelUrl == null) {
            this.addAlert(state, "Please provide a complete URL for the news feed.");
            return;
        }
        if (newChannelUrl != null && !newChannelUrl.equals(currentChannelUrl)) {
            try {
                URL url = new URL(newChannelUrl);
                Object content = url.getContent();
                NewsService.getChannel(url.toExternalForm());
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", (Object)((Object)this) + ".doUpdate(): newChannelUrl: " + newChannelUrl);
                }
                state.setAttribute(STATE_CHANNEL_URL, (Object)url.toExternalForm());
                ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
                tool.getPropertiesEdit().addProperty(PARAM_CHANNEL_URL, url.toExternalForm());
            }
            catch (NewsConnectionException e) {
                this.addAlert(state, e.getMessage());
                return;
            }
            catch (NewsFormatException e) {
                this.addAlert(state, e.getMessage());
                return;
            }
            catch (Exception e) {
                this.addAlert(state, e.getMessage());
                return;
            }
        }
        state.removeAttribute("mode");
        VelocityPortletPaneledAction.enableObservers(state);
        this.saveOptions();
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.removeAttribute("mode");
        VelocityPortletPaneledAction.enableObservers(state);
        this.cancelOptions();
    }

    static {
        MONITOR_PANEL = MONITOR_PANEL;
        CONTROL_PANEL = CONTROL_PANEL;
        PARAM_CHANNEL_URL = PARAM_CHANNEL_URL;
        STATE_CHANNEL_TITLE = STATE_CHANNEL_TITLE;
        STATE_CHANNEL_URL = STATE_CHANNEL_URL;
        FORM_CHANNEL_TITLE = FORM_CHANNEL_TITLE;
        FORM_CHANNEL_URL = FORM_CHANNEL_URL;
    }
}

