/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.Site;
import org.chefproject.core.User;
import org.chefproject.core.component.RefreshTopDelivery;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.CourierService;
import org.chefproject.service.PortalService;
import org.chefproject.service.RealmService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;

public class MembershipAction
extends VelocityPortletPaneledAction {
    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("action", state.getAttribute("action"));
        Vector<Site> openSites = new Vector<Site>();
        List sites = SiteService.getSites();
        Iterator iSites = sites.iterator();
        while (iSites.hasNext()) {
            Site site = (Site)iSites.next();
            if (site.getStatus() != 2 || !site.isJoinable() || SiteService.allowAccessSite(site.getId())) continue;
            openSites.add(site);
        }
        if (openSites.size() > 0) {
            Collections.sort(openSites);
            context.put("openSites", openSites);
        }
        return (String)this.getContext(rundata).get("template");
    }

    public void doJoin(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        User user = UsageSessionService.getSessionUser();
        String[] ids = data.getParameters().getStrings("join");
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                try {
                    Site site = SiteService.getSite(ids[i]);
                    String role = site.getJoinerRole();
                    if (role == null) {
                        Log.warn("chef", (Object)((Object)this) + ".doJoin(): null site joiner role for site: " + ids[i]);
                    } else {
                        RealmEdit edit = RealmService.editRealm(SiteService.siteReference(ids[i]));
                        edit.addUserRole(user, edit.getRole(role));
                        RealmService.commitEdit(edit);
                    }
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", (Object)((Object)this) + ".doJoin(): " + e);
                }
                catch (PermissionException e) {
                    Log.warn("chef", (Object)((Object)this) + ".doJoin(): " + e);
                }
                catch (InUseException e) {
                    Log.warn("chef", (Object)((Object)this) + ".doJoin(): " + e);
                }
                ++i;
            }
        }
        CourierService.deliver(new RefreshTopDelivery(PortalService.getCurrentClientWindowId(null)));
    }

    public void doUnjoin(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        User user = UsageSessionService.getSessionUser();
        String[] ids = data.getParameters().getStrings("unjoin");
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                try {
                    RealmEdit edit = RealmService.editRealm(SiteService.siteReference(ids[i]));
                    edit.removeUser(user);
                    RealmService.commitEdit(edit);
                }
                catch (IdUnusedException ignore) {
                }
                catch (PermissionException e) {
                    Log.warn("chef", (Object)((Object)this) + ".doUnjoin(): " + e);
                }
                catch (InUseException e) {
                    Log.warn("chef", (Object)((Object)this) + ".doJoin(): " + e);
                }
                ++i;
            }
        }
        CourierService.deliver(new RefreshTopDelivery(PortalService.getCurrentClientWindowId(null)));
    }

    protected boolean requireResetToolLink() {
        return false;
    }
}

