/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.map;

import org.apache.turbine.util.db.map.TableMap;

public class ColumnMap {
    private Object type = null;
    private int size = 0;
    private boolean pk = false;
    private boolean notNull = false;
    private String relatedTableName = "";
    private String relatedColumnName = "";
    private TableMap table;
    private String columnName;

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullyQualifiedName() {
        return this.table.getName() + "." + this.columnName;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public void setType(Object type) {
        this.type = type;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setPrimaryKey(boolean pk) {
        this.pk = pk;
    }

    public void setNotNull(boolean nn) {
        this.notNull = nn;
    }

    public void setForeignKey(String fullyQualifiedName) {
        if (fullyQualifiedName != null && fullyQualifiedName.length() > 0) {
            this.relatedTableName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(46));
            this.relatedColumnName = fullyQualifiedName.substring(fullyQualifiedName.indexOf(46) + 1);
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public void setForeignKey(String tableName, String columnName) {
        if (tableName != null && tableName.length() > 0 && columnName != null && columnName.length() > 0) {
            this.relatedTableName = tableName;
            this.relatedColumnName = columnName;
        } else {
            this.relatedTableName = "";
            this.relatedColumnName = "";
        }
    }

    public Object getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPrimaryKey() {
        return this.pk;
    }

    public boolean isNotNull() {
        return this.notNull || this.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.relatedTableName != null && this.relatedTableName.length() > 0;
    }

    public String getRelatedName() {
        return this.relatedTableName + "." + this.relatedColumnName;
    }

    public String getRelatedTableName() {
        return this.relatedTableName;
    }

    public String getRelatedColumnName() {
        return this.relatedColumnName;
    }

    public ColumnMap(String name, TableMap containingTable) {
        this.columnName = name;
        this.table = containingTable;
    }
}

