/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ValueParser;
import org.apache.turbine.util.parser.BaseValueParser;

public abstract class DataStreamParser
implements Iterator {
    private List columnNames;
    private StreamTokenizer tokenizer;
    private ValueParser lineValues;
    private boolean neverRead = true;
    private String characterEncoding;

    protected abstract void initTokenizer(StreamTokenizer var1);

    public void setColumnNames(List columnNames) {
        this.columnNames = columnNames;
    }

    public void readColumnNames() throws IOException {
        this.columnNames = new ArrayList();
        this.neverRead = false;
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            this.columnNames.add(this.tokenizer.sval);
            this.tokenizer.nextToken();
        }
    }

    public boolean hasNextRow() throws IOException {
        if (this.neverRead || this.tokenizer.ttype == 10) {
            this.tokenizer.nextToken();
            this.tokenizer.pushBack();
            this.neverRead = false;
        }
        return this.tokenizer.ttype != -1;
    }

    public ValueParser nextRow() throws IOException, NoSuchElementException {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException();
        }
        if (this.lineValues == null) {
            this.lineValues = new BaseValueParser(this.characterEncoding);
        } else {
            this.lineValues.clear();
        }
        Iterator it = this.columnNames.iterator();
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            if (it.hasNext()) {
                String colname = it.next().toString();
                String colval = this.tokenizer.sval;
                System.out.println(colname + "=" + colval);
                this.lineValues.add(colname, colval);
            }
            this.tokenizer.nextToken();
        }
        return this.lineValues;
    }

    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextRow();
        }
        catch (IOException e) {
            Log.error("IOException in CSVParser.hasNext", e);
        }
        return hasNext;
    }

    public Object next() throws NoSuchElementException {
        ValueParser nextRow = null;
        try {
            nextRow = this.nextRow();
        }
        catch (IOException e) {
            Log.error("IOException in CSVParser.next", e);
            throw new NoSuchElementException();
        }
        return nextRow;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public DataStreamParser(Reader in, List columnNames, String characterEncoding) {
        this.columnNames = columnNames;
        this.characterEncoding = characterEncoding;
        if (this.characterEncoding == null) {
            this.characterEncoding = "US-ASCII";
            try {
                this.characterEncoding = ((InputStreamReader)in).getEncoding();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        this.tokenizer = new StreamTokenizer(new BufferedReader(in));
        this.initTokenizer(this.tokenizer);
    }
}

