/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.torque.engine.database.model.Column;
import org.apache.turbine.torque.engine.database.model.Database;
import org.apache.turbine.torque.engine.database.model.ForeignKey;
import org.apache.turbine.torque.engine.database.model.IdMethodParameter;
import org.apache.turbine.torque.engine.database.model.Index;
import org.apache.turbine.torque.engine.database.model.Inheritance;
import org.apache.turbine.torque.engine.database.model.Unique;
import org.apache.velocity.util.StringUtils;
import org.xml.sax.Attributes;

public class Table {
    private List columnList;
    private List foreignKeys;
    private List indices;
    private List unices;
    private List idMethodParameters;
    private String name;
    private String javaName;
    private String idMethod;
    private Database tableParent;
    private List referrers;
    private List foreignTableNames;
    private boolean containsForeignPK;
    private Column inheritanceColumn;
    private boolean skipSql;
    private boolean abstractValue;
    private String alias;
    private String baseClass;
    private String basePeer;
    private Hashtable columnsByName = new Hashtable();
    private Hashtable columnsByJavaName = new Hashtable();

    public void loadFromXML(Attributes attrib, String defaultIdMethod) {
        this.name = attrib.getValue("name");
        this.javaName = attrib.getValue("javaName");
        this.idMethod = attrib.getValue("idMethod");
        if ("null".equals(this.idMethod)) {
            this.idMethod = defaultIdMethod;
        }
        this.skipSql = "true".equals(attrib.getValue("skipSql"));
        this.abstractValue = "true".equals(attrib.getValue("abstract"));
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.alias = attrib.getValue("alias");
    }

    public String getBaseClass() {
        if (this.isAlias() && this.baseClass == null) {
            return this.alias;
        }
        if (this.baseClass == null) {
            return this.getDatabase().getBaseClass();
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.isAlias() && this.basePeer == null) {
            return this.alias + "Peer";
        }
        if (this.basePeer == null) {
            return this.getDatabase().getBasePeer();
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public Column addColumn(Attributes attrib) {
        Column col = new Column();
        col.loadFromXML(attrib);
        this.addColumn(col);
        return col;
    }

    public void addColumn(Column col) {
        col.setTable(this);
        if (col.isInheritance()) {
            this.inheritanceColumn = col;
        }
        this.columnList.add(col);
        this.columnsByName.put(col.getName(), col);
        this.columnsByJavaName.put(col.getJavaName(), col);
        col.setPosition(this.columnList.size());
    }

    public ForeignKey addForeignKey(Attributes attrib) {
        ForeignKey fk = new ForeignKey();
        fk.loadFromXML(attrib);
        this.addForeignKey(fk);
        return fk;
    }

    public Column getChildrenColumn() {
        return this.inheritanceColumn;
    }

    public List getChildrenNames() {
        if (this.inheritanceColumn == null || !this.inheritanceColumn.isEnumeratedClasses()) {
            return null;
        }
        List children = this.inheritanceColumn.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        int i = 0;
        while (i < children.size()) {
            names.add(((Inheritance)children.get(i)).getClassName());
            ++i;
        }
        return names;
    }

    public void addReferrer(ForeignKey fk) {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        this.referrers.add(fk);
    }

    public List getReferrers() {
        return this.referrers;
    }

    public void setContainsForeignPK(boolean b) {
        this.containsForeignPK = b;
    }

    public boolean getContainsForeignPK() {
        return this.containsForeignPK;
    }

    public List getForeignTableNames() {
        if (this.foreignTableNames == null) {
            this.foreignTableNames = new ArrayList(1);
        }
        return this.foreignTableNames;
    }

    public void addForeignKey(ForeignKey fk) {
        fk.setTable(this);
        this.foreignKeys.add(fk);
        if (this.foreignTableNames == null) {
            this.foreignTableNames = new ArrayList(5);
        }
        if (this.foreignTableNames.contains(fk.getForeignTableName())) {
            this.foreignTableNames.add(fk.getForeignTableName());
        }
    }

    public IdMethodParameter addIdMethodParameter(Attributes attrib) {
        IdMethodParameter imp = new IdMethodParameter();
        imp.loadFromXML(attrib);
        this.addIdMethodParameter(imp);
        return imp;
    }

    public void addIdMethodParameter(IdMethodParameter imp) {
        imp.setTable(this);
        if (this.idMethodParameters == null) {
            this.idMethodParameters = new ArrayList(2);
        }
        this.idMethodParameters.add(imp);
    }

    public void addIndex(Index index) {
        index.setTable(this);
        this.indices.add(index);
    }

    public Index addIndex(Attributes attrib) {
        Index index = new Index();
        index.loadFromXML(attrib);
        this.addIndex(index);
        return index;
    }

    public void addUnique(Unique unique) {
        unique.setTable(this);
        this.unices.add(unique);
    }

    public Unique addUnique(Attributes attrib) {
        Unique unique = new Unique();
        this.addUnique(unique);
        return unique;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getJavaName() {
        if (this.javaName == null) {
            return StringUtils.removeUnderScores(this.name);
        }
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getIdMethod() {
        if (this.idMethod == null) {
            return "none";
        }
        return this.idMethod;
    }

    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    public boolean isSkipSql() {
        return this.skipSql || this.isAlias();
    }

    public void setSkipSql(boolean v) {
        this.skipSql = v;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAlias() {
        return this.alias != null;
    }

    public void setAlias(String v) {
        this.alias = v;
    }

    public boolean isAbstract() {
        return this.abstractValue;
    }

    public void setAbstract(boolean v) {
        this.abstractValue = v;
    }

    public Column[] getColumns() {
        int size = this.columnList.size();
        Column[] tbls = new Column[size];
        int i = 0;
        while (i < size) {
            tbls[i] = (Column)this.columnList.get(i);
            ++i;
        }
        return tbls;
    }

    public int getNumColumns() {
        return this.columnList.size();
    }

    public ForeignKey[] getForeignKeys() {
        int size = this.foreignKeys.size();
        ForeignKey[] tbls = new ForeignKey[size];
        int i = 0;
        while (i < size) {
            tbls[i] = (ForeignKey)this.foreignKeys.get(i);
            ++i;
        }
        return tbls;
    }

    public List getIdMethodParameters() {
        return this.idMethodParameters;
    }

    public String getSequenceName() {
        String result = null;
        if (this.getIdMethod().equals("sequence")) {
            result = this.getIdMethodParameters() == null ? this.getName() + "_SEQ" : ((IdMethodParameter)this.getIdMethodParameters().get(0)).getValue();
        }
        return result;
    }

    public Index[] getIndices() {
        int size = this.indices.size();
        Index[] tbls = new Index[size];
        int i = 0;
        while (i < size) {
            tbls[i] = (Index)this.indices.get(i);
            ++i;
        }
        return tbls;
    }

    public Unique[] getUnices() {
        int size = this.unices.size();
        Unique[] tbls = new Unique[size];
        int i = 0;
        while (i < size) {
            tbls[i] = (Unique)this.unices.get(i);
            ++i;
        }
        return tbls;
    }

    public Column getColumn(String name) {
        return (Column)this.columnsByName.get(name);
    }

    public Column getColumnByJavaName(String javaName) {
        return (Column)this.columnsByJavaName.get(javaName);
    }

    public ForeignKey getForeignKey(String col) {
        Iterator iter = this.foreignKeys.iterator();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            if (!key.getLocalColumns().contains(col)) continue;
            return key;
        }
        return null;
    }

    public boolean containsColumn(Column col) {
        return this.columnList.contains(col);
    }

    public boolean containsColumn(String name) {
        return this.getColumn(name) != null;
    }

    public void setDatabase(Database parent) {
        this.tableParent = parent;
    }

    public Database getDatabase() {
        return this.tableParent;
    }

    public String toString() {
        Iterator iter;
        StringBuffer result = new StringBuffer();
        result.append("<table name=\"").append(this.name).append('\"');
        if (this.javaName != null) {
            result.append(" javaname=\"").append(this.javaName).append('\"');
        }
        if (this.idMethod != null) {
            result.append(" idMethod=\"").append(this.idMethod).append('\"');
        }
        if (this.skipSql) {
            result.append(" skipSql=\"").append(new Boolean(this.skipSql)).append('\"');
        }
        if (this.abstractValue) {
            result.append(" abstract=\"").append(new Boolean(this.abstractValue)).append('\"');
        }
        if (this.baseClass != null) {
            result.append(" baseClass=\"").append(this.baseClass).append('\"');
        }
        if (this.basePeer != null) {
            result.append(" basePeer=\"").append(this.basePeer).append('\"');
        }
        result.append(">\n");
        if (this.columnList != null) {
            iter = this.columnList.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this.foreignKeys != null) {
            iter = this.foreignKeys.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this.idMethodParameters != null) {
            iter = this.idMethodParameters.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        result.append("</table>\n");
        return result.toString();
    }

    public List getPrimaryKey() {
        ArrayList<Column> pk = new ArrayList<Column>(this.columnList.size());
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (!col.isPrimaryKey()) continue;
            pk.add(col);
        }
        return pk;
    }

    public final ArrayList getPrimaryKeys() {
        return (ArrayList)this.getPrimaryKey();
    }

    public String printPrimaryKey() {
        return this.printList(this.columnList);
    }

    public final String printPrimaryKeys() {
        return this.printPrimaryKey();
    }

    private String printList(List list) {
        StringBuffer result = new StringBuffer();
        boolean comma = false;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (!col.isPrimaryKey()) continue;
            if (comma) {
                result.append(',');
            } else {
                comma = true;
            }
            result.append(col.getName());
        }
        return result.toString();
    }

    public List getAdditionalIndicesForPrimaryKey() {
        List pk = this.getPrimaryKey();
        int nbrPKParts = pk.size();
        ArrayList<String> additionalIndices = new ArrayList<String>(nbrPKParts - 1);
        int i = 1;
        while (i < nbrPKParts) {
            additionalIndices.add(this.printList(pk.subList(i, nbrPKParts)));
            ++i;
        }
        return additionalIndices;
    }

    public Table() {
        this(null);
    }

    public Table(String name) {
        this.name = name;
        this.columnList = new ArrayList();
        this.foreignKeys = new ArrayList(5);
        this.indices = new ArrayList(5);
        this.unices = new ArrayList(5);
    }
}

