/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.java;

import java.util.Vector;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;

public abstract class JavaBaseFactory
implements AssemblerFactory {
    private static Vector packages = TurbineResources.getVector("module.packages");

    public Assembler getAssembler(String packageName, String name) {
        Assembler assembler = null;
        int i = 0;
        while (i < packages.size()) {
            String className = (String)packages.elementAt(i) + "." + packageName + "." + name;
            try {
                Class<?> servClass = Class.forName(className);
                assembler = (Assembler)servClass.newInstance();
                return assembler;
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoClassDefFoundError ncdfe) {
            }
            catch (ClassCastException cce) {
                return null;
            }
            catch (InstantiationException ine) {
                return null;
            }
            catch (IllegalAccessException ilae) {
                return null;
            }
            ++i;
        }
        return assembler;
    }

    public abstract Assembler getAssembler(String var1) throws Exception;

    static {
        ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
    }
}

