/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject.test;

import com.sourceforge.knecs.dsm.resourceobject.RISConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISConnectionFactory;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.resourceobject.Task;
import com.sourceforge.knecs.dsm.util.EmbeddedAnno;
import com.sourceforge.knecs.security.jaas.CMCSNameHandler;
import com.sourceforge.knecs.security.jaas.JAASUtils;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.net.PasswordAuthentication;
import java.util.logging.Logger;
import javax.security.auth.login.LoginContext;

public class TestTask {
    private TestTask(String[] args) {
        Logger mlog = LoggerUtils.getLogger(this);
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String context = props.getProperty("logincontext");
        String account = props.getProperty("portalid");
        String pop = props.getProperty("portalobjects");
        String mHoststr = svr + pop;
        try {
            JAASUtils.initLoginConfig(this.getClass());
        }
        catch (SecurityException se) {
            System.out.println("Unable to initialize JAAS config " + se.getMessage());
            System.exit(-1);
        }
        try {
            LoginContext lc = new LoginContext(context, new CMCSNameHandler(account));
            lc.login();
            PasswordAuthentication pa = JAASUtils.subjectToDSICredentials(lc.getSubject());
            RISConnection ris = RISConnectionFactory.getRISConnection(mHoststr);
            ris.connect(pa.getUserName(), new String(pa.getPassword()));
            Task task = new Task();
            task.setTitle("from test driver");
            task.setOwnerId("karen");
            EmbeddedAnno anno = new EmbeddedAnno("karen", "comment 1");
            EmbeddedAnno[] annos = new EmbeddedAnno[]{anno};
            task.setComments(annos);
            System.out.println("Task XML->\n " + task.toXML());
            String ctxName = ris.save(task);
            ResourceObject ro = ris.getResourceObject(ctxName);
            if (ro != null) {
                mlog.info("getobject result XML" + ro.toXML());
            }
            annos = new EmbeddedAnno[]{anno, anno = new EmbeddedAnno("karen", "comment 2")};
            task.setComments(annos);
            ctxName = ris.save(task);
            ro = ris.getResourceObject(ctxName);
            if (ro != null) {
                mlog.info("getobject result XML" + ro.toXML());
            }
            ris.close();
            lc.logout();
        }
        catch (Exception ex) {
            mlog.severe("Caught Exception during RISTest: " + ex.toString() + "\n" + "Trace:\n" + ex.getStackTrace().toString());
        }
    }

    public static void main(String[] args) {
        TestTask st = new TestTask(args);
    }
}

