/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ChefObject;
import com.sourceforge.knecs.dsm.util.EmbeddedAnno;

public class Task
extends ChefObject {
    public static final String CREATOR = "http://purl.org/dc/elements/1.1/:creator";
    public static final String TITLE = "http://purl.org/dc/elements/1.1/:title";
    public static final String DESCRIPTION = "http://purl.org/dc/elements/1.1/:description";
    public static final String STATUS = "http://purl.oclc.org/NET/cmcs/internal/schema/:status";
    public static final String ASSIGNEDTO = "http://purl.oclc.org/NET/cmcs/internal/schema/:assignedto";
    public static final String PRIORITY = "http://purl.oclc.org/NET/cmcs/internal/schema/:prioirty";
    public static final String TARGETVERSION = "http://purl.oclc.org/NET/cmcs/internal/schema/:version";
    public static final String CATEGORY = "http://purl.oclc.org/NET/cmcs/internal/schema/:category";
    public static final String USERKEYWORDS = "http://purl.oclc.org/NET/cmcs/internal/schema/:userkeywords";
    public static final String COMMENTS = "http://purl.oclc.org/NET/cmcs/internal/schema/:comments";
    public static final String REQUIREDBY = "http://purl.oclc.org/NET/cmcs/internal/schema/:requiredby";
    public static final String DUEDATE = "http://purl.oclc.org/NET/cmcs/internal/schema/:duedate";

    public Task() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating Tools class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(TITLE, String.class);
        this.mAttributeTypes.put(DESCRIPTION, String.class);
        this.mAttributeTypes.put(STATUS, String.class);
        this.mAttributeTypes.put(ASSIGNEDTO, String[].class);
        this.mAttributeTypes.put(REQUIREDBY, String[].class);
        this.mAttributeTypes.put(PRIORITY, String.class);
        this.mAttributeTypes.put(TARGETVERSION, String.class);
        this.mAttributeTypes.put(CATEGORY, String.class);
        this.mAttributeTypes.put(USERKEYWORDS, String[].class);
        this.mAttributeTypes.put(COMMENTS, EmbeddedAnno[].class);
        this.mAttributeTypes.put(DUEDATE, String.class);
    }

    public String getIdNumber() {
        int dot;
        String id = this.getId();
        int dash = id.indexOf("-");
        if (dash >= 0) {
            id = id.substring(dash + 1);
        }
        if ((dot = id.indexOf(".")) >= 0) {
            id = id.substring(0, dot);
        }
        return id;
    }

    public String getTitle() {
        return (String)this.mResourceEntry.get(TITLE);
    }

    public String getDescription() {
        return (String)this.mResourceEntry.get(DESCRIPTION);
    }

    public String getDueDate() {
        return (String)this.mResourceEntry.get(DUEDATE);
    }

    public String getStatus() {
        return (String)this.mResourceEntry.get(STATUS);
    }

    public String getPriority() {
        return (String)this.mResourceEntry.get(PRIORITY);
    }

    public String[] getAssignedTo() {
        return this.getAsStringArray(ASSIGNEDTO);
    }

    public String[] getRequiredBy() {
        return this.getAsStringArray(REQUIREDBY);
    }

    public String getTargetVersion() {
        return (String)this.mResourceEntry.get(TARGETVERSION);
    }

    public String getCategory() {
        return (String)this.mResourceEntry.get(CATEGORY);
    }

    public String[] getKeywords() {
        return this.getAsStringArray(USERKEYWORDS);
    }

    public EmbeddedAnno[] getComments() {
        Class<?> vclass;
        EmbeddedAnno[] ret = null;
        Object value = this.mResourceEntry.get(COMMENTS);
        if (value != null && (vclass = value.getClass()).isArray()) {
            ret = (EmbeddedAnno[])value;
            ret = (EmbeddedAnno[])ret.clone();
        }
        return ret;
    }

    public void setTitle(String value) {
        this.mResourceEntry.put(TITLE, value);
    }

    public void setDescription(String description) {
        this.mResourceEntry.put(DESCRIPTION, description);
    }

    public void setDueDate(String date) {
        this.mResourceEntry.put(DUEDATE, date);
    }

    public void setStatus(String value) {
        this.mResourceEntry.put(STATUS, value);
    }

    public void setPriority(String value) {
        this.mResourceEntry.put(PRIORITY, value);
    }

    public void setAssignedTo(String[] values) {
        this.mResourceEntry.put(ASSIGNEDTO, values);
    }

    public void setRequiredBy(String[] values) {
        this.mResourceEntry.put(REQUIREDBY, values);
    }

    public void setTargetVersion(String value) {
        this.mResourceEntry.put(TARGETVERSION, value);
    }

    public void setCategory(String value) {
        this.mResourceEntry.put(CATEGORY, value);
    }

    public void setComments(EmbeddedAnno[] values) {
        this.mResourceEntry.put(COMMENTS, values);
    }

    public void setKeywords(String[] values) {
        this.mResourceEntry.put(USERKEYWORDS, values);
    }
}

