#ifndef _KAYAAPI_H // -*-C++-*-
#define _KAYAAPI_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#ifndef WIN32
#include <pthread.h>
#define GC_THREADS
#else
#define GC_WIN32_THREADS
#endif
#include <gc/gc_cpp.h>
#include "VM.h"

class Value;
class Array;

typedef Value* KValue;
typedef Array* KArray;

// FIXME: Following two are deprecated, and kept for old code.
// Remove when all uses in the distribution are replaced.
typedef KValue KayaValue;
typedef KArray KayaArray;

typedef wchar_t KChar;
typedef wchar_t* KString;
typedef kint KInt;
typedef double KFloat;

/// String conversion macros
// char* to KString
#define KSTRING(x) strtowc(x)
#define KVSTRING(vm,x) strtovwc(vm,x)
// char to KChar
#define KCHAR(x) chrtowc(x)
// curses alt-chars to KChar
#define KACHAR(x) (wchar_t)x
// KString to char*
#define CSTRING(x) wctostr(x)
#define CNSTRING(x,i) wcntostr(x,i)
#define CNPSTRING(narrow,wide,len) char narrow[(len+1)*4]; wcnptostr(wide,len,narrow);
// KChar to char
#define CCHAR(x) wctochr(x)

// Following conversion macros are no-ops, but should be used in case
// the kaya representation changes.
#define KINT(x) (kint)x
#define CINT(x) (int)x
#define KFLOAT(x) x
#define CFLOAT(x) x


extern "C" {
    /// Make a new, uninitialised value.
    KValue newKayaValue();
    /// Make a new, empty array, with room for <size> elements.
    /// Give size 0 to let the rts choose the size.
    KArray newKayaArray(kint size);
  // same as above, but with the VM pointer supplied
    KArray newKayaArray2(void* vmptr, kint size);

    // Make new, initialised values.
    KValue KayaInt(KInt x);
    KValue KayaPtr(void* x);
    KValue KayaChar(KChar c);
    KValue KayaFloat(KFloat f);
    KValue KayaString(KString str);
    KValue KayaString2(VMState* vm);
    KValue KayaCharString(char* str);
    KValue KayaUnion(kint tag, kint args);
    KValue KayaArrayVal(KArray ar);

    // Query basic values
    KInt KayaGetInt(KValue v);
    KChar KayaGetChar(KValue v);
    KFloat KayaGetFloat(KValue v);
    KString KayaGetString(KValue v);
    KArray KayaGetArray(KValue v);

    // Set basic values
    void KayaSetInt(KValue v,KInt i);
    void KayaSetChar(KValue v,KChar c);
    void KayaSetFloat(KValue v,KFloat f);
    void KayaSetString(KValue v,KString s);
    void KayaSetCharString(KValue v,char* s);
    void KayaSetArray(KValue v,KArray a);

    // Array manipulation
    void KayaArrayPush(KArray a,KValue v);
    void KayaArraySet(KArray a, kint index, KValue v);
    KValue KayaArrayLookup(KArray a, kint index);
    kint KayaArraySize(KArray a);

    // Unions
    kint KayaUnionGetTag(KValue v);
    KValue KayaUnionGetArg(KValue v,kint i);
    void KayaUnionSetArg(KValue v,kint i,KValue val);

    // Callbacks
    KValue KayaCall(KValue fn, kint args, ...);

    // Allocate a garbage collected block of memory (uses libgc)
    void* KayaAlloc(kint size);

    // Handy function for combining an array into a bitmask.
    // The function <func> converts a kaya value (presumably a union) into a
    // C side bitmask; orArray iterates through the array ORing these values
    // together.
    kint orArray(KArray a, kint(*func)(KValue));

}



#endif
