// -*-C-*-ish

import Net;
import Posix;
import Sockets;
import Webapp;
import WebCommon;
import Crypto;
import HTMLDocument;
import SCGI;
import IO;

default Void webconfig() {}

default SCGI scgiconfig() = SCGI(7597,2,2,4,10,100,10);

Void __panic(String err, Int code)
{
  /*  putStrLn("Status: 500 Internal Server Error");
  putStrLn("Content-type: text/plain; charset=UTF-8");
  putStrLn("Cache-control: no-cache,private");
  putStrLn("");*/
  put(stderr,"Kaya panic: "+err+" ("+code+")");
}

Void __start() {
    Prelude::gcIncremental();
    try {
      sconf = module::scgiconfig();
      __loop(sconf);
    } catch(err) {
      put(stderr,exceptionMessage(err));
    }
}

Void __loop(SCGI config) {
  lsock = listen(TCP,config.port,config.maxbacklog);
  children = createArray(config.maxservers);
  for x in [0..config.maxservers-1] {
    children[x] = nothing;
  }
  do {
    try {
      // check if there are enough spare servers up to the limit
      if (numSpareServers(children) < config.minspareservers) {
	// // start some more
	case firstEmptySlot(children) of {
	  nothing -> ; // can't start anything
	  | just(slot) -> ; // can start something
	  comm = socketPair;
	  oob = socketPair;
	  pid = fork();
	  if (pid == 0) {
	    // child process
	    closeSocket(lsock);
	    close(comm.snd);
	    close(oob.snd);
	    for child in children {
	      case child of {
		nothing -> ;
		|just(cproc) -> case cproc.client of {
		  nothing -> ;
		  // forked one mustn't hang on to these!
		  |just(client) -> closeConnection(client);
		}
	      }
	    }
	    __forked(config,comm.fst,oob.fst);
	    close(oob.fst);
	    close(comm.fst);
	    return;
	  } else {
	    close(comm.fst);
	    close(oob.fst);
	    children[slot] = just(ChildProcess(comm.snd,oob.snd,nothing,config.maxchildpages));
	  }
	}
      }

      if (pid != 0) { // only in the superserver
	// check if there are too many spare servers
	if (numSpareServers(children) > config.maxspareservers) {
	  // // send oobkills
	  case firstSpareSlot(children) of {
	    nothing -> ; // shouldn't happen
	    | just(slot) -> cproc = deref(children[slot]);
	    // send kill to child process, 
	    send(cproc.oobsock,"KILL");
	    // close sockets
	    close(cproc.oobsock);
	    close(cproc.cgisock);
	    // set slot to nothing
	    children[slot] = nothing;
	  }
	}
	// if any spare servers, check if anything is pending on listen()
	case firstSpareSlot(children) of {
	  nothing -> ; // can't accept any more for now
	  // // accept() and pass it on to a spare server
	  | just(slot) -> cproc = deref(children[slot]);
	  if (pending(cproc.oobsock,1)) {
	    if (recv(cproc.oobsock,4,10) == "DEAD") {
	      close(cproc.oobsock);
	      close(cproc.cgisock);
	      // set slot to nothing
	      children[slot] = nothing;
	    }
	  } else if (connWaiting(lsock)) {
	    // check for pending, accept, set inuse, send data
	    client = accept(lsock);
	    cproc.client = just(client);
	    send(cproc.oobsock,"OKAY");
	    netToSocket(deref(cproc.client),cproc.cgisock);
	  }
	}
	// check if anything is pending and ready on oobs
	for child@slot in children {
	  case child of {
	    nothing -> ;
	    | just(cproc) -> case cproc.client of {
	      nothing -> ;
	      | just(client) -> if (pending(cproc.oobsock,10)) {
		// // throw back the written data to the accept()ed and close, unset inuse
		okay = recv(cproc.oobsock,4);
		if (okay != "DONE") {
		  put(stderr,"Received: "+okay+" rather than DONE\n");
		}
		if (pending(cproc.cgisock,10)) {
		  socketToNet(cproc.cgisock,client);
		}
		closeConnection(client);
		cproc.client = nothing;
		cproc.remaining--;
		if (cproc.remaining < 1) {
		  send(cproc.oobsock,"KILL");
		  // close sockets
		  close(cproc.oobsock);
		  close(cproc.cgisock);
		  // set slot to nothing
		  children[slot] = nothing;
		}
	      } else if (pending(cproc.cgisock,10)) {
		// just shift what we have
		socketToNet(cproc.cgisock,client);
		// and we'll clean up next time round
	      }
	    }
	  }
	}
      }
      reap();
      microSleep(100);
    } catch(e) { // shouldn't be a wildcard
      exceptionBacktrace(e);
    }
  } while (true);
}

Void __forked(SCGI config, Socket comm, Socket oob) {
  module::webconfig();
  /*** remaining should be handled by main server
       as otherwise there's a race condition that comes up rather a lot
  ***/

  do {
    command = recv(oob,4,-1);
    if (command == "KILL") {
      send(oob,"DEAD");
      return;
    } else if (command == "OKAY") {
      try {
	SCGI::initEnv(comm);
	// initWebApp needs to be able to read POST from socket rather than stdin
	WebCommon::initWebApp("",SCGI::scgiEnv,SCGI::nextChar@(comm),SCGI::finishedInput@(comm));
	scgiPage(comm,module::webmain());
      } catch(e) {
	if (!Webapp::headersSent) {
	  send(comm,"Status: 500 Internal Server Error\r\n");
	  send(comm,"Content-type: text/plain; charset=UTF-8\r\n");
	  send(comm,"Cache-control: no-cache,private\r\n");
	  send(comm,"\r\n");
	}
	send(comm,"An error has occurred.\r\n");     
      }
      removeTemporaryUploaded(); 
      // try to garbage collect as much memory as possible
      // before taking on a new request
      old = gcSetFSD(20); gc(); void(gcSetFSD(old));
    }
    send(oob,"DONE");
  } while(true);
}
