.TH "HDAPSD" 8 "__DATE__" "hdapsd __VERSION__" "hdapsd"
.SH NAME
hdapsd \- park the drive in case of an emergency
.SH SYNOPSIS
.B hdapsd \fR[\fI\-f\fR|\fI\-r\fR|\fI\-c <cfgfile>\fR|\fI\-d <device>\fR|\fI\-s <sensitivity>\fR|\fI\-a\fR|\fI\-v\fR|\fI\-b\fR|\fI\-p\fR|\fI\-t\fR|\fI\-y\fR|\fI\-H\fR|\fI\-S\fR|\fI\-L\fR|\fI\-l\fR|\fI\-V\fR|\fI\-h\fR]
.SH OPTIONS
.TP
\fB\-c\fR \fB\-\-cfgfile=\fR\fI<cfgfile>\fR
Load configuration from <cfgfile>. Only available if hdapsd was compiled with libconfig support.
.TP
\fB\-d\fR \fB\-\-device=\fR\fI<device>\fR
<device> is likely to be hda or sda. Can be given multiple times to protect multiple devices.
.TP
\fB\-f\fR \fB\-\-force\fR
Force unloading heads, even if kernel thinks different (on pre ATA7 drives).
This only works when adding devices by hand (\-d).
.TP
\fB\-r\fR \fB\-\-force\-rotational\fR
Autodetect drives as rotational, even if kernel thinks they are not.
.TP
\fB\-s\fR \fB\-\-sensitivity=\fR\fI<sensitivity>\fR
How sensitive hdapsd should be to movements.
Defaults to 15, higher values mean less sensitive.
.TP
\fB\-a\fR \fB\-\-adaptive\fR
Adaptive threshold (automatic increase when the built\-in keyboard/mouse are used).
.TP
\fB\-v\fR \fB\-\-verbose\fR
Get verbose statistics.
.TP
\fB\-b\fR \fB\-\-background\fR
Run the process in the background.
.TP
\fB\-p\fR \fB\-\-pidfile\fR[\fI=<pidfile>\fR]
Create a pid file when running in background.
If <pidfile> is not specified, it's set to /var/run/hdapsd.pid.
.TP
\fB\-t\fR \fB\-\-dry\-run\fR
Don't actually park the drive.
.TP
\fB\-y\fR \fB\-\-poll\-sysfs\fR
Force use of sysfs interface to accelerometer.
.TP
\fB\-H\fR \fB\-\-hardware\-logic\fR
Uses the hardware fall detection logic instead of the software
one. Options \-\-sensitivity and \-\-adaptive have no effect
in this mode.
.TP
\fB\-S\fR \fB\-\-software\-logic\fR
Uses the software fall detection logic even if the hardware one is
available.
.TP
\fB\-L\fR \fB\-\-no\-leds\fR
Don't blink the LEDs when a shock is detected.
.TP
\fB\-l\fR \fB\-\-syslog\fR
Log to syslog instead of stdout/stderr.
.TP
\fB\-V\fR \fB\-\-version\fR
Display version information and exit.
.TP
\fB\-h\fR \fB\-\-help\fR
Display help and exit.

.PP
You can send SIGUSR1 to deactivate hdapsd for 8 seconds.
