// generated by tube_transfer.py
// tube: 6L6CG
// plate current function: pentode
// mu: 8.7
// kx: 1.35
// kg1: 1460
// kg2: 4500
// kp: 48
// kvb: 12
// Uin_min: -21
// Uin_max: 21
// Vp: 450
// Rp: 5000

table1d_imp<2001> tubetable_6L6CG[2] __rt_data = {
	{ // Ri = 68k
	-21,21,47.619,2001, {
	250.851854386,250.727213665,250.602546401,250.477852608,250.3531323,
	250.228385489,250.10361219,249.978812416,249.85398618,249.729133497,
	249.60425438,249.479348843,249.354416898,249.22945856,249.104473843,
	248.97946276,248.854425324,248.72936155,248.604271452,248.479155042,
	248.354012334,248.228843343,248.103648082,247.978426565,247.853178806,
	247.727904818,247.602604615,247.477278212,247.351925621,247.226546857,
	247.101141933,246.975710864,246.850253663,246.724770344,246.599260922,
	246.473725409,246.34816382,246.222576169,246.09696247,245.971322737,
	245.845656983,245.719965223,245.594247471,245.468503741,245.342734046,
	245.216938401,245.09111682,244.965269317,244.839395906,244.713496602,
	244.587571417,244.461620367,244.335643466,244.209640727,244.083612165,
	243.957557794,243.831477628,243.705371682,243.579239969,243.453082505,
	243.326899302,243.200690377,243.074455741,242.948195411,242.8219094,
	242.695597723,242.569260394,242.442897427,242.316508838,242.190094639,
	242.063654846,241.937189472,241.810698534,241.684182044,241.557640017,
	241.431072468,241.304479412,241.177860862,241.051216834,240.924547342,
	240.7978524,240.671132023,240.544386226,240.417615023,240.290818429,
	240.163996458,240.037149126,239.910276446,239.783378434,239.656455104,
	239.529506471,239.40253255,239.275533355,239.148508902,239.021459204,
	238.894384278,238.767284137,238.640158796,238.513008271,238.385832576,
	238.258631726,238.131405736,238.004154621,237.876878396,237.749577076,
	237.622250676,237.494899211,237.367522695,237.240121144,237.112694574,
	236.985242998,236.857766432,236.730264892,236.602738392,236.475186947,
	236.347610573,236.220009285,236.092383097,235.964732026,235.837056087,
	235.709355294,235.581629663,235.453879209,235.326103948,235.198303895,
	235.070479065,234.942629473,234.814755136,234.686856068,234.558932285,
	234.430983802,234.303010635,234.175012799,234.04699031,233.918943183,
	233.790871434,233.662775078,233.534654131,233.406508609,233.278338526,
	233.1501439,233.021924745,232.893681077,232.765412913,232.637120266,
	232.508803154,232.380461592,232.252095596,232.123705182,231.995290365,
	231.866851162,231.738387587,231.609899658,231.48138739,231.352850799,
	231.224289901,231.095704712,230.967095248,230.838461524,230.709803558,
	230.581121365,230.45241496,230.323684361,230.194929584,230.066150644,
	229.937347557,229.808520341,229.67966901,229.550793582,229.421894073,
	229.292970498,229.164022875,229.035051219,228.906055547,228.777035876,
	228.647992221,228.518924599,228.389833027,228.260717521,228.131578097,
	228.002414773,227.873227564,227.744016487,227.614781559,227.485522796,
	227.356240215,227.226933833,227.097603666,226.968249732,226.838872046,
	226.709470626,226.580045488,226.450596649,226.321124126,226.191627936,
	226.062108095,225.932564622,225.802997531,225.673406842,225.54379257,
	225.414154732,225.284493346,225.154808428,225.025099996,224.895368067,
	224.765612658,224.635833786,224.506031468,224.376205721,224.246356563,
	224.116484012,223.986588083,223.856668795,223.726726165,223.59676021,
	223.466770948,223.336758396,223.206722572,223.076663492,222.946581175,
	222.816475639,222.686346899,222.556194975,222.426019884,222.295821643,
	222.165600271,222.035355784,221.905088201,221.774797539,221.644483816,
	221.51414705,221.383787259,221.25340446,221.122998671,220.992569911,
	220.862118198,220.731643548,220.601145981,220.470625515,220.340082166,
	220.209515954,220.078926897,219.948315013,219.817680319,219.687022835,
	219.556342577,219.425639566,219.294913818,219.164165353,219.033394188,
	218.902600343,218.771783834,218.640944682,218.510082904,218.379198518,
	218.248291544,218.117362,217.986409905,217.855435276,217.724438134,
	217.593418496,217.462376381,217.331311808,217.200224796,217.069115363,
	216.937983529,216.806829312,216.675652731,216.544453805,216.413232554,
	216.281988995,216.150723149,216.019435034,215.888124669,215.756792073,
	215.625437266,215.494060267,215.362661095,215.231239769,215.099796308,
	214.968330733,214.836843062,214.705333314,214.573801509,214.442247667,
	214.310671807,214.179073949,214.047454111,213.915812314,213.784148578,
	213.652462921,213.520755364,213.389025927,213.257274629,213.125501489,
	212.993706529,212.861889766,212.730051223,212.598190918,212.466308871,
	212.334405103,212.202479634,212.070532482,211.93856367,211.806573216,
	211.674561142,211.542527466,211.41047221,211.278395394,211.146297038,
	211.014177162,210.882035787,210.749872934,210.617688622,210.485482872,
	210.353255705,210.221007142,210.088737202,209.956445907,209.824133278,
	209.691799334,209.559444097,209.427067588,209.294669827,209.162250836,
	209.029810634,208.897349244,208.764866686,208.632362982,208.499838151,
	208.367292216,208.234725197,208.102137116,207.969527994,207.836897852,
	207.704246712,207.571574594,207.438881521,207.306167513,207.173432592,
	207.040676779,206.907900097,206.775102566,206.642284209,206.509445046,
	206.3765851,206.243704392,206.110802944,205.977880778,205.844937916,
	205.71197438,205.578990191,205.445985371,205.312959943,205.179913929,
	205.04684735,204.913760229,204.780652588,204.64752445,204.514375836,
	204.381206768,204.24801727,204.114807363,203.98157707,203.848326414,
	203.715055417,203.581764101,203.448452489,203.315120604,203.181768468,
	203.048396104,202.915003536,202.781590785,202.648157874,202.514704827,
	202.381231667,202.247738415,202.114225097,201.980691733,201.847138349,
	201.713564966,201.579971608,201.446358299,201.31272506,201.179071917,
	201.045398892,200.911706009,200.777993291,200.644260761,200.510508444,
	200.376736363,200.242944541,200.109133002,199.975301771,199.84145087,
	199.707580323,199.573690155,199.43978039,199.305851051,199.171902162,
	199.037933748,198.903945832,198.769938439,198.635911593,198.501865318,
	198.367799639,198.233714579,198.099610164,197.965486418,197.831343365,
	197.697181029,197.562999436,197.42879861,197.294578575,197.160339357,
	197.02608098,196.891803469,196.757506849,196.623191145,196.488856381,
	196.354502584,196.220129777,196.085737987,195.951327237,195.816897554,
	195.682448963,195.547981489,195.413495157,195.278989993,195.144466022,
	195.00992327,194.875361763,194.740781525,194.606182584,194.471564964,
	194.336928691,194.202273791,194.06760029,193.932908214,193.798197588,
	193.66346844,193.528720795,193.393954679,193.259170118,193.124367138,
	192.989545767,192.85470603,192.719847953,192.584971564,192.450076888,
	192.315163953,192.180232784,192.045283408,191.910315853,191.775330145,
	191.64032631,191.505304376,191.37026437,191.235206318,191.100130248,
	190.965036187,190.829924162,190.6947942,190.559646328,190.424480574,
	190.289296965,190.154095528,190.018876292,189.883639283,189.748384529,
	189.613112058,189.477821897,189.342514075,189.207188619,189.071845557,
	188.936484916,188.801106726,188.665711014,188.530297807,188.394867135,
	188.259419026,188.123953507,187.988470607,187.852970354,187.717452778,
	187.581917906,187.446365767,187.310796389,187.175209802,187.039606034,
	186.903985114,186.76834707,186.632691932,186.497019729,186.361330489,
	186.225624242,186.089901017,185.954160843,185.818403749,185.682629765,
	185.546838921,185.411031245,185.275206767,185.139365516,185.003507523,
	184.867632817,184.731741428,184.595833385,184.459908719,184.323967459,
	184.188009636,184.052035279,183.916044419,183.780037085,183.644013309,
	183.50797312,183.371916549,183.235843626,183.099754382,182.963648847,
	182.827527052,182.691389027,182.555234804,182.419064414,182.282877886,
	182.146675252,182.010456543,181.874221791,181.737971025,181.601704279,
	181.465421581,181.329122965,181.192808462,181.056478102,180.920131918,
	180.783769941,180.647392202,180.510998734,180.374589568,180.238164737,
	180.101724271,179.965268203,179.828796566,179.69230939,179.555806709,
	179.419288555,179.28275496,179.146205956,179.009641575,178.873061851,
	178.736466816,178.599856503,178.463230944,178.326590172,178.18993422,
	178.053263121,177.916576908,177.779875614,177.643159272,177.506427915,
	177.369681577,177.232920291,177.09614409,176.959353008,176.822547079,
	176.685726336,176.548890812,176.412040542,176.27517556,176.138295898,
	176.001401592,175.864492675,175.727569182,175.590631146,175.453678602,
	175.316711585,175.179730128,175.042734266,174.905724034,174.768699466,
	174.631660597,174.494607462,174.357540095,174.220458532,174.083362807,
	173.946252956,173.809129014,173.671991016,173.534838996,173.397672991,
	173.260493037,173.123299167,172.986091419,172.848869828,172.711634428,
	172.574385257,172.437122351,172.299845744,172.162555473,172.025251575,
	171.887934084,171.750603039,171.613258474,171.475900427,171.338528933,
	171.20114403,171.063745754,170.926334142,170.78890923,170.651471056,
	170.514019656,170.376555067,170.239077327,170.101586472,169.96408254,
	169.826565569,169.689035595,169.551492656,169.41393679,169.276368034,
	169.138786426,169.001192004,168.863584806,168.72596487,168.588332233,
	168.450686934,168.313029011,168.175358503,168.037675447,167.899979882,
	167.762271847,167.624551381,167.486818521,167.349073307,167.211315778,
	167.073545972,166.935763929,166.797969687,166.660163286,166.522344765,
	166.384514164,166.246671521,166.108816877,165.97095027,165.833071742,
	165.69518133,165.557279076,165.419365018,165.281439198,165.143501655,
	165.00555243,164.867591562,164.729619092,164.59163506,164.453639507,
	164.315632474,164.177614001,164.039584129,163.901542898,163.763490351,
	163.625426527,163.487351468,163.349265215,163.211167809,163.073059292,
	162.934939705,162.79680909,162.658667488,162.520514942,162.382351492,
	162.244177181,162.10599205,161.967796143,161.8295895,161.691372165,
	161.553144179,161.414905585,161.276656426,161.138396744,161.000126581,
	160.861845981,160.723554986,160.58525364,160.446941985,160.308620065,
	160.170287922,160.031945601,159.893593144,159.755230595,159.616857998,
	159.478475396,159.340082833,159.201680353,159.063268,158.924845818,
	158.786413851,158.647972143,158.509520739,158.371059684,158.23258902,
	158.094108794,157.95561905,157.817119832,157.678611187,157.540093157,
	157.40156579,157.263029129,157.12448322,156.985928109,156.84736384,
	156.70879046,156.570208015,156.431616549,156.293016109,156.15440674,
	156.015788489,155.877161402,155.738525525,155.599880904,155.461227586,
	155.322565617,155.183895044,155.045215914,154.906528273,154.767832168,
	154.629127647,154.490414756,154.351693543,154.212964054,154.074226338,
	153.935480442,153.796726413,153.657964299,153.519194148,153.380416008,
	153.241629927,153.102835953,152.964034133,152.825224517,152.686407153,
	152.547582089,152.408749374,152.269909057,152.131061185,151.99220581,
	151.853342978,151.71447274,151.575595145,151.436710241,151.297818079,
	151.158918708,151.020012178,150.881098537,150.742177837,150.603250127,
	150.464315457,150.325373877,150.186425438,150.047470189,149.908508182,
	149.769539467,149.630564094,149.491582115,149.35259358,149.21359854,
	149.074597047,148.935589151,148.796574904,148.657554357,148.518527562,
	148.379494571,148.240455434,148.101410205,147.962358935,147.823301676,
	147.684238481,147.545169401,147.406094489,147.267013797,147.127927379,
	146.988835286,146.849737572,146.71063429,146.571525493,146.432411233,
	146.293291565,146.154166541,146.015036215,145.875900641,145.736759873,
	145.597613963,145.458462967,145.319306939,145.180145932,145.04098,
	144.901809199,144.762633583,144.623453206,144.484268123,144.34507839,
	144.20588406,144.06668519,143.927481833,143.788274047,143.649061886,
	143.509845405,143.370624661,143.231399709,143.092170605,142.952937405,
	142.813700166,142.674458943,142.535213793,142.395964772,142.256711938,
	142.117455346,141.978195055,141.83893112,141.699663598,141.560392548,
	141.421118026,141.28184009,141.142558798,141.003274207,140.863986374,
	140.724695359,140.585401218,140.446104011,140.306803796,140.16750063,
	140.028194573,139.888885684,139.74957402,139.610259641,139.470942607,
	139.331622976,139.192300807,139.05297616,138.913649096,138.774319672,
	138.634987949,138.495653988,138.356317848,138.216979589,138.077639272,
	137.938296957,137.798952704,137.659606576,137.520258631,137.380908932,
	137.241557539,137.102204514,136.962849918,136.823493812,136.684136258,
	136.544777319,136.405417055,136.266055529,136.126692803,135.987328939,
	135.847964,135.708598048,135.569231146,135.429863356,135.290494743,
	135.151125368,135.011755296,134.872384589,134.733013311,134.593641526,
	134.454269297,134.314896689,134.175523765,134.03615059,133.896777228,
	133.757403743,133.618030201,133.478656667,133.339283204,133.199909879,
	133.060536757,132.921163903,132.781791383,132.642419262,132.503047608,
	132.363676485,132.224305961,132.084936102,131.945566975,131.806198648,
	131.666831187,131.527464661,131.388099138,131.248734685,131.109371373,
	130.970009269,130.830648444,130.691288969,130.551930914,130.41257435,
	130.273219351,130.133865989,129.994514339,129.855164477,129.71581648,
	129.576470426,129.437126396,129.297784474,129.158444743,129.019107294,
	128.879772217,128.74043961,128.601109572,128.46178221,128.322457637,
	128.183135974,128.043817351,127.904501909,127.7651898,127.625881192,
	127.486576271,127.347275241,127.207978331,127.068685798,126.929397933,
	126.790115064,126.650837565,126.511565864,126.372300451,126.23304189,
	126.093790834,125.954548036,125.815314369,125.67609085,125.536878659,
	125.397679174,125.258494001,125.119325017,124.980174416,124.841044764,
	124.701939066,124.56286084,124.423814207,124.284803996,124.145835867,
	124.00691645,123.868053516,123.729256168,123.590535067,123.451902691,
	123.313373641,123.174964984,123.036696658,122.898591922,122.760677882,
	122.622986073,122.485553116,122.348421452,122.211640134,122.075265695,
	121.939363062,121.804006501,121.669280563,121.535280987,121.402115498,
	121.26990444,121.138781133,121.008891876,120.880395478,120.7534622,
	120.628272046,120.505012318,120.38387444,120.265050114,120.148726933,
	120.035083669,119.924285514,119.81647958,119.711790975,119.610319733,
	119.512138789,119.417293101,119.325799912,119.237650035,119.152809993,
	119.071224771,118.992820955,118.91751003,118.845191646,118.775756699,
	118.709090141,118.645073439,118.583586674,118.524510274,118.467726405,
	118.413120053,118.360579831,118.309998558,118.261273641,118.214307302,
	118.169006685,118.125283855,118.08305573,118.042243961,118.002774761,
	117.96457872,117.927590599,117.891749108,117.856996693,117.823279316,
	117.790546242,117.758749831,117.727845344,117.69779075,117.668546553,
	117.640075617,117.612343013,117.58531587,117.558963236,117.533255946,
	117.508166509,117.483668991,117.459738909,117.436353141,117.413489833,
	117.391128314,117.369249023,117.347833433,117.326863989,117.306324042,
	117.286197796,117.266470251,117.247127157,117.228154966,117.209540788,
	117.191272357,117.173337986,117.155726539,117.138427399,117.121430431,
	117.104725963,117.088304755,117.072157976,117.056277181,117.04065429,
	117.025281568,117.010151607,116.995257309,116.980591868,116.966148756,
	116.951921707,116.937904708,116.924091981,116.910477974,116.89705735,
	116.883824974,116.870775906,116.857905392,116.845208851,116.832681871,
	116.8203202,116.808119738,116.79607653,116.78418676,116.772446744,
	116.760852927,116.749401871,116.738090257,116.726914875,116.715872624,
	116.7049605,116.6941756,116.683515113,116.672976316,116.662556574,
	116.652253333,116.642064119,116.631986532,116.622018246,116.612157005,
	116.602400619,116.592746966,116.583193981,116.573739664,116.564382069,
	116.555119308,116.545949544,116.536870993,116.52788192,116.518980639,
	116.510165509,116.501434933,116.492787357,116.48422127,116.4757352,
	116.467327714,116.458997414,116.450742942,116.442562972,116.434456212,
	116.426421403,116.418457318,116.41056276,116.402736561,116.394977582,
	116.387284713,116.379656867,116.372092988,116.364592041,116.357153016,
	116.349774929,116.342456817,116.33519774,116.327996777,116.320853032,
	116.313765626,116.306733702,116.299756419,116.292832958,116.285962517,
	116.279144309,116.272377567,116.26566154,116.258995492,116.252378704,
	116.24581047,116.2392901,116.232816919,116.226390266,116.220009492,
	116.213673962,116.207383055,116.201136161,116.194932683,116.188772035,
	116.182653644,116.176576947,116.170541393,116.16454644,116.158591559,
	116.152676229,116.14679994,116.14096219,116.13516249,116.129400356,
	116.123675316,116.117986905,116.112334668,116.106718157,116.101136932,
	116.095590563,116.090078625,116.084600703,116.079156388,116.073745277,
	116.068366978,116.063021102,116.057707269,116.052425103,116.047174239,
	116.041954313,116.036764971,116.031605862,116.026476645,116.02137698,
	116.016306537,116.011264987,116.00625201,116.00126729,115.996310516,
	115.991381382,115.986479588,115.981604836,115.976756837,115.971935302,
	115.967139951,115.962370504,115.957626689,115.952908237,115.948214882,
	115.943546364,115.938902425,115.934282814,115.929687279,115.925115577,
	115.920567465,115.916042706,115.911541064,115.907062309,115.902606213,
	115.898172552,115.893761104,115.889371653,115.885003982,115.880657881,
	115.876333141,115.872029556,115.867746924,115.863485045,115.859243722,
	115.855022761,115.85082197,115.84664116,115.842480146,115.838338743,
	115.83421677,115.83011405,115.826030404,115.82196566,115.817919646,
	115.813892193,115.809883134,115.805892304,115.80191954,115.797964683,
	115.794027573,115.790108055,115.786205974,115.782321178,115.778453516,
	115.774602842,115.770769007,115.766951868,115.763151282,115.759367108,
	115.755599207,115.751847441,115.748111674,115.744391773,115.740687606,
	115.736999041,115.73332595,115.729668205,115.72602568,115.722398251,
	115.718785795,115.71518819,115.711605316,115.708037055,115.70448329,
	115.700943904,115.697418784,115.693907817,115.690410891,115.686927894,
	115.68345872,115.680003258,115.676561404,115.673133051,115.669718096,
	115.666316434,115.662927966,115.659552589,115.656190205,115.652840714,
	115.649504021,115.646180028,115.64286864,115.639569764,115.636283306,
	115.633009175,115.629747278,115.626497528,115.623259833,115.620034107,
	115.616820261,115.613618211,115.610427871,115.607249156,115.604081983,
	115.60092627,115.597781935,115.594648896,115.591527075,115.588416392,
	115.585316768,115.582228127,115.579150392,115.576083486,115.573027335,
	115.569981864,115.566947001,115.563922671,115.560908803,115.557905326,
	115.554912169,115.551929263,115.548956537,115.545993924,115.543041355,
	115.540098764,115.537166085,115.53424325,115.531330196,115.528426857,
	115.52553317,115.522649071,115.519774498,115.516909389,115.514053683,
	115.511207317,115.508370233,115.505542371,115.50272367,115.499914074,
	115.497113523,115.494321961,115.49153933,115.488765574,115.486000638,
	115.483244465,115.480497002,115.477758193,115.475027985,115.472306325,
	115.46959316,115.466888437,115.464192105,115.461504112,115.458824408,
	115.456152941,115.453489663,115.450834523,115.448187472,115.445548462,
	115.442917445,115.440294372,115.437679196,115.435071871,115.43247235,
	115.429880586,115.427296534,115.424720149,115.422151386,115.4195902,
	115.417036547,115.414490383,115.411951665,115.40942035,115.406896395,
	115.404379759,115.401870398,115.399368272,115.396873339,115.394385559,
	115.39190489,115.389431294,115.386964729,115.384505157,115.382052538,
	115.379606833,115.377168005,115.374736014,115.372310823,115.369892394,
	115.36748069,115.365075674,115.362677309,115.36028556,115.357900389,
	115.355521762,115.353149642,115.350783995,115.348424785,115.346071978,
	115.34372554,115.341385437,115.339051634,115.336724098,115.334402796,
	115.332087695,115.329778762,115.327475964,115.32517927,115.322888648,
	115.320604065,115.31832549,115.316052892,115.31378624,115.311525503,
	115.30927065,115.307021652,115.304778478,115.302541099,115.300309484,
	115.298083604,115.295863431,115.293648935,115.291440088,115.289236861,
	115.287039226,115.284847154,115.282660618,115.28047959,115.278304043,
	115.27613395,115.273969283,115.271810015,115.26965612,115.267507572,
	115.265364344,115.26322641,115.261093745,115.258966322,115.256844115,
	115.254727101,115.252615253,115.250508547,115.248406958,115.246310461,
	115.244219031,115.242132646,115.240051279,115.237974909,115.23590351,
	115.23383706,115.231775534,115.22971891,115.227667164,115.225620275,
	115.223578218,115.221540971,115.219508512,115.217480819,115.21545787,
	115.213439641,115.211426113,115.209417262,115.207413068,115.205413509,
	115.203418564,115.201428212,115.199442432,115.197461202,115.195484503,
	115.193512314,115.191544614,115.189581384,115.187622603,115.185668251,
	115.183718308,115.181772755,115.179831572,115.177894739,115.175962238,
	115.174034049,115.172110153,115.170190531,115.168275164,115.166364034,
	115.164457122,115.162554409,115.160655878,115.15876151,115.156871287,
	115.154985191,115.153103204,115.151225308,115.149351486,115.147481721,
	115.145615994,115.143754289,115.141896588,115.140042875,115.138193132,
	115.136347342,115.13450549,115.132667557,115.130833528,115.129003386,
	115.127177115,115.125354699,115.123536121,115.121721365,115.119910417,
	115.118103258,115.116299875,115.114500251,115.112704371,115.110912219,
	115.109123781,115.10733904,115.105557981,115.10378059,115.102006852,
	115.100236752,115.098470274,115.096707405,115.094948129,115.093192432,
	115.0914403,115.089691718,115.087946672,115.086205148,115.084467132,
	115.08273261,115.081001567,115.07927399,115.077549866,115.07582918,
	115.074111919,115.072398069,115.070687617,115.06898055,115.067276855,
	115.065576517,115.063879524,115.062185864,115.060495522,115.058808486,
	115.057124744,115.055444282,115.053767088,115.052093149,115.050422453,
	115.048754986,115.047090738,115.045429696,115.043771846,115.042117178,
	115.040465678,115.038817336,115.037172139,115.035530074,115.033891131,
	115.032255297,115.030622561,115.028992911,115.027366336,115.025742824,
	115.024122363,115.022504943,115.020890551,115.019279177,115.01767081,
	115.016065437,115.01446305,115.012863635,115.011267182,115.009673681,
	115.008083121,115.00649549,115.004910779,115.003328976,115.001750071,
	115.000174053,114.998600912,114.997030637,114.995463219,114.993898646,
	114.992336909,114.990777997,114.9892219,114.987668608,114.986118112,
	114.9845704,114.983025464,114.981483292,114.979943877,114.978407206,
	114.976873272,114.975342064,114.973813573,114.972287788,114.970764702,
	114.969244303,114.967726583,114.966211533,114.964699142,114.963189402,
	114.961682304,114.960177837,114.958675995,114.957176766,114.955680142,
	114.954186114,114.952694674,114.951205812,114.949719519,114.948235787,
	114.946754607,114.945275969,114.943799867,114.94232629,114.94085523,
	114.939386679,114.937920629,114.93645707,114.934995994,114.933537394,
	114.93208126,114.930627585,114.92917636,114.927727576,114.926281227,
	114.924837303,114.923395797,114.9219567,114.920520005,114.919085703,
	114.917653788,114.91622425,114.914797082,114.913372276,114.911949824,
	114.910529719,114.909111954,114.907696519,114.906283408,114.904872614,
	114.903464128,114.902057943,114.900654051,114.899252446,114.89785312,
	114.896456065,114.895061274,114.89366874,114.892278456,114.890890414,
	114.889504608,114.888121029,114.886739671,114.885360527,114.88398359,
	114.882608853,114.881236308,114.879865949,114.878497769,114.877131762,
	114.875767919,114.874406235,114.873046702,114.871689315,114.870334065,
	114.868980947,114.867629953,114.866281078,114.864934314,114.863589656,
	114.862247095,114.860906627,114.859568244,114.85823194,114.856897709,
	114.855565544,114.854235439,114.852907387,114.851581383,114.850257419,
	114.84893549,114.84761559,114.846297712,114.84498185,114.843667998,
	114.842356151,114.841046301,114.839738443,114.83843257,114.837128678,
	114.835826759,114.834526808,114.833228819,114.831932787,114.830638704,
	114.829346566,114.828056367,114.8267681,114.825481761,114.824197342,
	114.82291484,114.821634247,114.820355559,114.819078769,114.817803873,
	114.816530864,114.815259737,114.813990487,114.812723107,114.811457593,
	114.810193938,114.808932139,114.807672188,114.806414081,114.805157813,
	114.803903378,114.80265077,114.801399985,114.800151017,114.798903861,
	114.797658512,114.796414964,114.795173212,114.793933252,114.792695077,
	114.791458684,114.790224066,114.78899122,114.787760138,114.786530818,
	114.785303253,114.784077439,114.782853371,114.781631043,114.780410451,
	114.779191591,114.777974456,114.776759042,114.775545345,114.77433336,
	114.773123081,114.771914504,114.770707625,114.769502438,114.768298938,
	114.767097122,114.765896984,114.76469852,114.763501725,114.762306595,
	114.761113124,114.759921309,114.758731144,114.757542626,114.756355749,
	114.755170509,114.753986902,114.752804923,114.751624568,114.750445832,
	114.749268712,114.748093201,114.746919297,114.745746994,114.744576289,
	114.743407177,114.742239653,114.741073714,114.739909356,114.738746573,
	114.737585362,114.736425718,114.735267638,114.734111116,114.73295615,
	114.731802734,114.730650865,114.729500538,114.72835175,114.727204496,
	114.726058772,114.724914574,114.723771898,114.722630741,114.721491097,
	114.720352964,114.719216336,114.718081211,114.716947584,114.715815451,
	114.714684808,114.713555652,114.712427979,114.711301784,114.710177064,
	114.709053815,114.707932032,114.706811714,114.705692855,114.704575451,
	114.7034595,114.702344997,114.701231938,114.70012032,114.699010139,
	114.697901392,114.696794074,114.695688182,114.694583713,114.693480662,
	114.692379026,114.691278802,114.690179986,114.689082574,114.687986563,
	114.686891949,114.685798728,114.684706898,114.683616455,114.682527394,
	114.681439713,114.680353408,114.679268476,114.678184913,114.677102716,
	114.676021881,114.674942405,114.673864285,114.672787517,114.671712098,
	114.670638024,114.669565292,114.668493899,114.667423841,114.666355115,
	114.665287718,114.664221647,114.663156898,114.662093468,114.661031354,
	114.659970552,114.658911059,114.657852873,114.656795989,114.655740405,
	114.654686117,114.653633123,114.652581419,114.651531002,114.650481869,
	114.649434016,114.648387441,114.647342141,114.646298112,114.645255352,
	114.644213857,114.643173624,114.64213465,114.641096933,114.640060469,
	114.639025254,114.637991287,114.636958565,114.635927083,114.634896839,
	114.633867831,114.632840055,114.631813509,114.630788189,114.629764092,
	114.628741216,114.627719558,114.626699115,114.625679883,114.624661861,
	114.623645045,114.622629432,114.62161502,114.620601806,114.619589787,
	114.61857896,114.617569322,114.61656087,114.615553603,114.614547516,
	114.613542608,114.612538875,114.611536315,114.610534925,114.609534703,
	114.608535645,114.607537749,114.606541012,114.605545432,114.604551005,
	114.60355773,114.602565604,114.601574623,114.600584786,114.599596089,
	114.59860853,114.597622107,114.596636817,114.595652657,114.594669625,
	114.593687717,114.592706933,114.591727268,114.590748721,114.589771288,
	114.588794968,114.587819758,114.586845655,114.585872658,114.584900762,
	114.583929966,114.582960268,114.581991665,114.581024154,114.580057733,
	114.579092399,114.578128151,114.577164986,114.576202901,114.575241893,
	114.574281961,114.573323103,114.572365314,114.571408595,114.570452941,
	114.56949835,114.568544821,114.567592351,114.566640937,114.565690578,
	114.56474127,114.563793012,114.562845801,114.561899636,114.560954512,
	114.560010429,114.559067385,114.558125376,114.5571844,114.556244456,
	114.555305541,114.554367652,114.553430789,114.552494947,114.551560126,
	114.550626322,114.549693534,114.54876176,114.547830997,114.546901243,
	114.545972496,114.545044754,114.544118014,114.543192275,114.542267534,
	114.54134379,114.540421039,114.53949928,114.538578511,114.53765873,
	114.536739934,114.535822122,114.534905291,114.533989439,114.533074564,
	114.532160664,114.531247738,114.530335782,114.529424796,114.528514776,
	114.527605721,114.526697629,114.525790497,114.524884324,114.523979108,
	114.523074847,114.522171538,114.52126918,114.520367771,114.519467309,
	114.518567791,114.517669216,114.516771581,114.515874886,114.514979127,
	114.514084304,114.513190413,114.512297454,114.511405423,114.51051432,
	114.509624142,114.508734887,114.507846554,114.50695914,114.506072644,
	114.505187064,114.504302398,114.503418644,114.5025358,114.501653864,
	114.500772834,114.499892709,114.499013487,114.498135166,114.497257743,
	114.496381218,114.495505589,114.494630852,114.493757008,114.492884053,
	114.492011987,114.491140807,114.490270511,114.489401098,114.488532566,
	114.487664914,114.486798138,114.485932239,114.485067213,114.484203059,
	114.483339776,114.482477361,114.481615813,114.48075513,114.479895311,
	114.479036353
	}},
	{ // Ri = 250k
	-21,21,47.619,2001, {
	250.851854386,250.727213665,250.602546401,250.477852608,250.3531323,
	250.228385489,250.10361219,249.978812416,249.85398618,249.729133497,
	249.60425438,249.479348843,249.354416898,249.22945856,249.104473843,
	248.97946276,248.854425324,248.72936155,248.604271452,248.479155042,
	248.354012334,248.228843343,248.103648082,247.978426565,247.853178806,
	247.727904818,247.602604615,247.477278212,247.351925621,247.226546857,
	247.101141933,246.975710864,246.850253663,246.724770344,246.599260922,
	246.473725409,246.34816382,246.222576169,246.09696247,245.971322737,
	245.845656983,245.719965223,245.594247471,245.468503741,245.342734046,
	245.216938401,245.09111682,244.965269317,244.839395906,244.713496602,
	244.587571417,244.461620367,244.335643466,244.209640727,244.083612165,
	243.957557794,243.831477628,243.705371682,243.579239969,243.453082505,
	243.326899302,243.200690377,243.074455741,242.948195411,242.8219094,
	242.695597723,242.569260394,242.442897427,242.316508838,242.190094639,
	242.063654846,241.937189472,241.810698534,241.684182044,241.557640017,
	241.431072468,241.304479412,241.177860862,241.051216834,240.924547342,
	240.7978524,240.671132023,240.544386226,240.417615023,240.290818429,
	240.163996458,240.037149126,239.910276446,239.783378434,239.656455104,
	239.529506471,239.40253255,239.275533355,239.148508902,239.021459204,
	238.894384278,238.767284137,238.640158796,238.513008271,238.385832576,
	238.258631726,238.131405736,238.004154621,237.876878396,237.749577076,
	237.622250676,237.494899211,237.367522695,237.240121144,237.112694574,
	236.985242998,236.857766432,236.730264892,236.602738392,236.475186947,
	236.347610573,236.220009285,236.092383097,235.964732026,235.837056087,
	235.709355294,235.581629663,235.453879209,235.326103948,235.198303895,
	235.070479065,234.942629473,234.814755136,234.686856068,234.558932285,
	234.430983802,234.303010635,234.175012799,234.04699031,233.918943183,
	233.790871434,233.662775078,233.534654131,233.406508609,233.278338526,
	233.1501439,233.021924745,232.893681077,232.765412913,232.637120266,
	232.508803154,232.380461592,232.252095596,232.123705182,231.995290365,
	231.866851162,231.738387587,231.609899658,231.48138739,231.352850799,
	231.224289901,231.095704712,230.967095248,230.838461524,230.709803558,
	230.581121365,230.45241496,230.323684361,230.194929584,230.066150644,
	229.937347557,229.808520341,229.67966901,229.550793582,229.421894073,
	229.292970498,229.164022875,229.035051219,228.906055547,228.777035876,
	228.647992221,228.518924599,228.389833027,228.260717521,228.131578097,
	228.002414773,227.873227564,227.744016487,227.614781559,227.485522796,
	227.356240215,227.226933833,227.097603666,226.968249732,226.838872046,
	226.709470626,226.580045488,226.450596649,226.321124126,226.191627936,
	226.062108095,225.932564622,225.802997531,225.673406842,225.54379257,
	225.414154732,225.284493346,225.154808428,225.025099996,224.895368067,
	224.765612658,224.635833786,224.506031468,224.376205721,224.246356563,
	224.116484012,223.986588083,223.856668795,223.726726165,223.59676021,
	223.466770948,223.336758396,223.206722572,223.076663492,222.946581175,
	222.816475639,222.686346899,222.556194975,222.426019884,222.295821643,
	222.165600271,222.035355784,221.905088201,221.774797539,221.644483816,
	221.51414705,221.383787259,221.25340446,221.122998671,220.992569911,
	220.862118198,220.731643548,220.601145981,220.470625515,220.340082166,
	220.209515954,220.078926897,219.948315013,219.817680319,219.687022835,
	219.556342577,219.425639566,219.294913818,219.164165353,219.033394188,
	218.902600343,218.771783834,218.640944682,218.510082904,218.379198518,
	218.248291544,218.117362,217.986409905,217.855435276,217.724438134,
	217.593418496,217.462376381,217.331311808,217.200224796,217.069115363,
	216.937983529,216.806829312,216.675652731,216.544453805,216.413232554,
	216.281988995,216.150723149,216.019435034,215.888124669,215.756792073,
	215.625437266,215.494060267,215.362661095,215.231239769,215.099796308,
	214.968330733,214.836843062,214.705333314,214.573801509,214.442247667,
	214.310671807,214.179073949,214.047454111,213.915812314,213.784148578,
	213.652462921,213.520755364,213.389025927,213.257274629,213.125501489,
	212.993706529,212.861889766,212.730051223,212.598190918,212.466308871,
	212.334405103,212.202479634,212.070532482,211.93856367,211.806573216,
	211.674561142,211.542527466,211.41047221,211.278395394,211.146297038,
	211.014177162,210.882035787,210.749872934,210.617688622,210.485482872,
	210.353255705,210.221007142,210.088737202,209.956445907,209.824133278,
	209.691799334,209.559444097,209.427067588,209.294669827,209.162250836,
	209.029810634,208.897349244,208.764866686,208.632362982,208.499838151,
	208.367292216,208.234725197,208.102137116,207.969527994,207.836897852,
	207.704246712,207.571574594,207.438881521,207.306167513,207.173432592,
	207.040676779,206.907900097,206.775102566,206.642284209,206.509445046,
	206.3765851,206.243704392,206.110802944,205.977880778,205.844937916,
	205.71197438,205.578990191,205.445985371,205.312959943,205.179913929,
	205.04684735,204.913760229,204.780652588,204.64752445,204.514375836,
	204.381206768,204.24801727,204.114807363,203.98157707,203.848326414,
	203.715055417,203.581764101,203.448452489,203.315120604,203.181768468,
	203.048396104,202.915003536,202.781590785,202.648157874,202.514704827,
	202.381231667,202.247738415,202.114225097,201.980691733,201.847138349,
	201.713564966,201.579971608,201.446358299,201.31272506,201.179071917,
	201.045398892,200.911706009,200.777993291,200.644260761,200.510508444,
	200.376736363,200.242944541,200.109133002,199.975301771,199.84145087,
	199.707580323,199.573690155,199.43978039,199.305851051,199.171902162,
	199.037933748,198.903945832,198.769938439,198.635911593,198.501865318,
	198.367799639,198.233714579,198.099610164,197.965486418,197.831343365,
	197.697181029,197.562999436,197.42879861,197.294578575,197.160339357,
	197.02608098,196.891803469,196.757506849,196.623191145,196.488856381,
	196.354502584,196.220129777,196.085737987,195.951327237,195.816897554,
	195.682448963,195.547981489,195.413495157,195.278989993,195.144466022,
	195.00992327,194.875361763,194.740781525,194.606182584,194.471564964,
	194.336928691,194.202273791,194.06760029,193.932908214,193.798197588,
	193.66346844,193.528720795,193.393954679,193.259170118,193.124367138,
	192.989545767,192.85470603,192.719847953,192.584971564,192.450076888,
	192.315163953,192.180232784,192.045283408,191.910315853,191.775330145,
	191.64032631,191.505304376,191.37026437,191.235206318,191.100130248,
	190.965036187,190.829924162,190.6947942,190.559646328,190.424480574,
	190.289296965,190.154095528,190.018876292,189.883639283,189.748384529,
	189.613112058,189.477821897,189.342514075,189.207188619,189.071845557,
	188.936484916,188.801106726,188.665711014,188.530297807,188.394867135,
	188.259419026,188.123953507,187.988470607,187.852970354,187.717452778,
	187.581917906,187.446365767,187.310796389,187.175209802,187.039606034,
	186.903985114,186.76834707,186.632691932,186.497019729,186.361330489,
	186.225624242,186.089901017,185.954160843,185.818403749,185.682629765,
	185.546838921,185.411031245,185.275206767,185.139365516,185.003507523,
	184.867632817,184.731741428,184.595833385,184.459908719,184.323967459,
	184.188009636,184.052035279,183.916044419,183.780037085,183.644013309,
	183.50797312,183.371916549,183.235843626,183.099754382,182.963648847,
	182.827527052,182.691389027,182.555234804,182.419064414,182.282877886,
	182.146675252,182.010456543,181.874221791,181.737971025,181.601704279,
	181.465421581,181.329122965,181.192808462,181.056478102,180.920131918,
	180.783769941,180.647392202,180.510998734,180.374589568,180.238164737,
	180.101724271,179.965268203,179.828796566,179.69230939,179.555806709,
	179.419288555,179.28275496,179.146205956,179.009641575,178.873061851,
	178.736466816,178.599856503,178.463230944,178.326590172,178.18993422,
	178.053263121,177.916576908,177.779875614,177.643159272,177.506427915,
	177.369681577,177.232920291,177.09614409,176.959353008,176.822547079,
	176.685726336,176.548890812,176.412040542,176.27517556,176.138295898,
	176.001401592,175.864492675,175.727569182,175.590631146,175.453678602,
	175.316711585,175.179730128,175.042734266,174.905724034,174.768699466,
	174.631660597,174.494607462,174.357540095,174.220458532,174.083362807,
	173.946252956,173.809129014,173.671991016,173.534838996,173.397672991,
	173.260493037,173.123299167,172.986091419,172.848869828,172.711634428,
	172.574385257,172.437122351,172.299845744,172.162555473,172.025251575,
	171.887934084,171.750603039,171.613258474,171.475900427,171.338528933,
	171.20114403,171.063745754,170.926334142,170.78890923,170.651471056,
	170.514019656,170.376555067,170.239077327,170.101586472,169.96408254,
	169.826565569,169.689035595,169.551492656,169.41393679,169.276368034,
	169.138786426,169.001192004,168.863584806,168.72596487,168.588332233,
	168.450686934,168.313029011,168.175358503,168.037675447,167.899979882,
	167.762271847,167.624551381,167.486818521,167.349073307,167.211315778,
	167.073545972,166.935763929,166.797969687,166.660163286,166.522344765,
	166.384514164,166.246671521,166.108816877,165.97095027,165.833071742,
	165.69518133,165.557279076,165.419365018,165.281439198,165.143501655,
	165.00555243,164.867591562,164.729619092,164.59163506,164.453639507,
	164.315632474,164.177614001,164.039584129,163.901542898,163.763490351,
	163.625426527,163.487351468,163.349265215,163.211167809,163.073059292,
	162.934939705,162.79680909,162.658667488,162.520514942,162.382351492,
	162.244177181,162.10599205,161.967796143,161.8295895,161.691372165,
	161.553144179,161.414905585,161.276656426,161.138396744,161.000126581,
	160.861845981,160.723554986,160.58525364,160.446941985,160.308620065,
	160.170287922,160.031945601,159.893593144,159.755230595,159.616857998,
	159.478475396,159.340082833,159.201680353,159.063268,158.924845818,
	158.786413851,158.647972143,158.509520739,158.371059684,158.23258902,
	158.094108794,157.95561905,157.817119832,157.678611187,157.540093157,
	157.40156579,157.263029129,157.12448322,156.985928109,156.84736384,
	156.70879046,156.570208015,156.431616549,156.293016109,156.15440674,
	156.015788489,155.877161402,155.738525525,155.599880904,155.461227586,
	155.322565617,155.183895044,155.045215914,154.906528273,154.767832168,
	154.629127647,154.490414756,154.351693543,154.212964054,154.074226338,
	153.935480442,153.796726413,153.657964299,153.519194148,153.380416008,
	153.241629927,153.102835953,152.964034133,152.825224517,152.686407153,
	152.547582089,152.408749374,152.269909057,152.131061185,151.99220581,
	151.853342978,151.71447274,151.575595145,151.436710241,151.297818079,
	151.158918708,151.020012178,150.881098537,150.742177837,150.603250127,
	150.464315457,150.325373877,150.186425438,150.047470189,149.908508182,
	149.769539467,149.630564094,149.491582115,149.35259358,149.21359854,
	149.074597047,148.935589151,148.796574904,148.657554357,148.518527562,
	148.379494571,148.240455434,148.101410205,147.962358935,147.823301676,
	147.684238481,147.545169401,147.406094489,147.267013797,147.127927379,
	146.988835286,146.849737572,146.71063429,146.571525493,146.432411233,
	146.293291565,146.154166541,146.015036215,145.875900641,145.736759873,
	145.597613963,145.458462967,145.319306939,145.180145932,145.04098,
	144.901809199,144.762633583,144.623453206,144.484268123,144.34507839,
	144.20588406,144.06668519,143.927481833,143.788274047,143.649061886,
	143.509845405,143.370624661,143.231399709,143.092170605,142.952937405,
	142.813700166,142.674458943,142.535213793,142.395964772,142.256711938,
	142.117455346,141.978195055,141.83893112,141.699663598,141.560392548,
	141.421118026,141.28184009,141.142558798,141.003274207,140.863986374,
	140.724695359,140.585401218,140.446104011,140.306803796,140.16750063,
	140.028194573,139.888885684,139.74957402,139.610259641,139.470942607,
	139.331622976,139.192300807,139.052976161,138.913649096,138.774319672,
	138.63498795,138.495653988,138.356317848,138.216979589,138.077639272,
	137.938296957,137.798952705,137.659606576,137.520258632,137.380908933,
	137.24155754,137.102204515,136.962849919,136.823493814,136.68413626,
	136.544777321,136.405417058,136.266055532,136.126692806,135.987328943,
	135.847964005,135.708598054,135.569231153,135.429863365,135.290494753,
	135.15112538,135.01175531,134.872384605,134.73301333,134.593641548,
	134.454269323,134.314896719,134.175523801,134.036150632,133.896777278,
	133.757403803,133.618030271,133.478656749,133.339283301,133.199909993,
	133.060536891,132.921164061,132.781791568,132.642419481,132.503047864,
	132.363676787,132.224306317,132.084936521,131.945567468,131.806199228,
	131.666831869,131.527465464,131.388100082,131.248735797,131.10937268,
	130.970010808,130.830650255,130.6912911,130.551933421,130.412577301,
	130.273222823,130.133870074,129.994519147,129.855170134,129.715823137,
	129.57647826,129.437135614,129.297795321,129.158457508,129.019122314,
	128.879789891,128.740460407,128.601134044,128.461811007,128.322491522,
	128.183175848,128.043864271,127.904557119,127.765254765,127.625957636,
	127.486666221,127.347381083,127.208102873,127.068832342,126.929570364,
	126.790317954,126.651076291,126.511846751,126.372630941,126.233430736,
	126.094248329,125.955086286,125.815947611,125.676835821,125.537755038,
	125.39871009,125.259706637,125.120751312,124.981851884,124.843017458,
	124.704258697,124.565588083,124.427020217,124.288572174,124.150263893,
	124.012118641,123.874163533,123.73643011,123.598955008,123.461780678,
	123.32495619,123.188538098,123.052591349,122.917190237,122.782419343,
	122.648374441,122.5151633,122.38290631,122.251736844,122.121801264,
	121.993258446,121.866278726,121.741042191,121.617736231,121.496552363,
	121.377682388,121.261313998,121.147626066,121.036783884,120.928934657,
	120.824203582,120.722690772,120.624469231,120.529583978,120.438052299,
	120.349865045,120.264988757,120.183368433,120.104930659,120.029586911,
	119.957236822,119.887771266,119.821075166,119.757029957,119.695515685,
	119.636412741,119.579603253,119.524972169,119.472408062,119.421803714,
	119.373056493,119.326068588,119.280747106,119.237004079,119.194756393,
	119.153925668,119.114438089,119.076224219,119.03921879,119.003360489,
	118.96859174,118.93485848,118.902109955,118.870298505,118.839379373,
	118.809310509,118.780052401,118.751567898,118.723822056,118.69678199,
	118.670416734,118.644697112,118.619595621,118.595086314,118.571144699,
	118.547747645,118.524873286,118.502500945,118.480611049,118.459185066,
	118.438205432,118.417655491,118.397519439,118.377782272,118.358429731,
	118.339448263,118.320824973,118.302547588,118.284604418,118.266984321,
	118.249676674,118.23267134,118.21595864,118.199529332,118.18337458,
	118.167485936,118.151855315,118.13647498,118.121337519,118.106435831,
	118.091763107,118.077312815,118.063078688,118.049054709,118.035235097,
	118.021614299,118.008186974,117.994947986,117.981892392,117.969015436,
	117.956312535,117.943779275,117.931411403,117.919204815,117.907155555,
	117.895259806,117.883513883,117.871914226,117.860457399,117.84914008,
	117.837959059,117.82691123,117.815993591,117.805203237,117.794537354,
	117.78399322,117.773568198,117.763259732,117.753065347,117.742982643,
	117.733009292,117.723143038,117.713381689,117.703723121,117.694165271,
	117.684706135,117.675343768,117.66607628,117.656901834,117.647818645,
	117.638824978,117.629919144,117.621099503,117.612364456,117.60371245,
	117.595141972,117.58665155,117.578239749,117.569905172,117.56164646,
	117.553462285,117.545351356,117.537312413,117.529344229,117.521445604,
	117.513615373,117.505852394,117.498155556,117.490523775,117.48295599,
	117.475451168,117.468008299,117.460626397,117.453304499,117.446041665,
	117.438836974,117.431689528,117.424598449,117.417562878,117.410581976,
	117.403654923,117.396780914,117.389959165,117.383188907,117.376469388,
	117.369799873,117.363179642,117.356607988,117.350084223,117.34360767,
	117.337177667,117.330793566,117.324454732,117.318160542,117.311910387,
	117.305703669,117.299539802,117.293418213,117.287338339,117.281299628,
	117.275301538,117.26934354,117.263425112,117.257545744,117.251704935,
	117.245902194,117.240137038,117.234408994,117.228717598,117.223062393,
	117.217442932,117.211858775,117.20630949,117.200794654,117.19531385,
	117.18986667,117.184452712,117.179071581,117.173722889,117.168406256,
	117.163121306,117.157867673,117.152644994,117.147452913,117.142291082,
	117.137159157,117.132056799,117.126983676,117.121939462,117.116923835,
	117.111936479,117.106977083,117.10204534,117.097140951,117.092263618,
	117.087413051,117.082588962,117.077791068,117.073019093,117.068272762,
	117.063551807,117.058855962,117.054184965,117.049538561,117.044916496,
	117.04031852,117.035744388,117.031193858,117.026666693,117.022162656,
	117.017681518,117.013223051,117.008787029,117.004373232,116.999981442,
	116.995611444,116.991263027,116.986935981,116.982630101,116.978345185,
	116.974081032,116.969837445,116.96561423,116.961411196,116.957228153,
	116.953064916,116.948921299,116.944797123,116.940692208,116.936606379,
	116.93253946,116.928491281,116.924461672,116.920450466,116.916457499,
	116.912482607,116.90852563,116.90458641,116.90066479,116.896760617,
	116.892873737,116.889004001,116.88515126,116.881315367,116.877496179,
	116.873693551,116.869907344,116.866137418,116.862383636,116.858645861,
	116.85492396,116.8512178,116.847527251,116.843852184,116.84019247,
	116.836547984,116.832918602,116.8293042,116.825704656,116.822119852,
	116.818549668,116.814993986,116.811452693,116.807925671,116.80441281,
	116.800913997,116.797429121,116.793958073,116.790500746,116.787057033,
	116.783626828,116.780210027,116.776806528,116.773416227,116.770039026,
	116.766674823,116.763323521,116.759985022,116.75665923,116.75334605,
	116.750045388,116.746757151,116.743481246,116.740217583,116.736966071,
	116.733726622,116.730499147,116.727283559,116.724079773,116.720887702,
	116.717707263,116.714538371,116.711380945,116.708234903,116.705100163,
	116.701976647,116.698864274,116.695762967,116.692672647,116.689593239,
	116.686524666,116.683466853,116.680419727,116.677383212,116.674357237,
	116.671341729,116.668336618,116.665341832,116.662357301,116.659382956,
	116.65641873,116.653464553,116.650520358,116.64758608,116.644661653,
	116.64174701,116.638842088,116.635946823,116.633061151,116.63018501,
	116.627318338,116.624461072,116.621613153,116.61877452,116.615945113,
	116.613124873,116.610313742,116.607511661,116.604718573,116.601934422,
	116.59915915,116.596392701,116.593635021,116.590886055,116.588145748,
	116.585414046,116.582690897,116.579976246,116.577270043,116.574572234,
	116.57188277,116.569201597,116.566528668,116.56386393,116.561207335,
	116.558558833,116.555918377,116.553285916,116.550661405,116.548044795,
	116.54543604,116.542835092,116.540241906,116.537656436,116.535078636,
	116.532508463,116.52994587,116.527390815,116.524843252,116.52230314,
	116.519770434,116.517245092,116.514727072,116.512216332,116.50971283,
	116.507216525,116.504727376,116.502245343,116.499770386,116.497302464,
	116.494841538,116.492387569,116.489940518,116.487500346,116.485067016,
	116.482640489,116.480220728,116.477807695,116.475401354,116.473001668,
	116.4706086,116.468222114,116.465842175,116.463468747,116.461101795,
	116.458741284,116.456387179,116.454039446,116.451698051,116.44936296,
	116.447034139,116.444711555,116.442395176,116.440084968,116.437780898,
	116.435482935,116.433191047,116.430905201,116.428625367,116.426351513,
	116.424083607,116.42182162,116.419565521,116.417315279,116.415070864,
	116.412832246,116.410599397,116.408372285,116.406150883,116.403935162,
	116.401725091,116.399520644,116.397321791,116.395128506,116.392940758,
	116.390758522,116.38858177,116.386410473,116.384244606,116.382084142,
	116.379929053,116.377779313,116.375634897,116.373495777,116.371361928,
	116.369233324,116.367109941,116.364991751,116.362878731,116.360770856,
	116.3586681,116.356570438,116.354477848,116.352390303,116.350307781,
	116.348230256,116.346157706,116.344090108,116.342027436,116.339969669,
	116.337916783,116.335868755,116.333825562,116.331787183,116.329753593,
	116.327724772,116.325700697,116.323681346,116.321666697,116.319656728,
	116.317651418,116.315650746,116.31365469,116.311663229,116.309676343,
	116.30769401,116.30571621,116.303742922,116.301774126,116.299809801,
	116.297849928,116.295894486,116.293943456,116.291996818,116.290054553,
	116.28811664,116.286183061,116.284253796,116.282328827,116.280408133,
	116.278491698,116.276579501,116.274671525,116.27276775,116.270868159,
	116.268972733,116.267081454,116.265194304,116.263311266,116.261432321,
	116.259557452,116.257686642,116.255819872,116.253957126,116.252098387,
	116.250243637,116.24839286,116.246546038,116.244703156,116.242864195,
	116.24102914,116.239197974,116.237370681,116.235547245,116.233727649,
	116.231911878,116.230099915,116.228291745,116.226487352,116.22468672,
	116.222889834,116.221096679,116.219307238,116.217521497,116.215739441,
	116.213961054,116.212186322,116.210415229,116.208647761,116.206883904,
	116.205123641,116.20336696,116.201613845,116.199864283,116.198118258,
	116.196375757,116.194636766,116.19290127,116.191169256,116.189440709,
	116.187715617,116.185993965,116.18427574,116.182560928,116.180849515,
	116.179141489,116.177436837,116.175735544,116.174037598,116.172342985,
	116.170651694,116.16896371,116.167279021,116.165597615,116.163919478,
	116.162244597,116.160572962,116.158904558,116.157239374,116.155577397,
	116.153918615,116.152263015,116.150610587,116.148961317,116.147315193,
	116.145672205,116.144032339,116.142395584,116.140761929,116.139131362,
	116.13750387,116.135879444,116.13425807,116.132639739,116.131024437,
	116.129412156,116.127802882,116.126196605,116.124593314,116.122992998,
	116.121395645,116.119801246,116.118209789,116.116621263,116.115035658,
	116.113452962,116.111873167,116.11029626,116.108722231,116.107151071,
	116.105582768,116.104017312,116.102454693,116.100894901,116.099337926,
	116.097783757,116.096232385,116.0946838,116.093137991,116.091594948,
	116.090054663,116.088517125,116.086982324,116.085450251,116.083920896,
	116.082394249,116.080870302,116.079349044,116.077830466,116.076314558,
	116.074801313,116.073290719,116.071782768,116.070277451,116.068774759,
	116.067274682,116.065777212,116.064282339,116.062790055,116.06130035,
	116.059813216,116.058328644,116.056846625,116.055367151,116.053890213,
	116.052415801,116.050943909,116.049474526,116.048007645,116.046543257,
	116.045081354,116.043621927,116.042164969,116.040710469,116.039258422,
	116.037808817,116.036361648,116.034916906,116.033474582,116.03203467,
	116.03059716,116.029162045,116.027729317,116.026298969,116.024870991,
	116.023445377,116.022022118,116.020601208,116.019182638,116.0177664,
	116.016352487,116.014940892,116.013531606,116.012124623,116.010719935,
	116.009317534,116.007917413,116.006519565,116.005123982,116.003730657,
	116.002339583,116.000950753,115.999564159,115.998179794,115.996797651,
	115.995417723,115.994040004,115.992664485,115.99129116,115.989920022,
	115.988551065,115.98718428,115.985819662,115.984457204,115.983096898,
	115.981738738,115.980382718,115.97902883,115.977677068,115.976327425,
	115.974979895,115.973634471,115.972291147,115.970949915,115.969610771,
	115.968273706,115.966938715,115.965605792,115.964274929,115.962946121,
	115.961619361,115.960294644,115.958971962,115.95765131,115.956332681,
	115.95501607,115.953701469,115.952388874,115.951078278,115.949769674,
	115.948463057,115.947158422,115.945855761,115.944555069,115.94325634,
	115.941959568,115.940664748,115.939371873,115.938080937,115.936791936,
	115.935504863,115.934219712,115.932936478,115.931655154,115.930375736,
	115.929098218,115.927822594,115.926548859,115.925277006,115.924007031,
	115.922738928,115.921472691,115.920208315,115.918945795,115.917685125,
	115.916426299,115.915169313,115.913914162,115.912660838,115.911409339,
	115.910159657,115.908911788,115.907665727,115.906421469,115.905179008,
	115.903938338,115.902699456,115.901462356,115.900227033,115.898993481,
	115.897761696,115.896531672,115.895303405,115.89407689,115.892852122,
	115.891629095,115.890407805,115.889188247,115.887970415,115.886754306,
	115.885539915,115.884327236,115.883116264,115.881906996,115.880699425,
	115.879493548,115.87828936,115.877086856,115.87588603,115.87468688,
	115.8734894,115.872293585,115.87109943,115.869906932,115.868716086,
	115.867526887,115.86633933,115.865153411,115.863969126,115.86278647,
	115.861605438,115.860426027,115.859248231,115.858072047,115.856897469,
	115.855724494,115.854553118,115.853383335,115.852215142,115.851048535,
	115.849883508,115.848720058,115.847558181,115.846397872,115.845239127,
	115.844081942,115.842926313,115.841772235,115.840619705,115.839468718,
	115.838319271,115.837171358,115.836024976,115.834880122,115.83373679,
	115.832594977,115.831454679,115.830315892,115.829178612,115.828042835,
	115.826908556,115.825775773,115.824644481,115.823514676,115.822386355,
	115.821259513,115.820134146,115.819010252,115.817887825,115.816766862,
	115.81564736,115.814529314,115.813412721,115.812297577,115.811183879,
	115.810071621,115.808960802,115.807851417,115.806743462,115.805636934,
	115.80453183,115.803428144,115.802325875,115.801225018,115.80012557,
	115.799027526,115.797930884,115.79683564,115.795741791,115.794649332,
	115.793558261,115.792468573,115.791380266,115.790293336,115.789207779,
	115.788123592,115.787040772,115.785959315,115.784879217,115.783800476,
	115.782723088,115.781647049,115.780572356,115.779499006,115.778426996,
	115.777356321,115.77628698,115.775218968,115.774152282,115.77308692,
	115.772022876,115.77096015,115.769898737,115.768838633,115.767779836,
	115.766722343,115.765666151,115.764611255,115.763557654,115.762505343,
	115.76145432,115.760404582,115.759356125,115.758308946,115.757263043,
	115.756218412,115.75517505,115.754132953,115.75309212,115.752052547,
	115.751014231,115.749977168,115.748941356,115.747906792,115.746873473,
	115.745841396,115.744810558,115.743780955,115.742752586,115.741725447,
	115.740699534,115.739674846,115.73865138,115.737629131,115.736608098,
	115.735588278,115.734569668,115.733552264,115.732536065,115.731521066,
	115.730507267,115.729494662,115.728483251,115.72747303,115.726463995,
	115.725456145,115.724449477,115.723443988,115.722439675,115.721436535,
	115.720434566,115.719433765,115.718434129,115.717435656,115.716438343,
	115.715442187,115.714447185,115.713453335,115.712460635,115.711469081,
	115.710478671,115.709489402,115.708501272,115.707514278,115.706528417,
	115.705543687,115.704560086,115.70357761,115.702596258,115.701616026,
	115.700636912,115.699658914,115.698682028,115.697706253,115.696731586,
	115.695758025,115.694785566,115.693814208,115.692843948,115.691874784,
	115.690906712,115.689939732,115.688973839,115.688009032,115.687045308,
	115.686082666,115.685121101,115.684160613,115.683201198,115.682242855,
	115.681285581,115.680329373,115.679374229,115.678420147,115.677467125,
	115.676515159,115.675564249,115.67461439,115.673665582,115.672717822,
	115.671771107,115.670825436,115.669880805,115.668937213,115.667994658,
	115.667053136,115.666112647,115.665173187,115.664234754,115.663297346,
	115.662360962,115.661425598,115.660491252,115.659557923,115.658625608,
	115.657694304,115.656764011,115.655834724,115.654906443,115.653979166,
	115.653052889,115.652127611,115.65120333,115.650280043,115.649357749,
	115.648436445,115.647516129,115.6465968,115.645678454,115.64476109,
	115.643844706,115.6429293,115.642014869,115.641101412,115.640188926,
	115.63927741,115.638366861,115.637457278,115.636548658,115.635640999,
	115.634734299,115.633828557,115.63292377,115.632019936,115.631117053,
	115.630215119,115.629314133,115.628414092,115.627514994,115.626616838,
	115.625719621,115.624823341,115.623927997,115.623033586,115.622140107,
	115.621247558,115.620355936,115.61946524,115.618575467,115.617686617,
	115.616798687,115.615911675,115.615025579,115.614140398,115.613256129,
	115.612372771,115.611490322,115.610608779,115.609728142,115.608848408,
	115.607969575,115.607091641,115.606214606,115.605338466,115.60446322,
	115.603588867,115.602715403,115.601842829,115.600971141,115.600100338,
	115.599230419,115.598361381,115.597493222,115.596625942,115.595759537,
	115.594894007,115.59402935,115.593165563,115.592302646,115.591440596,
	115.590579411,115.589719091,115.588859632,115.588001034,115.587143295,
	115.586286413,115.585430386,115.584575212,115.583720891,115.58286742,
	115.582014797
	}}
};
