#/*******************************************************************************
#*
#*       This file is part of the General Hidden Markov Model Library,
#*       GHMM version __VERSION__, see http://ghmm.org
#*
#*       Filename: class_change.py
#*       Authors:  Benjamin Georgi
#*
#*       Copyright (C) 1998-2004 Alexander Schliep
#*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
#*       Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik,
#*                               Berlin
#*
#*       Contact: schliep@ghmm.org
#*
#*       This library is free software; you can redistribute it and/or
#*       modify it under the terms of the GNU Library General Public
#*       License as published by the Free Software Foundation; either
#*       version 2 of the License, or (at your option) any later version.
#*
#*       This library is distributed in the hope that it will be useful,
#*       but WITHOUT ANY WARRANTY; without even the implied warranty of
#*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#*       Library General Public License for more details.
#*
#*       You should have received a copy of the GNU Library General Public
#*       License along with this library; if not, write to the Free
#*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#*
#*
#*       This file is version $Revision: 2291 $
#*                       from $Date: 2013-01-03 13:45:31 -0500 (Thu, 03 Jan 2013) $
#*             last change by $Author: schliep $.
#*
#*******************************************************************************/

class testChange:
    def __init__(self):
        self.classes = None

    def setData(self,classes):
        self.classes = classes
    
    def __call__(self,seq,k,t):
        print "*** ",seq,k,t
        print "data: ",self.classes
        return 0
        



def getClass( seq, k,t):
     """ Example of a Python class change function.
     
     @param seq list of obervations
     @param k   sequence index of seq in the sequence collection seq came from
     @param t   current time step in seq (e.g  we need the class for seq[t] )
     
     """
     # dummy function right now
     #return 0

     # The class change could depend on a number of variables.
     # Here are some examples:
    
     # the sequence index k
     #if k < 10:
     #    print "k < 10 -> class 0"
     #    return 0
     #else:
     #    print "k > 10 -> class 1"
     #    return 1    

     # the time step t
     if t < 6:
         print "t < 6 -> class 0"
         return 0
     else:    
         print "t > 6 -> class 1"
         return 1

     # some cumulative function over the sequence
     seq_sum = 0
     for i in range(t):
         seq_sum += seq[i]
     if seq_sum <= 80:
         return 0
     else:
         return 1 

     # or some combination thereof for any number of classes.
