/*
 * funtions for analyzing dvi in vf-file (vfd stands for vf-file dvi)
 */

#include	"defs.h"
#include	"commands.h"
#include	"dconv.h"
#include	"global.h"

int vfd_getcommand();
void vfd_backupone();
void vfd_getbytes();
void vfd_skipbytes();
int vfd_getuint();
int vfd_getint();
void vfd_movedown();
void vfd_movedown_v();
void vfd_moveover();
void vfd_moveover_v();
void vfd_setrule();
void vfd_setrule_v();
struct dconv vfd_dconv_templ = {
    vfd_getcommand,
    vfd_backupone,
    vfd_getbytes,
    vfd_skipbytes,
    vfd_getuint,
    vfd_getint,
    NULL,
    NULL,
    NULL,
    vfd_movedown,
    vfd_movedown_v,
    vfd_moveover,
    vfd_moveover_v,
    vfd_setrule,
    vfd_setrule_v,
    0
};

int
vfd_getcommand()
{
    dc_bufbeg++;
    return (dc_bufbeg > dc_bufend ? POST : *(dc_bufbeg-1));
}

void
vfd_backupone()
{
    --dc_bufbeg;
}

void
vfd_getbytes(cp, n)
char *cp;
int n;
{
    (void)strncpy(cp, (char *)dc_bufbeg, n);
    dc_bufbeg += n;
}

void
vfd_skipbytes(n)
int n;
{
    dc_bufbeg += n;
}

int
vfd_getuint(n)
int n;
{
    int x;

    x = makeuint(dc_bufbeg, n);
    dc_bufbeg += n;
    return x;
}

int
vfd_getint(n)
int n;
{
    int x;

    x = makeint(dc_bufbeg, n);
    dc_bufbeg += n;
    return x;
}


void
vfd_movedown(a)
int a;
{
    v += scale(a, dc_scale);
}

void
vfd_movedown_v(a)
int a;
{
    h -= scale(a, dc_scale);
}

void
vfd_moveover(b)
int b;
{
    h += scale(b, dc_scale);
}

void
vfd_moveover_v(b)
int b;
{
    v += scale(b, dc_scale);
}

void
vfd_setrule(a, b, Set)	/* this routine will draw a rule */
int a, b;
BOOLEAN Set;
{
    dfd_setrule(scale(a, dc_scale), scale(b, dc_scale));
}

void
vfd_setrule_v(a, b, Set)	/* this routine will draw a rule */
int a, b;
BOOLEAN Set;
{
    dfd_setrule_v(scale(a, dc_scale), scale(b, dc_scale));
}
