/*
 * Copyright (C) 2007-2009 KenD00
 * 
 * This file is part of DumpHD.
 * 
 * DumpHD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package dumphd.util;

import java.io.PrintStream;

/**
 * Implementation of MessagePrinter which prints all messages to the given PrintStream.
 * 
 * @author KenD00
 */
public final class PrintStreamPrinter implements MessagePrinter {

   /**
    * The PrintStream used for output
    */
   private PrintStream out = null;


   /**
    * Creates a new PrintStreamPrinter which uses the given PrintStream for output.
    * 
    * @param stream The PrintStream used for output
    */
   public PrintStreamPrinter(PrintStream stream) {
      this.out = stream;
   }

   /* (non-Javadoc)
    * @see core.MessagePrinter#print(java.lang.String)
    */
   public void print(String msg) {
      out.print(msg);
   }

   /* (non-Javadoc)
    * @see core.MessagePrinter#println(java.lang.String)
    */
   public void println(String msg) {
      out.println(msg);
   }

   /* (non-Javadoc)
    * @see core.MessagePrinter#println()
    */
   public void println() {
      out.println();
   }

}
