package org.apache.maven.doxia.module.twiki.parser;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;

/**
 * Represents a verbatim block
 *
 * @author Christian Nardi
 * @version $Id: VerbatimBlock.java 747837 2009-02-25 15:50:39Z ltheussl $
 */
class VerbatimBlock
    extends AbstractFatherBlock
{
    /**
     * Creates the VerbatimBlock.
     *
     * @param childBlocks child blocks
     */
    VerbatimBlock( final Block[] childBlocks )
    {
        super( childBlocks );
    }

    /** {@inheritDoc} */
    final void before( final Sink sink )
    {
        sink.verbatim( SinkEventAttributeSet.BOXED );
    }

    /** {@inheritDoc} */
    final void after( final Sink sink )
    {
        sink.verbatim_();
    }
}
