/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix blosum90{

    10, 1,

	{{ (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.3346, 0.190, 0.7547, 0.4434, -1.4 , 0.544178, 1.377760, 1.377760 },
	{ 9, 2, (double)INT2_MAX, 0.310, 0.12, 0.46, 0.67, -6 , 0.570267, 4.232290, 4.334170 },
	{ 8, 2, (double)INT2_MAX, 0.300, 0.099, 0.39, 0.76, -7, 0.581580, 5.797020, 5.961420 },
	{ 7, 2, (double)INT2_MAX, 0.283, 0.072, 0.30, 0.93, -11, 0.600024, 9.040880, 9.321600 },
	{ 6, 2, (double)INT2_MAX, 0.259, 0.048, 0.22, 1.2, -16, 0.629344, 16.024400, 16.531600 },
	{ 11, 1, (double)INT2_MAX, 0.302, 0.093, 0.39, 0.78, -8, 0.576919, 7.143250, 7.619190 },
	{ 10, 1, (double)INT2_MAX, 0.290, 0.075, 0.28, 1.04, -15, 0.591366, 11.483900, 12.269800 },
	{ 9, 1, (double)INT2_MAX, 0.265, 0.044, 0.20, 1.3, -19, 0.613013, 21.408300, 22.840900 }},

    {
	 /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    5, -2, -2, -3, -1, -1, -1,  0, -2, -2, -2, -1, -2,
            -3, -1,  1,  0, -4, -3, -1, -2, -2, -1, -1, -6, -12,
    /*R*/   -2,  6, -1, -3, -5,  1, -1, -3,  0, -4, -3,  2, -2,
            -4, -3, -1, -2, -4, -3, -3, -2, -3,  0, -1, -6, -12,
    /*N*/   -2, -1,  7,  1, -4,  0, -1, -1,  0, -4, -4,  0, -3,
            -4, -3,  0,  0, -5, -3, -4,  5, -4, -1, -1, -6, -12,
    /*D*/   -3, -3,  1,  7, -5, -1,  1, -2, -2, -5, -5, -1, -4,
            -5, -3, -1, -2, -6, -4, -5,  5, -5,  1, -1, -6, -12,
    /*C*/   -1, -5, -4, -5,  9, -4, -6, -4, -5, -2, -2, -4, -2,
            -3, -4, -2, -2, -4, -4, -2, -4, -2, -5, -1, -6, -12,
    /*Q*/   -1,  1,  0, -1, -4,  7,  2, -3,  1, -4, -3,  1,  0,
            -4, -2, -1, -1, -3, -3, -3, -1, -3,  5, -1, -6, -12,
    /*E*/   -1, -1, -1,  1, -6,  2,  6, -3, -1, -4, -4,  0, -3,
            -5, -2, -1, -1, -5, -4, -3,  1, -4,  5, -1, -6, -12,
    /*G*/    0, -3, -1, -2, -4, -3, -3,  6, -3, -5, -5, -2, -4,
            -5, -3, -1, -3, -4, -5, -5, -2, -5, -3, -1, -6, -12,
    /*H*/   -2,  0,  0, -2, -5,  1, -1, -3,  8, -4, -4, -1, -3,
            -2, -3, -2, -2, -3,  1, -4, -1, -4,  0, -1, -6, -12,
    /*I*/   -2, -4, -4, -5, -2, -4, -4, -5, -4,  5,  1, -4,  1,
            -1, -4, -3, -1, -4, -2,  3, -5,  3, -4, -1, -6, -12,
    /*L*/   -2, -3, -4, -5, -2, -3, -4, -5, -4,  1,  5, -3,  2,
             0, -4, -3, -2, -3, -2,  0, -5,  4, -4, -1, -6, -12,
    /*K*/   -1,  2,  0, -1, -4,  1,  0, -2, -1, -4, -3,  6, -2,
            -4, -2, -1, -1, -5, -3, -3, -1, -3,  1, -1, -6, -12,
    /*M*/   -2, -2, -3, -4, -2,  0, -3, -4, -3,  1,  2, -2,  7,
            -1, -3, -2, -1, -2, -2,  0, -4,  2, -2, -1, -6, -12,
    /*F*/   -3, -4, -4, -5, -3, -4, -5, -5, -2, -1,  0, -4, -1,
             7, -4, -3, -3,  0,  3, -2, -4,  0, -4, -1, -6, -12,
    /*P*/   -1, -3, -3, -3, -4, -2, -2, -3, -3, -4, -4, -2, -3,
            -4,  8, -2, -2, -5, -4, -3, -3, -4, -2, -1, -6, -12,
    /*S*/    1, -1,  0, -1, -2, -1, -1, -1, -2, -3, -3, -1, -2,
            -3, -2,  5,  1, -4, -3, -2,  0, -3, -1, -1, -6, -12,
    /*T*/    0, -2,  0, -2, -2, -1, -1, -3, -2, -1, -2, -1, -1,
            -3, -2,  1,  6, -4, -2, -1, -1, -2, -1, -1, -6, -12,
    /*W*/   -4, -4, -5, -6, -4, -3, -5, -4, -3, -4, -3, -5, -2,
             0, -5, -4, -4, 11,  2, -3, -6, -3, -4, -1, -6, -12,
    /*Y*/   -3, -3, -3, -4, -4, -3, -4, -5,  1, -2, -2, -3, -2,
             3, -4, -3, -2,  2,  8, -3, -4, -2, -3, -1, -6, -12,
    /*V*/   -1, -3, -4, -5, -2, -3, -3, -5, -4,  3,  0, -3,  0,
            -2, -3, -2, -1, -3, -3,  5, -4,  1, -3, -1, -6, -12,
    /*B*/   -2, -2,  5,  5, -4, -1,  1, -2, -1, -5, -5, -1, -4,
            -4, -3,  0, -1, -6, -4, -4,  5, -5,  0, -1, -6, -12,
    /*J*/   -2, -3, -4, -5, -2, -3, -4, -5, -4,  3,  4, -3,  2,
             0, -4, -3, -2, -3, -2,  1, -5,  4, -4, -1, -6, -12,
    /*Z*/   -1,  0, -1,  1, -5,  5,  5, -3,  0, -4, -4,  1, -2,
            -4, -2, -1, -1, -4, -3, -3,  0, -4,  5, -1, -6, -12,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6, -12,
    /***/   -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
            -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,  1, -12,
			-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
			-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12 },

    { {2.8941466476520718e-02, 1.8963172918503119e-03, 1.4296539454877236e-03,
   1.6120541525071418e-03, 1.4378045557717186e-03, 1.5518753295389346e-03,
   2.6715149842246304e-03, 4.9176944070822995e-03, 8.3429471034916194e-04,
   2.2806166994472367e-03, 3.1400426239163565e-03, 2.5717145234657262e-03,
   9.7190459199705012e-04, 1.1707482997247202e-03, 1.9972723941546994e-03,
   6.1234827650497045e-03, 3.4990592936902896e-03, 3.1628263576966828e-04,
   9.5781456962094815e-04, 4.2309560726043610e-03},
  {1.8963172918503119e-03, 2.2892163644406403e-02, 1.4545259958564671e-03,
   1.1118856442462741e-03, 3.0043550945087249e-04, 2.0799816656266574e-03,
   1.9867845182036542e-03, 1.2814494483589008e-03, 1.0659803319010067e-03,
   8.7747376727426759e-04, 1.5563382766215293e-03, 5.6726070720652388e-03,
   5.5601248568691477e-04, 6.0014287440373390e-04, 7.7860213318230740e-04,
   1.7926007027022699e-03, 1.3337993839260983e-03, 1.8822355540425045e-04,
   6.3568077704304765e-04, 1.1439035919666126e-03},
  {1.4296539454877236e-03, 1.4545259958564671e-03, 1.7753653137209658e-02,
   3.4122251157479486e-03, 3.5262434817793110e-04, 1.2595133876871906e-03,
   1.7189800468094042e-03, 2.1939494568804173e-03, 1.1268322842671913e-03,
   6.2771773800865524e-04, 9.0162895039764071e-04, 1.9751605656395136e-03,
   3.4437514139917542e-04, 4.5695294787233016e-04, 5.6210182826678802e-04,
   2.6415583911000790e-03, 1.8096241176560255e-03, 1.1361193219385239e-04,
   5.3166878528705414e-04, 7.8744578895086331e-04},
  {1.6120541525071418e-03, 1.1118856442462741e-03, 3.4122251157479486e-03,
   2.8905985529761216e-02, 2.8205144393017687e-04, 1.2470706135571605e-03,
   4.8098591474193932e-03, 2.0787428065125128e-03, 7.3570523495442291e-04,
   6.1360733950558593e-04, 8.9746213145538078e-04, 1.7935339070485811e-03,
   2.8515554540729039e-04, 4.9706948686116547e-04, 8.3650620447870902e-04,
   2.1902661040309438e-03, 1.4770487412630099e-03, 9.6154148977656466e-05,
   4.1238640135342840e-04, 8.1983005205147035e-04},
  {1.4378045557717186e-03, 3.0043550945087249e-04, 3.5262434817793110e-04,
   2.8205144393017687e-04, 1.8963924833314688e-02, 2.4062393656260663e-04,
   2.4018396300677406e-04, 5.1191591124580998e-04, 1.4262451141854431e-04,
   1.0187249201952210e-03, 1.2204913461061227e-03, 3.4081454298601579e-04,
   3.0855994042178013e-04, 5.4061743869703049e-04, 2.6341296370767072e-04,
   9.0081780182465609e-04, 8.3760722742725604e-04, 1.1402385673074935e-04,
   3.0875531409262481e-04, 1.2790175783090351e-03},
  {1.5518753295389346e-03, 2.0799816656266574e-03, 1.2595133876871906e-03,
   1.2470706135571605e-03, 2.4062393656260663e-04, 1.1258473852655668e-02,
   3.3929068022966746e-03, 1.0135072388571143e-03, 1.0428112436817220e-03,
   6.2154432511249121e-04, 1.2200582014470405e-03, 2.6612615004061048e-03,
   6.9614541817054399e-04, 4.3847028249800182e-04, 6.3169039064483155e-04,
   1.5347331351459369e-03, 1.1633090191045159e-03, 1.8118969468635933e-04,
   4.8090269093961543e-04, 8.6038475380201306e-04},
  {2.6715149842246304e-03, 1.9867845182036542e-03, 1.7189800468094042e-03,
   4.8098591474193932e-03, 2.4018396300677406e-04, 3.3929068022966746e-03,
   2.4082550387620767e-02, 1.5173914448105995e-03, 1.0609424122148584e-03,
   8.6556272233095357e-04, 1.2693446983220930e-03, 3.1728712431242272e-03,
   4.8675933771578960e-04, 5.2592632830518644e-04, 1.1283633992741310e-03,
   2.4358395159902540e-03, 1.7460695145653721e-03, 1.7186658965667723e-04,
   5.3762929629223334e-04, 1.3537458445130380e-03},
  {4.9176944070822995e-03, 1.2814494483589008e-03, 2.1939494568804173e-03,
   2.0787428065125128e-03, 5.1191591124580998e-04, 1.0135072388571143e-03,
   1.5173914448105995e-03, 5.2105577140795424e-02, 6.6116372972342219e-04,
   7.9279793619671047e-04, 1.4084669216931525e-03, 1.8091800840455807e-03,
   4.5905141534639837e-04, 7.2640563736237702e-04, 9.1606958049118977e-04,
   3.2250721573096343e-03, 1.6376154647606311e-03, 2.8505580568873712e-04,
   5.3377971995623207e-04, 1.1777891482397749e-03},
  {8.3429471034916194e-04, 1.0659803319010067e-03, 1.1268322842671913e-03,
   7.3570523495442291e-04, 1.4262451141854431e-04, 1.0428112436817220e-03,
   1.0609424122148584e-03, 6.6116372972342219e-04, 1.1500733945516558e-02,
   3.8185691425617459e-04, 6.9827301155994540e-04, 9.0371184948679912e-04,
   2.4699125636645672e-04, 5.9147458541551113e-04, 3.8444740537595942e-04,
   8.5932297611334600e-04, 6.0598617290751988e-04, 1.4705149603278306e-04,
   1.4431522344877262e-03, 4.5696999458730438e-04},
  {2.2806166994472367e-03, 8.7747376727426759e-04, 6.2771773800865524e-04,
   6.1360733950558593e-04, 1.0187249201952210e-03, 6.2154432511249121e-04,
   8.6556272233095357e-04, 7.9279793619671047e-04, 3.8185691425617459e-04,
   2.4545975084797667e-02, 1.0187721075530867e-02, 1.0015355309232945e-03,
   2.3855654456497641e-03, 2.3760161494061206e-03, 6.6596344099825570e-04,
   1.2754928334842836e-03, 2.1146482135048364e-03, 2.8885067061466341e-04,
   1.1275668044226116e-03, 1.2010991497586472e-02},
  {3.1400426239163565e-03, 1.5563382766215293e-03, 9.0162895039764071e-04,
   8.9746213145538078e-04, 1.2204913461061227e-03, 1.2200582014470405e-03,
   1.2693446983220930e-03, 1.4084669216931525e-03, 6.9827301155994540e-04,
   1.0187721075530867e-02, 4.7314665506091480e-02, 1.6493087064879096e-03,
   4.9150964217477052e-03, 4.7389371254676835e-03, 1.0204208998598171e-03,
   1.9093387711173759e-03, 2.5387072113370619e-03, 5.5567682513643440e-04,
   1.7591338828767365e-03, 8.0719383241327648e-03},
  {2.5717145234657262e-03, 5.6726070720652388e-03, 1.9751605656395136e-03,
   1.7935339070485811e-03, 3.4081454298601579e-04, 2.6612615004061048e-03,
   3.1728712431242272e-03, 1.8091800840455807e-03, 9.0371184948679912e-04,
   1.0015355309232945e-03, 1.6493087064879096e-03, 2.1110006225715187e-02,
   6.5644301788968489e-04, 6.8011754565553524e-04, 1.1433484348853926e-03,
   2.2696044144588988e-03, 1.8742456882945837e-03, 1.4351856033992664e-04,
   6.5878172544710722e-04, 1.2879210940900179e-03},
  {9.7190459199705012e-04, 5.5601248568691477e-04, 3.4437514139917542e-04,
   2.8515554540729039e-04, 3.0855994042178013e-04, 6.9614541817054399e-04,
   4.8675933771578960e-04, 4.5905141534639837e-04, 2.4699125636645672e-04,
   2.3855654456497641e-03, 4.9150964217477052e-03, 6.5644301788968489e-04,
   6.7525741637165784e-03, 9.2071349348378116e-04, 2.9821836819244002e-04,
   6.2250823423415716e-04, 8.5497291624530018e-04, 1.8480270544289832e-04,
   4.1789997362558619e-04, 2.0390401916086623e-03},
  {1.1707482997247202e-03, 6.0014287440373390e-04, 4.5695294787233016e-04,
   4.9706948686116547e-04, 5.4061743869703049e-04, 4.3847028249800182e-04,
   5.2592632830518644e-04, 7.2640563736237702e-04, 5.9147458541551113e-04,
   2.3760161494061206e-03, 4.7389371254676835e-03, 6.8011754565553524e-04,
   9.2071349348378116e-04, 2.2759929778368840e-02, 3.8203945097730409e-04,
   9.0070409285055049e-04, 9.3733303528124379e-04, 7.0215975437974915e-04,
   4.5967694652672827e-03, 1.9728777259904423e-03},
  {1.9972723941546994e-03, 7.7860213318230740e-04, 5.6210182826678802e-04,
   8.3650620447870902e-04, 2.6341296370767072e-04, 6.3169039064483155e-04,
   1.1283633992741310e-03, 9.1606958049118977e-04, 3.8444740537595942e-04,
   6.6596344099825570e-04, 1.0204208998598171e-03, 1.1433484348853926e-03,
   2.9821836819244002e-04, 3.8203945097730409e-04, 2.4044365492630580e-02,
   1.3333728667143045e-03, 9.5861529112551574e-04, 1.0367126137135345e-04,
   2.9369391163915916e-04, 9.1754627765824664e-04},
  {6.1234827650497045e-03, 1.7926007027022699e-03, 2.6415583911000790e-03,
   2.1902661040309438e-03, 9.0081780182465609e-04, 1.5347331351459369e-03,
   2.4358395159902540e-03, 3.2250721573096343e-03, 8.5932297611334600e-04,
   1.2754928334842836e-03, 1.9093387711173759e-03, 2.2696044144588988e-03,
   6.2250823423415716e-04, 9.0070409285055049e-04, 1.3333728667143045e-03,
   2.0222291957641345e-02, 4.8820444720790194e-03, 2.0564914018856946e-04,
   8.5252084753556067e-04, 1.9182160488867347e-03},
  {3.4990592936902896e-03, 1.3337993839260983e-03, 1.8096241176560255e-03,
   1.4770487412630099e-03, 8.3760722742725604e-04, 1.1633090191045159e-03,
   1.7460695145653721e-03, 1.6376154647606311e-03, 6.0598617290751988e-04,
   2.1146482135048364e-03, 2.5387072113370619e-03, 1.8742456882945837e-03,
   8.5497291624530018e-04, 9.3733303528124379e-04, 9.5861529112551574e-04,
   4.8820444720790194e-03, 1.9324325014986026e-02, 1.8008131088087498e-04,
   7.7364223266285920e-04, 3.0481291734621883e-03},
  {3.1628263576966828e-04, 1.8822355540425045e-04, 1.1361193219385239e-04,
   9.6154148977656466e-05, 1.1402385673074935e-04, 1.8118969468635933e-04,
   1.7186658965667723e-04, 2.8505580568873712e-04, 1.4705149603278306e-04,
   2.8885067061466341e-04, 5.5567682513643440e-04, 1.4351856033992664e-04,
   1.8480270544289832e-04, 7.0215975437974915e-04, 1.0367126137135345e-04,
   2.0564914018856946e-04, 1.8008131088087498e-04, 1.0080756092360078e-02,
   9.7237191290610822e-04, 3.3849359263814259e-04},
  {9.5781456962094815e-04, 6.3568077704304765e-04, 5.3166878528705414e-04,
   4.1238640135342840e-04, 3.0875531409262481e-04, 4.8090269093961543e-04,
   5.3762929629223334e-04, 5.3377971995623207e-04, 1.4431522344877262e-03,
   1.1275668044226116e-03, 1.7591338828767365e-03, 6.5878172544710722e-04,
   4.1789997362558619e-04, 4.5967694652672827e-03, 2.9369391163915916e-04,
   8.5252084753556067e-04, 7.7364223266285920e-04, 9.7237191290610822e-04,
   1.7299655473877330e-02, 1.0599282277832859e-03},
  {4.2309560726043610e-03, 1.1439035919666126e-03, 7.8744578895086331e-04,
   8.1983005205147035e-04, 1.2790175783090351e-03, 8.6038475380201306e-04,
   1.3537458445130380e-03, 1.1777891482397749e-03, 4.5696999458730438e-04,
   1.2010991497586472e-02, 8.0719383241327648e-03, 1.2879210940900179e-03,
   2.0390401916086623e-03, 1.9728777259904423e-03, 9.1754627765824664e-04,
   1.9182160488867347e-03, 3.0481291734621883e-03, 3.3849359263814259e-04,
   1.0599282277832859e-03, 2.8697002670368957e-02} },

   { 7.2552570322773416e-02, 4.9204908670176822e-02, 4.1453803904895913e-02,
    5.4114599751069477e-02, 2.9605031943377283e-02, 3.3576453482421185e-02,
    5.5175092196696710e-02, 7.9252675455356913e-02, 2.4890326300616415e-02,
    6.6060229109246138e-02, 9.6973050911305106e-02, 5.3375686232455331e-02,
    2.4402790064347962e-02, 4.6515405498268582e-02, 3.8659721995628657e-02,
    5.8095437228457614e-02, 5.1596863495160232e-02, 1.5369491541399532e-02,
    3.5653734247116535e-02, 7.3472127649230390e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {0.00000000e+00, 5.49812903e+00, 4.38682591e-01, 6.69393543e-01,
    4.10593787e-01, 6.67362415e-01, 3.46907686e-01, 8.55253386e-01,
    4.61993747e-01, 4.75838329e-01, 6.64089300e-01, 4.46304927e-01,
    5.48948177e-01, 4.75350260e-01, 7.12075051e-01, 6.37043670e-01,
    5.31189855e-01, 1.45279278e+00, 9.34706358e-01, 7.93712275e-01,
    2.83637106e-01, 7.50000000e-01, 3.70274337e-01, 6.55892238e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.58271706e-01},
   {0.00000000e+00, 4.38682591e-01, 5.85593083e+00, 2.24322103e-01,
    6.24911512e+00, 1.23816514e+00, 2.14608760e-01, 5.64122407e-01,
    7.82997018e-01, 1.96621553e-01, 7.38810616e-01, 1.94127812e-01,
    2.69937418e-01, 5.34266045e+00, 3.78549747e-01, 7.81147613e-01,
    5.45762328e-01, 8.70271567e-01, 6.66528685e-01, 2.28904046e-01,
    1.42810925e-01, 7.50000000e-01, 2.77062678e-01, 1.06526643e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.95138263e-01},
   {0.00000000e+00, 6.69393543e-01, 2.24322103e-01, 2.16370056e+01,
    1.76054992e-01, 1.47039970e-01, 3.92579579e-01, 2.18182122e-01,
    1.93552170e-01, 5.20896357e-01, 2.15679622e-01, 4.25126435e-01,
    4.27104871e-01, 2.87330927e-01, 2.30151009e-01, 2.42068607e-01,
    2.06242089e-01, 5.23756471e-01, 5.48342086e-01, 5.88014943e-01,
    2.50594014e-01, 7.50000000e-01, 2.92512133e-01, 1.82991170e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.63931905e-01},
   {0.00000000e+00, 4.10593787e-01, 6.24911512e+00, 1.76054992e-01,
    9.87094836e+00, 1.61092322e+00, 1.97472144e-01, 4.84699282e-01,
    5.46208942e-01, 1.71646922e-01, 6.20942905e-01, 1.71021465e-01,
    2.15937410e-01, 1.52110375e+00, 3.99848977e-01, 6.86343892e-01,
    4.17577647e-01, 6.96691332e-01, 5.29001708e-01, 2.06199101e-01,
    1.15609648e-01, 7.50000000e-01, 2.13739536e-01, 1.26113669e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.71274897e-01},
   {0.00000000e+00, 6.67362415e-01, 1.23816514e+00, 1.47039970e-01,
    1.61092322e+00, 7.91072600e+00, 2.04920324e-01, 3.47008914e-01,
    7.72534981e-01, 2.37473636e-01, 1.07737256e+00, 2.37238651e-01,
    3.61519510e-01, 7.51559518e-01, 5.28989676e-01, 1.83144568e+00,
    7.31811567e-01, 7.59912485e-01, 6.13331345e-01, 3.33942314e-01,
    2.02669731e-01, 7.50000000e-01, 2.73296982e-01, 5.61081481e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.37333866e-01},
   {0.00000000e+00, 3.46907686e-01, 2.14608760e-01, 3.92579579e-01,
    1.97472144e-01, 2.04920324e-01, 1.05190688e+01, 1.97046381e-01,
    5.10867985e-01, 7.73236776e-01, 2.73932585e-01, 1.05058955e+00,
    8.11125795e-01, 2.36979230e-01, 2.12448013e-01, 2.80742738e-01,
    2.62210098e-01, 3.33306129e-01, 3.90547453e-01, 5.77272331e-01,
    9.82154073e-01, 7.50000000e-01, 2.77172979e+00, 2.33605433e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 9.38207661e-01},
   {0.00000000e+00, 8.55253386e-01, 5.64122407e-01, 2.18182122e-01,
    4.84699282e-01, 3.47008914e-01, 1.97046381e-01, 8.29576319e+00,
    3.35169505e-01, 1.51428808e-01, 4.27685370e-01, 1.83265898e-01,
    2.37360208e-01, 6.67802895e-01, 2.98989408e-01, 3.80871171e-01,
    3.28608745e-01, 7.00460225e-01, 4.00474342e-01, 2.02269779e-01,
    2.34021877e-01, 7.50000000e-01, 1.88904853e-01, 3.59819671e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.70365676e-01},
   {0.00000000e+00, 4.61993747e-01, 7.82997018e-01, 1.93552170e-01,
    5.46208942e-01, 7.72534981e-01, 5.10867985e-01, 3.35169505e-01,
    1.85636930e+01, 2.32236241e-01, 6.80230209e-01, 2.89296785e-01,
    4.06641319e-01, 1.09210477e+00, 3.99528365e-01, 1.24778653e+00,
    8.70382542e-01, 5.94270003e-01, 4.71855284e-01, 2.49881715e-01,
    3.84396440e-01, 7.50000000e-01, 1.62620965e+00, 9.52331980e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.66176152e-01},
   {0.00000000e+00, 4.75838329e-01, 1.96621553e-01, 5.20896357e-01,
    1.71646922e-01, 2.37473636e-01, 7.73236776e-01, 1.51428808e-01,
    2.32236241e-01, 5.62471003e+00, 2.84042165e-01, 1.59032509e+00,
    1.47982983e+00, 2.29223921e-01, 2.60766373e-01, 2.80218761e-01,
    2.69951432e-01, 3.32350183e-01, 6.20404233e-01, 2.47466358e+00,
    2.84494454e-01, 7.50000000e-01, 4.78737209e-01, 2.53644956e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.22503669e+00},
   {0.00000000e+00, 6.64089300e-01, 7.38810616e-01, 2.15679622e-01,
    6.20942905e-01, 1.07737256e+00, 2.73932585e-01, 4.27685370e-01,
    6.80230209e-01, 2.84042165e-01, 7.40971353e+00, 3.18645229e-01,
    5.03980900e-01, 8.92677413e-01, 5.54085013e-01, 1.48494120e+00,
    2.15988586e+00, 7.31921781e-01, 6.80549543e-01, 3.28415139e-01,
    1.74946435e-01, 7.50000000e-01, 3.46172886e-01, 1.23156378e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.04624249e-01},
   {0.00000000e+00, 4.46304927e-01, 1.94127812e-01, 4.25126435e-01,
    1.71021465e-01, 2.37238651e-01, 1.05058955e+00, 1.83265898e-01,
    2.89296785e-01, 1.59032509e+00, 3.18645229e-01, 5.03145573e+00,
    2.07702392e+00, 2.24291285e-01, 2.72188366e-01, 3.74709469e-01,
    3.26170372e-01, 3.38914311e-01, 5.07385737e-01, 1.13293282e+00,
    3.72830750e-01, 7.50000000e-01, 5.08794972e-01, 2.89246563e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.63712766e+00},
   {0.00000000e+00, 5.48948177e-01, 2.69937418e-01, 4.27104871e-01,
    2.15937410e-01, 3.61519510e-01, 8.11125795e-01, 2.37360208e-01,
    4.06641319e-01, 1.47982983e+00, 5.03980900e-01, 2.07702392e+00,
    1.13394084e+01, 3.40430076e-01, 3.16108504e-01, 8.49621832e-01,
    4.63059321e-01, 4.39100157e-01, 6.79030953e-01, 1.13727027e+00,
    4.92730381e-01, 7.50000000e-01, 4.80316866e-01, 5.46178209e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.83504401e+00},
   {0.00000000e+00, 4.75350260e-01, 5.34266045e+00, 2.87330927e-01,
    1.52110375e+00, 7.51559518e-01, 2.36979230e-01, 6.67802895e-01,
    1.09210477e+00, 2.29223921e-01, 8.92677413e-01, 2.24291285e-01,
    3.40430076e-01, 1.03313947e+01, 3.50745318e-01, 9.04906229e-01,
    7.13097098e-01, 1.09686657e+00, 8.46059068e-01, 2.58543521e-01,
    1.78320001e-01, 7.50000000e-01, 3.59725936e-01, 8.09573592e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.26289963e-01},
   {0.00000000e+00, 7.12075051e-01, 3.78549747e-01, 2.30151009e-01,
    3.99848977e-01, 5.28989676e-01, 2.12448013e-01, 2.98989408e-01,
    3.99528365e-01, 2.60766373e-01, 5.54085013e-01, 2.72188366e-01,
    3.16108504e-01, 3.50745318e-01, 1.60877707e+01, 4.86643270e-01,
    4.09306303e-01, 5.93677872e-01, 4.80576271e-01, 3.23032809e-01,
    1.74477792e-01, 7.50000000e-01, 2.13074361e-01, 5.12969199e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.67560235e-01},
   {0.00000000e+00, 6.37043670e-01, 7.81147613e-01, 2.42068607e-01,
    6.86343892e-01, 1.83144568e+00, 2.80742738e-01, 3.80871171e-01,
    1.24778653e+00, 2.80218761e-01, 1.48494120e+00, 3.74709469e-01,
    8.49621832e-01, 9.04906229e-01, 4.86643270e-01, 9.98642121e+00,
    1.25897253e+00, 7.86784913e-01, 6.71486014e-01, 3.48766905e-01,
    3.51106744e-01, 7.50000000e-01, 4.01714365e-01, 4.91663315e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.36422330e-01},
   {0.00000000e+00, 5.31189855e-01, 5.45762328e-01, 2.06242089e-01,
    4.17577647e-01, 7.31811567e-01, 2.62210098e-01, 3.28608745e-01,
    8.70382542e-01, 2.69951432e-01, 2.15988586e+00, 3.26170372e-01,
    4.63059321e-01, 7.13097098e-01, 4.09306303e-01, 1.25897253e+00,
    9.45518393e+00, 6.27094667e-01, 5.25362150e-01, 3.16415957e-01,
    2.48889195e-01, 7.50000000e-01, 3.62347797e-01, 9.31246918e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.03390753e-01},
   {0.00000000e+00, 1.45279278e+00, 8.70271567e-01, 5.23756471e-01,
    6.96691332e-01, 7.59912485e-01, 3.33306129e-01, 7.00460225e-01,
    5.94270003e-01, 3.32350183e-01, 7.31921781e-01, 3.38914311e-01,
    4.39100157e-01, 1.09686657e+00, 5.93677872e-01, 7.86784913e-01,
    6.27094667e-01, 5.99164849e+00, 1.62868240e+00, 4.49399804e-01,
    2.30316670e-01, 7.50000000e-01, 4.11583504e-01, 7.70078852e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.36254561e-01},
   {0.00000000e+00, 9.34706358e-01, 6.66528685e-01, 5.48342086e-01,
    5.29001708e-01, 6.13331345e-01, 3.90547453e-01, 4.00474342e-01,
    4.71855284e-01, 6.20404233e-01, 6.80549543e-01, 5.07385737e-01,
    6.79030953e-01, 8.46059068e-01, 4.80576271e-01, 6.71486014e-01,
    5.25362150e-01, 1.62868240e+00, 7.25868130e+00, 8.04058132e-01,
    2.27083637e-01, 7.50000000e-01, 4.20544390e-01, 6.35332398e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 5.53180238e-01},
   {0.00000000e+00, 7.93712275e-01, 2.28904046e-01, 5.88014943e-01,
    2.06199101e-01, 3.33942314e-01, 5.77272331e-01, 2.02269779e-01,
    2.49881715e-01, 2.47466358e+00, 3.28415139e-01, 1.13293282e+00,
    1.13727027e+00, 2.58543521e-01, 3.23032809e-01, 3.48766905e-01,
    3.16415957e-01, 4.49399804e-01, 8.04058132e-01, 5.31607752e+00,
    2.99756311e-01, 7.50000000e-01, 4.04621372e-01, 3.39550748e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 1.67659508e+00},
   {0.00000000e+00, 2.83637106e-01, 1.42810925e-01, 2.50594014e-01,
    1.15609648e-01, 2.02669731e-01, 9.82154073e-01, 2.34021877e-01,
    3.84396440e-01, 2.84494454e-01, 1.74946435e-01, 3.72830750e-01,
    4.92730381e-01, 1.78320001e-01, 1.74477792e-01, 3.51106744e-01,
    2.48889195e-01, 2.30316670e-01, 2.27083637e-01, 2.99756311e-01,
    4.26750567e+01, 7.50000000e-01, 1.77446682e+00, 2.58826370e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.37037347e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 3.70274337e-01, 2.77062678e-01, 2.92512133e-01,
    2.13739536e-01, 2.73296982e-01, 2.77172979e+00, 1.88904853e-01,
    1.62620965e+00, 4.78737209e-01, 3.46172886e-01, 5.08794972e-01,
    4.80316866e-01, 3.59725936e-01, 2.13074361e-01, 4.01714365e-01,
    3.62347797e-01, 4.11583504e-01, 4.20544390e-01, 4.04621372e-01,
    1.77446682e+00, 7.50000000e-01, 1.36090374e+01, 3.21879801e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 4.96615724e-01},
   {0.00000000e+00, 6.55892238e-01, 1.06526643e+00, 1.82991170e-01,
    1.26113669e+00, 5.61081481e+00, 2.33605433e-01, 3.59819671e-01,
    9.52331980e-01, 2.53644956e-01, 1.23156378e+00, 2.89246563e-01,
    5.46178209e-01, 8.09573592e-01, 5.12969199e-01, 4.91663315e+00,
    9.31246918e-01, 7.70078852e-01, 6.35332398e-01, 3.39550748e-01,
    2.58826370e-01, 7.50000000e-01, 3.21879801e-01, 5.34819225e+00,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 2.74820979e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.20000000e-01, 1.20000000e-01, 1.20000000e-01,
    1.20000000e-01, 1.33300000e+00, 1.20000000e-01, 1.20000000e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 4.58271706e-01, 1.95138263e-01, 4.63931905e-01,
    1.71274897e-01, 2.37333866e-01, 9.38207661e-01, 1.70365676e-01,
    2.66176152e-01, 3.22503669e+00, 3.04624249e-01, 3.63712766e+00,
    1.83504401e+00, 2.26289963e-01, 2.67560235e-01, 3.36422330e-01,
    3.03390753e-01, 3.36254561e-01, 5.53180238e-01, 1.67659508e+00,
    3.37037347e-01, 7.50000000e-01, 4.96615724e-01, 2.74820979e-01,
    7.50000000e-01, 1.20000000e-01, 7.50000000e-01, 3.47015056e+00} }

};

}