/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/test_suites.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta]
 */


#include <diagnostics/util/test_suites.ts.hpp>

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_suite.hpp>
#include <diagnostics/util/dummy_test_case.ts.hpp>

#include <diagnostics/util/to_string.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

::diagnostics::unittest::Test_Suite * simple_test_suite()
{
    using namespace diagnostics::unittest;
    
    Test_Suite *s1(new Test_Suite("S1"));
    s1->add(new Stupid_Test_Case("C1"));
    s1->add(new Stupid_Test_Case("C2"));
    Test_Suite * s2(new Test_Suite("S2"));
    s2->add(new Stupid_Test_Case("C1"));
    s2->add(new Stupid_Test_Case("C2"));
    Test_Suite * s3(new Test_Suite("S3"));
    s3->add(new Stupid_Test_Case("C1"));
    s3->add(new Stupid_Test_Case("C2"));
    s1->add(s2);
    s1->add(s3);
    return s1;
}

::diagnostics::unittest::Test_Suite * simple_unnamed_test_suite()
{
    using namespace diagnostics::unittest;
    
    Test_Suite *s1(new Test_Suite(""));
    s1->add(new Stupid_Test_Case("C1"));
    s1->add(new Stupid_Test_Case("C2"));
    Test_Suite * s2(new Test_Suite("S2"));
    s2->add(new Stupid_Test_Case("C1"));
    s2->add(new Stupid_Test_Case("C2"));
    Test_Suite * s3(new Test_Suite("S3"));
    s3->add(new Stupid_Test_Case("C1"));
    s3->add(new Stupid_Test_Case("C2"));
    s1->add(s2);
    s1->add(s3);
    return s1;
}


::diagnostics::unittest::Test_Suite * test_suite_all_test_case_variations()
{
    using namespace diagnostics::internal;
    using namespace diagnostics;
    using namespace unittest;

    Test_Suite *s1(new Test_Suite("S1"));
    Test_Suite *s2(new Test_Suite("S2"));
    Test_Suite *s3(new Test_Suite("S3"));
    s1->add(s2);
    s1->add(s3);
    
    int i;
    for(i=0;i<8;++i) {
	s1->add(new Dummy_Test_Case("name"+to_string(i),1,true,i&(1<<LEVEL_PROD),i&(1<<LEVEL_DEBUG),i&(1<<LEVEL_AUDIT)));
	s2->add(new Dummy_Test_Case("name"+to_string(i),2,false,i&(1<<LEVEL_PROD),i&(1<<LEVEL_DEBUG),i&(1<<LEVEL_AUDIT)));
	s3->add(new Dummy_Test_Case("name"+to_string(i),3,true,i&(1<<LEVEL_PROD),i&(1<<LEVEL_DEBUG),i&(1<<LEVEL_AUDIT)));
    }


    return s1;
}

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
