/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GENERAL_H_
#define GENERAL_H_

#include <glib.h>

#define SETTINGFILE "desktopnova.xml"
#define CACHEFILE "files.cache"
#define DEFAULTTIMEVALUE 10
#define PIDLOCKFILE "pidlock"
#define AUTORUNFILE "desktopnova-daemon.desktop"
#define AUTORUNCONTENT \
		"\n" \
		"[Desktop Entry]\n" \
		"Type=Application\n" \
		"Encoding=UTF-8\n" \
		"Version=1.0\n" \
		"Name=desktopnova-daemon\n" \
		"Exec=" BINDIR "/desktopnova-daemon\n" \
		"Icon=desktopnova\n" \
		"X-GNOME-Autostart-enabled=true\n"

#define AUTORUNTRAYFILE "desktopnova-tray.desktop"
#define AUTORUNTRAYCONTENT \
		"\n" \
		"[Desktop Entry]\n" \
		"Type=Application\n" \
		"Encoding=UTF-8\n" \
		"Version=1.0\n" \
		"Name=desktopnova-tray\n" \
		"Exec=" BINDIR "/desktopnova-tray\n" \
		"Icon=desktopnova\n" \
		"X-GNOME-Autostart-enabled=true\n"

#define DEFAULT_FILTERS "png jpg jpeg bmp svg gif tif"

#define error(x) g_critical("Version=%s %s:%u - %s: %s", \
        VERSION,__FILE__, __LINE__, x, g_strerror(errno))

gchar * get_setting_file();
gchar * get_app_dir();
gchar * get_home_dir();

gint comp_string(const void * elem1, const void * elem2);

#endif /*GENERAL_H_*/
