/*

   Derby - Class DummyVTI2

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.StringColumnVTI;

/**
 * <p>
 * This class goes into a jar file called dummy_vti.jar. We  use this class to
 * verify that restricted table functions can be invoked from inside jar files stored
 * inside the database. We use this jar file in the DatabaseClassLoading test.
 * Compile this class with the Java 5 compiler.
 * </p>
 */
public class DummyVTI2 extends StringColumnVTI implements RestrictedVTI
{
    private static  final   String[]    COLUMN_NAMES = { "A" };
    private static  final   String[]    DATA = { "0", "1", "2" };

    private int _idx = -1;
    private boolean _allowRestriction;
    
    private DummyVTI2( boolean allowRestriction )
    {
        super( COLUMN_NAMES );
        
        _allowRestriction = allowRestriction;
    }

    public  static  DummyVTI2    dummyVTI2( boolean allowRestriction )
    {
        return new DummyVTI2( allowRestriction );
    }

    // VTITemplate api
    public  boolean next()
    {
        _idx++;
        
        if ( _idx >= DATA.length ) { return false; }
        else { return true; }
    }
    public  void    close() {}
    protected   String  getRawColumn( int columnNumber )
    {
        return DATA[ _idx ];
    }

    // RestrictedVTI api
    public  void initScan(java.lang.String[] columnNames, Restriction restriction)
        throws SQLException
    {
        if ( !_allowRestriction ) { throw new SQLException( "Illegal restriction!", "XYZZY" ); }
    }
    
}
