// ------------------------------------------------------------------------
//
// SPDX-License-Identifier: LGPL-2.1-or-later
// Copyright (C) 2010 - 2022 by the deal.II authors
//
// This file is part of the deal.II library.
//
// Part of the source code is dual licensed under Apache-2.0 WITH
// LLVM-exception OR LGPL-2.1-or-later. Detailed license information
// governing the source code and code contributions can be found in
// LICENSE.md and CONTRIBUTING.md at the top level directory of deal.II.
//
// ------------------------------------------------------------------------


/**
 * @defgroup Parallel Parallel computing
 *
 * @brief A group discussing the use of multiple processors.
 *
 * This group contains information on %parallel computing. It is
 * subdivided into parts on @ref threads and on @ref distributed.
 */


/**
 * A namespace in which we define classes and algorithms that deal
 * with running in %parallel on shared memory machines when deal.II is
 * configured to use multiple threads (see @ref threads), as well as
 * running things in %parallel on %distributed memory machines (see
 * @ref distributed).
 *
 * @ingroup threads
 */
namespace parallel
{
}
