// ---------------------------------------------------------------------
//
// Copyright (C) 2009 - 2016 by the deal.II authors
//
// This file is part of the deal.II library.
//
// The deal.II library is free software; you can use it, redistribute
// it, and/or modify it under the terms of the GNU Lesser General
// Public License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// The full text of the license can be found in the file LICENSE.md at
// the top level directory of deal.II.
//
// ---------------------------------------------------------------------


/**
 * @defgroup Parallel Parallel computing
 *
 * @brief A module discussing the use of multiple processors.
 *
 * This module contains information on %parallel computing. It is
 * subdivided into parts on @ref threads and on @ref distributed.
 */


/**
 * A namespace in which we define classes and algorithms that deal
 * with running in %parallel on shared memory machines when deal.II is
 * configured to use multiple threads (see @ref threads), as well as
 * running things in %parallel on %distributed memory machines (see
 * @ref distributed).
 *
 * @ingroup threads
 * @author Wolfgang Bangerth, 2008, 2009
 */
namespace parallel
{
}
