#ifndef SEARCHWIDGET_H
#define SEARCHWIDGET_H

#include <QWidget>
#include "ui_search.h"
#include "searchtablemodel.h"
#include <rpcdriver/types.h>

/**
Contains the search widget. Implements associated operations
 
	@author Rikard Bjorklind <olof@users.sourceforge.net>
*/
class SearchWidget : public QWidget
{
    Q_OBJECT
public:
    SearchWidget(QWidget *parent = 0);
    ~SearchWidget();
	//bool isEmpty() { return model.isEmpty(); }
	
public slots:
	//! Called on arriving results
	void searchResults(int,const QList<SearchEntry>);

private:
    Ui::searchForm ui;
	SearchTableModel model;
	QMenu *contextMenu;
	
private slots:
    void on_searchButton_pressed();
    void on_searchCombo_activated(const QString&);
	void on_searchView_doubleClicked(const QModelIndex&);
	void on_hideZeroSlots_stateChanged(int);
	
	//! Downloads a file given a search result index.
	void download(const QModelIndex&);
	void downloadTo(const QModelIndex&);
	void onContextMenu(const QPoint&);
	void onContextDownload();
	void onContextDownloadTo();
	void onContextDownloadDir();
	void onContextDownloadDirTo();
	void onContextTTHSearch();
	void onContextGetFileList();
	
signals:
    void search(int session, qint64 size, int sizeMode, int typeMode, const QString& search, SearchWidget* originator);
	void downloadFile( const SearchEntry& );
	void downloadFile( int uId, const QString& file, int64 size, const QString& tth );
	void downloadFileTo( const SearchEntry&, const QString& );
	void downloadFileTo( int uId, const QString& file, int64 size, const QString& tth, const QString& dir );
	void getUserFileList(int);
};

#endif
