with Interfaces.C; use Interfaces.C;
with System;
with dbus_types_h;
with Interfaces.C.Strings;
with dbus_shared_h;
limited with dbus_errors_h;
with dbus_arch_deps_h;

package dbus_connection_h is

   --  skipped empty struct DBusWatch

   --  skipped empty struct DBusTimeout

   --  skipped empty struct DBusPreallocatedSend

   --  skipped empty struct DBusPendingCall

   --  skipped empty struct DBusConnection

   subtype DBusWatchFlags is unsigned;
   DBUS_WATCH_READABLE : constant DBusWatchFlags := 1;
   DBUS_WATCH_WRITABLE : constant DBusWatchFlags := 2;
   DBUS_WATCH_ERROR : constant DBusWatchFlags := 4;
   DBUS_WATCH_HANGUP : constant DBusWatchFlags := 8;  -- ../dbus/dbus-connection.h:72:3

   subtype DBusDispatchStatus is unsigned;
   DBUS_DISPATCH_DATA_REMAINS : constant DBusDispatchStatus := 0;
   DBUS_DISPATCH_COMPLETE : constant DBusDispatchStatus := 1;
   DBUS_DISPATCH_NEED_MEMORY : constant DBusDispatchStatus := 2;  -- ../dbus/dbus-connection.h:83:3

   type DBusAddWatchFunction is access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:90:24

   type DBusWatchToggledFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:96:24

   type DBusRemoveWatchFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:102:24

   type DBusAddTimeoutFunction is access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:109:24

   type DBusTimeoutToggledFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:116:24

   type DBusRemoveTimeoutFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:122:24

   type DBusDispatchStatusFunction is access procedure
        (arg1 : System.Address;
         arg2 : DBusDispatchStatus;
         arg3 : System.Address);  -- ../dbus/dbus-connection.h:127:24

   type DBusWakeupMainFunction is access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:134:24

   type DBusAllowUnixUserFunction is access function
        (arg1 : System.Address;
         arg2 : unsigned_long;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:142:24

   type DBusAllowWindowsUserFunction is access function
        (arg1 : System.Address;
         arg2 : Interfaces.C.Strings.chars_ptr;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:152:24

   type DBusPendingCallNotifyFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:161:17

   type DBusHandleMessageFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;  -- ../dbus/dbus-connection.h:168:30

   function dbus_connection_open (arg1 : Interfaces.C.Strings.chars_ptr; arg2 : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:172:20
   pragma Import (C, dbus_connection_open, "dbus_connection_open");

   function dbus_connection_open_private (arg1 : Interfaces.C.Strings.chars_ptr; arg2 : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:174:20
   pragma Import (C, dbus_connection_open_private, "dbus_connection_open_private");

   function dbus_connection_ref (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:176:20
   pragma Import (C, dbus_connection_ref, "dbus_connection_ref");

   procedure dbus_connection_unref (arg1 : System.Address);  -- ../dbus/dbus-connection.h:177:20
   pragma Import (C, dbus_connection_unref, "dbus_connection_unref");

   procedure dbus_connection_close (arg1 : System.Address);  -- ../dbus/dbus-connection.h:178:20
   pragma Import (C, dbus_connection_close, "dbus_connection_close");

   function dbus_connection_get_is_connected (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:179:20
   pragma Import (C, dbus_connection_get_is_connected, "dbus_connection_get_is_connected");

   function dbus_connection_get_is_authenticated (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:180:20
   pragma Import (C, dbus_connection_get_is_authenticated, "dbus_connection_get_is_authenticated");

   function dbus_connection_get_is_anonymous (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:181:20
   pragma Import (C, dbus_connection_get_is_anonymous, "dbus_connection_get_is_anonymous");

   function dbus_connection_get_server_id (arg1 : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-connection.h:182:20
   pragma Import (C, dbus_connection_get_server_id, "dbus_connection_get_server_id");

   procedure dbus_connection_set_exit_on_disconnect (arg1 : System.Address; arg2 : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:183:20
   pragma Import (C, dbus_connection_set_exit_on_disconnect, "dbus_connection_set_exit_on_disconnect");

   procedure dbus_connection_flush (arg1 : System.Address);  -- ../dbus/dbus-connection.h:185:20
   pragma Import (C, dbus_connection_flush, "dbus_connection_flush");

   function dbus_connection_read_write_dispatch (arg1 : System.Address; arg2 : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:186:20
   pragma Import (C, dbus_connection_read_write_dispatch, "dbus_connection_read_write_dispatch");

   function dbus_connection_read_write (arg1 : System.Address; arg2 : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:188:20
   pragma Import (C, dbus_connection_read_write, "dbus_connection_read_write");

   function dbus_connection_borrow_message (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:190:20
   pragma Import (C, dbus_connection_borrow_message, "dbus_connection_borrow_message");

   procedure dbus_connection_return_message (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:191:20
   pragma Import (C, dbus_connection_return_message, "dbus_connection_return_message");

   procedure dbus_connection_steal_borrowed_message (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:193:20
   pragma Import (C, dbus_connection_steal_borrowed_message, "dbus_connection_steal_borrowed_message");

   function dbus_connection_pop_message (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:195:20
   pragma Import (C, dbus_connection_pop_message, "dbus_connection_pop_message");

   function dbus_connection_get_dispatch_status (arg1 : System.Address) return DBusDispatchStatus;  -- ../dbus/dbus-connection.h:196:20
   pragma Import (C, dbus_connection_get_dispatch_status, "dbus_connection_get_dispatch_status");

   function dbus_connection_dispatch (arg1 : System.Address) return DBusDispatchStatus;  -- ../dbus/dbus-connection.h:197:20
   pragma Import (C, dbus_connection_dispatch, "dbus_connection_dispatch");

   function dbus_connection_has_messages_to_send (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:198:20
   pragma Import (C, dbus_connection_has_messages_to_send, "dbus_connection_has_messages_to_send");

   function dbus_connection_send
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : access dbus_arch_deps_h.dbus_uint32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:199:20
   pragma Import (C, dbus_connection_send, "dbus_connection_send");

   function dbus_connection_send_with_reply
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : System.Address;
      arg4 : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:202:20
   pragma Import (C, dbus_connection_send_with_reply, "dbus_connection_send_with_reply");

   function dbus_connection_send_with_reply_and_block
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : int;
      arg4 : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:206:20
   pragma Import (C, dbus_connection_send_with_reply_and_block, "dbus_connection_send_with_reply_and_block");

   function dbus_connection_set_watch_functions
     (arg1 : System.Address;
      arg2 : access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;
      arg3 : access procedure (arg1 : System.Address; arg2 : System.Address);
      arg4 : access procedure (arg1 : System.Address; arg2 : System.Address);
      arg5 : System.Address;
      arg6 : access procedure (arg1 : System.Address)) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:210:20
   pragma Import (C, dbus_connection_set_watch_functions, "dbus_connection_set_watch_functions");

   function dbus_connection_set_timeout_functions
     (arg1 : System.Address;
      arg2 : access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;
      arg3 : access procedure (arg1 : System.Address; arg2 : System.Address);
      arg4 : access procedure (arg1 : System.Address; arg2 : System.Address);
      arg5 : System.Address;
      arg6 : access procedure (arg1 : System.Address)) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:216:20
   pragma Import (C, dbus_connection_set_timeout_functions, "dbus_connection_set_timeout_functions");

   procedure dbus_connection_set_wakeup_main_function
     (arg1 : System.Address;
      arg2 : access procedure (arg1 : System.Address);
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:222:20
   pragma Import (C, dbus_connection_set_wakeup_main_function, "dbus_connection_set_wakeup_main_function");

   procedure dbus_connection_set_dispatch_status_function
     (arg1 : System.Address;
      arg2 : access procedure
        (arg1 : System.Address;
         arg2 : DBusDispatchStatus;
         arg3 : System.Address);
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:226:20
   pragma Import (C, dbus_connection_set_dispatch_status_function, "dbus_connection_set_dispatch_status_function");

   function dbus_connection_get_unix_user (arg1 : System.Address; arg2 : access unsigned_long) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:230:20
   pragma Import (C, dbus_connection_get_unix_user, "dbus_connection_get_unix_user");

   function dbus_connection_get_unix_process_id (arg1 : System.Address; arg2 : access unsigned_long) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:232:20
   pragma Import (C, dbus_connection_get_unix_process_id, "dbus_connection_get_unix_process_id");

   function dbus_connection_get_adt_audit_session_data
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:234:20
   pragma Import (C, dbus_connection_get_adt_audit_session_data, "dbus_connection_get_adt_audit_session_data");

   procedure dbus_connection_set_unix_user_function
     (arg1 : System.Address;
      arg2 : access function
        (arg1 : System.Address;
         arg2 : unsigned_long;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:237:20
   pragma Import (C, dbus_connection_set_unix_user_function, "dbus_connection_set_unix_user_function");

   function dbus_connection_get_windows_user (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:241:20
   pragma Import (C, dbus_connection_get_windows_user, "dbus_connection_get_windows_user");

   procedure dbus_connection_set_windows_user_function
     (arg1 : System.Address;
      arg2 : access function
        (arg1 : System.Address;
         arg2 : Interfaces.C.Strings.chars_ptr;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:243:20
   pragma Import (C, dbus_connection_set_windows_user_function, "dbus_connection_set_windows_user_function");

   procedure dbus_connection_set_allow_anonymous (arg1 : System.Address; arg2 : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:247:20
   pragma Import (C, dbus_connection_set_allow_anonymous, "dbus_connection_set_allow_anonymous");

   procedure dbus_connection_set_route_peer_messages (arg1 : System.Address; arg2 : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:249:20
   pragma Import (C, dbus_connection_set_route_peer_messages, "dbus_connection_set_route_peer_messages");

   function dbus_connection_add_filter
     (arg1 : System.Address;
      arg2 : access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address)) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:255:13
   pragma Import (C, dbus_connection_add_filter, "dbus_connection_add_filter");

   procedure dbus_connection_remove_filter
     (arg1 : System.Address;
      arg2 : access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;
      arg3 : System.Address);  -- ../dbus/dbus-connection.h:259:13
   pragma Import (C, dbus_connection_remove_filter, "dbus_connection_remove_filter");

   function dbus_connection_allocate_data_slot (arg1 : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:265:13
   pragma Import (C, dbus_connection_allocate_data_slot, "dbus_connection_allocate_data_slot");

   procedure dbus_connection_free_data_slot (arg1 : access dbus_arch_deps_h.dbus_int32_t);  -- ../dbus/dbus-connection.h:266:13
   pragma Import (C, dbus_connection_free_data_slot, "dbus_connection_free_data_slot");

   function dbus_connection_set_data
     (arg1 : System.Address;
      arg2 : dbus_arch_deps_h.dbus_int32_t;
      arg3 : System.Address;
      arg4 : access procedure (arg1 : System.Address)) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:267:13
   pragma Import (C, dbus_connection_set_data, "dbus_connection_set_data");

   function dbus_connection_get_data (arg1 : System.Address; arg2 : dbus_arch_deps_h.dbus_int32_t) return System.Address;  -- ../dbus/dbus-connection.h:271:13
   pragma Import (C, dbus_connection_get_data, "dbus_connection_get_data");

   procedure dbus_connection_set_change_sigpipe (arg1 : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:274:13
   pragma Import (C, dbus_connection_set_change_sigpipe, "dbus_connection_set_change_sigpipe");

   procedure dbus_connection_set_max_message_size (arg1 : System.Address; arg2 : long);  -- ../dbus/dbus-connection.h:276:6
   pragma Import (C, dbus_connection_set_max_message_size, "dbus_connection_set_max_message_size");

   function dbus_connection_get_max_message_size (arg1 : System.Address) return long;  -- ../dbus/dbus-connection.h:278:6
   pragma Import (C, dbus_connection_get_max_message_size, "dbus_connection_get_max_message_size");

   procedure dbus_connection_set_max_received_size (arg1 : System.Address; arg2 : long);  -- ../dbus/dbus-connection.h:279:6
   pragma Import (C, dbus_connection_set_max_received_size, "dbus_connection_set_max_received_size");

   function dbus_connection_get_max_received_size (arg1 : System.Address) return long;  -- ../dbus/dbus-connection.h:281:6
   pragma Import (C, dbus_connection_get_max_received_size, "dbus_connection_get_max_received_size");

   function dbus_connection_get_outgoing_size (arg1 : System.Address) return long;  -- ../dbus/dbus-connection.h:282:6
   pragma Import (C, dbus_connection_get_outgoing_size, "dbus_connection_get_outgoing_size");

   function dbus_connection_preallocate_send (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:284:23
   pragma Import (C, dbus_connection_preallocate_send, "dbus_connection_preallocate_send");

   procedure dbus_connection_free_preallocated_send (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:285:23
   pragma Import (C, dbus_connection_free_preallocated_send, "dbus_connection_free_preallocated_send");

   procedure dbus_connection_send_preallocated
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : System.Address;
      arg4 : access dbus_arch_deps_h.dbus_uint32_t);  -- ../dbus/dbus-connection.h:287:23
   pragma Import (C, dbus_connection_send_preallocated, "dbus_connection_send_preallocated");

   type DBusObjectPathUnregisterFunction is access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:299:30

   type DBusObjectPathMessageFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;  -- ../dbus/dbus-connection.h:306:30

   type DBusObjectPathVTable is record
      unregister_function : access procedure (arg1 : System.Address; arg2 : System.Address);  -- ../dbus/dbus-connection.h:318:38
      message_function : access function
           (arg1 : System.Address;
            arg2 : System.Address;
            arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;  -- ../dbus/dbus-connection.h:319:38
      dbus_internal_pad1 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:321:11
      dbus_internal_pad2 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:322:11
      dbus_internal_pad3 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:323:11
      dbus_internal_pad4 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:324:11
   end record;
   pragma Convention (C_Pass_By_Copy, DBusObjectPathVTable);  -- ../dbus/dbus-connection.h:53:16

   function dbus_connection_try_register_object_path
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : access constant DBusObjectPathVTable;
      arg4 : System.Address;
      arg5 : access dbus_errors_h.DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:327:13
   pragma Import (C, dbus_connection_try_register_object_path, "dbus_connection_try_register_object_path");

   function dbus_connection_register_object_path
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : access constant DBusObjectPathVTable;
      arg4 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:333:13
   pragma Import (C, dbus_connection_register_object_path, "dbus_connection_register_object_path");

   function dbus_connection_try_register_fallback
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : access constant DBusObjectPathVTable;
      arg4 : System.Address;
      arg5 : access dbus_errors_h.DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:338:13
   pragma Import (C, dbus_connection_try_register_fallback, "dbus_connection_try_register_fallback");

   function dbus_connection_register_fallback
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : access constant DBusObjectPathVTable;
      arg4 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:344:13
   pragma Import (C, dbus_connection_register_fallback, "dbus_connection_register_fallback");

   function dbus_connection_unregister_object_path (arg1 : System.Address; arg2 : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:348:13
   pragma Import (C, dbus_connection_unregister_object_path, "dbus_connection_unregister_object_path");

   function dbus_connection_get_object_path_data
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:351:13
   pragma Import (C, dbus_connection_get_object_path_data, "dbus_connection_get_object_path_data");

   function dbus_connection_list_registered
     (arg1 : System.Address;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:355:13
   pragma Import (C, dbus_connection_list_registered, "dbus_connection_list_registered");

   function dbus_connection_get_unix_fd (arg1 : System.Address; arg2 : access int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:359:13
   pragma Import (C, dbus_connection_get_unix_fd, "dbus_connection_get_unix_fd");

   function dbus_connection_get_socket (arg1 : System.Address; arg2 : access int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:361:13
   pragma Import (C, dbus_connection_get_socket, "dbus_connection_get_socket");

   function dbus_watch_get_fd (arg1 : System.Address) return int;  -- ../dbus/dbus-connection.h:373:21
   pragma Import (C, dbus_watch_get_fd, "dbus_watch_get_fd");

   function dbus_watch_get_unix_fd (arg1 : System.Address) return int;  -- ../dbus/dbus-connection.h:376:14
   pragma Import (C, dbus_watch_get_unix_fd, "dbus_watch_get_unix_fd");

   function dbus_watch_get_socket (arg1 : System.Address) return int;  -- ../dbus/dbus-connection.h:377:14
   pragma Import (C, dbus_watch_get_socket, "dbus_watch_get_socket");

   function dbus_watch_get_flags (arg1 : System.Address) return unsigned;  -- ../dbus/dbus-connection.h:378:14
   pragma Import (C, dbus_watch_get_flags, "dbus_watch_get_flags");

   function dbus_watch_get_data (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:379:14
   pragma Import (C, dbus_watch_get_data, "dbus_watch_get_data");

   procedure dbus_watch_set_data
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:380:14
   pragma Import (C, dbus_watch_set_data, "dbus_watch_set_data");

   function dbus_watch_handle (arg1 : System.Address; arg2 : unsigned) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:383:14
   pragma Import (C, dbus_watch_handle, "dbus_watch_handle");

   function dbus_watch_get_enabled (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:385:14
   pragma Import (C, dbus_watch_get_enabled, "dbus_watch_get_enabled");

   function dbus_timeout_get_interval (arg1 : System.Address) return int;  -- ../dbus/dbus-connection.h:394:13
   pragma Import (C, dbus_timeout_get_interval, "dbus_timeout_get_interval");

   function dbus_timeout_get_data (arg1 : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:395:13
   pragma Import (C, dbus_timeout_get_data, "dbus_timeout_get_data");

   procedure dbus_timeout_set_data
     (arg1 : System.Address;
      arg2 : System.Address;
      arg3 : access procedure (arg1 : System.Address));  -- ../dbus/dbus-connection.h:396:13
   pragma Import (C, dbus_timeout_set_data, "dbus_timeout_set_data");

   function dbus_timeout_handle (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:399:13
   pragma Import (C, dbus_timeout_handle, "dbus_timeout_handle");

   function dbus_timeout_get_enabled (arg1 : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:400:13
   pragma Import (C, dbus_timeout_get_enabled, "dbus_timeout_get_enabled");

end dbus_connection_h;
