/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2010  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4oUnit.Extensions;
using Db4oUnit.Extensions.Fixtures;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Internal.Slots;
using Db4objects.Db4o.Tests.Common.Freespace;

namespace Db4objects.Db4o.Tests.Common.Freespace
{
	public class FreespaceManagerReopenTestCase : AbstractDb4oTestCase, IOptOutMultiSession
		, IOptOutDefragSolo, IOptOutNonStandardBlockSize
	{
		private static int Size = 199331;

		public static void Main(string[] args)
		{
			new FreespaceManagerReopenTestCase().RunSolo();
		}

		/// <exception cref="System.Exception"></exception>
		protected override void Configure(IConfiguration config)
		{
			base.Configure(config);
			config.BTreeNodeSize(4);
		}

		/// <exception cref="System.Exception"></exception>
		public virtual void Test()
		{
			Slot testSlot = LocalContainer().AllocateSlot(Size);
			Slot reserveSlot = LocalContainer().AllocateSlot(Size / 2);
			Reopen();
			LocalContainer().Free(testSlot);
			LocalContainer().Free(reserveSlot);
			Reopen();
			Slot slot1 = LocalContainer().AllocateSlot(Size);
			Assert.IsTrue(Overlap(testSlot, slot1));
			Reopen();
			Slot slot2 = LocalContainer().AllocateSlot(Size);
			Assert.IsFalse(Overlap(testSlot, slot2));
		}

		private bool Overlap(Slot slot, Slot other)
		{
			Slot first = slot.Address() < other.Address() ? slot : other;
			Slot second = slot.Address() > other.Address() ? slot : other;
			return first.Address() + first.Length() >= second.Address();
		}

		private LocalObjectContainer LocalContainer()
		{
			return ((LocalObjectContainer)Db());
		}
	}
}
