module Test.Maybench.Utils where

import Data.Monoid (Monoid,mappend)

infixr 5 <|
infixl 5 |>

class ConsLeft f where
  (<|) :: a -> f a -> f a

class ConsRight f where
  (|>) :: f a -> a -> f a

instance ConsLeft [] where
  (<|) = (:)

instance ConsRight [] where
  xs |> x = xs ++ [x]

infix 5 <++>
(<++>) :: Monoid a => a -> a -> a
(<++>) = mappend

list :: b -> (a -> [a] -> b) -> [a] -> b
list nil _    []     = nil
list _   cons (x:xs) = cons x xs

fromList :: a -> [a] -> a
fromList _   [x] = x
fromList def _   = def
