/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 shigeo
 *	special thanks to Keiichi SAKAI, URURI
 */

/*
 *	99/05/13 3D Now!Ή by shigeo
 *	mdct[`2.3{̍(640000clk -> 288000clk)
 *	Ŝł͖7%̍
 *	99/05/17 PENƂ̃\[X̓
 *	܂ǂ̗]nL(1͗]TŏoƎv)
 *
 *	tableInitForMDCT()ŏɌĂԂƂYȂ!!!
 *	99/08/10
 *	LAMẼ\[XƓ
 *	LAMEmdctȂ葬̂ŋ
 *	99/09/02 
 *	mdct_SSE, mdct_FPU쐬
 *	99/09/02()
 *	mdct_CASM̂mdct_C̃e[uOɏoB
 *	e[uinit_mdct()ɈړB
 *	mdct_FPU쐬
 *	99/09/03()
 *	mdct_3DN쐬
 *	99/09/29(sakai)
 *	arb_SSE쐬
 *	99/10/03(shigeo)
 *	arb_3DN쐬
 *	99/10/17()
 *	mdct_sub_{3DN,FPU}full asm(3DN 110k clk)
 */

#include "common.h"
#include "mdct.h"
#include "haveunit.h"

void mdct_sub_SSE(L3SBS (*sb_sample), float (*mdct_freq)[2][576], int stereo, III_side_info_t *l3_side, int mode_gr);
void mdct_sub_3DN(L3SBS (*sb_sample), float (*mdct_freq)[2][576], int stereo, III_side_info_t *l3_side, int mode_gr);
void mdct_sub_FPU(L3SBS (*sb_sample), float (*mdct_freq)[2][576], int stereo, III_side_info_t *l3_side, int mode_gr);

/* defined in msubtbl.nas */
extern void (*mdct)( float *in, float *out, int block_type );

void mdct_3DN(float *in, float *out, int block_type);/*avg550clk*/
#ifdef USE_E3DN
void mdct_E3DN(float *in, float *out, int block_type);
#endif

extern float ca_arb[8], cs_arb[8];
extern float csa_arb_3DN[8*4];
/*
 * csa[1:0]=s[0:1]
 * csa[3:2]=a[0:1]
 * csa[5:4]=s[1:0]
 * csa[7:6]=a[1:0]
 * csa[9:8]=s[2:3],...
 */

extern float win_mdct[4][36];
extern float cos_s_mdct[6][12];
extern float cos_l_mdct[18][18];

/* aliasing reduction butterfly */
/* 4500[clk]@PIII */

void setup_mdct(int useUNIT)
{
	if(useUNIT & t3DN){
		SETUP_DSP("use:mdct_sub_3DN\n");
		mdct_sub = mdct_sub_3DN;
#ifdef USE_E3DN
		if( useUNIT & tE3DN ){
			SETUP_DSP("use:mdct_E3DN\n");
			mdct = mdct_E3DN;
		}else
#endif
		{
			SETUP_DSP("use:mdct_3DN\n");
			mdct = mdct_3DN;
		}
	}else
	if(useUNIT & tSSE){
		SETUP_DSP("use:mdct_sub_SSE\n");	// 77k[clk]
		mdct_sub = mdct_sub_SSE;
	}else
	{
        SETUP_DSP("use:mdct_sub_FPU\n");
        mdct_sub = mdct_sub_FPU;
	}
}

/*
 *	mdctŎg߂̃e[u쐬
 */

void init_mdct_3DN(void){
	int k,i,m,N;

    /* type 0 */
    for ( i = 0; i < 36; i++ )
		win_mdct[0][i] = sin( PI/36 * (i + 0.5) );
    /* type 1*/
    for ( i = 0; i < 18; i++ ) 
		win_mdct[1][i] = sin( PI/36 * (i + 0.5) );
    for ( i = 18; i < 24; i++ )
		win_mdct[1][i] = 1.0;
    for ( i = 24; i < 30; i++ )
		win_mdct[1][i] = sin( PI/12 * ( i + 0.5 - 18) );
    for ( i = 30; i < 36; i++ )
		win_mdct[1][i] = 0.0;
    /* type 3*/
    for ( i = 0; i < 6; i++ )
		win_mdct[3][i] = 0.0;
    for ( i = 6; i < 12; i++ ) 
		win_mdct[3][i] = sin( PI/12 * (i + 0.5 - 6) );
    for ( i = 12; i < 18; i++ )
		win_mdct[3][i] = 1.0;
    for ( i = 18; i < 36; i++ )
		win_mdct[3][i] = sin( PI/36 * (i + 0.5) );

    N = 12;
    for ( m = 0; m < N / 2; m++ )
      for ( k = 0; k < N; k++ )
			cos_s_mdct[m][k] = cos( (PI /(2 * N)) * (2 * k + 1 + N / 2) *
				(2 * m + 1) ) / (N / 4) * sin( PI/12 * (k + 0.5) );

    N = 36;
	for ( m = 0; m < N / 2; m++ ){
		for ( k = 0; k < 9; k++ ){
			cos_l_mdct[m][k] = cos( (PI / (2 * N)) * (2 * k + 1 + N / 2) *
				(2 * m + 1) ) / (N / 4);
			cos_l_mdct[m][9+k] = cos( (PI / (2 * N)) * (2 * (18 + k) + 1 + N / 2) *
                     (2 * m + 1) ) / (N / 4);
		}
	}
}

/*
 *	sOɂ̊֐ĂԂƂYȂ!!!
 */

void tableInitForMDCT(void){
	int k;
	float c[8] = { -0.6,-0.535,-0.33,-0.185,-0.095,-0.041,-0.0142, -0.0037 };
	for ( k = 0; k < 8; k++ ){
	    double sq;
	    sq = sqrt( 1.0 + c[k] * c[k] );
	    ca_arb[k] = c[k] / sq;
	    cs_arb[k] = 1.0 / sq;
	}
	for( k = 0; k < 4; k++ ){
		float s_l,s_h,a_l,a_h;
		s_l = cs_arb[k*2+0];
		s_h = cs_arb[k*2+1];
		a_l = ca_arb[k*2+0];
		a_h = ca_arb[k*2+1];
		csa_arb_3DN[0+k*8] = s_h;
		csa_arb_3DN[1+k*8] = s_l;
		csa_arb_3DN[2+k*8] = a_h;
		csa_arb_3DN[3+k*8] = a_l;

		csa_arb_3DN[4+k*8] = s_l;
		csa_arb_3DN[5+k*8] = s_h;
		csa_arb_3DN[6+k*8] = a_l;
		csa_arb_3DN[7+k*8] = a_h;
	}
	init_mdct_3DN();
}
