/* image.c generated by valac 0.40.4, the Vala compiler
 * generated from image.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* XPM */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};


extern cairo_surface_t* background_surface;
cairo_surface_t* background_surface = NULL;

gboolean is_color_parsable (const gchar* spec);
void parse_color (const gchar* spec,
                  GdkRGBA* result);
void fetch_color (const gchar* spec,
                  GdkRGBA* result);
void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
#define MIN_SCALED_WIDTH 10
#define MIN_SCALED_HEIGHT 10
GdkPixbuf* get_placeholder_pixbuf (void);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
void dimensions_get_scaled (Dimensions *self,
                            gint scale,
                            gboolean scale_up,
                            Dimensions* result);
void dimensions_with_min (Dimensions *self,
                          gint min_width,
                          gint min_height,
                          Dimensions* result);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
#define DEGREE (G_PI / 180.0)
void draw_rounded_corners_filled (cairo_t* ctx,
                                  Dimensions* dim,
                                  GdkPoint* origin,
                                  gdouble radius_proportion);
void context_rounded_corners (cairo_t* cx,
                              Dimensions* dim,
                              GdkPoint* origin,
                              gdouble radius_proportion);
gint dimensions_minor_axis (Dimensions *self);
guchar shift_color_byte (gint b,
                         gint shift);
void shift_colors (GdkPixbuf* pixbuf,
                   gint red,
                   gint green,
                   gint blue,
                   gint alpha);
gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
gboolean rectangles_equal (GdkRectangle* a,
                           GdkRectangle* b);
gchar* rectangle_to_string (GdkRectangle* rect);
void clamp_rectangle (GdkRectangle* original,
                      Dimensions* max,
                      GdkRectangle* result);
void scale_point (GdkPoint* p,
                  gdouble factor,
                  GdkPoint* result);
void add_points (GdkPoint* p1,
                 GdkPoint* p2,
                 GdkPoint* result);
void subtract_points (GdkPoint* p1,
                      GdkPoint* p2,
                      GdkPoint* result);
void fix_cairo_pixbuf (GdkPixbuf* pixbuf);
void compute_arb_rotated_size (gdouble src_width,
                               gdouble src_height,
                               gdouble angle,
                               gdouble* dest_width,
                               gdouble* dest_height);
gdouble degrees_to_radians (gdouble theta);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf,
                       gdouble angle);
void rotate_point_arb (GdkPoint* source_point,
                       gint img_w,
                       gint img_h,
                       gdouble angle,
                       gboolean invert,
                       GdkPoint* result);
void derotate_point_arb (GdkPoint* source_point,
                         gint img_w,
                         gint img_h,
                         gdouble angle,
                         GdkPoint* result);
cairo_surface_t* get_background_surface (void);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
void invalidate_transparent_background (void);
void paint_pixmap_with_background (cairo_t* ctx,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void clamp_inside_rotated_image (Box* src,
                                 gint img_w,
                                 gint img_h,
                                 gdouble angle_deg,
                                 gboolean preserve_geom,
                                 Box* result);
void box_get_offset (Box *self,
                     gint xofs,
                     gint yofs,
                     Box* result);
void box_init (Box *self,
               gint left,
               gint top,
               gint right,
               gint bottom);

const gchar* fallback_image_missing[103] = {"48 48 54 1 ", "  c #6A6D67", ". c #6C6E69", "X c #72746F", "o c #747672", "O c #777974", "+ c #797B77", "@ c #7C7E7A", "# c #7F817C", "$ c #81837F", "% c #848682", "& c #878984", "* c #888A86", "= c #8C8D8A", "- c #8F908C", "; c #90928E", ": c #949591", "> c #969894", ", c #999B96", "< c #9C9E9A", "1 c #9FA09C", "2 c #A1A39E", "3 c #A4A6A2", "4 c #A6A9A4", "5 c #A9ABA6", "6 c #ACADA9", "7 c #AEB1AB", "8 c #B1B2AF", "9 c #B3B4B1", "0 c #B6B9B3", "q c #B9BCB6", "w c #BDBEBA", "e c #BEC2BB", "r c #C1C4BE", "t c #C5C5C2", "y c #C6C9C3", "u c #C9CCC6", "i c #CCCDCB", "p c #CED2CA", "a c #D2D6CE", "s c #D5D5D3", "d c #D7D8D5", "f c #D9D9D6", "g c #DCDCDA", "h c #DFE0DD", "j c #E0E0DE", "k c #E4E4E2", "l c #E7E8E5", "z c #E9E9E7", "x c #EDEDEC", "c c #EFF0EE", "v c #F1F1EF", "b c #F2F2F1", "n c #FFFFFF", "m c None", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmaaaaaaaaaasaisaaaaaaaaaaaaaaaaaaapppiipuuuuumm", "mannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnym", "manbbbbbbbbbvbbvvvvxvvvbvvvvvvvvccccccxxvxvxxnym", "manbt89898888988888888888999999999999999999txnrm", "manb6======================-;;=;;;;;;;;;;=:7znrm", "manv6&%%**%*%%%%*%%****=======;==;;;;=;=;==7znem", "manv4%%%%$%%%%%%%%%%%=****=======;==-======6znwm", "manx3%%#$$$$##%#$%%%*%**==========-=--=====6znqm", "manx1$@%#$@$###%%%%=****=*===--;;----====*=5lnqm", "manx<@@@@@@@@##%$%%%%****========-==-======5kn0m", "manz<@@@+@+@@@#$%%%%%=%=%===;=:=--------=-*4kn8m", "manz>O+O+O+@@@#$$%%%%========;;=--------=*=3kn9m", "mpnl:OOOOO+@@$##%%%%%=%=====;=;;--;-----===3kn8m", "munl;OooOOO@@@#$%%%%%======;;;;;:;;;;;---==1hn7m", "munl;oXoOO+@###$%%=%=======;::;::::;;---&#+-gn7m", "mynk*XXooOO+$$#$%%%%=%===;;:;:::::;:-$#XooX-fn5m", "mynk*XXOOO@@$$$$%%=%====;::::>::;*#OXXXXXXX*dn5m", "mrnk*oOO@@@#$$$$%=====::::>>>=%@OXOooXXXooo&dn3m", "mrnj*++@$$$$**$===-;;::>>:=@Ooo@XOOoo#o#OOO=fn3m", "menj*@#$$$$$**===;;:::=%@@@@@@O@#O#Oo#o#++@;gn2m", "menj*$$$$&**===;:;=*#@@@@@@@@@@@#######o##%>gn2m", "menh*$$%**===;=*%###########%@@@###$####$%=,gn1m", "m0nj=%***=**&$$$%$$$%$$%$$$$%$$$$$$$$$$%*;:2hn<m", "m0nj****&&&$$&&$%%%%%%%%%%%%%%%%$$*$%%%*;>13gn,m", "m0ng****&&&&&&&&&&&&*%*%*%%*%******%**-:,136kz;m", "m0nh***$&&&&&&&&&&&&%**********%*$***;:,1358r7*m", "m8ng*&&&&&&&&&*$&*&&&&$=$=$=&&&&&&**=:,<11>$65mm", "m7ng*&&&&&&&&&**&&&&&&**=$-$&&&&&&*-:,1..&1wi:mm", "m7ng&&&&&&&&=$*$&&&&&***$$$$&&&***=>,1<onxsi6*mm", "m6nf*&&&&&*&$***&&&&*$*$--$-&&&%*=;,13,:ztw9%mmm", "m5nf*%&&&&&&=$=$%*&&**%*$$&&&&**=>,225;5srw%mmmm", "m4nf3*&&**&&$-$-*******%$;&&*&*->,2365+ui7$mmmmm", "m3nsfffdddsddaffssssdassgaaaassddfgjg4wu;ommmmmm", "m3nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnvq3<$.mmmmmmm", "mm2211111,<,,,,,,>>>>:::;::;----=====@mmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm"};

gboolean
is_color_parsable (const gchar* spec)
{
	gboolean result = FALSE;
	GdkRGBA color = {0};
#line 117 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (spec != NULL, FALSE);
#line 118 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	result = gdk_rgba_parse (&color, spec);
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 206 "image.c"
}


void
parse_color (const gchar* spec,
             GdkRGBA* result)
{
	GdkRGBA _tmp0_ = {0};
#line 122 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (spec, &_tmp0_);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp0_;
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 223 "image.c"
}


void
fetch_color (const gchar* spec,
             GdkRGBA* result)
{
	GdkRGBA rgba = {0};
#line 126 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 127 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	if (!gdk_rgba_parse (&rgba, spec)) {
#line 129 "/home/jens/Source/shotwell/src/util/image.vala"
		g_error ("image.vala:129: Can't parse color %s", spec);
#line 240 "image.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rgba;
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 246 "image.c"
}


void
set_source_color_from_string (cairo_t* ctx,
                              const gchar* spec)
{
	GdkRGBA rgba = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_;
	gdouble _tmp2_;
	GdkRGBA _tmp3_;
	gdouble _tmp4_;
	GdkRGBA _tmp5_;
	gdouble _tmp6_;
	GdkRGBA _tmp7_;
	gdouble _tmp8_;
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (spec, &_tmp0_);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	rgba = _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.red;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.green;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.blue;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.alpha;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgba (ctx, _tmp2_, _tmp4_, _tmp6_, _tmp8_);
#line 290 "image.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
	return self ? g_object_ref (self) : NULL;
#line 299 "image.c"
}


GdkPixbuf*
get_placeholder_pixbuf (void)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/util/image.vala"
	pixbuf = NULL;
#line 311 "image.c"
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp0_;
		GtkIconTheme* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = gtk_icon_theme_get_default ();
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		icon_theme = _tmp1_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = gtk_icon_theme_load_icon (icon_theme, "image-missing", (gint) GTK_ICON_SIZE_DIALOG, 0, &_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp3_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
			_g_object_unref0 (icon_theme);
#line 333 "image.c"
			goto __catch4_g_error;
		}
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = _tmp2_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (icon_theme);
#line 348 "image.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GdkPixbuf* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_error_ = _inner_error_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_inner_error_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = gdk_pixbuf_new_from_xpm_data (fallback_image_missing);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _error_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = _tmp6_->message;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		g_warning ("image.vala:152: Could not load icon from theme: %s", _tmp7_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_error_free0 (_error_);
#line 375 "image.c"
	}
	__finally4:
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		return NULL;
#line 388 "image.c"
	}
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	result = pixbuf;
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 394 "image.c"
}


GdkPixbuf*
scale_pixbuf (GdkPixbuf* pixbuf,
              gint scale,
              GdkInterpType interp,
              gboolean scale_up)
{
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	Dimensions _tmp0_ = {0};
	Dimensions scaled = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_;
	gint _tmp6_;
	Dimensions _tmp12_ = {0};
	Dimensions _tmp13_;
	gint _tmp14_;
	Dimensions _tmp15_;
	gint _tmp16_;
	GdkPixbuf* _tmp17_;
#line 158 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (pixbuf, &_tmp0_);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp0_;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_get_scaled (&original, scale, scale_up, &_tmp1_);
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 440 "image.c"
		Dimensions _tmp7_;
		gint _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 455 "image.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 459 "image.c"
	}
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 463 "image.c"
		GdkPixbuf* _tmp11_;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = _g_object_ref0 (pixbuf);
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp11_;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 471 "image.c"
	}
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (&scaled, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp12_);
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp12_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = _tmp13_.width;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.height;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = gdk_pixbuf_scale_simple (pixbuf, _tmp14_, _tmp16_, interp);
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp17_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 491 "image.c"
}


GdkPixbuf*
resize_pixbuf (GdkPixbuf* pixbuf,
               Dimensions* resized,
               GdkInterpType interp)
{
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	Dimensions _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_;
	gint _tmp5_;
	Dimensions _tmp11_ = {0};
	Dimensions _tmp12_;
	gint _tmp13_;
	Dimensions _tmp14_;
	gint _tmp15_;
	GdkPixbuf* _tmp16_;
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (resized != NULL, NULL);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (pixbuf, &_tmp0_);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp3_ == _tmp5_) {
#line 532 "image.c"
		Dimensions _tmp6_;
		gint _tmp7_;
		Dimensions _tmp8_;
		gint _tmp9_;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = _tmp6_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = _tmp8_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp7_ == _tmp9_;
#line 547 "image.c"
	} else {
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 551 "image.c"
	}
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 555 "image.c"
		GdkPixbuf* _tmp10_;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _g_object_ref0 (pixbuf);
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp10_;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 563 "image.c"
	}
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (resized, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp11_);
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	*resized = _tmp11_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.width;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = _tmp14_.height;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = gdk_pixbuf_scale_simple (pixbuf, _tmp13_, _tmp15_, interp);
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp16_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 583 "image.c"
}


void
draw_rounded_corners_filled (cairo_t* ctx,
                             Dimensions* dim,
                             GdkPoint* origin,
                             gdouble radius_proportion)
{
	Dimensions _tmp0_;
	GdkPoint _tmp1_;
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *dim;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *origin;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	context_rounded_corners (ctx, &_tmp0_, &_tmp1_, radius_proportion);
#line 186 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (ctx);
#line 609 "image.c"
}


void
context_rounded_corners (cairo_t* cx,
                         Dimensions* dim,
                         GdkPoint* origin,
                         gdouble radius_proportion)
{
	gdouble left = 0.0;
	GdkPoint _tmp0_;
	gint _tmp1_;
	gdouble top = 0.0;
	GdkPoint _tmp2_;
	gint _tmp3_;
	gdouble right = 0.0;
	GdkPoint _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	gdouble bottom = 0.0;
	GdkPoint _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_;
	gint _tmp11_;
	gdouble radius = 0.0;
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (cx != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	radius_proportion = CLAMP (radius_proportion, 2.0, 100.0);
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *origin;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	left = (gdouble) _tmp1_;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *origin;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.y;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	top = (gdouble) _tmp3_;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *origin;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.x;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *dim;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.width;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	right = (gdouble) (_tmp5_ + _tmp7_);
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = *origin;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.y;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *dim;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.height;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = (gdouble) (_tmp9_ + _tmp11_);
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	radius = ((gdouble) dimensions_minor_axis (dim)) / radius_proportion;
#line 204 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_move_to (cx, left, top);
#line 205 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (cx, right - radius, top + radius, radius, -90 * DEGREE, 0 * DEGREE);
#line 206 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (cx, right - radius, bottom - radius, radius, 0 * DEGREE, 90 * DEGREE);
#line 207 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (cx, left + radius, bottom - radius, radius, 90 * DEGREE, 180 * DEGREE);
#line 208 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (cx, left + radius, top + radius, radius, 180 * DEGREE, 270 * DEGREE);
#line 209 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_clip (cx);
#line 690 "image.c"
}


inline guchar
shift_color_byte (gint b,
                  gint shift)
{
	guchar result = '\0';
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	result = (guchar) CLAMP (b + shift, 0, 255);
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 703 "image.c"
}


void
shift_colors (GdkPixbuf* pixbuf,
              gint red,
              gint green,
              gint blue,
              gint alpha)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint width = 0;
	gint height = 0;
	gint rowstride = 0;
	gint channels = 0;
	guchar* pixels = NULL;
	guint8* _tmp4_;
	gint _tmp5_;
#line 216 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	if (red >= -255) {
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = red <= 255;
#line 731 "image.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 735 "image.c"
	}
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp0_, "red >= -255 && red <= 255");
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	if (green >= -255) {
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = green <= 255;
#line 743 "image.c"
	} else {
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 747 "image.c"
	}
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp1_, "green >= -255 && green <= 255");
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	if (blue >= -255) {
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = blue <= 255;
#line 755 "image.c"
	} else {
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 759 "image.c"
	}
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp2_, "blue >= -255 && blue <= 255");
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	if (alpha >= -255) {
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = alpha <= 255;
#line 767 "image.c"
	} else {
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = FALSE;
#line 771 "image.c"
	}
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp3_, "alpha >= -255 && alpha <= 255");
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	width = gdk_pixbuf_get_width (pixbuf);
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	height = gdk_pixbuf_get_height (pixbuf);
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	channels = gdk_pixbuf_get_n_channels (pixbuf);
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = gdk_pixbuf_get_pixels (pixbuf);
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	pixels = _tmp4_;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = channels;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp5_ >= 3, "channels >= 3");
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (gdk_pixbuf_get_colorspace (pixbuf) == GDK_COLORSPACE_RGB, "pixbuf.get_colorspace() == Gdk.Colorspace.RGB");
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (gdk_pixbuf_get_bits_per_sample (pixbuf) == 8, "pixbuf.get_bits_per_sample() == 8");
#line 795 "image.c"
	{
		gint y = 0;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
		y = 0;
#line 800 "image.c"
		{
			gboolean _tmp6_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp6_ = TRUE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 807 "image.c"
				gint _tmp8_;
				gint _tmp9_;
				gint y_offset = 0;
				gint _tmp10_;
				gint _tmp11_;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp6_) {
#line 815 "image.c"
					gint _tmp7_;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp7_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					y = _tmp7_ + 1;
#line 821 "image.c"
				}
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp6_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp8_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp9_ = height;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 833 "image.c"
				}
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp10_ = y;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp11_ = rowstride;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				y_offset = _tmp10_ * _tmp11_;
#line 841 "image.c"
				{
					gint x = 0;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
					x = 0;
#line 846 "image.c"
					{
						gboolean _tmp12_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						_tmp12_ = TRUE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						while (TRUE) {
#line 853 "image.c"
							gint _tmp14_;
							gint _tmp15_;
							gint offset = 0;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gboolean _tmp37_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!_tmp12_) {
#line 863 "image.c"
								gint _tmp13_;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp13_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								x = _tmp13_ + 1;
#line 869 "image.c"
							}
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp12_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp14_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp15_ = width;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!(_tmp14_ < _tmp15_)) {
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								break;
#line 881 "image.c"
							}
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp16_ = y_offset;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp17_ = x;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp18_ = channels;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							offset = _tmp16_ + (_tmp17_ * _tmp18_);
#line 238 "/home/jens/Source/shotwell/src/util/image.vala"
							if (red != 0) {
#line 893 "image.c"
								guchar* _tmp19_;
								gint _tmp20_;
								guchar* _tmp21_;
								gint _tmp22_;
								guchar _tmp23_;
								guchar _tmp24_;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp19_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp20_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp21_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp22_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp23_ = _tmp21_[_tmp22_];
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp19_[_tmp20_] = shift_color_byte ((gint) _tmp23_, red);
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp24_ = _tmp19_[_tmp20_];
#line 914 "image.c"
							}
#line 241 "/home/jens/Source/shotwell/src/util/image.vala"
							if (green != 0) {
#line 918 "image.c"
								guchar* _tmp25_;
								gint _tmp26_;
								guchar* _tmp27_;
								gint _tmp28_;
								guchar _tmp29_;
								guchar _tmp30_;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp25_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp26_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp27_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp28_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp29_ = _tmp27_[_tmp28_ + 1];
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp25_[_tmp26_ + 1] = shift_color_byte ((gint) _tmp29_, green);
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp30_ = _tmp25_[_tmp26_ + 1];
#line 939 "image.c"
							}
#line 244 "/home/jens/Source/shotwell/src/util/image.vala"
							if (blue != 0) {
#line 943 "image.c"
								guchar* _tmp31_;
								gint _tmp32_;
								guchar* _tmp33_;
								gint _tmp34_;
								guchar _tmp35_;
								guchar _tmp36_;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp31_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp32_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp33_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp34_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp35_ = _tmp33_[_tmp34_ + 2];
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp31_[_tmp32_ + 2] = shift_color_byte ((gint) _tmp35_, blue);
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp36_ = _tmp31_[_tmp32_ + 2];
#line 964 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (alpha != 0) {
#line 968 "image.c"
								gint _tmp38_;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp38_ = channels;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp37_ = _tmp38_ >= 4;
#line 974 "image.c"
							} else {
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp37_ = FALSE;
#line 978 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp37_) {
#line 982 "image.c"
								guchar* _tmp39_;
								gint _tmp40_;
								guchar* _tmp41_;
								gint _tmp42_;
								guchar _tmp43_;
								guchar _tmp44_;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp39_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp40_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp41_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp42_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp43_ = _tmp41_[_tmp42_ + 3];
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp39_[_tmp40_ + 3] = shift_color_byte ((gint) _tmp43_, alpha);
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp44_ = _tmp39_[_tmp40_ + 3];
#line 1003 "image.c"
							}
						}
					}
				}
			}
		}
	}
}


gboolean
coord_in_rectangle (gint x,
                    gint y,
                    GdkRectangle* rect)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_;
	gint _tmp4_;
#line 253 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, FALSE);
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (x >= _tmp4_) {
#line 1033 "image.c"
		GdkRectangle _tmp5_;
		gint _tmp6_;
		GdkRectangle _tmp7_;
		gint _tmp8_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _tmp5_.x;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.width;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = x < (_tmp6_ + _tmp8_);
#line 1048 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1052 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1056 "image.c"
		GdkRectangle _tmp9_;
		gint _tmp10_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = y >= _tmp10_;
#line 1065 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1069 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1073 "image.c"
		GdkRectangle _tmp11_;
		gint _tmp12_;
		GdkRectangle _tmp13_;
		gint _tmp14_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _tmp11_.y;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = *rect;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = _tmp13_.height;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = y <= (_tmp12_ + _tmp14_);
#line 1088 "image.c"
	} else {
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1092 "image.c"
	}
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1098 "image.c"
}


gboolean
rectangles_equal (GdkRectangle* a,
                  GdkRectangle* b)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.x;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 1128 "image.c"
		GdkRectangle _tmp7_;
		gint _tmp8_;
		GdkRectangle _tmp9_;
		gint _tmp10_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.y;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.y;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 1143 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1147 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1151 "image.c"
		GdkRectangle _tmp11_;
		gint _tmp12_;
		GdkRectangle _tmp13_;
		gint _tmp14_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _tmp11_.width;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = _tmp13_.width;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp12_ == _tmp14_;
#line 1166 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1170 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1174 "image.c"
		GdkRectangle _tmp15_;
		gint _tmp16_;
		GdkRectangle _tmp17_;
		gint _tmp18_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = *a;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = _tmp15_.height;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = *b;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = _tmp17_.height;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp16_ == _tmp18_;
#line 1189 "image.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1193 "image.c"
	}
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1199 "image.c"
}


gchar*
rectangle_to_string (GdkRectangle* rect)
{
	gchar* result = NULL;
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
#line 261 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, NULL);
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.width;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.height;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = g_strdup_printf ("%d,%d %dx%d", _tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp8_;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1240 "image.c"
}


void
clamp_rectangle (GdkRectangle* original,
                 Dimensions* max,
                 GdkRectangle* result)
{
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_;
	gint _tmp11_;
	GdkRectangle _tmp12_;
	gint _tmp13_;
	Dimensions _tmp14_;
	gint _tmp15_;
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (original != NULL);
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (max != NULL);
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *original;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *max;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.width;
#line 267 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.x = CLAMP (_tmp1_, 0, _tmp3_);
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *original;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.y;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *max;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.height;
#line 268 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.y = CLAMP (_tmp5_, 0, _tmp7_);
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = *original;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.width;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *max;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.width;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.width = CLAMP (_tmp9_, 0, _tmp11_);
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *original;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.height;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = *max;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = _tmp14_.height;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.height = CLAMP (_tmp13_, 0, _tmp15_);
#line 272 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rect;
#line 272 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1316 "image.c"
}


void
scale_point (GdkPoint* p,
             gdouble factor,
             GdkPoint* result)
{
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p != NULL);
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = (gint) ((factor * _tmp2_) + 0.5);
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.y;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = (gint) ((factor * _tmp4_) + 0.5);
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1353 "image.c"
}


void
add_points (GdkPoint* p1,
            GdkPoint* p2,
            GdkPoint* result)
{
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
#line 283 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 283 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ + _tmp4_;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ + _tmp8_;
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1404 "image.c"
}


void
subtract_points (GdkPoint* p1,
                 GdkPoint* p2,
                 GdkPoint* result)
{
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ - _tmp4_;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ - _tmp8_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1455 "image.c"
}


void
fix_cairo_pixbuf (GdkPixbuf* pixbuf)
{
	guchar* gdk_pixels = NULL;
	void* _tmp0_;
	void* _tmp1_;
#line 300 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = gdk_pixbuf_get_pixels (pixbuf);
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_pixels = _tmp1_;
#line 1473 "image.c"
	{
		gint j = 0;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
		j = 0;
#line 1478 "image.c"
		{
			gboolean _tmp2_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp2_ = TRUE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 1485 "image.c"
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				guchar* p = NULL;
				guchar* _tmp7_;
				guchar* end = NULL;
				guchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				guchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp2_) {
#line 1500 "image.c"
					gint _tmp3_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp3_ = j;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					j = _tmp3_ + 1;
#line 1506 "image.c"
				}
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp2_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp4_ = j;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp5_ = gdk_pixbuf_get_height (pixbuf);
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp6_ = _tmp5_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp4_ < _tmp6_)) {
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 1520 "image.c"
				}
#line 303 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp7_ = gdk_pixels;
#line 303 "/home/jens/Source/shotwell/src/util/image.vala"
				p = _tmp7_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp8_ = p;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp9_ = gdk_pixbuf_get_width (pixbuf);
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp10_ = _tmp9_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
				end = _tmp8_ + (4 * _tmp10_);
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
				while (TRUE) {
#line 1536 "image.c"
					guchar* _tmp11_;
					guchar* _tmp12_;
					guchar tmp = '\0';
					guchar* _tmp13_;
					guchar _tmp14_;
					guchar* _tmp15_;
					guchar* _tmp16_;
					guchar _tmp17_;
					guchar _tmp18_;
					guchar* _tmp19_;
					guchar _tmp20_;
					guchar _tmp21_;
					guchar* _tmp22_;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp11_ = p;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp12_ = end;
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
					if (!(_tmp11_ < _tmp12_)) {
#line 306 "/home/jens/Source/shotwell/src/util/image.vala"
						break;
#line 1558 "image.c"
					}
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp13_ = p;
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp14_ = _tmp13_[0];
#line 307 "/home/jens/Source/shotwell/src/util/image.vala"
					tmp = _tmp14_;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_ = p;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp16_ = p;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp17_ = _tmp16_[2];
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_[0] = _tmp17_;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp18_ = _tmp15_[0];
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp19_ = p;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp20_ = tmp;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp19_[2] = _tmp20_;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp21_ = _tmp19_[2];
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp22_ = p;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					p = _tmp22_ + 4;
#line 1588 "image.c"
				}
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp23_ = gdk_pixels;
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp24_ = gdk_pixbuf_get_rowstride (pixbuf);
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp25_ = _tmp24_;
#line 320 "/home/jens/Source/shotwell/src/util/image.vala"
				gdk_pixels = _tmp23_ + _tmp25_;
#line 1598 "image.c"
			}
		}
	}
}


/**
 * Finds the size of the smallest axially-aligned rectangle that could contain
 * a rectangle src_width by src_height, rotated by angle.
 *
 * @param src_width The width of the incoming rectangle.
 * @param src_height The height of the incoming rectangle.
 * @param angle The amount to rotate by, given in degrees.
 * @param dest_width The width of the computed rectangle.
 * @param dest_height The height of the computed rectangle.
 */
void
compute_arb_rotated_size (gdouble src_width,
                          gdouble src_height,
                          gdouble angle,
                          gdouble* dest_width,
                          gdouble* dest_height)
{
	gdouble _vala_dest_width = 0.0;
	gdouble _vala_dest_height = 0.0;
#line 337 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = fabs (degrees_to_radians (angle));
#line 338 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (angle <= G_PI_2, "angle <= Math.PI_2");
#line 339 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_width = (src_width * cos (angle)) + (src_height * sin (angle));
#line 340 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_height = (src_height * cos (angle)) + (src_width * sin (angle));
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_width) {
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_width = _vala_dest_width;
#line 1636 "image.c"
	}
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_height) {
#line 334 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_height = _vala_dest_height;
#line 1642 "image.c"
	}
}


/**
 * @brief Rotates a pixbuf to an arbitrary angle, given in degrees, and returns the rotated pixbuf.
 *
 * @param source_pixbuf The source image that needs to be angled.
 * @param angle The angle the source image should be rotated by.
 */
GdkPixbuf*
rotate_arb (GdkPixbuf* source_pixbuf,
            gdouble angle)
{
	GdkPixbuf* result = NULL;
	gdouble x_tmp = 0.0;
	gdouble y_tmp = 0.0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	GdkPixbuf* dest_pixbuf = NULL;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GdkPixbuf* _tmp9_;
	cairo_format_t _tmp10_ = 0;
	gboolean _tmp11_;
	gboolean _tmp12_;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp13_;
	void* _tmp14_;
	void* _tmp15_;
	GdkPixbuf* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GdkPixbuf* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GdkPixbuf* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_surface_t* _tmp25_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	GdkPixbuf* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GdkPixbuf* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	GdkPixbuf* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GdkPixbuf* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	cairo_t* _tmp50_;
	cairo_t* _tmp51_;
	cairo_pattern_t* _tmp52_;
	cairo_t* _tmp53_;
	GdkPixbuf* _tmp54_;
#line 349 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (source_pixbuf), NULL);
#line 353 "/home/jens/Source/shotwell/src/util/image.vala"
	if (angle == 0.0) {
#line 1721 "image.c"
		GdkPixbuf* _tmp0_;
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _g_object_ref0 (source_pixbuf);
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp0_;
#line 354 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 1729 "image.c"
	}
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_pixbuf_get_width (source_pixbuf);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = gdk_pixbuf_get_height (source_pixbuf);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) _tmp2_, (gdouble) _tmp4_, angle, &_tmp5_, &_tmp6_);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	x_tmp = _tmp5_;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	y_tmp = _tmp6_;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = x_tmp;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = y_tmp;
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, (gint) round (_tmp7_), (gint) round (_tmp8_));
#line 364 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_pixbuf = _tmp9_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = gdk_pixbuf_get_has_alpha (source_pixbuf);
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = _tmp11_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp12_) {
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = CAIRO_FORMAT_ARGB32;
#line 1761 "image.c"
	} else {
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = CAIRO_FORMAT_RGB24;
#line 1765 "image.c"
	}
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = gdk_pixbuf_get_pixels (_tmp13_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = _tmp14_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = gdk_pixbuf_get_width (_tmp16_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = dest_pixbuf;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = gdk_pixbuf_get_rowstride (_tmp22_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = _tmp23_;
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = cairo_image_surface_create_for_data ((guchar*) _tmp15_, _tmp10_, _tmp18_, _tmp21_, _tmp24_);
#line 367 "/home/jens/Source/shotwell/src/util/image.vala"
	surface = _tmp25_;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = surface;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = cairo_create (_tmp26_);
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	context = _tmp27_;
#line 374 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = context;
#line 374 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgb (_tmp28_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp29_ = context;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp30_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = gdk_pixbuf_get_width (_tmp30_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _tmp31_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = gdk_pixbuf_get_height (_tmp33_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp35_ = _tmp34_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rectangle (_tmp29_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp32_, (gdouble) _tmp35_);
#line 376 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp36_ = context;
#line 376 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_fill (_tmp36_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp37_ = context;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = dest_pixbuf;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = gdk_pixbuf_get_width (_tmp38_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = _tmp39_;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = dest_pixbuf;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = gdk_pixbuf_get_height (_tmp41_);
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp43_ = _tmp42_;
#line 378 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp37_, (gdouble) (_tmp40_ / 2), (gdouble) (_tmp43_ / 2));
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp44_ = context;
#line 379 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rotate (_tmp44_, degrees_to_radians (angle));
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp45_ = context;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp46_ = gdk_pixbuf_get_width (source_pixbuf);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = _tmp46_;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = gdk_pixbuf_get_height (source_pixbuf);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = _tmp48_;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp45_, (gdouble) ((-_tmp47_) / 2), (gdouble) ((-_tmp49_) / 2));
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp50_ = context;
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_cairo_set_source_pixbuf (_tmp50_, source_pixbuf, (gdouble) 0, (gdouble) 0);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp51_ = context;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp52_ = cairo_get_source (_tmp51_);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_pattern_set_filter (_tmp52_, CAIRO_FILTER_BEST);
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp53_ = context;
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp53_);
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp54_ = dest_pixbuf;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	fix_cairo_pixbuf (_tmp54_);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	result = dest_pixbuf;
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_destroy0 (context);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_surface_destroy0 (surface);
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1883 "image.c"
}


/**
 * @brief Rotates a point around the upper left corner of an image to an arbitrary angle,
 * given in degrees, and returns the rotated point, translated such that it, along with its attendant
 * image, are in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be rotated and scaled.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void
rotate_point_arb (GdkPoint* source_point,
                  gint img_w,
                  gint img_h,
                  gdouble angle,
                  gboolean invert,
                  GdkPoint* result)
{
	gdouble dest_width = 0.0;
	gdouble dest_height = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	cairo_matrix_t matrix = {0};
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble dest_x = 0.0;
	GdkPoint _tmp5_;
	gint _tmp6_;
	gdouble dest_y = 0.0;
	GdkPoint _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	GdkPoint _tmp11_ = {0};
#line 406 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 409 "/home/jens/Source/shotwell/src/util/image.vala"
	if (angle == 0.0) {
#line 1928 "image.c"
		GdkPoint _tmp0_;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = *source_point;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		*result = _tmp0_;
#line 411 "/home/jens/Source/shotwell/src/util/image.vala"
		return;
#line 1936 "image.c"
	}
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) img_w, (gdouble) img_h, angle, &_tmp1_, &_tmp2_);
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_width = _tmp1_;
#line 416 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_height = _tmp2_;
#line 418 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_init_identity (&matrix);
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = dest_width;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = dest_height;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, _tmp3_ / 2, _tmp4_ / 2);
#line 420 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_rotate (&matrix, degrees_to_radians (angle));
#line 421 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, (gdouble) ((-img_w) / 2), (gdouble) ((-img_h) / 2));
#line 422 "/home/jens/Source/shotwell/src/util/image.vala"
	if (invert) {
#line 423 "/home/jens/Source/shotwell/src/util/image.vala"
		_vala_assert (cairo_matrix_invert (&matrix) == CAIRO_STATUS_SUCCESS, "matrix.invert() == Cairo.Status.SUCCESS");
#line 1960 "image.c"
	}
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *source_point;
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.x;
#line 425 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_x = (gdouble) _tmp6_;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *source_point;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_y = (gdouble) _tmp8_;
#line 427 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_transform_point (&matrix, &dest_x, &dest_y);
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = dest_x;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = dest_y;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_.x = (gint) _tmp9_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_.y = (gint) _tmp10_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp11_;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1988 "image.c"
}


/**
 * @brief <u>De</u>rotates a point around the upper left corner of an image from an arbitrary angle,
 * given in degrees, and returns the de-rotated point, taking into account any translation necessary
 * to make sure all of the rotated image stays in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be de-rotated.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void
derotate_point_arb (GdkPoint* source_point,
                    gint img_w,
                    gint img_h,
                    gdouble angle,
                    GdkPoint* result)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_ = {0};
#line 445 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *source_point;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	rotate_point_arb (&_tmp0_, img_w, img_h, angle, TRUE, &_tmp1_);
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp1_;
#line 446 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2024 "image.c"
}


static gpointer
_cairo_surface_reference0 (gpointer self)
{
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 2033 "image.c"
}


cairo_surface_t*
get_background_surface (void)
{
	cairo_surface_t* result = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp31_;
	cairo_surface_t* _tmp32_;
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = background_surface;
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == NULL) {
#line 2048 "image.c"
		gchar* color_a = NULL;
		gchar* color_b = NULL;
		ConfigFacade* config = NULL;
		ConfigFacade* _tmp1_;
		gchar* type = NULL;
		ConfigFacade* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GQuark _tmp7_ = 0U;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		static GQuark _tmp6_label0 = 0;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		static GQuark _tmp6_label1 = 0;
#line 2063 "image.c"
		cairo_surface_t* _tmp17_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp18_;
		cairo_t* _tmp19_;
		cairo_t* _tmp20_;
		cairo_t* _tmp21_;
		const gchar* _tmp22_;
		cairo_t* _tmp23_;
		cairo_t* _tmp24_;
		cairo_t* _tmp25_;
		cairo_t* _tmp26_;
		const gchar* _tmp27_;
		cairo_t* _tmp28_;
		cairo_t* _tmp29_;
		cairo_t* _tmp30_;
#line 455 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = config_facade_get_instance ();
#line 455 "/home/jens/Source/shotwell/src/util/image.vala"
		config = _tmp1_;
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = config;
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = configuration_facade_get_transparent_background_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 457 "/home/jens/Source/shotwell/src/util/image.vala"
		type = _tmp3_;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = type;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = _tmp4_;
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
		if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("checkered")))) {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2099 "image.c"
				default:
				{
					gchar* _tmp8_;
					gchar* _tmp9_;
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp8_ = g_strdup ("#808080");
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 460 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp8_;
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp9_ = g_strdup ("#ccc");
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 461 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp9_;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2118 "image.c"
				}
			}
		} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("solid")))) {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2124 "image.c"
				default:
				{
					ConfigFacade* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp10_ = config;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp11_ = configuration_facade_get_transparent_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp11_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp12_ = color_b;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp13_ = g_strdup (_tmp12_);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp13_;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2149 "image.c"
				}
			}
		} else {
#line 458 "/home/jens/Source/shotwell/src/util/image.vala"
			switch (0) {
#line 2155 "image.c"
				default:
				{
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp14_ = g_strdup ("#000");
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_b);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					color_b = _tmp14_;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_ = color_b;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp16_ = g_strdup (_tmp15_);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					_g_free0 (color_a);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
					color_a = _tmp16_;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 2177 "image.c"
				}
			}
		}
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 16, 16);
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_surface_destroy0 (background_surface);
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
		background_surface = _tmp17_;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = background_surface;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp19_ = cairo_create (_tmp18_);
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		ctx = _tmp19_;
#line 473 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp20_ = ctx;
#line 473 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_set_operator (_tmp20_, CAIRO_OPERATOR_SOURCE);
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp21_ = ctx;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp22_ = color_a;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
		set_source_color_from_string (_tmp21_, _tmp22_);
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp23_ = ctx;
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) 8, (gdouble) 8);
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp24_ = ctx;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp24_, (gdouble) 8, (gdouble) 8, (gdouble) 8, (gdouble) 8);
#line 477 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp25_ = ctx;
#line 477 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (_tmp25_);
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp26_ = ctx;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp27_ = color_b;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
		set_source_color_from_string (_tmp26_, _tmp27_);
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp28_ = ctx;
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp28_, (gdouble) 0, (gdouble) 8, (gdouble) 8, (gdouble) 8);
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp29_ = ctx;
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (_tmp29_, (gdouble) 8, (gdouble) 0, (gdouble) 8, (gdouble) 8);
#line 481 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp30_ = ctx;
#line 481 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (_tmp30_);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_destroy0 (ctx);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (type);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (config);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (color_b);
#line 452 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_free0 (color_a);
#line 2243 "image.c"
	}
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = background_surface;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _cairo_surface_reference0 (_tmp31_);
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp32_;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 2253 "image.c"
}


void
invalidate_transparent_background (void)
{
#line 488 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_surface_destroy0 (background_surface);
#line 488 "/home/jens/Source/shotwell/src/util/image.vala"
	background_surface = NULL;
#line 2264 "image.c"
}


void
paint_pixmap_with_background (cairo_t* ctx,
                              GdkPixbuf* pixbuf,
                              gint x,
                              gint y)
{
#line 491 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 491 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 492 "/home/jens/Source/shotwell/src/util/image.vala"
	if (gdk_pixbuf_get_has_alpha (pixbuf)) {
#line 2280 "image.c"
		cairo_surface_t* _tmp0_;
		cairo_surface_t* _tmp1_;
		cairo_pattern_t* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = get_background_surface ();
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp0_;
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_set_source_surface (ctx, _tmp1_, (gdouble) 0, (gdouble) 0);
#line 493 "/home/jens/Source/shotwell/src/util/image.vala"
		_cairo_surface_destroy0 (_tmp1_);
#line 494 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = cairo_get_source (ctx);
#line 494 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_pattern_set_extend (_tmp2_, CAIRO_EXTEND_REPEAT);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = gdk_pixbuf_get_width (pixbuf);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = _tmp3_;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = gdk_pixbuf_get_height (pixbuf);
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _tmp5_;
#line 495 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) _tmp4_, (gdouble) _tmp6_);
#line 496 "/home/jens/Source/shotwell/src/util/image.vala"
		cairo_fill (ctx);
#line 2312 "image.c"
	}
#line 499 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_cairo_set_source_pixbuf (ctx, pixbuf, (gdouble) x, (gdouble) y);
#line 500 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (ctx);
#line 2318 "image.c"
}


void
clamp_inside_rotated_image (Box* src,
                            gint img_w,
                            gint img_h,
                            gdouble angle_deg,
                            gboolean preserve_geom,
                            Box* result)
{
	GdkPoint top_left = {0};
	Box _tmp0_;
	gint _tmp1_;
	Box _tmp2_;
	gint _tmp3_;
	GdkPoint _tmp4_ = {0};
	GdkPoint _tmp5_ = {0};
	GdkPoint top_right = {0};
	Box _tmp6_;
	gint _tmp7_;
	Box _tmp8_;
	gint _tmp9_;
	GdkPoint _tmp10_ = {0};
	GdkPoint _tmp11_ = {0};
	GdkPoint bottom_left = {0};
	Box _tmp12_;
	gint _tmp13_;
	Box _tmp14_;
	gint _tmp15_;
	GdkPoint _tmp16_ = {0};
	GdkPoint _tmp17_ = {0};
	GdkPoint bottom_right = {0};
	Box _tmp18_;
	gint _tmp19_;
	Box _tmp20_;
	gint _tmp21_;
	GdkPoint _tmp22_ = {0};
	GdkPoint _tmp23_ = {0};
	gdouble angle = 0.0;
	gint top_offset = 0;
	gint bottom_offset = 0;
	gint left_offset = 0;
	gint right_offset = 0;
	gint top = 0;
	GdkPoint _tmp24_;
	gint _tmp25_;
	GdkPoint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint bottom = 0;
	GdkPoint _tmp31_;
	gint _tmp32_;
	GdkPoint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint left = 0;
	GdkPoint _tmp38_;
	gint _tmp39_;
	GdkPoint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint right = 0;
	GdkPoint _tmp45_;
	gint _tmp46_;
	GdkPoint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	Box _tmp52_ = {0};
#line 504 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (src != NULL);
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *src;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.left;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *src;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.top;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.x = _tmp1_;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.y = _tmp3_;
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp4_, img_w, img_h, angle_deg, &_tmp5_);
#line 507 "/home/jens/Source/shotwell/src/util/image.vala"
	top_left = _tmp5_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *src;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.right;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = *src;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.top;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_.x = _tmp7_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_.y = _tmp9_;
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp10_, img_w, img_h, angle_deg, &_tmp11_);
#line 508 "/home/jens/Source/shotwell/src/util/image.vala"
	top_right = _tmp11_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *src;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.left;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = *src;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = _tmp14_.bottom;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_.x = _tmp13_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_.y = _tmp15_;
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp16_, img_w, img_h, angle_deg, &_tmp17_);
#line 509 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_left = _tmp17_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = *src;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = _tmp18_.right;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = *src;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_.bottom;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.x = _tmp19_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.y = _tmp21_;
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp22_, img_w, img_h, angle_deg, &_tmp23_);
#line 510 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_right = _tmp23_;
#line 512 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = degrees_to_radians (angle_deg);
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	top_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	left_offset = 0;
#line 513 "/home/jens/Source/shotwell/src/util/image.vala"
	right_offset = 0;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = top_left;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = _tmp24_.y;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = top_right;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = _tmp26_.y;
#line 515 "/home/jens/Source/shotwell/src/util/image.vala"
	top = MIN (_tmp25_, _tmp27_);
#line 516 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = top;
#line 516 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp28_ < 0) {
#line 2478 "image.c"
		gint _tmp29_;
		gdouble _tmp30_;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp29_ = top;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp30_ = angle;
#line 517 "/home/jens/Source/shotwell/src/util/image.vala"
		top_offset = (gint) ((0 - _tmp29_) * cos (_tmp30_));
#line 2487 "image.c"
	}
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = bottom_left;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _tmp31_.y;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = bottom_right;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = _tmp33_.y;
#line 519 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = MAX (_tmp32_, _tmp34_);
#line 520 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp35_ = bottom;
#line 520 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp35_ > img_h) {
#line 2503 "image.c"
		gint _tmp36_;
		gdouble _tmp37_;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp36_ = bottom;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp37_ = angle;
#line 521 "/home/jens/Source/shotwell/src/util/image.vala"
		bottom_offset = (gint) ((img_h - _tmp36_) * cos (_tmp37_));
#line 2512 "image.c"
	}
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = top_left;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = _tmp38_.x;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = bottom_left;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = _tmp40_.x;
#line 523 "/home/jens/Source/shotwell/src/util/image.vala"
	left = MIN (_tmp39_, _tmp41_);
#line 524 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = left;
#line 524 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp42_ < 0) {
#line 2528 "image.c"
		gint _tmp43_;
		gdouble _tmp44_;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp43_ = left;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp44_ = angle;
#line 525 "/home/jens/Source/shotwell/src/util/image.vala"
		left_offset = (gint) ((0 - _tmp43_) * cos (_tmp44_));
#line 2537 "image.c"
	}
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp45_ = top_right;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp46_ = _tmp45_.x;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = bottom_right;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = _tmp47_.x;
#line 527 "/home/jens/Source/shotwell/src/util/image.vala"
	right = MAX (_tmp46_, _tmp48_);
#line 528 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = right;
#line 528 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp49_ > img_w) {
#line 2553 "image.c"
		gint _tmp50_;
		gdouble _tmp51_;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp50_ = right;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp51_ = angle;
#line 529 "/home/jens/Source/shotwell/src/util/image.vala"
		right_offset = (gint) ((img_w - _tmp50_) * cos (_tmp51_));
#line 2562 "image.c"
	}
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	if (preserve_geom) {
#line 2566 "image.c"
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		Box _tmp57_ = {0};
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp53_ = left_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp54_ = right_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp55_ = top_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp56_ = bottom_offset;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		box_get_offset (src, _tmp53_ + _tmp54_, _tmp55_ + _tmp56_, &_tmp57_);
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp52_ = _tmp57_;
#line 2584 "image.c"
	} else {
		Box _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		Box _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		Box _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		Box _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp58_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp59_ = _tmp58_.left;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp60_ = left_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp61_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp62_ = _tmp61_.top;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp63_ = top_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp64_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp65_ = _tmp64_.right;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp66_ = right_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp67_ = *src;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp68_ = _tmp67_.bottom;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp69_ = bottom_offset;
#line 532 "/home/jens/Source/shotwell/src/util/image.vala"
		box_init (&_tmp52_, _tmp59_ + _tmp60_, _tmp62_ + _tmp63_, _tmp65_ + _tmp66_, _tmp68_ + _tmp69_);
#line 2624 "image.c"
	}
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp52_;
#line 531 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2630 "image.c"
}



