/* EventDirectoryItem.c generated by valac 0.40.4, the Vala compiler
 * generated from EventDirectoryItem.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_EVENT_DIRECTORY_ITEM (event_directory_item_get_type ())
#define EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem))
#define EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))
#define IS_EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_DIRECTORY_ITEM))
#define IS_EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_DIRECTORY_ITEM))
#define EVENT_DIRECTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))

typedef struct _EventDirectoryItem EventDirectoryItem;
typedef struct _EventDirectoryItemClass EventDirectoryItemClass;
typedef struct _EventDirectoryItemPrivate EventDirectoryItemPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
enum  {
	EVENT_DIRECTORY_ITEM_0_PROPERTY,
	EVENT_DIRECTORY_ITEM_NUM_PROPERTIES
};
static GParamSpec* event_directory_item_properties[EVENT_DIRECTORY_ITEM_NUM_PROPERTIES];

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _EventDirectoryItem {
	CheckerboardItem parent_instance;
	EventDirectoryItemPrivate * priv;
	Event* event;
};

struct _EventDirectoryItemClass {
	CheckerboardItemClass parent_class;
};

struct _EventDirectoryItemPrivate {
	GdkRectangle paul_lynde;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;


static gpointer event_directory_item_parent_class = NULL;
extern EventSourceCollection* event_global;
extern Scaling event_directory_item_squared_scaling;
Scaling event_directory_item_squared_scaling = {0};

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType event_directory_item_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
#define EVENT_DIRECTORY_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemPrivate))
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType event_source_collection_get_type (void) G_GNUC_CONST;
static void event_directory_item_on_events_altered (EventDirectoryItem* self,
                                             GeeMap* map);
static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                            GeeMap* items,
                                                                            gpointer self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport,
                               Scaling* result);
static gint event_directory_item_get_CROPPED_SCALE (void);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
EventDirectoryItem* event_directory_item_new (Event* event);
EventDirectoryItem* event_directory_item_construct (GType object_type,
                                                    Event* event);
static gchar* event_directory_item_get_formatted_title (Event* event);
gchar* event_source_get_comment (EventSource* self);
CheckerboardItem* checkerboard_item_construct (GType object_type,
                                               ThumbnailSource* source,
                                               Dimensions* initial_pixbuf_dim,
                                               const gchar* title,
                                               const gchar* comment,
                                               gboolean marked_up,
                                               PangoAlignment alignment);
GType media_source_get_type (void) G_GNUC_CONST;
static void event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                               GdkRectangle* result);
MediaSource* event_get_primary_source (Event* self);
void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media,
                                                GdkRectangle* paul_lynde,
                                                GError** error);
GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
static void ___lambda19_ (void);
static void ____lambda19__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                         GdkPixbuf* unscaled,
                                                         Dimensions* dim,
                                                         GdkInterpType interp,
                                                         GError* err,
                                                         gpointer self);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
void clamp_rectangle (GdkRectangle* original,
                      Dimensions* max,
                      GdkRectangle* result);
gboolean media_source_collection_has_photo (GeeCollection* media);
GeeCollection* event_source_get_media (EventSource* self);
gboolean media_source_collection_has_video (GeeCollection* media);
gint event_source_get_media_count (EventSource* self);
gchar* event_get_formatted_daterange (Event* self);
gchar* data_object_get_name (DataObject* self);
gchar* guarded_markup_escape_text (const gchar* plain);
static void event_directory_item_real_exposed (CheckerboardItem* base);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
gchar* data_object_to_string (DataObject* self);
static void event_directory_item_update_comment (EventDirectoryItem* self,
                                          gboolean init);
void checkerboard_item_exposed (CheckerboardItem* self);
static void event_directory_item_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
static void event_directory_item_real_thumbnail_altered (ThumbnailView* base);
static void event_directory_item_real_paint_shadow (CheckerboardItem* base,
                                             cairo_t* ctx,
                                             Dimensions* dimensions,
                                             GdkPoint* origin,
                                             gint radius,
                                             gfloat initial_alpha);
void checkerboard_item_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha);
static void event_directory_item_real_paint_border (CheckerboardItem* base,
                                             cairo_t* ctx,
                                             Dimensions* object_dimensions,
                                             GdkPoint* object_origin,
                                             gint border_width);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                              gint border_width,
                                              Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                          gint border_width,
                                          GdkPoint* result);
void draw_rounded_corners_filled (cairo_t* ctx,
                                  Dimensions* dim,
                                  GdkPoint* origin,
                                  gdouble radius_proportion);
static void event_directory_item_real_paint_image (CheckerboardItem* base,
                                            cairo_t* ctx,
                                            GdkPixbuf* pixbuf,
                                            GdkPoint* origin);
void context_rounded_corners (cairo_t* cx,
                              Dimensions* dim,
                              GdkPoint* origin,
                              gdouble radius_proportion);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
static void event_directory_item_finalize (GObject * obj);
static void _vala_event_directory_item_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);


static void
_event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                       GeeMap* items,
                                                                       gpointer self)
{
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_on_events_altered ((EventDirectoryItem*) self, items);
#line 560 "EventDirectoryItem.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 569 "EventDirectoryItem.c"
}


EventDirectoryItem*
event_directory_item_construct (GType object_type,
                                Event* event)
{
	EventDirectoryItem * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Event* _tmp9_;
	MediaSource* _tmp10_;
	MediaSource* _tmp11_;
	GdkRectangle _tmp12_ = {0};
	GdkRectangle _tmp13_;
	Dimensions _tmp14_ = {0};
	EventSourceCollection* _tmp15_;
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = event_directory_item_get_formatted_title (event);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = _tmp5_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = (EventDirectoryItem*) checkerboard_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp4_, _tmp6_, _tmp8_, TRUE, PANGO_ALIGN_CENTER);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp8_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp6_);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = _g_object_ref0 (event);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->event = _tmp9_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event_get_primary_source (event);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp11_, &_tmp12_);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp12_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp11_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = self->priv->paul_lynde;
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp13_, &_tmp14_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp14_);
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = event_global;
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self, 0);
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self;
#line 648 "EventDirectoryItem.c"
}


EventDirectoryItem*
event_directory_item_new (Event* event)
{
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return event_directory_item_construct (TYPE_EVENT_DIRECTORY_ITEM, event);
#line 657 "EventDirectoryItem.c"
}


static void
event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                          GdkRectangle* result)
{
	Dimensions scaled = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	GdkRectangle paul_lynde = {0};
	Dimensions _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
#line 43 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (source));
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media_source_get_dimensions (source, PHOTO_EXCEPTION_NONE, &_tmp0_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_get_scaled_dimensions (&event_directory_item_squared_scaling, &_tmp0_, &_tmp1_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaled = _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&paul_lynde, 0, sizeof (GdkRectangle));
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = event_directory_item_get_CROPPED_SCALE ();
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = _tmp4_;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = _tmp6_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.x = CLAMP (_tmp3_ - _tmp5_, 0, _tmp7_) / 2;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = _tmp8_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event_directory_item_get_CROPPED_SCALE ();
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _tmp12_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.y = CLAMP (_tmp9_ - _tmp11_, 0, _tmp13_) / 2;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = event_directory_item_get_CROPPED_SCALE ();
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = _tmp14_;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.width = _tmp15_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = event_directory_item_get_CROPPED_SCALE ();
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp17_ = _tmp16_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.height = _tmp17_;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*result = paul_lynde;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return;
#line 739 "EventDirectoryItem.c"
}


static void
___lambda19_ (void)
{
}


static void
____lambda19__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                    GdkPixbuf* unscaled,
                                                    Dimensions* dim,
                                                    GdkInterpType interp,
                                                    GError* err,
                                                    gpointer self)
{
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	___lambda19_ ();
#line 759 "EventDirectoryItem.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self ? g_error_copy (self) : NULL;
#line 768 "EventDirectoryItem.c"
}


static GdkPixbuf*
event_directory_item_get_paul_lynde (MediaSource* media,
                                     GdkRectangle* paul_lynde,
                                     GError** error)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	Dimensions thumbnail_dimensions = {0};
	GdkPixbuf* _tmp13_;
	Dimensions _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	Dimensions _tmp16_;
	gint _tmp17_;
	GdkRectangle _tmp18_;
	gint _tmp19_;
	GdkRectangle _tmp32_;
	Dimensions _tmp33_;
	GdkRectangle _tmp34_ = {0};
	GdkPixbuf* _tmp35_;
	GdkRectangle _tmp36_;
	gint _tmp37_;
	GdkRectangle _tmp38_;
	gint _tmp39_;
	GdkRectangle _tmp40_;
	gint _tmp41_;
	GdkRectangle _tmp42_;
	gint _tmp43_;
	GdkPixbuf* _tmp44_;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (paul_lynde != NULL, NULL);
#line 805 "EventDirectoryItem.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = event_directory_item_squared_scaling;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = media_source_get_preview_pixbuf (media, &_tmp1_, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp0_ = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 819 "EventDirectoryItem.c"
			goto __catch58_g_error;
		}
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp0_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		pixbuf = _tmp3_;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp0_);
#line 832 "EventDirectoryItem.c"
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* _error_ = NULL;
		Dimensions _tmp4_ = {0};
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_error_ = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_inner_error_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_init (&_tmp4_, (gint) THUMBNAIL_CACHE_SIZE_BIG, (gint) THUMBNAIL_CACHE_SIZE_BIG);
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_tmp4_, THUMBNAIL_CACHE_DEFAULT_INTERP, ____lambda19__thumbnail_cache_async_fetch_callback, NULL, NULL);
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (media, TYPE_LIBRARY_PHOTO)) {
#line 849 "EventDirectoryItem.c"
			LibraryPhoto* photo = NULL;
			LibraryPhoto* _tmp5_;
			GdkPixbuf* _tmp6_ = NULL;
			LibraryPhoto* _tmp7_;
			Scaling _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
#line 66 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 66 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			photo = _tmp5_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp7_ = photo;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp8_ = event_directory_item_squared_scaling;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp9_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp8_, &_inner_error_);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp6_ = _tmp9_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
				_g_object_unref0 (photo);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
				_g_error_free0 (_error_);
#line 875 "EventDirectoryItem.c"
				goto __finally58;
			}
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = _tmp6_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp6_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (pixbuf);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			pixbuf = _tmp10_;
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (_tmp6_);
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (photo);
#line 890 "EventDirectoryItem.c"
		} else {
			GError* _tmp11_;
			GError* _tmp12_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp11_ = _error_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp12_ = _g_error_copy0 (_tmp11_);
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_inner_error_ = _tmp12_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_error_free0 (_error_);
#line 902 "EventDirectoryItem.c"
			goto __finally58;
		}
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_error_free0 (_error_);
#line 907 "EventDirectoryItem.c"
	}
	__finally58:
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return NULL;
#line 918 "EventDirectoryItem.c"
	}
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = pixbuf;
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (_tmp13_, &_tmp14_);
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	thumbnail_dimensions = _tmp14_;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = thumbnail_dimensions;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp17_ = _tmp16_.width;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp18_ = *paul_lynde;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp19_ = _tmp18_.width;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp17_ > (2 * _tmp19_)) {
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp15_ = TRUE;
#line 938 "EventDirectoryItem.c"
	} else {
		Dimensions _tmp20_;
		gint _tmp21_;
		GdkRectangle _tmp22_;
		gint _tmp23_;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp20_ = thumbnail_dimensions;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp21_ = _tmp20_.height;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp22_ = *paul_lynde;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp23_ = _tmp22_.height;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp15_ = _tmp21_ > (_tmp23_ * 2);
#line 954 "EventDirectoryItem.c"
	}
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp15_) {
#line 958 "EventDirectoryItem.c"
		LibraryPhoto* photo = NULL;
		LibraryPhoto* _tmp24_;
		GdkPixbuf* _tmp25_ = NULL;
		LibraryPhoto* _tmp26_;
		Scaling _tmp27_;
		GdkPixbuf* _tmp28_;
		GdkPixbuf* _tmp29_;
		GdkPixbuf* _tmp30_;
		Dimensions _tmp31_ = {0};
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		photo = _tmp24_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp26_ = photo;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp27_ = event_directory_item_squared_scaling;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp28_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp27_, &_inner_error_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp25_ = _tmp28_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (photo);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (pixbuf);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return NULL;
#line 990 "EventDirectoryItem.c"
		}
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp29_ = _tmp25_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp25_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		pixbuf = _tmp29_;
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = pixbuf;
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_pixbuf (_tmp30_, &_tmp31_);
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		thumbnail_dimensions = _tmp31_;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp25_);
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (photo);
#line 1010 "EventDirectoryItem.c"
	}
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp32_ = *paul_lynde;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp33_ = thumbnail_dimensions;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	clamp_rectangle (&_tmp32_, &_tmp33_, &_tmp34_);
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*paul_lynde = _tmp34_;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp35_ = pixbuf;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp36_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp37_ = _tmp36_.x;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp38_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp39_ = _tmp38_.y;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp40_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp41_ = _tmp40_.width;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp42_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp43_ = _tmp42_.height;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp44_ = gdk_pixbuf_new_subpixbuf (_tmp35_, _tmp37_, _tmp39_, _tmp41_, _tmp43_);
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = _tmp44_;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (pixbuf);
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 1046 "EventDirectoryItem.c"
}


static gchar*
event_directory_item_get_formatted_title (Event* event)
{
	gchar* result = NULL;
	gboolean has_photos = FALSE;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean has_videos = FALSE;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gint count = 0;
	gchar* count_text = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gchar* daterange = NULL;
	gchar* _tmp20_;
	gchar* name = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_;
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = media_source_collection_has_photo (_tmp1_);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp1_);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_photos = _tmp2_;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = media_source_collection_has_video (_tmp4_);
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp4_);
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_videos = _tmp5_;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count = event_source_get_media_count (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_EVENT_SOURCE, EventSource));
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = g_strdup ("");
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count_text = _tmp6_;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = has_photos;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp8_) {
#line 1105 "EventDirectoryItem.c"
		gboolean _tmp9_;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp9_ = has_videos;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = _tmp9_;
#line 1111 "EventDirectoryItem.c"
	} else {
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = FALSE;
#line 1115 "EventDirectoryItem.c"
	}
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp7_) {
#line 1119 "EventDirectoryItem.c"
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp10_ = count;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp11_ = count;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp12_ = g_strdup_printf (ngettext ("%d Photo/Video", "%d Photos/Videos", (gulong) _tmp10_), _tmp11_);
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		count_text = _tmp12_;
#line 1133 "EventDirectoryItem.c"
	} else {
		gboolean _tmp13_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = has_videos;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (_tmp13_) {
#line 1140 "EventDirectoryItem.c"
			gint _tmp14_;
			gint _tmp15_;
			gchar* _tmp16_;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp14_ = count;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp15_ = count;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp16_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) _tmp14_), _tmp15_);
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp16_;
#line 1154 "EventDirectoryItem.c"
		} else {
			gint _tmp17_;
			gint _tmp18_;
			gchar* _tmp19_;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp17_ = count;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp18_ = count;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp19_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) _tmp17_), _tmp18_);
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp19_;
#line 1169 "EventDirectoryItem.c"
		}
	}
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = event_get_formatted_daterange (event);
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	daterange = _tmp20_;
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp21_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (event, TYPE_DATA_OBJECT, DataObject));
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	name = _tmp21_;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp23_ = daterange;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp23_ == NULL) {
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp22_ = TRUE;
#line 1186 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp24_ = daterange;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp25_ = name;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp22_ = g_strcmp0 (_tmp24_, _tmp25_) == 0;
#line 1196 "EventDirectoryItem.c"
	}
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp22_) {
#line 1200 "EventDirectoryItem.c"
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp26_ = name;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp27_ = guarded_markup_escape_text (_tmp26_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp28_ = _tmp27_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp29_ = count_text;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = guarded_markup_escape_text (_tmp29_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp31_ = _tmp30_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp32_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp28_, _tmp31_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp33_ = _tmp32_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp31_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp28_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp33_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1239 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp34_ = name;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp35_ = guarded_markup_escape_text (_tmp34_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp36_ = _tmp35_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp37_ = count_text;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp38_ = guarded_markup_escape_text (_tmp37_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp39_ = _tmp38_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp40_ = daterange;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp41_ = guarded_markup_escape_text (_tmp40_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp42_ = _tmp41_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp43_ = g_strdup_printf ("<b>%s</b>\n%s\n%s", _tmp36_, _tmp39_, _tmp42_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp44_ = _tmp43_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp42_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp39_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp36_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp44_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1290 "EventDirectoryItem.c"
	}
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (name);
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (daterange);
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (count_text);
#line 1298 "EventDirectoryItem.c"
}


static void
event_directory_item_real_exposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GError * _inner_error_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 117 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
#line 118 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1313 "EventDirectoryItem.c"
	}
	{
		GdkPixbuf* _tmp0_ = NULL;
		Event* _tmp1_;
		MediaSource* _tmp2_;
		MediaSource* _tmp3_;
		GdkRectangle _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = self->event;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = event_get_primary_source (_tmp1_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = _tmp2_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = self->priv->paul_lynde;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = event_directory_item_get_paul_lynde (_tmp3_, &_tmp4_, &_inner_error_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp6_ = _tmp5_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp3_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp0_ = _tmp6_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1341 "EventDirectoryItem.c"
			goto __catch59_g_error;
		}
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp0_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp0_);
#line 1348 "EventDirectoryItem.c"
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* err = NULL;
		Event* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		err = _inner_error_;
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_inner_error_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = self->event;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp9_ = _tmp8_;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp10_ = err;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp11_ = _tmp10_->message;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("EventDirectoryItem.vala:123: Unable to fetch preview for %s: %s", _tmp9_, _tmp11_);
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp9_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_error_free0 (err);
#line 1379 "EventDirectoryItem.c"
	}
	__finally59:
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1390 "EventDirectoryItem.c"
	}
#line 126 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1396 "EventDirectoryItem.c"
}


static void
event_directory_item_real_unexposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
#line 131 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 132 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (!checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
#line 133 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1412 "EventDirectoryItem.c"
	}
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->priv->paul_lynde;
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp1_);
#line 137 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1422 "EventDirectoryItem.c"
}


static void
event_directory_item_on_events_altered (EventDirectoryItem* self,
                                        GeeMap* map)
{
	Event* _tmp0_;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 141 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (gee_map_has_key (map, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject))) {
#line 1441 "EventDirectoryItem.c"
		Event* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = self->event;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = event_directory_item_get_formatted_title (_tmp1_);
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = _tmp2_;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, TRUE, PANGO_ALIGN_CENTER);
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp3_);
#line 1455 "EventDirectoryItem.c"
	}
}


static void
event_directory_item_real_thumbnail_altered (ThumbnailView* base)
{
	EventDirectoryItem * self;
	MediaSource* media = NULL;
	Event* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GError * _inner_error_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_get_primary_source (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media = _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = media;
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp2_, &_tmp3_);
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp3_;
#line 152 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
#line 1486 "EventDirectoryItem.c"
		{
			GdkPixbuf* _tmp4_ = NULL;
			MediaSource* _tmp5_;
			GdkRectangle _tmp6_;
			GdkPixbuf* _tmp7_;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = media;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp6_ = self->priv->paul_lynde;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp7_ = event_directory_item_get_paul_lynde (_tmp5_, &_tmp6_, &_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp4_ = _tmp7_;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1502 "EventDirectoryItem.c"
				goto __catch60_g_error;
			}
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp4_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (_tmp4_);
#line 1509 "EventDirectoryItem.c"
		}
		goto __finally60;
		__catch60_g_error:
		{
			GError* err = NULL;
			Event* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			err = _inner_error_;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_inner_error_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp8_ = self->event;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject));
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = _tmp9_;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp11_ = err;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp12_ = _tmp11_->message;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("EventDirectoryItem.vala:156: Unable to fetch preview for %s: %s", _tmp10_, _tmp12_);
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (_tmp10_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_error_free0 (err);
#line 1540 "EventDirectoryItem.c"
		}
		__finally60:
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (media);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return;
#line 1553 "EventDirectoryItem.c"
		}
	} else {
		GdkRectangle _tmp13_;
		Dimensions _tmp14_ = {0};
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = self->priv->paul_lynde;
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_rectangle (&_tmp13_, &_tmp14_);
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp14_);
#line 1564 "EventDirectoryItem.c"
	}
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	THUMBNAIL_VIEW_CLASS (event_directory_item_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 146 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (media);
#line 1570 "EventDirectoryItem.c"
}


static void
event_directory_item_real_paint_shadow (CheckerboardItem* base,
                                        cairo_t* ctx,
                                        Dimensions* dimensions,
                                        GdkPoint* origin,
                                        gint radius,
                                        gfloat initial_alpha)
{
	EventDirectoryItem * self;
	Dimensions altered = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_;
	GdkPoint _tmp5_;
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (dimensions != NULL);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_.width;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_.height;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&altered, _tmp1_ - 25, _tmp3_ - 25);
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = altered;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = *origin;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->paint_shadow (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), ctx, &_tmp4_, &_tmp5_, 36, initial_alpha);
#line 1614 "EventDirectoryItem.c"
}


static void
event_directory_item_real_paint_border (CheckerboardItem* base,
                                        cairo_t* ctx,
                                        Dimensions* object_dimensions,
                                        GdkPoint* object_origin,
                                        gint border_width)
{
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkPoint origin = {0};
	GdkPoint _tmp2_;
	GdkPoint _tmp3_ = {0};
	Dimensions _tmp4_;
	GdkPoint _tmp5_;
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_origin != NULL);
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *object_dimensions;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_dimensions (&_tmp0_, border_width, &_tmp1_);
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp1_;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = *object_origin;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_origin (&_tmp2_, border_width, &_tmp3_);
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	origin = _tmp3_;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = dimensions;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = origin;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	draw_rounded_corners_filled (ctx, &_tmp4_, &_tmp5_, 6.0);
#line 1660 "EventDirectoryItem.c"
}


static void
event_directory_item_real_paint_image (CheckerboardItem* base,
                                       cairo_t* ctx,
                                       GdkPixbuf* pixbuf,
                                       GdkPoint* origin)
{
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (pixbuf, &_tmp0_);
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp0_;
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (gdk_pixbuf_get_has_alpha (pixbuf)) {
#line 1693 "EventDirectoryItem.c"
		Dimensions _tmp1_;
		GdkPoint _tmp2_;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = dimensions;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = *origin;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		draw_rounded_corners_filled (ctx, &_tmp1_, &_tmp2_, 6.0);
#line 1702 "EventDirectoryItem.c"
	}
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = dimensions;
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = *origin;
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	context_rounded_corners (ctx, &_tmp3_, &_tmp4_, 6.0);
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = *origin;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = _tmp5_.x;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = *origin;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_.y;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	gdk_cairo_set_source_pixbuf (ctx, pixbuf, (gdouble) _tmp6_, (gdouble) _tmp8_);
#line 189 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	cairo_paint (ctx);
#line 1722 "EventDirectoryItem.c"
}


static void
event_directory_item_update_comment (EventDirectoryItem* self,
                                     gboolean init)
{
	gchar* comment = NULL;
	Event* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	comment = _tmp1_;
#line 194 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = comment;
#line 194 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (is_string_empty (_tmp2_)) {
#line 195 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1748 "EventDirectoryItem.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (!init) {
#line 1752 "EventDirectoryItem.c"
			const gchar* _tmp3_;
#line 197 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp3_ = comment;
#line 197 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
#line 1758 "EventDirectoryItem.c"
		} else {
#line 199 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "", FALSE, PANGO_ALIGN_LEFT);
#line 1762 "EventDirectoryItem.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (comment);
#line 1767 "EventDirectoryItem.c"
}


static gint
event_directory_item_get_CROPPED_SCALE (void)
{
	gint result;
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM) + ((thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG) - thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM)) / 2);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 1779 "EventDirectoryItem.c"
}


static void
event_directory_item_class_init (EventDirectoryItemClass * klass)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	Scaling _tmp5_ = {0};
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_type_class_add_private (klass, sizeof (EventDirectoryItemPrivate));
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) event_directory_item_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) event_directory_item_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView *)) event_directory_item_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) event_directory_item_real_paint_shadow;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint)) event_directory_item_real_paint_border;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem *, cairo_t*, GdkPixbuf*, GdkPoint*)) event_directory_item_real_paint_image;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_event_directory_item_get_property;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->finalize = event_directory_item_finalize;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_to_fill_viewport (&_tmp4_, &_tmp5_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_squared_scaling = _tmp5_;
#line 1826 "EventDirectoryItem.c"
}


static void
event_directory_item_instance_init (EventDirectoryItem * self)
{
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv = EVENT_DIRECTORY_ITEM_GET_PRIVATE (self);
#line 20 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&self->priv->paul_lynde, 0, sizeof (GdkRectangle));
#line 1837 "EventDirectoryItem.c"
}


static void
event_directory_item_finalize (GObject * obj)
{
	EventDirectoryItem * self;
	EventSourceCollection* _tmp0_;
	guint _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_global;
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self);
#line 18 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (event_directory_item_parent_class)->finalize (obj);
#line 1859 "EventDirectoryItem.c"
}


GType
event_directory_item_get_type (void)
{
	static volatile gsize event_directory_item_type_id__volatile = 0;
	if (g_once_init_enter (&event_directory_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventDirectoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_directory_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventDirectoryItem), 0, (GInstanceInitFunc) event_directory_item_instance_init, NULL };
		GType event_directory_item_type_id;
		event_directory_item_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "EventDirectoryItem", &g_define_type_info, 0);
		g_once_init_leave (&event_directory_item_type_id__volatile, event_directory_item_type_id);
	}
	return event_directory_item_type_id__volatile;
}


static void
_vala_event_directory_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	EventDirectoryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	switch (property_id) {
#line 1887 "EventDirectoryItem.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		break;
#line 1893 "EventDirectoryItem.c"
	}
}



