/* PhotoMonitor.c generated by valac 0.40.4, the Vala compiler
 * generated from PhotoMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_PHOTO_UPDATES (photo_updates_get_type ())
#define PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_UPDATES, PhotoUpdates))
#define PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))
#define IS_PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_UPDATES))
#define IS_PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_UPDATES))
#define PHOTO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))

typedef struct _PhotoUpdates PhotoUpdates;
typedef struct _PhotoUpdatesClass PhotoUpdatesClass;
typedef struct _PhotoUpdatesPrivate PhotoUpdatesPrivate;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;
typedef struct _PhotoMonitorPrivate PhotoMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB (photo_monitor_reimport_master_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))

typedef struct _PhotoMonitorReimportMasterJob PhotoMonitorReimportMasterJob;
typedef struct _PhotoMonitorReimportMasterJobClass PhotoMonitorReimportMasterJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB (photo_monitor_reimport_editable_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))

typedef struct _PhotoMonitorReimportEditableJob PhotoMonitorReimportEditableJob;
typedef struct _PhotoMonitorReimportEditableJobClass PhotoMonitorReimportEditableJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB (photo_monitor_reimport_raw_development_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))

typedef struct _PhotoMonitorReimportRawDevelopmentJob PhotoMonitorReimportRawDevelopmentJob;
typedef struct _PhotoMonitorReimportRawDevelopmentJobClass PhotoMonitorReimportRawDevelopmentJobClass;
enum  {
	PHOTO_MONITOR_0_PROPERTY,
	PHOTO_MONITOR_NUM_PROPERTIES
};
static GParamSpec* photo_monitor_properties[PHOTO_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_ORIENTATION (orientation_get_type ())
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _PhotoMonitorReimportMasterJobPrivate PhotoMonitorReimportMasterJobPrivate;

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
typedef struct _PhotoMonitorReimportEditableJobPrivate PhotoMonitorReimportEditableJobPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
typedef struct _PhotoMonitorReimportRawDevelopmentJobPrivate PhotoMonitorReimportRawDevelopmentJobPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _PhotoUpdates {
	MonitorableUpdates parent_instance;
	PhotoUpdatesPrivate * priv;
	LibraryPhoto* photo;
	gboolean reimport_master;
	gboolean reimport_editable;
	gboolean reimport_raw_developments;
	GFile* editable_file;
	gboolean editable_file_info_altered;
	gboolean raw_developer_file_info_altered;
	GFileInfo* editable_file_info;
	gboolean editable_in_alteration;
	gboolean raw_development_in_alteration;
	gboolean revert_to_master;
	GeeCollection* developer_files;
};

struct _PhotoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_editable_file) (PhotoUpdates* self, GFile* file);
	void (*set_editable_file_info) (PhotoUpdates* self, GFileInfo* info);
	void (*set_editable_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_editable_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_development_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_developer_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_revert_to_master) (PhotoUpdates* self, gboolean revert);
	void (*add_raw_developer_file) (PhotoUpdates* self, GFile* file);
	void (*clear_raw_developer_files) (PhotoUpdates* self);
	void (*set_reimport_master) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_editable) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_raw_developments) (PhotoUpdates* self, gboolean reimport);
};

typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable* * monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _PhotoMonitor {
	MediaMonitor parent_instance;
	PhotoMonitorPrivate * priv;
};

struct _PhotoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _PhotoMonitorPrivate {
	Workers* workers;
	GeeArrayList* matched_editables;
	GeeArrayList* matched_developments;
	GeeHashMap* master_reimport_pending;
	GeeHashMap* editable_reimport_pending;
	GeeHashMap* raw_developments_reimport_pending;
};

typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _PhotoMonitorReimportMasterJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportMasterJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportMasterState* reimport_state;
	gboolean mark_online;
	GError* err;
};

struct _PhotoMonitorReimportMasterJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportEditableJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportEditableJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportEditableState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportEditableJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportRawDevelopmentJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportRawDevelopmentJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportRawDevelopmentState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportRawDevelopmentJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);

static gpointer photo_updates_parent_class = NULL;
static gpointer photo_monitor_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
static gpointer photo_monitor_reimport_master_job_parent_class = NULL;
static gpointer photo_monitor_reimport_editable_job_parent_class = NULL;
static gpointer photo_monitor_reimport_raw_development_job_parent_class = NULL;

gpointer monitorable_updates_ref (gpointer instance);
void monitorable_updates_unref (gpointer instance);
GParamSpec* param_spec_monitorable_updates (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_monitorable_updates (GValue* value,
                                    gpointer v_object);
void value_take_monitorable_updates (GValue* value,
                                     gpointer v_object);
gpointer value_get_monitorable_updates (const GValue* value);
GType monitorable_updates_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType photo_updates_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
PhotoUpdates* photo_updates_new (LibraryPhoto* photo);
PhotoUpdates* photo_updates_construct (GType object_type,
                                       LibraryPhoto* photo);
MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
MonitorableUpdates* monitorable_updates_construct (GType object_type,
                                                   Monitorable* monitorable);
static void photo_updates_real_mark_offline (MonitorableUpdates* base);
void monitorable_updates_mark_offline (MonitorableUpdates* self);
gboolean photo_updates_is_reimport_master (PhotoUpdates* self);
gboolean photo_updates_is_reimport_editable (PhotoUpdates* self);
GFile* photo_updates_get_editable_file (PhotoUpdates* self);
GFileInfo* photo_updates_get_editable_file_info (PhotoUpdates* self);
GeeCollection* photo_updates_get_raw_developer_files (PhotoUpdates* self);
static gboolean photo_updates_real_is_in_alteration (MonitorableUpdates* base);
gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self);
gboolean photo_updates_is_revert_to_master (PhotoUpdates* self);
void photo_updates_set_editable_file (PhotoUpdates* self,
                                      GFile* file);
static void photo_updates_real_set_editable_file (PhotoUpdates* self,
                                           GFile* file);
void photo_updates_set_editable_file_info (PhotoUpdates* self,
                                           GFileInfo* info);
static void photo_updates_real_set_editable_file_info (PhotoUpdates* self,
                                                GFileInfo* info);
void photo_updates_set_editable_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered);
static void photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered);
void photo_updates_set_editable_in_alteration (PhotoUpdates* self,
                                               gboolean in_alteration);
static void photo_updates_real_set_editable_in_alteration (PhotoUpdates* self,
                                                    gboolean in_alteration);
void photo_updates_set_raw_development_in_alteration (PhotoUpdates* self,
                                                      gboolean in_alteration);
static void photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self,
                                                           gboolean in_alteration);
void photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered);
static void photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                             gboolean altered);
void photo_updates_set_revert_to_master (PhotoUpdates* self,
                                         gboolean revert);
static void photo_updates_real_set_revert_to_master (PhotoUpdates* self,
                                              gboolean revert);
void photo_updates_add_raw_developer_file (PhotoUpdates* self,
                                           GFile* file);
static void photo_updates_real_add_raw_developer_file (PhotoUpdates* self,
                                                GFile* file);
void photo_updates_clear_raw_developer_files (PhotoUpdates* self);
static void photo_updates_real_clear_raw_developer_files (PhotoUpdates* self);
void photo_updates_set_reimport_master (PhotoUpdates* self,
                                        gboolean reimport);
static void photo_updates_real_set_reimport_master (PhotoUpdates* self,
                                             gboolean reimport);
void monitorable_updates_mark_online (MonitorableUpdates* self);
void photo_updates_set_reimport_editable (PhotoUpdates* self,
                                          gboolean reimport);
static void photo_updates_real_set_reimport_editable (PhotoUpdates* self,
                                               gboolean reimport);
gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self);
void photo_updates_set_reimport_raw_developments (PhotoUpdates* self,
                                                  gboolean reimport);
static void photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self,
                                                       gboolean reimport);
static gboolean photo_updates_real_is_all_updated (MonitorableUpdates* base);
gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
static void photo_updates_finalize (MonitorableUpdates * obj);
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType photo_monitor_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_background_job (GValue* value,
                               gpointer v_object);
void value_take_background_job (GValue* value,
                                gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
static GType photo_monitor_reimport_master_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType photo_monitor_reimport_editable_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType photo_monitor_reimport_raw_development_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PHOTO_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_MONITOR, PhotoMonitorPrivate))
#define PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE 20
#define PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE 5
PhotoMonitor* photo_monitor_new (Workers* workers,
                                 GCancellable* cancellable);
PhotoMonitor* photo_monitor_construct (GType object_type,
                                       Workers* workers,
                                       GCancellable* cancellable);
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
MediaMonitor* media_monitor_construct (GType object_type,
                                       MediaSourceCollection* sources,
                                       GCancellable* cancellable);
static MonitorableUpdates* photo_monitor_real_create_updates (MediaMonitor* base,
                                                       Monitorable* monitorable);
static MediaSourceCollection* photo_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean photo_monitor_real_is_file_represented (MediaMonitor* base,
                                                 GFile* file);
GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST;
static LibraryPhoto* photo_monitor_get_photo_state_by_file (PhotoMonitor* self,
                                                     GFile* file,
                                                     LibraryPhotoSourceCollectionState* state);
static void photo_monitor_real_close (MediaMonitor* base);
void background_job_cancel (BackgroundJob* self);
void media_monitor_close (MediaMonitor* self);
static void photo_monitor_cancel_reimports (PhotoMonitor* self,
                                     LibraryPhoto* photo);
static MediaMonitorDiscoveredFile photo_monitor_real_notify_file_discovered (MediaMonitor* base,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable* * monitorable);
static GeeCollection* photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                                GFileInfo* info,
                                                                GeeCollection* matches_master,
                                                                GeeCollection* matches_editable,
                                                                GeeCollection* matched_development);
gchar* data_object_to_string (DataObject* self);
gboolean photo_does_editable_exist (Photo* self);
void photo_revert_to_master (Photo* self,
                             gboolean notify);
void photo_monitor_update_editable_file (PhotoMonitor* self,
                                         LibraryPhoto* photo,
                                         GFile* file);
void photo_monitor_update_raw_development_file (PhotoMonitor* self,
                                                LibraryPhoto* photo,
                                                GFile* file);
static GFile** photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base,
                                                         Monitorable* monitorable,
                                                         int* result_length1);
gboolean photo_has_editable (Photo* self);
GFile* photo_get_editable_file (Photo* self);
static void _vala_array_add131 (GFile** * array,
                         int* length,
                         int* size,
                         GFile* value);
GeeCollection* photo_get_raw_developer_files (Photo* self);
static void _vala_array_add132 (GFile** * array,
                         int* length,
                         int* size,
                         GFile* value);
static GFile** _vala_array_dup26 (GFile** self,
                           int length);
static void photo_monitor_real_update_backing_file_info (MediaMonitor* base,
                                                  Monitorable* monitorable,
                                                  GFile* file,
                                                  GFileInfo* info);
GFile* media_monitor_get_master_file (MediaMonitor* self,
                                      Monitorable* monitorable);
static void photo_monitor_check_for_master_changes (PhotoMonitor* self,
                                             LibraryPhoto* photo,
                                             GFileInfo* info);
GFile* photo_monitor_get_editable_file (PhotoMonitor* self,
                                        LibraryPhoto* photo);
static void photo_monitor_check_for_editable_changes (PhotoMonitor* self,
                                               LibraryPhoto* photo,
                                               GFileInfo* info);
GeeCollection* photo_monitor_get_raw_development_files (PhotoMonitor* self,
                                                        LibraryPhoto* photo);
static void photo_monitor_check_for_raw_development_changes (PhotoMonitor* self,
                                                      LibraryPhoto* photo,
                                                      GFileInfo* info);
static void photo_monitor_real_notify_discovery_completing (MediaMonitor* base);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
BackingPhotoRow* photo_get_master_photo_row (Photo* self);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
gboolean backing_photo_row_is_touched (BackingPhotoRow* self,
                                       GFileInfo* info);
void media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                                    Monitorable* monitorable);
void media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                             Monitorable* monitorable,
                                                             GFileInfo* info);
void photo_monitor_update_reimport_master (PhotoMonitor* self,
                                           LibraryPhoto* photo);
void photo_monitor_update_revert_to_master (PhotoMonitor* self,
                                            LibraryPhoto* photo);
BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
void photo_monitor_update_editable_file_info_altered (PhotoMonitor* self,
                                                      LibraryPhoto* photo);
void photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self,
                                                               LibraryPhoto* photo,
                                                               GFileInfo* info);
void photo_monitor_update_reimport_editable (PhotoMonitor* self,
                                             LibraryPhoto* photo);
GType raw_developer_get_type (void) G_GNUC_CONST;
void photo_set_raw_developer (Photo* self,
                              RawDeveloper d,
                              gboolean notify);
GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType orientation_get_type (void) G_GNUC_CONST;
void photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self,
                                                             LibraryPhoto* photo);
void photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self,
                                                                      LibraryPhoto* photo);
void photo_monitor_update_reimport_raw_developments (PhotoMonitor* self,
                                                     LibraryPhoto* photo);
static gboolean photo_monitor_real_notify_file_created (MediaMonitor* base,
                                                 GFile* file,
                                                 GFileInfo* info);
const gchar* library_photo_source_collection_state_to_string (LibraryPhotoSourceCollectionState self);
void media_monitor_mdbg (const gchar* msg);
void media_monitor_update_online (MediaMonitor* self,
                                  Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_moved (MediaMonitor* base,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* info);
void media_monitor_update_master_file (MediaMonitor* self,
                                       Monitorable* monitorable,
                                       GFile* file);
void media_monitor_update_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_altered (MediaMonitor* base,
                                                 GFile* file);
void media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                     Monitorable* monitorable,
                                                     gboolean in_alteration);
void photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self,
                                                       LibraryPhoto* photo,
                                                       gboolean in_alteration);
void photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self,
                                                              LibraryPhoto* photo,
                                                              gboolean in_alteration);
static gboolean photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                            GFile* file);
static gboolean photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                              GFile* file,
                                                              GFileInfo* info);
static gboolean photo_monitor_real_notify_file_deleted (MediaMonitor* base,
                                                 GFile* file);
static void photo_monitor_real_on_media_source_destroyed (MediaMonitor* base,
                                                   DataSource* source);
void media_monitor_on_media_source_destroyed (MediaMonitor* self,
                                              DataSource* source);
gboolean media_monitor_has_pending_updates (MediaMonitor* self);
GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
PhotoUpdates* photo_monitor_get_existing_photo_updates (PhotoMonitor* self,
                                                        LibraryPhoto* photo);
GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
GFile* media_source_get_master_file (MediaSource* self);
LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                                 GFile* file,
                                                                 LibraryPhotoSourceCollectionState* state);
PhotoUpdates* photo_monitor_fetch_photo_updates (PhotoMonitor* self,
                                                 LibraryPhoto* photo);
MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self,
                                                 Monitorable* monitorable);
MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self,
                                                        Monitorable* monitorable);
static void photo_monitor_real_process_updates (MediaMonitor* base,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
void media_monitor_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error);
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
GQuark database_error_quark (void);
void photo_set_many_editable_file (GeeMap* map,
                                   GError** error);
void app_window_database_error (GError* err);
void photo_update_many_editable_timestamps (GeeMap* map,
                                            GError** error);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_new (PhotoMonitor* owner,
                                                                      LibraryPhoto* photo);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_construct (GType object_type,
                                                                            PhotoMonitor* owner,
                                                                            LibraryPhoto* photo);
void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_new (PhotoMonitor* owner,
                                                                          LibraryPhoto* photo);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_construct (GType object_type,
                                                                                PhotoMonitor* owner,
                                                                                LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner,
                                                                                       LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_construct (GType object_type,
                                                                                             PhotoMonitor* owner,
                                                                                             LibraryPhoto* photo);
static void photo_monitor_on_master_reimported (PhotoMonitor* self,
                                         BackgroundJob* j);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_master (Photo* self,
                                   PhotoReimportMasterState* state,
                                   GError** error);
gboolean media_source_is_offline (MediaSource* self);
static void photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self,
                                                 BackgroundJob* j);
static void photo_monitor_on_editable_reimported (PhotoMonitor* self,
                                           BackgroundJob* j);
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_editable (Photo* self,
                                     PhotoReimportEditableState* state,
                                     GError** error);
static void photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self,
                                                   BackgroundJob* j);
static void photo_monitor_on_raw_development_reimported (PhotoMonitor* self,
                                                  BackgroundJob* j);
gpointer photo_reimport_raw_development_state_ref (gpointer instance);
void photo_reimport_raw_development_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
void photo_value_set_reimport_raw_development_state (GValue* value,
                                                     gpointer v_object);
void photo_value_take_reimport_raw_development_state (GValue* value,
                                                      gpointer v_object);
gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState* state,
                                            GError** error);
static void photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self,
                                                          BackgroundJob* j);
static void _photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job,
                                                              gpointer self);
static void _photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                        gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         void* cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void photo_monitor_reimport_master_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_master (Photo* self,
                                            PhotoReimportMasterState* * reimport_state,
                                            GError** error);
static void photo_monitor_reimport_master_job_finalize (BackgroundJob * obj);
static void _photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job,
                                                                gpointer self);
static void _photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                          gpointer self);
static void photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_editable (Photo* self,
                                              PhotoReimportEditableState* * state,
                                              GError** error);
static void photo_monitor_reimport_editable_job_finalize (BackgroundJob * obj);
static void _photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job,
                                                                       gpointer self);
static void _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                                 gpointer self);
static void photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_raw_development (Photo* self,
                                                     PhotoReimportRawDevelopmentState* * state,
                                                     GError** error);
static void photo_monitor_reimport_raw_development_job_finalize (BackgroundJob * obj);
static void photo_monitor_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 1105 "PhotoMonitor.c"
}


PhotoUpdates*
photo_updates_construct (GType object_type,
                         LibraryPhoto* photo)
{
	PhotoUpdates* self = NULL;
	LibraryPhoto* _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 23 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoUpdates*) monitorable_updates_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _g_object_ref0 (photo);
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp0_;
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 1127 "PhotoMonitor.c"
}


PhotoUpdates*
photo_updates_new (LibraryPhoto* photo)
{
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_updates_construct (TYPE_PHOTO_UPDATES, photo);
#line 1136 "PhotoMonitor.c"
}


static void
photo_updates_real_mark_offline (MonitorableUpdates* base)
{
	PhotoUpdates * self;
#line 28 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 29 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->mark_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 31 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = FALSE;
#line 32 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = FALSE;
#line 33 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = FALSE;
#line 1154 "PhotoMonitor.c"
}


gboolean
photo_updates_is_reimport_master (PhotoUpdates* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->reimport_master;
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1171 "PhotoMonitor.c"
}


gboolean
photo_updates_is_reimport_editable (PhotoUpdates* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->reimport_editable;
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1188 "PhotoMonitor.c"
}


GFile*
photo_updates_get_editable_file (PhotoUpdates* self)
{
	GFile* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->editable_file;
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1208 "PhotoMonitor.c"
}


GFileInfo*
photo_updates_get_editable_file_info (PhotoUpdates* self)
{
	GFileInfo* result = NULL;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->editable_file_info;
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1228 "PhotoMonitor.c"
}


GeeCollection*
photo_updates_get_raw_developer_files (PhotoUpdates* self)
{
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 52 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1248 "PhotoMonitor.c"
}


static gboolean
photo_updates_real_is_in_alteration (MonitorableUpdates* base)
{
	PhotoUpdates * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 56 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates))) {
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = TRUE;
#line 1264 "PhotoMonitor.c"
	} else {
		gboolean _tmp1_;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->editable_in_alteration;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp1_;
#line 1271 "PhotoMonitor.c"
	}
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1277 "PhotoMonitor.c"
}


gboolean
photo_updates_is_revert_to_master (PhotoUpdates* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->revert_to_master;
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1294 "PhotoMonitor.c"
}


static void
photo_updates_real_set_editable_file (PhotoUpdates* self,
                                      GFile* file)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp2_;
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((file == NULL) || G_IS_FILE (file));
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (file != NULL) {
#line 1308 "PhotoMonitor.c"
		gboolean _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->revert_to_master;
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp1_;
#line 1314 "PhotoMonitor.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1318 "PhotoMonitor.c"
	}
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 67 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1324 "PhotoMonitor.c"
	}
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (file);
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file);
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file = _tmp2_;
#line 1332 "PhotoMonitor.c"
}


void
photo_updates_set_editable_file (PhotoUpdates* self,
                                 GFile* file)
{
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file (self, file);
#line 1344 "PhotoMonitor.c"
}


static void
photo_updates_real_set_editable_file_info (PhotoUpdates* self,
                                           GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	GFileInfo* _tmp2_;
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (info != NULL) {
#line 1358 "PhotoMonitor.c"
		gboolean _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->revert_to_master;
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp1_;
#line 1364 "PhotoMonitor.c"
	} else {
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1368 "PhotoMonitor.c"
	}
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 75 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1374 "PhotoMonitor.c"
	}
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (info);
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file_info);
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info = _tmp2_;
#line 78 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (info == NULL) {
#line 79 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file_info_altered = FALSE;
#line 1386 "PhotoMonitor.c"
	}
}


void
photo_updates_set_editable_file_info (PhotoUpdates* self,
                                      GFileInfo* info)
{
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file_info (self, info);
#line 1399 "PhotoMonitor.c"
}


static void
photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered)
{
	gboolean _tmp0_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (altered) {
#line 1410 "PhotoMonitor.c"
		gboolean _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->revert_to_master;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp1_;
#line 1416 "PhotoMonitor.c"
	} else {
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1420 "PhotoMonitor.c"
	}
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 85 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1426 "PhotoMonitor.c"
	}
#line 87 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info_altered = altered;
#line 1430 "PhotoMonitor.c"
}


void
photo_updates_set_editable_file_info_altered (PhotoUpdates* self,
                                              gboolean altered)
{
#line 82 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 82 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file_info_altered (self, altered);
#line 1442 "PhotoMonitor.c"
}


static void
photo_updates_real_set_editable_in_alteration (PhotoUpdates* self,
                                               gboolean in_alteration)
{
#line 91 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_in_alteration = in_alteration;
#line 1452 "PhotoMonitor.c"
}


void
photo_updates_set_editable_in_alteration (PhotoUpdates* self,
                                          gboolean in_alteration)
{
#line 90 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 90 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_in_alteration (self, in_alteration);
#line 1464 "PhotoMonitor.c"
}


static void
photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self,
                                                      gboolean in_alteration)
{
#line 95 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_development_in_alteration = in_alteration;
#line 1474 "PhotoMonitor.c"
}


void
photo_updates_set_raw_development_in_alteration (PhotoUpdates* self,
                                                 gboolean in_alteration)
{
#line 94 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 94 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_raw_development_in_alteration (self, in_alteration);
#line 1486 "PhotoMonitor.c"
}


static void
photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                        gboolean altered)
{
#line 99 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_developer_file_info_altered = altered;
#line 1496 "PhotoMonitor.c"
}


void
photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self,
                                                   gboolean altered)
{
#line 98 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 98 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_raw_developer_file_info_altered (self, altered);
#line 1508 "PhotoMonitor.c"
}


static void
photo_updates_real_set_revert_to_master (PhotoUpdates* self,
                                         gboolean revert)
{
#line 103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (revert) {
#line 105 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->reimport_editable = FALSE;
#line 106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (self->editable_file);
#line 106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file = NULL;
#line 107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (self->editable_file_info);
#line 107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file_info = NULL;
#line 1528 "PhotoMonitor.c"
	}
#line 110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->revert_to_master = revert;
#line 1532 "PhotoMonitor.c"
}


void
photo_updates_set_revert_to_master (PhotoUpdates* self,
                                    gboolean revert)
{
#line 102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_revert_to_master (self, revert);
#line 1544 "PhotoMonitor.c"
}


static void
photo_updates_real_add_raw_developer_file (PhotoUpdates* self,
                                           GFile* file)
{
	GeeCollection* _tmp0_;
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 114 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 114 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_collection_add (_tmp0_, file);
#line 1559 "PhotoMonitor.c"
}


void
photo_updates_add_raw_developer_file (PhotoUpdates* self,
                                      GFile* file)
{
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->add_raw_developer_file (self, file);
#line 1571 "PhotoMonitor.c"
}


static void
photo_updates_real_clear_raw_developer_files (PhotoUpdates* self)
{
	GeeCollection* _tmp0_;
#line 118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_collection_clear (_tmp0_);
#line 1583 "PhotoMonitor.c"
}


void
photo_updates_clear_raw_developer_files (PhotoUpdates* self)
{
#line 117 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 117 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->clear_raw_developer_files (self);
#line 1594 "PhotoMonitor.c"
}


static void
photo_updates_real_set_reimport_master (PhotoUpdates* self,
                                        gboolean reimport)
{
#line 122 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = reimport;
#line 124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (reimport) {
#line 125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 1608 "PhotoMonitor.c"
	}
}


void
photo_updates_set_reimport_master (PhotoUpdates* self,
                                   gboolean reimport)
{
#line 121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_master (self, reimport);
#line 1621 "PhotoMonitor.c"
}


static void
photo_updates_real_set_reimport_editable (PhotoUpdates* self,
                                          gboolean reimport)
{
	gboolean _tmp0_ = FALSE;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (reimport) {
#line 1632 "PhotoMonitor.c"
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = self->revert_to_master;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp2_) {
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp1_ = TRUE;
#line 1641 "PhotoMonitor.c"
		} else {
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp1_ = monitorable_updates_is_set_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 1645 "PhotoMonitor.c"
		}
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp1_;
#line 1649 "PhotoMonitor.c"
	} else {
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1653 "PhotoMonitor.c"
	}
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 131 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1659 "PhotoMonitor.c"
	}
#line 133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = reimport;
#line 1663 "PhotoMonitor.c"
}


void
photo_updates_set_reimport_editable (PhotoUpdates* self,
                                     gboolean reimport)
{
#line 128 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 128 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_editable (self, reimport);
#line 1675 "PhotoMonitor.c"
}


static void
photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self,
                                                  gboolean reimport)
{
#line 137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = reimport;
#line 139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (reimport) {
#line 140 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 1689 "PhotoMonitor.c"
	}
}


void
photo_updates_set_reimport_raw_developments (PhotoUpdates* self,
                                             gboolean reimport)
{
#line 136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_raw_developments (self, reimport);
#line 1702 "PhotoMonitor.c"
}


static gboolean
photo_updates_real_is_all_updated (MonitorableUpdates* base)
{
	PhotoUpdates * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates))) {
#line 1724 "PhotoMonitor.c"
		gboolean _tmp9_;
#line 145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = self->reimport_master;
#line 145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = _tmp9_ == FALSE;
#line 1730 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = FALSE;
#line 1734 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_) {
#line 1738 "PhotoMonitor.c"
		gboolean _tmp10_;
#line 146 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = self->reimport_editable;
#line 146 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = _tmp10_ == FALSE;
#line 1744 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = FALSE;
#line 1748 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_) {
#line 1752 "PhotoMonitor.c"
		GFile* _tmp11_;
#line 147 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = self->editable_file;
#line 147 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = _tmp11_ == NULL;
#line 1758 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = FALSE;
#line 1762 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp6_) {
#line 1766 "PhotoMonitor.c"
		gboolean _tmp12_;
#line 148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = self->editable_file_info_altered;
#line 148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _tmp12_ == FALSE;
#line 1772 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = FALSE;
#line 1776 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 1780 "PhotoMonitor.c"
		GFileInfo* _tmp13_;
#line 149 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = self->editable_file_info;
#line 149 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = _tmp13_ == NULL;
#line 1786 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = FALSE;
#line 1790 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 1794 "PhotoMonitor.c"
		gboolean _tmp14_;
#line 150 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = self->editable_in_alteration;
#line 150 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp14_ == FALSE;
#line 1800 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = FALSE;
#line 1804 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_) {
#line 1808 "PhotoMonitor.c"
		GeeCollection* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = self->developer_files;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = gee_collection_get_size (_tmp15_);
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp16_;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp17_ == 0;
#line 1820 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = FALSE;
#line 1824 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_) {
#line 1828 "PhotoMonitor.c"
		gboolean _tmp18_;
#line 152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = self->raw_developer_file_info_altered;
#line 152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp18_ == FALSE;
#line 1834 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = FALSE;
#line 1838 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 1842 "PhotoMonitor.c"
		gboolean _tmp19_;
#line 153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = self->revert_to_master;
#line 153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp19_ == FALSE;
#line 1848 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1852 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1858 "PhotoMonitor.c"
}


static void
photo_updates_class_init (PhotoUpdatesClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->finalize = photo_updates_finalize;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->mark_offline = (void (*) (MonitorableUpdates *)) photo_updates_real_mark_offline;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_in_alteration = (gboolean (*) (MonitorableUpdates *)) photo_updates_real_is_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file = (void (*) (PhotoUpdates *, GFile*)) photo_updates_real_set_editable_file;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file_info = (void (*) (PhotoUpdates *, GFileInfo*)) photo_updates_real_set_editable_file_info;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file_info_altered = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_editable_file_info_altered;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_in_alteration = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_editable_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_raw_development_in_alteration = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_raw_development_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_raw_developer_file_info_altered = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_raw_developer_file_info_altered;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_revert_to_master = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_revert_to_master;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->add_raw_developer_file = (void (*) (PhotoUpdates *, GFile*)) photo_updates_real_add_raw_developer_file;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->clear_raw_developer_files = (void (*) (PhotoUpdates *)) photo_updates_real_clear_raw_developer_files;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_master = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_reimport_master;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_editable = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_reimport_editable;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_raw_developments = (void (*) (PhotoUpdates *, gboolean)) photo_updates_real_set_reimport_raw_developments;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates *)) photo_updates_real_is_all_updated;
#line 1899 "PhotoMonitor.c"
}


static void
photo_updates_instance_init (PhotoUpdates * self)
{
	GeeArrayList* _tmp0_;
#line 10 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = FALSE;
#line 11 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = FALSE;
#line 12 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = FALSE;
#line 13 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file = NULL;
#line 14 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info_altered = FALSE;
#line 15 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_developer_file_info_altered = FALSE;
#line 16 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info = NULL;
#line 17 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_in_alteration = FALSE;
#line 18 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_development_in_alteration = FALSE;
#line 19 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->revert_to_master = FALSE;
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1931 "PhotoMonitor.c"
}


static void
photo_updates_finalize (MonitorableUpdates * obj)
{
	PhotoUpdates * self;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 8 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 13 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file);
#line 16 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file_info);
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->developer_files);
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->finalize (obj);
#line 1951 "PhotoMonitor.c"
}


GType
photo_updates_get_type (void)
{
	static volatile gsize photo_updates_type_id__volatile = 0;
	if (g_once_init_enter (&photo_updates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoUpdates), 0, (GInstanceInitFunc) photo_updates_instance_init, NULL };
		GType photo_updates_type_id;
		photo_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "PhotoUpdates", &g_define_type_info, 0);
		g_once_init_leave (&photo_updates_type_id__volatile, photo_updates_type_id);
	}
	return photo_updates_type_id__volatile;
}


static gpointer
_workers_ref0 (gpointer self)
{
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? workers_ref (self) : NULL;
#line 1974 "PhotoMonitor.c"
}


PhotoMonitor*
photo_monitor_construct (GType object_type,
                         Workers* workers,
                         GCancellable* cancellable)
{
	PhotoMonitor * self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	Workers* _tmp1_;
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 238 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = library_photo_global;
#line 238 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitor*) media_monitor_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), cancellable);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _workers_ref0 (workers);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->workers = _tmp1_;
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 2002 "PhotoMonitor.c"
}


PhotoMonitor*
photo_monitor_new (Workers* workers,
                   GCancellable* cancellable)
{
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_construct (TYPE_PHOTO_MONITOR, workers, cancellable);
#line 2012 "PhotoMonitor.c"
}


static MonitorableUpdates*
photo_monitor_real_create_updates (MediaMonitor* base,
                                   Monitorable* monitorable)
{
	PhotoMonitor * self;
	MonitorableUpdates* result = NULL;
	PhotoUpdates* _tmp0_;
#line 243 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 243 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 244 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (monitorable, TYPE_LIBRARY_PHOTO), "monitorable is LibraryPhoto");
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_updates_new (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2035 "PhotoMonitor.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? data_collection_ref (self) : NULL;
#line 2044 "PhotoMonitor.c"
}


static MediaSourceCollection*
photo_monitor_real_get_media_source_collection (MediaMonitor* base)
{
	PhotoMonitor * self;
	MediaSourceCollection* result = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
#line 249 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = library_photo_global;
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _data_collection_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2065 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_is_file_represented (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	gboolean _tmp3_;
#line 253 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 253 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp2_);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp3_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2098 "PhotoMonitor.c"
}


static void
photo_monitor_real_close (MediaMonitor* base)
{
	PhotoMonitor * self;
#line 258 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 2108 "PhotoMonitor.c"
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = self->priv->master_reimport_pending;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp1_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp2_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _tmp4_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 2135 "PhotoMonitor.c"
			GeeIterator* _tmp6_;
			PhotoMonitorReimportMasterJob* job = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PhotoMonitorReimportMasterJob* _tmp9_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _job_it;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 2147 "PhotoMonitor.c"
			}
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _job_it;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportMasterJob*) _tmp8_;
#line 260 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = job;
#line 260 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 2161 "PhotoMonitor.c"
		}
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 2165 "PhotoMonitor.c"
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_;
		GeeIterator* _tmp15_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = self->priv->editable_reimport_pending;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = _tmp11_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = _tmp14_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp13_);
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp15_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 2193 "PhotoMonitor.c"
			GeeIterator* _tmp16_;
			PhotoMonitorReimportEditableJob* job = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			PhotoMonitorReimportEditableJob* _tmp19_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = _job_it;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!gee_iterator_next (_tmp16_)) {
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 2205 "PhotoMonitor.c"
			}
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _job_it;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportEditableJob*) _tmp18_;
#line 263 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = job;
#line 263 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 2219 "PhotoMonitor.c"
		}
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 2223 "PhotoMonitor.c"
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp20_;
		GeeCollection* _tmp21_;
		GeeCollection* _tmp22_;
		GeeCollection* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _tmp25_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = self->priv->raw_developments_reimport_pending;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp21_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = _tmp21_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = _tmp22_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp25_ = _tmp24_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp23_);
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp25_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 2251 "PhotoMonitor.c"
			GeeIterator* _tmp26_;
			PhotoMonitorReimportRawDevelopmentJob* job = NULL;
			GeeIterator* _tmp27_;
			gpointer _tmp28_;
			PhotoMonitorReimportRawDevelopmentJob* _tmp29_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = _job_it;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!gee_iterator_next (_tmp26_)) {
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 2263 "PhotoMonitor.c"
			}
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = _job_it;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = gee_iterator_get (_tmp27_);
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportRawDevelopmentJob*) _tmp28_;
#line 266 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = job;
#line 266 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 2277 "PhotoMonitor.c"
		}
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 2281 "PhotoMonitor.c"
	}
#line 268 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 2285 "PhotoMonitor.c"
}


static void
photo_monitor_cancel_reimports (PhotoMonitor* self,
                                LibraryPhoto* photo)
{
	PhotoMonitorReimportMasterJob* master_job = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PhotoMonitorReimportMasterJob* _tmp2_;
	PhotoMonitorReimportEditableJob* editable_job = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	PhotoMonitorReimportEditableJob* _tmp6_;
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->master_reimport_pending;
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	master_job = (PhotoMonitorReimportMasterJob*) _tmp1_;
#line 273 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = master_job;
#line 273 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ != NULL) {
#line 2315 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp3_;
#line 274 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = master_job;
#line 274 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 2321 "PhotoMonitor.c"
	}
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = self->priv->editable_reimport_pending;
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	editable_job = (PhotoMonitorReimportEditableJob*) _tmp5_;
#line 277 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = editable_job;
#line 277 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp6_ != NULL) {
#line 2333 "PhotoMonitor.c"
		PhotoMonitorReimportEditableJob* _tmp7_;
#line 278 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = editable_job;
#line 278 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 2339 "PhotoMonitor.c"
	}
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (editable_job);
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (master_job);
#line 2345 "PhotoMonitor.c"
}


static MediaMonitorDiscoveredFile
photo_monitor_real_notify_file_discovered (MediaMonitor* base,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable* * monitorable)
{
	PhotoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	MediaMonitorDiscoveredFile result = 0;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), 0);
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 285 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 285 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 286 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 286 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_monitorable = NULL;
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (monitorable) {
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*monitorable = _vala_monitorable;
#line 2392 "PhotoMonitor.c"
		} else {
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 2396 "PhotoMonitor.c"
		}
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2400 "PhotoMonitor.c"
	}
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 2410 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp4_;
			Monitorable* _tmp5_;
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = photo;
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable));
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_vala_monitorable = _tmp5_;
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (photo);
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (monitorable) {
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 2430 "PhotoMonitor.c"
			} else {
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 2434 "PhotoMonitor.c"
			}
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return result;
#line 2438 "PhotoMonitor.c"
		}
		default:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 2447 "PhotoMonitor.c"
		{
#line 304 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 304 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_vala_monitorable = NULL;
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (photo);
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (monitorable) {
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 2461 "PhotoMonitor.c"
			} else {
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 2465 "PhotoMonitor.c"
			}
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return result;
#line 2469 "PhotoMonitor.c"
		}
	}
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (monitorable) {
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*monitorable = _vala_monitorable;
#line 2478 "PhotoMonitor.c"
	} else {
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 2482 "PhotoMonitor.c"
	}
}


static GeeCollection*
photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	PhotoMonitor * self;
	MediaMonitorDiscoveredFile _vala_result = 0;
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeCollection* matched_masters = NULL;
	GeeArrayList* _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeArrayList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), NULL);
#line 313 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->matched_editables;
#line 313 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 314 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = self->priv->matched_developments;
#line 314 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 316 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 316 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	matched_masters = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = library_photo_global;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = matched_masters;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = self->priv->matched_editables;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = self->priv->matched_developments;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	library_photo_source_collection_fetch_by_matching_backing (_tmp3_, info, _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = matched_masters;
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = gee_collection_get_size (_tmp7_);
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp9_ = _tmp8_;
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp9_ > 0) {
#line 320 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = matched_masters;
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_result_) {
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*_result_ = _vala_result;
#line 2561 "PhotoMonitor.c"
		}
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2565 "PhotoMonitor.c"
	}
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp11_ = self->priv->matched_editables;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp13_ = _tmp12_;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp13_ == 0) {
#line 2575 "PhotoMonitor.c"
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = self->priv->matched_developments;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = _tmp15_;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = _tmp16_ == 0;
#line 2587 "PhotoMonitor.c"
	} else {
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = FALSE;
#line 2591 "PhotoMonitor.c"
	}
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp10_) {
#line 326 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = NULL;
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (matched_masters);
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_result_) {
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*_result_ = _vala_result;
#line 2605 "PhotoMonitor.c"
		}
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2609 "PhotoMonitor.c"
	}
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp17_ = self->priv->matched_editables;
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp19_ = _tmp18_;
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp19_ > 0) {
#line 2619 "PhotoMonitor.c"
		LibraryPhoto* match = NULL;
		GeeArrayList* _tmp20_;
		gpointer _tmp21_;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		LibraryPhoto* _tmp48_;
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = self->priv->matched_editables;
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp21_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		match = (LibraryPhoto*) _tmp21_;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = self->priv->matched_editables;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = _tmp23_;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp24_ > 1) {
#line 2641 "PhotoMonitor.c"
			gchar* _tmp25_;
			gchar* _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			LibraryPhoto* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = g_file_get_path (file);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = _tmp25_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = self->priv->matched_editables;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = _tmp28_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp30_ = match;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp31_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_DATA_OBJECT, DataObject));
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp32_ = _tmp31_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:335: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp26_, _tmp29_, _tmp32_);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp32_);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp26_);
#line 2672 "PhotoMonitor.c"
			{
				gint ctr = 0;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				ctr = 1;
#line 2677 "PhotoMonitor.c"
				{
					gboolean _tmp33_ = FALSE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp33_ = TRUE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					while (TRUE) {
#line 2684 "PhotoMonitor.c"
						gint _tmp35_;
						GeeArrayList* _tmp36_;
						gint _tmp37_;
						gint _tmp38_;
						GeeArrayList* _tmp39_;
						gint _tmp40_;
						gpointer _tmp41_;
						LibraryPhoto* _tmp42_;
						gboolean _tmp43_;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!_tmp33_) {
#line 2696 "PhotoMonitor.c"
							gint _tmp34_;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp34_ = ctr;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							ctr = _tmp34_ + 1;
#line 2702 "PhotoMonitor.c"
						}
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp33_ = FALSE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp35_ = ctr;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp36_ = self->priv->matched_editables;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp37_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp38_ = _tmp37_;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!(_tmp35_ < _tmp38_)) {
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							break;
#line 2718 "PhotoMonitor.c"
						}
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp39_ = self->priv->matched_editables;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp40_ = ctr;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp41_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp40_);
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp42_ = (LibraryPhoto*) _tmp41_;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp43_ = !photo_does_editable_exist (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_PHOTO, Photo));
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_tmp42_);
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (_tmp43_) {
#line 2734 "PhotoMonitor.c"
							GeeArrayList* _tmp44_;
							gint _tmp45_;
							gpointer _tmp46_;
							LibraryPhoto* _tmp47_;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp44_ = self->priv->matched_editables;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp45_ = ctr;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp46_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp45_);
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp47_ = (LibraryPhoto*) _tmp46_;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_PHOTO, Photo), TRUE);
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_g_object_unref0 (_tmp47_);
#line 2751 "PhotoMonitor.c"
						}
					}
				}
			}
		}
#line 343 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp48_ = match;
#line 343 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file (self, _tmp48_, file);
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (match);
#line 2763 "PhotoMonitor.c"
	}
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp49_ = self->priv->matched_developments;
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp50_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp51_ = _tmp50_;
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp51_ > 0) {
#line 2773 "PhotoMonitor.c"
		LibraryPhoto* match_raw = NULL;
		GeeArrayList* _tmp52_;
		gpointer _tmp53_;
		GeeArrayList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		LibraryPhoto* _tmp65_;
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp52_ = self->priv->matched_developments;
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp53_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		match_raw = (LibraryPhoto*) _tmp53_;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp54_ = self->priv->matched_developments;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp55_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp56_ = _tmp55_;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp56_ > 1) {
#line 2795 "PhotoMonitor.c"
			gchar* _tmp57_;
			gchar* _tmp58_;
			GeeArrayList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			LibraryPhoto* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp57_ = g_file_get_path (file);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp58_ = _tmp57_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp59_ = self->priv->matched_developments;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp60_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp61_ = _tmp60_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp62_ = match_raw;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp63_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_DATA_OBJECT, DataObject));
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp64_ = _tmp63_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:349: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp58_, _tmp61_, _tmp64_);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp64_);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp58_);
#line 2826 "PhotoMonitor.c"
		}
#line 353 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp65_ = match_raw;
#line 353 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_raw_development_file (self, _tmp65_, file);
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (match_raw);
#line 2834 "PhotoMonitor.c"
	}
#line 356 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = NULL;
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (matched_masters);
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_result_) {
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*_result_ = _vala_result;
#line 2846 "PhotoMonitor.c"
	}
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2850 "PhotoMonitor.c"
}


static void
_vala_array_add131 (GFile** * array,
                    int* length,
                    int* size,
                    GFile* value)
{
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if ((*length) == (*size)) {
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2866 "PhotoMonitor.c"
	}
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[(*length)++] = value;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[*length] = NULL;
#line 2872 "PhotoMonitor.c"
}


static void
_vala_array_add132 (GFile** * array,
                    int* length,
                    int* size,
                    GFile* value)
{
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if ((*length) == (*size)) {
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2888 "PhotoMonitor.c"
	}
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[(*length)++] = value;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[*length] = NULL;
#line 2894 "PhotoMonitor.c"
}


static GFile**
_vala_array_dup26 (GFile** self,
                   int length)
{
	GFile** result;
	int i;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = g_new0 (GFile*, length + 1);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	for (i = 0; i < length; i++) {
#line 2908 "PhotoMonitor.c"
		GFile* _tmp0_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result[i] = _tmp0_;
#line 2914 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2918 "PhotoMonitor.c"
}


static GFile**
photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base,
                                                 Monitorable* monitorable,
                                                 int* result_length1)
{
	PhotoMonitor * self;
	GFile** result = NULL;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	LibraryPhoto* _tmp2_;
	GeeCollection* raw_files = NULL;
	LibraryPhoto* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GFile** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint __tmp17__size_ = 0;
	GFile** _tmp18_;
	gint _tmp18__length1;
	GFile** _tmp20_;
	gint _tmp20__length1;
	GFile** _tmp21_;
	gint _tmp21__length1;
#line 361 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 361 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 362 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 362 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp0_;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = g_new0 (GFile*, 0 + 1);
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files = _tmp1_;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files_length1 = 0;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_files_size_ = files_length1;
#line 366 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 366 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo))) {
#line 2969 "PhotoMonitor.c"
		GFile** _tmp3_;
		gint _tmp3__length1;
		LibraryPhoto* _tmp4_;
		GFile* _tmp5_;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = files;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3__length1 = files_length1;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = photo;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO, Photo));
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_array_add131 (&files, &files_length1, &_files_size_, _tmp5_);
#line 2984 "PhotoMonitor.c"
	}
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = photo;
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	raw_files = _tmp7_;
#line 371 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = raw_files;
#line 371 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_ != NULL) {
#line 2996 "PhotoMonitor.c"
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp9_;
			GeeIterator* _tmp10_;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = raw_files;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_f_it = _tmp10_;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 3009 "PhotoMonitor.c"
				GeeIterator* _tmp11_;
				GFile* f = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				GFile** _tmp14_;
				gint _tmp14__length1;
				GFile* _tmp15_;
				GFile* _tmp16_;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = _f_it;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!gee_iterator_next (_tmp11_)) {
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3024 "PhotoMonitor.c"
				}
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp12_ = _f_it;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = gee_iterator_get (_tmp12_);
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				f = (GFile*) _tmp13_;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = files;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14__length1 = files_length1;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = f;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_array_add132 (&files, &files_length1, &_files_size_, _tmp16_);
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (f);
#line 3044 "PhotoMonitor.c"
			}
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_f_it);
#line 3048 "PhotoMonitor.c"
		}
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18_ = files;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18__length1 = files_length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp18__length1 > 0) {
#line 3057 "PhotoMonitor.c"
		GFile** _tmp19_;
		gint _tmp19__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = files;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19__length1 = files_length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp19_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17__length1 = _tmp19__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		__tmp17__size_ = _tmp17__length1;
#line 3070 "PhotoMonitor.c"
	} else {
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17__length1 = 0;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		__tmp17__size_ = _tmp17__length1;
#line 3078 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp20_ = (_tmp17_ != NULL) ? _vala_array_dup26 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp20__length1 = _tmp17__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = _tmp20_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21__length1 = _tmp20__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (result_length1) {
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*result_length1 = _tmp21__length1;
#line 3092 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp21_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (raw_files);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 3104 "PhotoMonitor.c"
}


static void
photo_monitor_real_update_backing_file_info (MediaMonitor* base,
                                             Monitorable* monitorable,
                                             GFile* file,
                                             GFileInfo* info)
{
	PhotoMonitor * self;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 380 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 380 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp0_;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = media_monitor_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MONITORABLE, Monitorable));
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = g_file_equal (_tmp3_, file);
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp3_);
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 3145 "PhotoMonitor.c"
		LibraryPhoto* _tmp5_;
#line 383 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = photo;
#line 383 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_check_for_master_changes (self, _tmp5_, info);
#line 3151 "PhotoMonitor.c"
	} else {
		gboolean _tmp6_ = FALSE;
		LibraryPhoto* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gboolean _tmp10_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = photo;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = photo_monitor_get_editable_file (self, _tmp7_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = _tmp8_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = _tmp9_ != NULL;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp9_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp10_) {
#line 3170 "PhotoMonitor.c"
			LibraryPhoto* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = photo_monitor_get_editable_file (self, _tmp11_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = _tmp12_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = g_file_equal (_tmp13_, file);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp13_);
#line 3184 "PhotoMonitor.c"
		} else {
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = FALSE;
#line 3188 "PhotoMonitor.c"
		}
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp6_) {
#line 3192 "PhotoMonitor.c"
			LibraryPhoto* _tmp14_;
#line 385 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = photo;
#line 385 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_check_for_editable_changes (self, _tmp14_, info);
#line 3198 "PhotoMonitor.c"
		} else {
			LibraryPhoto* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gboolean _tmp18_;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = photo;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = photo_monitor_get_raw_development_files (self, _tmp15_);
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _tmp16_;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = _tmp17_ != NULL;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp17_);
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp18_) {
#line 3216 "PhotoMonitor.c"
				{
					GeeIterator* _f_it = NULL;
					LibraryPhoto* _tmp19_;
					GeeCollection* _tmp20_;
					GeeCollection* _tmp21_;
					GeeIterator* _tmp22_;
					GeeIterator* _tmp23_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp19_ = photo;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp20_ = photo_monitor_get_raw_development_files (self, _tmp19_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp21_ = _tmp20_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp22_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ITERABLE, GeeIterable));
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp23_ = _tmp22_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp21_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_f_it = _tmp23_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					while (TRUE) {
#line 3240 "PhotoMonitor.c"
						GeeIterator* _tmp24_;
						GFile* f = NULL;
						GeeIterator* _tmp25_;
						gpointer _tmp26_;
						GFile* _tmp27_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp24_ = _f_it;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!gee_iterator_next (_tmp24_)) {
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							break;
#line 3252 "PhotoMonitor.c"
						}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp25_ = _f_it;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp26_ = gee_iterator_get (_tmp25_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						f = (GFile*) _tmp26_;
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp27_ = f;
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (g_file_equal (_tmp27_, file)) {
#line 3264 "PhotoMonitor.c"
							LibraryPhoto* _tmp28_;
#line 389 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp28_ = photo;
#line 389 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							photo_monitor_check_for_raw_development_changes (self, _tmp28_, info);
#line 3270 "PhotoMonitor.c"
						}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (f);
#line 3274 "PhotoMonitor.c"
					}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_f_it);
#line 3278 "PhotoMonitor.c"
				}
			}
		}
	}
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 3285 "PhotoMonitor.c"
}


static void
photo_monitor_real_notify_discovery_completing (MediaMonitor* base)
{
	PhotoMonitor * self;
	GeeArrayList* _tmp0_;
#line 394 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 395 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->matched_editables;
#line 395 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3300 "PhotoMonitor.c"
}


static void
photo_monitor_check_for_master_changes (PhotoMonitor* self,
                                        LibraryPhoto* photo,
                                        GFileInfo* info)
{
	BackingPhotoRow* state = NULL;
	BackingPhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	BackingPhotoRow* _tmp2_;
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 404 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (info == NULL) {
#line 405 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3323 "PhotoMonitor.c"
	}
#line 407 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
#line 407 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = state;
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (backing_photo_row_matches_file_info (_tmp1_, info)) {
#line 409 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_backing_photo_row_unref0 (state);
#line 409 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3337 "PhotoMonitor.c"
	}
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = state;
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (backing_photo_row_is_touched (_tmp2_, info)) {
#line 412 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
#line 413 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable), info);
#line 3347 "PhotoMonitor.c"
	} else {
#line 415 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_reimport_master (self, photo);
#line 3351 "PhotoMonitor.c"
	}
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_backing_photo_row_unref0 (state);
#line 3355 "PhotoMonitor.c"
}


static void
photo_monitor_check_for_editable_changes (PhotoMonitor* self,
                                          LibraryPhoto* photo,
                                          GFileInfo* info)
{
	BackingPhotoRow* state = NULL;
	BackingPhotoRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BackingPhotoRow* _tmp2_;
	BackingPhotoRow* _tmp4_;
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 420 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (info == NULL) {
#line 421 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_revert_to_master (self, photo);
#line 423 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3381 "PhotoMonitor.c"
	}
#line 427 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
#line 427 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = state;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = TRUE;
#line 3393 "PhotoMonitor.c"
	} else {
		BackingPhotoRow* _tmp3_;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = state;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = backing_photo_row_matches_file_info (_tmp3_, info);
#line 3400 "PhotoMonitor.c"
	}
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 429 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_backing_photo_row_unref0 (state);
#line 429 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3408 "PhotoMonitor.c"
	}
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (backing_photo_row_is_touched (_tmp4_, info)) {
#line 432 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file_info_altered (self, photo);
#line 433 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file_alterations_completed (self, photo, info);
#line 3418 "PhotoMonitor.c"
	} else {
#line 435 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_reimport_editable (self, photo);
#line 3422 "PhotoMonitor.c"
	}
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_backing_photo_row_unref0 (state);
#line 3426 "PhotoMonitor.c"
}


static void
photo_monitor_check_for_raw_development_changes (PhotoMonitor* self,
                                                 LibraryPhoto* photo,
                                                 GFileInfo* info)
{
	GeeCollection* rows = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 440 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (info == NULL) {
#line 442 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_set_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo), RAW_DEVELOPER_SHOTWELL, TRUE);
#line 444 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3450 "PhotoMonitor.c"
	}
#line 447 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
#line 447 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	rows = _tmp0_;
#line 448 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = rows;
#line 448 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_ == NULL) {
#line 449 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (rows);
#line 449 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3464 "PhotoMonitor.c"
	}
	{
		GeeIterator* _row_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = rows;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_row_it = _tmp3_;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 3478 "PhotoMonitor.c"
			GeeIterator* _tmp4_;
			BackingPhotoRow* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			BackingPhotoRow* _tmp7_;
			const gchar* _tmp8_;
			BackingPhotoRow* _tmp9_;
			const gchar* _tmp10_;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = _row_it;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3493 "PhotoMonitor.c"
			}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = _row_it;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			row = (BackingPhotoRow*) _tmp6_;
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = row;
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (backing_photo_row_matches_file_info (_tmp7_, info)) {
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_backing_photo_row_unref0 (row);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_row_it);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (rows);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 3513 "PhotoMonitor.c"
			}
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = g_file_info_get_name (info);
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = row;
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = _tmp9_->filepath;
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (g_strcmp0 (_tmp8_, _tmp10_) == 0) {
#line 3523 "PhotoMonitor.c"
				BackingPhotoRow* _tmp11_;
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = row;
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (backing_photo_row_is_touched (_tmp11_, info)) {
#line 458 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_raw_development_file_info_altered (self, photo);
#line 459 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_raw_development_file_alterations_completed (self, photo);
#line 3533 "PhotoMonitor.c"
				} else {
#line 461 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_raw_developments (self, photo);
#line 3537 "PhotoMonitor.c"
				}
#line 464 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_backing_photo_row_unref0 (row);
#line 464 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3543 "PhotoMonitor.c"
			}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_backing_photo_row_unref0 (row);
#line 3547 "PhotoMonitor.c"
		}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_row_it);
#line 3551 "PhotoMonitor.c"
	}
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (rows);
#line 3555 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_created (MediaMonitor* base,
                                        GFile* file,
                                        GFileInfo* info)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 472 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 472 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 3594 "PhotoMonitor.c"
	}
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3608 "PhotoMonitor.c"
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			LibraryPhotoSourceCollectionState _tmp6_;
			GEnumValue* _tmp7_;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = g_file_get_path (file);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = _tmp4_;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = state;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp6_);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:481: File %s created in %s state", _tmp5_, (_tmp7_ != NULL) ? _tmp7_->value_name : NULL);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp5_);
#line 482 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 3628 "PhotoMonitor.c"
		}
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3632 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			LibraryPhoto* _tmp13_;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = photo;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject));
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = _tmp9_;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = g_strdup_printf ("Will mark %s online", _tmp10_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = _tmp11_;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp12_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp12_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp10_);
#line 486 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = photo;
#line 486 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE, Monitorable));
#line 487 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 3662 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp14_;
			GEnumValue* _tmp15_;
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = state;
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp14_);
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:490: Unknown LibraryPhoto collection state %s", (_tmp15_ != NULL) ? _tmp15_->value_name : NULL);
#line 3674 "PhotoMonitor.c"
		}
	}
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 3683 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_moved (MediaMonitor* base,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* info)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState old_state = 0;
	LibraryPhoto* old_photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhotoSourceCollectionState new_state = 0;
	LibraryPhoto* new_photo = NULL;
	LibraryPhotoSourceCollectionState _tmp2_ = 0;
	LibraryPhoto* _tmp3_;
	gboolean _tmp4_ = FALSE;
	LibraryPhoto* _tmp5_;
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (old_file), FALSE);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (new_file), FALSE);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, old_file, &_tmp0_);
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	old_state = _tmp0_;
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	old_photo = _tmp1_;
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo_monitor_get_photo_state_by_file (self, new_file, &_tmp2_);
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	new_state = _tmp2_;
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	new_photo = _tmp3_;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = old_photo;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_ != NULL) {
#line 3729 "PhotoMonitor.c"
		LibraryPhoto* _tmp6_;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = new_photo;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 3735 "PhotoMonitor.c"
	} else {
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = FALSE;
#line 3739 "PhotoMonitor.c"
	}
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 3743 "PhotoMonitor.c"
		LibraryPhotoSourceCollectionState _tmp7_;
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = old_state;
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		switch (_tmp7_) {
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3755 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				LibraryPhoto* _tmp15_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp8_ = old_photo;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject));
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp10_ = _tmp9_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = g_file_get_path (new_file);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp12_ = _tmp11_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = g_strdup_printf ("Will set new master file for %s to %s", _tmp10_, _tmp12_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = _tmp13_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp14_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp14_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp12_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp10_);
#line 523 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = old_photo;
#line 523 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_update_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MONITORABLE, Monitorable), new_file);
#line 524 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3793 "PhotoMonitor.c"
			}
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 3797 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				LibraryPhoto* _tmp23_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = old_photo;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject));
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = _tmp17_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = g_file_get_path (new_file);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp20_ = _tmp19_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp21_ = g_strdup_printf ("Will set new editable file for %s to %s", _tmp18_, _tmp20_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp22_ = _tmp21_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp22_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp22_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp20_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp18_);
#line 529 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp23_ = old_photo;
#line 529 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_monitor_update_editable_file (self, _tmp23_, new_file);
#line 530 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3835 "PhotoMonitor.c"
			}
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3839 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				LibraryPhoto* _tmp31_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp24_ = old_photo;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp25_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_DATA_OBJECT, DataObject));
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp26_ = _tmp25_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp27_ = g_file_get_path (new_file);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp28_ = _tmp27_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp29_ = g_strdup_printf ("Will set new raw development file for %s to %s", _tmp26_, _tmp28_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp30_ = _tmp29_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp30_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp30_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp28_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp26_);
#line 535 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp31_ = old_photo;
#line 535 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_monitor_update_raw_development_file (self, _tmp31_, new_file);
#line 536 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3877 "PhotoMonitor.c"
			}
			default:
			{
				LibraryPhotoSourceCollectionState _tmp32_;
				GEnumValue* _tmp33_;
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp32_ = old_state;
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp33_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp32_);
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_error ("PhotoMonitor.vala:539: Unknown LibraryPhoto collection state %s", (_tmp33_ != NULL) ? _tmp33_->value_name : NULL);
#line 3889 "PhotoMonitor.c"
			}
		}
	} else {
		gboolean _tmp34_ = FALSE;
		LibraryPhoto* _tmp35_;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp35_ = old_photo;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp35_ == NULL) {
#line 3899 "PhotoMonitor.c"
			LibraryPhoto* _tmp36_;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp36_ = new_photo;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp34_ = _tmp36_ != NULL;
#line 3905 "PhotoMonitor.c"
		} else {
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp34_ = FALSE;
#line 3909 "PhotoMonitor.c"
		}
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp34_) {
#line 3913 "PhotoMonitor.c"
			LibraryPhotoSourceCollectionState _tmp37_;
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp37_ = new_state;
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			switch (_tmp37_) {
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3925 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					LibraryPhoto* _tmp43_;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp38_ = new_photo;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp39_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_DATA_OBJECT, DataObject));
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp40_ = _tmp39_;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp41_ = g_strdup_printf ("Will reimport master file for %s", _tmp40_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp42_ = _tmp41_;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp42_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp42_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp40_);
#line 548 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp43_ = new_photo;
#line 548 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_master (self, _tmp43_);
#line 549 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3955 "PhotoMonitor.c"
				}
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 3959 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					LibraryPhoto* _tmp49_;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp44_ = new_photo;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp45_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_DATA_OBJECT, DataObject));
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp46_ = _tmp45_;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp47_ = g_strdup_printf ("Will reimport editable file for %s", _tmp46_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp48_ = _tmp47_;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp48_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp48_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp46_);
#line 553 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp49_ = new_photo;
#line 553 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_editable (self, _tmp49_);
#line 554 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3989 "PhotoMonitor.c"
				}
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3993 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					LibraryPhoto* _tmp55_;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp50_ = new_photo;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp51_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_DATA_OBJECT, DataObject));
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp52_ = _tmp51_;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp53_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp52_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp54_ = _tmp53_;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp54_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp54_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp52_);
#line 558 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp55_ = new_photo;
#line 558 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_raw_developments (self, _tmp55_);
#line 559 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 4023 "PhotoMonitor.c"
				}
				default:
				{
					LibraryPhotoSourceCollectionState _tmp56_;
					GEnumValue* _tmp57_;
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp56_ = new_state;
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp57_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp56_);
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					g_error ("PhotoMonitor.vala:562: Unknown LibraryPhoto collection state %s", (_tmp57_ != NULL) ? _tmp57_->value_name : NULL);
#line 4035 "PhotoMonitor.c"
				}
			}
		} else {
			gboolean _tmp58_ = FALSE;
			LibraryPhoto* _tmp59_;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp59_ = old_photo;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp59_ == NULL) {
#line 4045 "PhotoMonitor.c"
				LibraryPhoto* _tmp60_;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp60_ = new_photo;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp58_ = _tmp60_ == NULL;
#line 4051 "PhotoMonitor.c"
			} else {
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp58_ = FALSE;
#line 4055 "PhotoMonitor.c"
			}
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp58_) {
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				result = FALSE;
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (new_photo);
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (old_photo);
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return result;
#line 4067 "PhotoMonitor.c"
			} else {
				gboolean _tmp61_ = FALSE;
				LibraryPhoto* _tmp62_;
				LibraryPhotoSourceCollectionState _tmp64_;
				LibraryPhotoSourceCollectionState _tmp79_;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp62_ = old_photo;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp62_ != NULL) {
#line 4077 "PhotoMonitor.c"
					LibraryPhoto* _tmp63_;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp63_ = new_photo;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp61_ = _tmp63_ != NULL;
#line 4083 "PhotoMonitor.c"
				} else {
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp61_ = FALSE;
#line 4087 "PhotoMonitor.c"
				}
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (_tmp61_, "old_photo != null && new_photo != null");
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp64_ = old_state;
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				switch (_tmp64_) {
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 4097 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						LibraryPhoto* _tmp70_;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp65_ = old_photo;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp66_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_DATA_OBJECT, DataObject));
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp67_ = _tmp66_;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp68_ = g_strdup_printf ("Will mark offline %s", _tmp67_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp69_ = _tmp68_;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp69_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp69_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp67_);
#line 573 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp70_ = old_photo;
#line 573 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_MONITORABLE, Monitorable));
#line 574 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4127 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4133 "PhotoMonitor.c"
					{
#line 579 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4137 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4141 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						LibraryPhoto* _tmp76_;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp71_ = old_photo;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp72_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, TYPE_DATA_OBJECT, DataObject));
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp73_ = _tmp72_;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp74_ = g_strdup_printf ("Will revert %s to master", _tmp73_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp75_ = _tmp74_;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp75_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp75_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp73_);
#line 583 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp76_ = old_photo;
#line 583 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_revert_to_master (self, _tmp76_);
#line 584 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4171 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4175 "PhotoMonitor.c"
					{
#line 588 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4179 "PhotoMonitor.c"
					}
					default:
					{
						LibraryPhotoSourceCollectionState _tmp77_;
						GEnumValue* _tmp78_;
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp77_ = old_state;
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp78_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp77_);
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						g_error ("PhotoMonitor.vala:591: Unknown LibraryPhoto collection state %s", (_tmp78_ != NULL) ? _tmp78_->value_name : NULL);
#line 4191 "PhotoMonitor.c"
					}
				}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp79_ = new_state;
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				switch (_tmp79_) {
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4204 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp80_;
						gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						LibraryPhoto* _tmp85_;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp80_ = new_photo;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp81_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_DATA_OBJECT, DataObject));
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp82_ = _tmp81_;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp83_ = g_strdup_printf ("Will reimport master file for %s", _tmp82_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp84_ = _tmp83_;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp84_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp84_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp82_);
#line 599 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp85_ = new_photo;
#line 599 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_master (self, _tmp85_);
#line 600 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4234 "PhotoMonitor.c"
					}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4238 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						LibraryPhoto* _tmp91_;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp86_ = new_photo;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp87_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_DATA_OBJECT, DataObject));
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp88_ = _tmp87_;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp89_ = g_strdup_printf ("Will reimport editable file for %s", _tmp88_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp90_ = _tmp89_;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp90_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp90_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp88_);
#line 604 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp91_ = new_photo;
#line 604 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_editable (self, _tmp91_);
#line 605 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4268 "PhotoMonitor.c"
					}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4272 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp92_;
						gchar* _tmp93_;
						gchar* _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
						LibraryPhoto* _tmp97_;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp92_ = new_photo;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp93_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, TYPE_DATA_OBJECT, DataObject));
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp94_ = _tmp93_;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp95_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp94_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp96_ = _tmp95_;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp96_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp96_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp94_);
#line 609 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp97_ = new_photo;
#line 609 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_raw_developments (self, _tmp97_);
#line 610 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4302 "PhotoMonitor.c"
					}
					default:
					{
						LibraryPhotoSourceCollectionState _tmp98_;
						GEnumValue* _tmp99_;
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp98_ = new_state;
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp99_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp98_);
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						g_error ("PhotoMonitor.vala:613: Unknown LibraryPhoto collection state %s", (_tmp99_ != NULL) ? _tmp99_->value_name : NULL);
#line 4314 "PhotoMonitor.c"
					}
				}
			}
		}
	}
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (new_photo);
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (old_photo);
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4328 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_altered (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 620 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 620 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 623 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 623 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4364 "PhotoMonitor.c"
	}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 4376 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			LibraryPhoto* _tmp9_;
			LibraryPhoto* _tmp10_;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = photo;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _tmp5_;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = g_strdup_printf ("Will reimport master for %s", _tmp6_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = _tmp7_;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp8_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp8_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp6_);
#line 631 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = photo;
#line 631 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_master (self, _tmp9_);
#line 632 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 632 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 633 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4411 "PhotoMonitor.c"
		}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4415 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			LibraryPhoto* _tmp16_;
			LibraryPhoto* _tmp17_;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = _tmp12_;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = g_strdup_printf ("Will reimport editable for %s", _tmp13_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = _tmp14_;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp15_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp15_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp13_);
#line 637 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = photo;
#line 637 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_editable (self, _tmp16_);
#line 638 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = photo;
#line 638 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp17_, TRUE);
#line 639 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4450 "PhotoMonitor.c"
		}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4454 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			LibraryPhoto* _tmp23_;
			LibraryPhoto* _tmp24_;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = photo;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_OBJECT, DataObject));
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = _tmp19_;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = g_strdup_printf ("Will reimport raw development for %s", _tmp20_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = _tmp21_;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp22_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp22_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp20_);
#line 643 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = photo;
#line 643 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_raw_developments (self, _tmp23_);
#line 644 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = photo;
#line 644 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp24_, TRUE);
#line 645 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4489 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp25_;
			GEnumValue* _tmp26_;
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = state;
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp25_);
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:648: Unknown LibraryPhoto collection state %s", (_tmp26_ != NULL) ? _tmp26_->value_name : NULL);
#line 4501 "PhotoMonitor.c"
		}
	}
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4510 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                   GFile* file)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 654 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 654 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 657 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 657 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4546 "PhotoMonitor.c"
	}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 4556 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			LibraryPhoto* _tmp9_;
			LibraryPhoto* _tmp10_;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = photo;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _tmp5_;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = g_strdup_printf ("Will update master file info for %s", _tmp6_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = _tmp7_;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp8_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp8_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp6_);
#line 664 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = photo;
#line 664 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable));
#line 665 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 665 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 666 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4591 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4595 "PhotoMonitor.c"
		{
			gchar* _tmp11_;
			gchar* _tmp12_;
			LibraryPhotoSourceCollectionState _tmp13_;
			GEnumValue* _tmp14_;
			LibraryPhoto* _tmp15_;
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = g_file_get_path (file);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = _tmp11_;
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = state;
#line 671 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp13_);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:670: File %s attributes altered in %s state", _tmp12_, (_tmp14_ != NULL) ? _tmp14_->value_name : NULL);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp12_);
#line 672 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = photo;
#line 672 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 673 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4620 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4624 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			LibraryPhoto* _tmp21_;
			LibraryPhoto* _tmp22_;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = photo;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject));
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = _tmp17_;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = g_strdup_printf ("Will update editable file info for %s", _tmp18_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = _tmp19_;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp20_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp20_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp18_);
#line 677 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = photo;
#line 677 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_info_altered (self, _tmp21_);
#line 678 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = photo;
#line 678 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp22_, TRUE);
#line 679 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4659 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4663 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			LibraryPhoto* _tmp28_;
			LibraryPhoto* _tmp29_;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = photo;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DATA_OBJECT, DataObject));
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = _tmp24_;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = g_strdup_printf ("Will update raw development file info for %s", _tmp25_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = _tmp26_;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp27_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp27_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp25_);
#line 683 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = photo;
#line 683 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_info_altered (self, _tmp28_);
#line 684 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = photo;
#line 684 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp29_, TRUE);
#line 685 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4698 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp30_;
			GEnumValue* _tmp31_;
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp30_ = state;
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp31_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp30_);
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:688: Unknown LibraryPhoto collection state %s", (_tmp31_ != NULL) ? _tmp31_->value_name : NULL);
#line 4710 "PhotoMonitor.c"
		}
	}
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4719 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 697 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 697 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4758 "PhotoMonitor.c"
	}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4770 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp4_;
#line 704 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = photo;
#line 704 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable), info);
#line 705 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4779 "PhotoMonitor.c"
		}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4783 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_;
#line 708 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 708 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_alterations_completed (self, _tmp5_, info);
#line 709 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4792 "PhotoMonitor.c"
		}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4796 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp6_;
#line 712 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = photo;
#line 712 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_alterations_completed (self, _tmp6_);
#line 713 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4805 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp7_;
			GEnumValue* _tmp8_;
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = state;
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp7_);
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:716: Unknown LibraryPhoto collection state %s", (_tmp8_ != NULL) ? _tmp8_->value_name : NULL);
#line 4817 "PhotoMonitor.c"
		}
	}
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4826 "PhotoMonitor.c"
}


static gboolean
photo_monitor_real_notify_file_deleted (MediaMonitor* base,
                                        GFile* file)
{
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	LibraryPhotoSourceCollectionState _tmp0_ = 0;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhotoSourceCollectionState _tmp3_;
#line 722 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 722 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_photo_state_by_file (self, file, &_tmp0_);
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp0_;
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 725 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 725 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4862 "PhotoMonitor.c"
	}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp3_) {
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 4870 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			LibraryPhoto* _tmp9_;
			LibraryPhoto* _tmp10_;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = photo;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _tmp5_;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = g_strdup_printf ("Will mark %s offline", _tmp6_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = _tmp7_;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp8_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp8_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp6_);
#line 731 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = photo;
#line 731 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable));
#line 732 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 732 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable), FALSE);
#line 733 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4905 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4911 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp11_;
#line 738 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 738 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MONITORABLE, Monitorable), FALSE);
#line 739 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4920 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4924 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			LibraryPhoto* _tmp17_;
			LibraryPhoto* _tmp18_;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = photo;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject));
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = _tmp13_;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = g_strdup_printf ("Will revert %s to master", _tmp14_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = _tmp15_;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp16_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp16_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp14_);
#line 743 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = photo;
#line 743 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_revert_to_master (self, _tmp17_);
#line 744 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = photo;
#line 744 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp18_, FALSE);
#line 745 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4959 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4963 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			LibraryPhoto* _tmp24_;
			LibraryPhoto* _tmp25_;
			LibraryPhoto* _tmp26_;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = photo;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = _tmp20_;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = g_strdup_printf ("Will revert %s to master", _tmp21_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = _tmp22_;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp23_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp23_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp21_);
#line 749 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = photo;
#line 749 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_revert_to_master (self, _tmp24_);
#line 750 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = photo;
#line 750 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp25_, FALSE);
#line 751 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = photo;
#line 751 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp26_, FALSE);
#line 752 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 5003 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp27_;
			GEnumValue* _tmp28_;
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = state;
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp27_);
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:755: Unknown LibraryPhoto collection state %s", (_tmp28_ != NULL) ? _tmp28_->value_name : NULL);
#line 5015 "PhotoMonitor.c"
		}
	}
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5024 "PhotoMonitor.c"
}


static void
photo_monitor_real_on_media_source_destroyed (MediaMonitor* base,
                                              DataSource* source)
{
	PhotoMonitor * self;
#line 761 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 761 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 762 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->on_media_source_destroyed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), source);
#line 764 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_cancel_reimports (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 5041 "PhotoMonitor.c"
}


static LibraryPhoto*
photo_monitor_get_photo_state_by_file (PhotoMonitor* self,
                                       GFile* file,
                                       LibraryPhotoSourceCollectionState* state)
{
	LibraryPhotoSourceCollectionState _vala_state = 0;
	LibraryPhoto* result = NULL;
	GFile* real_file = NULL;
	GFile* _tmp58_ = NULL;
	GFile* _tmp59_;
	LibraryPhotoSourceCollection* _tmp60_;
	LibraryPhotoSourceCollectionState _tmp61_ = 0;
	LibraryPhoto* _tmp62_;
#line 767 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 767 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 768 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	real_file = NULL;
#line 769 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (media_monitor_has_pending_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor))) {
#line 5066 "PhotoMonitor.c"
		{
			GeeIterator* _monitorable_it = NULL;
			GeeCollection* _tmp0_;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_;
			GeeIterator* _tmp3_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp0_ = media_monitor_get_monitorables (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp1_ = _tmp0_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp3_ = _tmp2_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp1_);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_it = _tmp3_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 5087 "PhotoMonitor.c"
				GeeIterator* _tmp4_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				LibraryPhoto* photo = NULL;
				Monitorable* _tmp7_;
				LibraryPhoto* _tmp8_;
				PhotoUpdates* updates = NULL;
				LibraryPhoto* _tmp9_;
				PhotoUpdates* _tmp10_;
				PhotoUpdates* _tmp11_;
				gboolean _tmp12_ = FALSE;
				PhotoUpdates* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp22_ = FALSE;
				PhotoUpdates* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				gboolean _tmp26_;
				PhotoUpdates* _tmp33_;
				GeeCollection* _tmp34_;
				GeeCollection* _tmp35_;
				gboolean _tmp36_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp4_ = _monitorable_it;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!gee_iterator_next (_tmp4_)) {
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5119 "PhotoMonitor.c"
				}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp5_ = _monitorable_it;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				monitorable = (Monitorable*) _tmp6_;
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp7_ = monitorable;
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = _tmp8_;
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp9_ = photo;
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp10_ = photo_monitor_get_existing_photo_updates (self, _tmp9_);
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				updates = _tmp10_;
#line 774 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = updates;
#line 774 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp11_ == NULL) {
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					continue;
#line 5151 "PhotoMonitor.c"
				}
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = updates;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = _tmp14_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = _tmp15_ != NULL;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp15_);
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp16_) {
#line 5165 "PhotoMonitor.c"
					PhotoUpdates* _tmp17_;
					GFile* _tmp18_;
					GFile* _tmp19_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp17_ = updates;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp18_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp19_ = _tmp18_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp12_ = g_file_equal (_tmp19_, file);
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp19_);
#line 5179 "PhotoMonitor.c"
				} else {
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp12_ = FALSE;
#line 5183 "PhotoMonitor.c"
				}
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp12_) {
#line 5187 "PhotoMonitor.c"
					LibraryPhoto* _tmp20_;
					GFile* _tmp21_;
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp20_ = photo;
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp21_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MEDIA_SOURCE, MediaSource));
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (real_file);
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					real_file = _tmp21_;
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5206 "PhotoMonitor.c"
				}
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp23_ = updates;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp24_ = photo_updates_get_editable_file (_tmp23_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp25_ = _tmp24_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp26_ = _tmp25_ != NULL;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp25_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp26_) {
#line 5220 "PhotoMonitor.c"
					PhotoUpdates* _tmp27_;
					GFile* _tmp28_;
					GFile* _tmp29_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp27_ = updates;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp28_ = photo_updates_get_editable_file (_tmp27_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp29_ = _tmp28_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp22_ = g_file_equal (_tmp29_, file);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp29_);
#line 5234 "PhotoMonitor.c"
				} else {
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp22_ = FALSE;
#line 5238 "PhotoMonitor.c"
				}
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp22_) {
#line 5242 "PhotoMonitor.c"
					LibraryPhoto* _tmp30_;
					GFile* _tmp31_;
					GFile* _tmp32_;
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp30_ = photo;
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp31_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO, Photo));
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (real_file);
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					real_file = _tmp31_;
#line 788 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp32_ = real_file;
#line 788 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					if (_tmp32_ == NULL) {
#line 789 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE;
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						result = photo;
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_monitorable_updates_unref0 (updates);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (monitorable);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_monitorable_it);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (real_file);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (state) {
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							*state = _vala_state;
#line 5274 "PhotoMonitor.c"
						}
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						return result;
#line 5278 "PhotoMonitor.c"
					}
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5288 "PhotoMonitor.c"
				}
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp33_ = updates;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp34_ = photo_updates_get_raw_developer_files (_tmp33_);
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp35_ = _tmp34_;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp36_ = _tmp35_ != NULL;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp35_);
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp36_) {
#line 5302 "PhotoMonitor.c"
					gboolean found = FALSE;
					gboolean _tmp46_;
#line 798 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					found = FALSE;
#line 5307 "PhotoMonitor.c"
					{
						GeeIterator* _raw_it = NULL;
						PhotoUpdates* _tmp37_;
						GeeCollection* _tmp38_;
						GeeCollection* _tmp39_;
						GeeIterator* _tmp40_;
						GeeIterator* _tmp41_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp37_ = updates;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp38_ = photo_updates_get_raw_developer_files (_tmp37_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp39_ = _tmp38_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp40_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ITERABLE, GeeIterable));
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp41_ = _tmp40_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_tmp39_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_raw_it = _tmp41_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						while (TRUE) {
#line 5331 "PhotoMonitor.c"
							GeeIterator* _tmp42_;
							GFile* raw = NULL;
							GeeIterator* _tmp43_;
							gpointer _tmp44_;
							GFile* _tmp45_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp42_ = _raw_it;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							if (!gee_iterator_next (_tmp42_)) {
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								break;
#line 5343 "PhotoMonitor.c"
							}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp43_ = _raw_it;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp44_ = gee_iterator_get (_tmp43_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							raw = (GFile*) _tmp44_;
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp45_ = raw;
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							if (g_file_equal (_tmp45_, file)) {
#line 801 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								found = TRUE;
#line 803 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_g_object_unref0 (raw);
#line 803 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								break;
#line 5361 "PhotoMonitor.c"
							}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_g_object_unref0 (raw);
#line 5365 "PhotoMonitor.c"
						}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_raw_it);
#line 5369 "PhotoMonitor.c"
					}
#line 807 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp46_ = found;
#line 807 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					if (_tmp46_) {
#line 5375 "PhotoMonitor.c"
						GeeCollection* developed = NULL;
						LibraryPhoto* _tmp47_;
						GeeCollection* _tmp48_;
						GeeCollection* _tmp49_;
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp47_ = photo;
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp48_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_PHOTO, Photo));
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						developed = _tmp48_;
#line 809 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp49_ = developed;
#line 809 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (_tmp49_ != NULL) {
#line 5390 "PhotoMonitor.c"
							{
								GeeIterator* _f_it = NULL;
								GeeCollection* _tmp50_;
								GeeIterator* _tmp51_;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_tmp50_ = developed;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_tmp51_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ITERABLE, GeeIterable));
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_f_it = _tmp51_;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								while (TRUE) {
#line 5403 "PhotoMonitor.c"
									GeeIterator* _tmp52_;
									GFile* f = NULL;
									GeeIterator* _tmp53_;
									gpointer _tmp54_;
									GFile* _tmp55_;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp52_ = _f_it;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									if (!gee_iterator_next (_tmp52_)) {
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										break;
#line 5415 "PhotoMonitor.c"
									}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp53_ = _f_it;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp54_ = gee_iterator_get (_tmp53_);
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									f = (GFile*) _tmp54_;
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp55_ = f;
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									if (g_file_equal (_tmp55_, file)) {
#line 5427 "PhotoMonitor.c"
										GFile* _tmp56_;
										GFile* _tmp57_;
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_tmp56_ = f;
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_tmp57_ = _g_object_ref0 (_tmp56_);
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_g_object_unref0 (real_file);
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										real_file = _tmp57_;
#line 813 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER;
#line 815 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_g_object_unref0 (f);
#line 815 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										break;
#line 5444 "PhotoMonitor.c"
									}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_g_object_unref0 (f);
#line 5448 "PhotoMonitor.c"
								}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_g_object_unref0 (_f_it);
#line 5452 "PhotoMonitor.c"
							}
						}
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (developed);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_monitorable_updates_unref0 (updates);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (photo);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (monitorable);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 5465 "PhotoMonitor.c"
					}
				}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (monitorable);
#line 5474 "PhotoMonitor.c"
			}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_monitorable_it);
#line 5478 "PhotoMonitor.c"
		}
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp59_ = real_file;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp58_ = _tmp59_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp58_ == NULL) {
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp58_ = file;
#line 5489 "PhotoMonitor.c"
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp60_ = library_photo_global;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp62_ = library_photo_source_collection_get_state_by_file (_tmp60_, _tmp58_, &_tmp61_);
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_state = _tmp61_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp62_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (real_file);
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (state) {
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*state = _vala_state;
#line 5505 "PhotoMonitor.c"
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5509 "PhotoMonitor.c"
}


PhotoUpdates*
photo_monitor_fetch_photo_updates (PhotoMonitor* self,
                                   LibraryPhoto* photo)
{
	PhotoUpdates* result = NULL;
	MonitorableUpdates* _tmp0_;
#line 830 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 830 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = media_monitor_fetch_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5529 "PhotoMonitor.c"
}


PhotoUpdates*
photo_monitor_get_existing_photo_updates (PhotoMonitor* self,
                                          LibraryPhoto* photo)
{
	PhotoUpdates* result = NULL;
	MonitorableUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 834 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 834 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = media_monitor_get_existing_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MONITORABLE, Monitorable));
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO_UPDATES) ? ((PhotoUpdates*) _tmp0_) : NULL;
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_ == NULL) {
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_monitorable_updates_unref0 (_tmp0_);
#line 5552 "PhotoMonitor.c"
	}
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5558 "PhotoMonitor.c"
}


void
photo_monitor_update_reimport_master (PhotoMonitor* self,
                                      LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
#line 838 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 838 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_master (_tmp1_, TRUE);
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->master_reimport_pending;
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
#line 5585 "PhotoMonitor.c"
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportMasterJob* _tmp5_;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = self->priv->master_reimport_pending;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = (PhotoMonitorReimportMasterJob*) _tmp4_;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp5_);
#line 5599 "PhotoMonitor.c"
	}
}


void
photo_monitor_update_reimport_editable (PhotoMonitor* self,
                                        LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
#line 846 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 846 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_editable (_tmp1_, TRUE);
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->editable_reimport_pending;
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
#line 5627 "PhotoMonitor.c"
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportEditableJob* _tmp5_;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = self->priv->editable_reimport_pending;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = (PhotoMonitorReimportEditableJob*) _tmp4_;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp5_);
#line 5641 "PhotoMonitor.c"
	}
}


void
photo_monitor_update_reimport_raw_developments (PhotoMonitor* self,
                                                LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	GeeHashMap* _tmp2_;
#line 854 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 854 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_raw_developments (_tmp1_, TRUE);
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->raw_developments_reimport_pending;
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
#line 5669 "PhotoMonitor.c"
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp5_;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = self->priv->raw_developments_reimport_pending;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = (PhotoMonitorReimportRawDevelopmentJob*) _tmp4_;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp5_);
#line 5683 "PhotoMonitor.c"
	}
}


GFile*
photo_monitor_get_editable_file (PhotoMonitor* self,
                                 LibraryPhoto* photo)
{
	GFile* result = NULL;
	PhotoUpdates* updates = NULL;
	PhotoUpdates* _tmp0_;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoUpdates* _tmp3_;
#line 862 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 862 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 863 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_get_existing_photo_updates (self, photo);
#line 863 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	updates = _tmp0_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ != NULL) {
#line 5710 "PhotoMonitor.c"
		PhotoUpdates* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = photo_updates_get_editable_file (_tmp4_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = _tmp5_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp6_);
#line 5724 "PhotoMonitor.c"
	} else {
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = FALSE;
#line 5728 "PhotoMonitor.c"
	}
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_) {
#line 5732 "PhotoMonitor.c"
		PhotoUpdates* _tmp7_;
		GFile* _tmp8_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = photo_updates_get_editable_file (_tmp7_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp1_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp8_;
#line 5743 "PhotoMonitor.c"
	} else {
		GFile* _tmp9_;
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp1_);
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp9_;
#line 5752 "PhotoMonitor.c"
	}
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5760 "PhotoMonitor.c"
}


GeeCollection*
photo_monitor_get_raw_development_files (PhotoMonitor* self,
                                         LibraryPhoto* photo)
{
	GeeCollection* result = NULL;
	PhotoUpdates* updates = NULL;
	PhotoUpdates* _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoUpdates* _tmp3_;
#line 869 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 869 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 870 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_get_existing_photo_updates (self, photo);
#line 870 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	updates = _tmp0_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = updates;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ != NULL) {
#line 5786 "PhotoMonitor.c"
		PhotoUpdates* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = updates;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = photo_updates_get_raw_developer_files (_tmp4_);
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = _tmp5_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp6_);
#line 5800 "PhotoMonitor.c"
	} else {
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = FALSE;
#line 5804 "PhotoMonitor.c"
	}
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_) {
#line 5808 "PhotoMonitor.c"
		PhotoUpdates* _tmp7_;
		GeeCollection* _tmp8_;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = updates;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = photo_updates_get_raw_developer_files (_tmp7_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp1_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp8_;
#line 5819 "PhotoMonitor.c"
	} else {
		GeeCollection* _tmp9_;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp1_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp9_;
#line 5828 "PhotoMonitor.c"
	}
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5836 "PhotoMonitor.c"
}


void
photo_monitor_update_editable_file (PhotoMonitor* self,
                                    LibraryPhoto* photo,
                                    GFile* file)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file (_tmp1_, file);
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 5861 "PhotoMonitor.c"
}


void
photo_monitor_update_editable_file_info_altered (PhotoMonitor* self,
                                                 LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 880 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 880 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file_info_altered (_tmp1_, TRUE);
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 5883 "PhotoMonitor.c"
}


void
photo_monitor_update_raw_development_file (PhotoMonitor* self,
                                           LibraryPhoto* photo,
                                           GFile* file)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_add_raw_developer_file (_tmp1_, file);
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 5908 "PhotoMonitor.c"
}


void
photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self,
                                                        LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 888 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 888 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_developer_file_info_altered (_tmp1_, TRUE);
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 5930 "PhotoMonitor.c"
}


void
photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self,
                                                  LibraryPhoto* photo,
                                                  gboolean in_alteration)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 892 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 892 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_in_alteration (_tmp1_, in_alteration);
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 5953 "PhotoMonitor.c"
}


void
photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self,
                                                          LibraryPhoto* photo,
                                                          GFileInfo* info)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
	PhotoUpdates* _tmp2_;
	PhotoUpdates* _tmp3_;
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file_info (_tmp1_, info);
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_fetch_photo_updates (self, photo);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_in_alteration (_tmp3_, FALSE);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp3_);
#line 5988 "PhotoMonitor.c"
}


void
photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self,
                                                         LibraryPhoto* photo,
                                                         gboolean in_alteration)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 901 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 901 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_development_in_alteration (_tmp1_, in_alteration);
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 6011 "PhotoMonitor.c"
}


void
photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self,
                                                                 LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 905 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 905 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_development_in_alteration (_tmp1_, FALSE);
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 6033 "PhotoMonitor.c"
}


void
photo_monitor_update_revert_to_master (PhotoMonitor* self,
                                       LibraryPhoto* photo)
{
	PhotoUpdates* _tmp0_;
	PhotoUpdates* _tmp1_;
#line 909 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 909 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo_monitor_fetch_photo_updates (self, photo);
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_revert_to_master (_tmp1_, TRUE);
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp1_);
#line 6055 "PhotoMonitor.c"
}


static gpointer
_monitorable_updates_ref0 (gpointer self)
{
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? monitorable_updates_ref (self) : NULL;
#line 6064 "PhotoMonitor.c"
}


static void
photo_monitor_real_process_updates (MediaMonitor* base,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	PhotoMonitor * self;
	GeeMap* set_editable_file = NULL;
	GeeMap* set_editable_file_info = NULL;
	GeeMap* set_raw_developer_files = NULL;
	GeeArrayList* revert_to_master = NULL;
	GeeArrayList* reimport_master = NULL;
	GeeArrayList* reimport_editable = NULL;
	GeeArrayList* reimport_raw_developments = NULL;
	gint reimport_job_count = 0;
	GeeMap* _tmp82_;
	GeeMap* _tmp90_;
	GeeArrayList* _tmp98_;
	GeeArrayList* _tmp116_;
	GeeArrayList* _tmp142_;
	GeeArrayList* _tmp168_;
	GError * _inner_error_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (all_updates));
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), all_updates, controller, op_count, &_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_propagate_error (error, _inner_error_);
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 6105 "PhotoMonitor.c"
	}
#line 917 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_editable_file = NULL;
#line 918 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_editable_file_info = NULL;
#line 919 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_raw_developer_files = NULL;
#line 920 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	revert_to_master = NULL;
#line 921 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_master = NULL;
#line 922 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_editable = NULL;
#line 923 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_raw_developments = NULL;
#line 924 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_job_count = 0;
#line 6123 "PhotoMonitor.c"
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeIterator* _tmp0_;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (all_updates, GEE_TYPE_ITERABLE, GeeIterable));
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_monitorable_updates_it = _tmp0_;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 6133 "PhotoMonitor.c"
			GeeIterator* _tmp1_;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			PhotoUpdates* updates = NULL;
			MonitorableUpdates* _tmp4_;
			PhotoUpdates* _tmp5_;
			PhotoUpdates* _tmp6_;
			PhotoUpdates* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			gboolean _tmp10_;
			PhotoUpdates* _tmp21_;
			GFileInfo* _tmp22_;
			GFileInfo* _tmp23_;
			gboolean _tmp24_;
			PhotoUpdates* _tmp35_;
			GeeCollection* _tmp36_;
			GeeCollection* _tmp37_;
			gboolean _tmp38_;
			PhotoUpdates* _tmp49_;
			gboolean _tmp60_ = FALSE;
			PhotoUpdates* _tmp61_;
			gboolean _tmp71_ = FALSE;
			PhotoUpdates* _tmp72_;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp1_ = _monitorable_updates_it;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 6165 "PhotoMonitor.c"
			}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp2_ = _monitorable_updates_it;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			monitorable_updates = (MonitorableUpdates*) _tmp3_;
#line 927 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
#line 928 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 928 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 6179 "PhotoMonitor.c"
			}
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = monitorable_updates;
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = _monitorable_updates_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_PHOTO_UPDATES) ? ((PhotoUpdates*) _tmp4_) : NULL);
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			updates = _tmp5_;
#line 931 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = updates;
#line 931 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp6_ == NULL) {
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				continue;
#line 6197 "PhotoMonitor.c"
			}
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = updates;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = photo_updates_get_editable_file (_tmp7_);
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = _tmp8_;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = _tmp9_ != NULL;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp9_);
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp10_) {
#line 6211 "PhotoMonitor.c"
				GeeMap* _tmp11_;
				GeeMap* _tmp13_;
				PhotoUpdates* _tmp14_;
				LibraryPhoto* _tmp15_;
				PhotoUpdates* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				PhotoUpdates* _tmp19_;
				gint _tmp20_;
#line 935 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = set_editable_file;
#line 935 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp11_ == NULL) {
#line 6225 "PhotoMonitor.c"
					GeeHashMap* _tmp12_;
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp12_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_editable_file);
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_editable_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_MAP, GeeMap);
#line 6233 "PhotoMonitor.c"
				}
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = set_editable_file;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = updates;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = _tmp14_->photo;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = updates;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17_ = photo_updates_get_editable_file (_tmp16_);
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = _tmp17_;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp13_, _tmp15_, _tmp18_);
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp18_);
#line 939 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = updates;
#line 939 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_editable_file (_tmp19_, NULL);
#line 940 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp20_ = *op_count;
#line 940 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp20_ + 1;
#line 6259 "PhotoMonitor.c"
			}
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = updates;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = photo_updates_get_editable_file_info (_tmp21_);
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = _tmp22_;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = _tmp23_ != NULL;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp23_);
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp24_) {
#line 6273 "PhotoMonitor.c"
				GeeMap* _tmp25_;
				GeeMap* _tmp27_;
				PhotoUpdates* _tmp28_;
				LibraryPhoto* _tmp29_;
				PhotoUpdates* _tmp30_;
				GFileInfo* _tmp31_;
				GFileInfo* _tmp32_;
				PhotoUpdates* _tmp33_;
				gint _tmp34_;
#line 944 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp25_ = set_editable_file_info;
#line 944 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp25_ == NULL) {
#line 6287 "PhotoMonitor.c"
					GeeHashMap* _tmp26_;
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp26_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_editable_file_info);
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_editable_file_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_MAP, GeeMap);
#line 6295 "PhotoMonitor.c"
				}
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp27_ = set_editable_file_info;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp28_ = updates;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp29_ = _tmp28_->photo;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp30_ = updates;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp31_ = photo_updates_get_editable_file_info (_tmp30_);
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp32_ = _tmp31_;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp27_, _tmp29_, _tmp32_);
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp32_);
#line 948 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp33_ = updates;
#line 948 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_editable_file_info (_tmp33_, NULL);
#line 949 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp34_ = *op_count;
#line 949 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp34_ + 1;
#line 6321 "PhotoMonitor.c"
			}
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp35_ = updates;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp36_ = photo_updates_get_raw_developer_files (_tmp35_);
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp37_ = _tmp36_;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp38_ = _tmp37_ != NULL;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp37_);
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp38_) {
#line 6335 "PhotoMonitor.c"
				GeeMap* _tmp39_;
				GeeMap* _tmp41_;
				PhotoUpdates* _tmp42_;
				LibraryPhoto* _tmp43_;
				PhotoUpdates* _tmp44_;
				GeeCollection* _tmp45_;
				GeeCollection* _tmp46_;
				PhotoUpdates* _tmp47_;
				gint _tmp48_;
#line 953 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp39_ = set_raw_developer_files;
#line 953 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp39_ == NULL) {
#line 6349 "PhotoMonitor.c"
					GeeHashMap* _tmp40_;
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp40_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_raw_developer_files);
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_raw_developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_MAP, GeeMap);
#line 6357 "PhotoMonitor.c"
				}
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp41_ = set_raw_developer_files;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp42_ = updates;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp43_ = _tmp42_->photo;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp44_ = updates;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp45_ = photo_updates_get_raw_developer_files (_tmp44_);
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp46_ = _tmp45_;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp41_, _tmp43_, _tmp46_);
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp46_);
#line 957 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp47_ = updates;
#line 957 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_clear_raw_developer_files (_tmp47_);
#line 958 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp48_ = *op_count;
#line 958 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp48_ + 1;
#line 6383 "PhotoMonitor.c"
			}
#line 961 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp49_ = updates;
#line 961 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (photo_updates_is_revert_to_master (_tmp49_)) {
#line 6389 "PhotoMonitor.c"
				GeeArrayList* _tmp50_;
				GeeArrayList* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp59_;
#line 962 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp50_ = revert_to_master;
#line 962 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp50_ == NULL) {
#line 6399 "PhotoMonitor.c"
					GeeArrayList* _tmp51_;
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp51_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (revert_to_master);
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					revert_to_master = _tmp51_;
#line 6407 "PhotoMonitor.c"
				}
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp52_ = revert_to_master;
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp53_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp54_ = _tmp53_;
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp54_ < PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE) {
#line 6417 "PhotoMonitor.c"
					GeeArrayList* _tmp55_;
					PhotoUpdates* _tmp56_;
					LibraryPhoto* _tmp57_;
					PhotoUpdates* _tmp58_;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp55_ = revert_to_master;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp56_ = updates;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp57_ = _tmp56_->photo;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp57_);
#line 967 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp58_ = updates;
#line 967 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_updates_set_revert_to_master (_tmp58_, FALSE);
#line 6434 "PhotoMonitor.c"
				}
#line 969 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp59_ = *op_count;
#line 969 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp59_ + 1;
#line 6440 "PhotoMonitor.c"
			}
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp61_ = updates;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (photo_updates_is_reimport_master (_tmp61_)) {
#line 6446 "PhotoMonitor.c"
				gint _tmp62_;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp62_ = reimport_job_count;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp60_ = _tmp62_ < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
#line 6452 "PhotoMonitor.c"
			} else {
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp60_ = FALSE;
#line 6456 "PhotoMonitor.c"
			}
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp60_) {
#line 6460 "PhotoMonitor.c"
				GeeArrayList* _tmp63_;
				GeeArrayList* _tmp65_;
				PhotoUpdates* _tmp66_;
				LibraryPhoto* _tmp67_;
				PhotoUpdates* _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
#line 973 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp63_ = reimport_master;
#line 973 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp63_ == NULL) {
#line 6472 "PhotoMonitor.c"
					GeeArrayList* _tmp64_;
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp64_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (reimport_master);
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					reimport_master = _tmp64_;
#line 6480 "PhotoMonitor.c"
				}
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp65_ = reimport_master;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp66_ = updates;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp67_ = _tmp66_->photo;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp67_);
#line 977 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp68_ = updates;
#line 977 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_reimport_master (_tmp68_, FALSE);
#line 978 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp69_ = reimport_job_count;
#line 978 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				reimport_job_count = _tmp69_ + 1;
#line 979 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp70_ = *op_count;
#line 979 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp70_ + 1;
#line 6502 "PhotoMonitor.c"
			}
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp72_ = updates;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (photo_updates_is_reimport_editable (_tmp72_)) {
#line 6508 "PhotoMonitor.c"
				gint _tmp73_;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp73_ = reimport_job_count;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp71_ = _tmp73_ < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
#line 6514 "PhotoMonitor.c"
			} else {
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp71_ = FALSE;
#line 6518 "PhotoMonitor.c"
			}
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp71_) {
#line 6522 "PhotoMonitor.c"
				GeeArrayList* _tmp74_;
				GeeArrayList* _tmp76_;
				PhotoUpdates* _tmp77_;
				LibraryPhoto* _tmp78_;
				PhotoUpdates* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
#line 983 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp74_ = reimport_editable;
#line 983 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp74_ == NULL) {
#line 6534 "PhotoMonitor.c"
					GeeArrayList* _tmp75_;
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp75_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (reimport_editable);
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					reimport_editable = _tmp75_;
#line 6542 "PhotoMonitor.c"
				}
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp76_ = reimport_editable;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp77_ = updates;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp78_ = _tmp77_->photo;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp78_);
#line 987 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp79_ = updates;
#line 987 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_reimport_editable (_tmp79_, FALSE);
#line 988 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp80_ = reimport_job_count;
#line 988 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				reimport_job_count = _tmp80_ + 1;
#line 989 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp81_ = *op_count;
#line 989 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp81_ + 1;
#line 6564 "PhotoMonitor.c"
			}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_updates_unref0 (monitorable_updates);
#line 6570 "PhotoMonitor.c"
		}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_monitorable_updates_it);
#line 6574 "PhotoMonitor.c"
	}
#line 993 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp82_ = set_editable_file;
#line 993 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp82_ != NULL) {
#line 6580 "PhotoMonitor.c"
		GeeMap* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp83_ = set_editable_file;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp84_ = gee_map_get_size (_tmp83_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp85_ = _tmp84_;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp86_ = g_strdup_printf ("Changing editable file of %d photos", _tmp85_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp87_ = _tmp86_;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp87_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp87_);
#line 6600 "PhotoMonitor.c"
		{
			GeeMap* _tmp88_;
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp88_ = set_editable_file;
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_set_many_editable_file (_tmp88_, &_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 6611 "PhotoMonitor.c"
					goto __catch595_database_error;
				}
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_raw_developments);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_editable);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_master);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (revert_to_master);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_raw_developer_files);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file_info);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_clear_error (&_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 6634 "PhotoMonitor.c"
			}
		}
		goto __finally595;
		__catch595_database_error:
		{
			GError* err = NULL;
			GError* _tmp89_;
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			err = _inner_error_;
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp89_ = err;
#line 999 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			app_window_database_error (_tmp89_);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_error_free0 (err);
#line 6652 "PhotoMonitor.c"
		}
		__finally595:
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_raw_developments);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_editable);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_master);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (revert_to_master);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_raw_developer_files);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file_info);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 6675 "PhotoMonitor.c"
		}
	}
#line 1003 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp90_ = set_editable_file_info;
#line 1003 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp90_ != NULL) {
#line 6682 "PhotoMonitor.c"
		GeeMap* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp91_ = set_editable_file_info;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp92_ = gee_map_get_size (_tmp91_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp93_ = _tmp92_;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp94_ = g_strdup_printf ("Updating %d editable files timestamps", _tmp93_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp95_ = _tmp94_;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp95_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp95_);
#line 6702 "PhotoMonitor.c"
		{
			GeeMap* _tmp96_;
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp96_ = set_editable_file_info;
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_update_many_editable_timestamps (_tmp96_, &_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 6713 "PhotoMonitor.c"
					goto __catch596_database_error;
				}
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_raw_developments);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_editable);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_master);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (revert_to_master);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_raw_developer_files);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file_info);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_clear_error (&_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 6736 "PhotoMonitor.c"
			}
		}
		goto __finally596;
		__catch596_database_error:
		{
			GError* err = NULL;
			GError* _tmp97_;
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			err = _inner_error_;
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_inner_error_ = NULL;
#line 1009 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp97_ = err;
#line 1009 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			app_window_database_error (_tmp97_);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_error_free0 (err);
#line 6754 "PhotoMonitor.c"
		}
		__finally596:
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_raw_developments);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_editable);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_master);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (revert_to_master);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_raw_developer_files);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file_info);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 6777 "PhotoMonitor.c"
		}
	}
#line 1013 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp98_ = revert_to_master;
#line 1013 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp98_ != NULL) {
#line 6784 "PhotoMonitor.c"
		GeeArrayList* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp99_ = revert_to_master;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp100_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp101_ = _tmp100_;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp102_ = g_strdup_printf ("Reverting %d photos to master", _tmp101_);
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp103_ = _tmp102_;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp103_);
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp103_);
#line 6804 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp104_;
			GeeArrayList* _tmp105_;
			gint _photo_size = 0;
			GeeArrayList* _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			gint _photo_index = 0;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp104_ = revert_to_master;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp105_ = _g_object_ref0 (_tmp104_);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp105_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp106_ = _photo_list;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp107_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp108_ = _tmp107_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp108_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 6832 "PhotoMonitor.c"
				gint _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp112_;
				gint _tmp113_;
				gpointer _tmp114_;
				LibraryPhoto* _tmp115_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp109_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp109_ + 1;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp110_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp111_ = _photo_size;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp110_ < _tmp111_)) {
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 6853 "PhotoMonitor.c"
				}
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp112_ = _photo_list;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp113_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp114_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp113_);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp114_;
#line 1017 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp115_ = photo;
#line 1017 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, TYPE_PHOTO, Photo), TRUE);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 6869 "PhotoMonitor.c"
			}
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 6873 "PhotoMonitor.c"
		}
	}
#line 1024 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp116_ = reimport_master;
#line 1024 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp116_ != NULL) {
#line 6880 "PhotoMonitor.c"
		GeeArrayList* _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp117_ = reimport_master;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp118_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp119_ = _tmp118_;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp120_ = g_strdup_printf ("Reimporting %d masters", _tmp119_);
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp121_ = _tmp120_;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp121_);
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp121_);
#line 6900 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp122_;
			GeeArrayList* _tmp123_;
			gint _photo_size = 0;
			GeeArrayList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _photo_index = 0;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp122_ = reimport_master;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp123_ = _g_object_ref0 (_tmp122_);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp123_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp124_ = _photo_list;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp125_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp126_ = _tmp125_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp126_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 6928 "PhotoMonitor.c"
				gint _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp130_;
				gint _tmp131_;
				gpointer _tmp132_;
				GeeHashMap* _tmp133_;
				LibraryPhoto* _tmp134_;
				PhotoMonitorReimportMasterJob* job = NULL;
				LibraryPhoto* _tmp135_;
				PhotoMonitorReimportMasterJob* _tmp136_;
				GeeHashMap* _tmp137_;
				LibraryPhoto* _tmp138_;
				PhotoMonitorReimportMasterJob* _tmp139_;
				Workers* _tmp140_;
				PhotoMonitorReimportMasterJob* _tmp141_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp127_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp127_ + 1;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp128_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp129_ = _photo_size;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp128_ < _tmp129_)) {
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 6958 "PhotoMonitor.c"
				}
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp130_ = _photo_list;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp131_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp132_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp131_);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp132_;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp133_ = self->priv->master_reimport_pending;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp134_ = photo;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp134_), "!master_reimport_pending.has_key(photo)");
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp135_ = photo;
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp136_ = photo_monitor_reimport_master_job_new (self, _tmp135_);
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp136_;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp137_ = self->priv->master_reimport_pending;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp138_ = photo;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp139_ = job;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp138_, _tmp139_);
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp140_ = self->priv->workers;
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp141_ = job;
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp140_, G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 6998 "PhotoMonitor.c"
			}
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7002 "PhotoMonitor.c"
		}
	}
#line 1036 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp142_ = reimport_editable;
#line 1036 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp142_ != NULL) {
#line 7009 "PhotoMonitor.c"
		GeeArrayList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp143_ = reimport_editable;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp144_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp145_ = _tmp144_;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp146_ = g_strdup_printf ("Reimporting %d editables", _tmp145_);
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp147_ = _tmp146_;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp147_);
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp147_);
#line 7029 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp148_;
			GeeArrayList* _tmp149_;
			gint _photo_size = 0;
			GeeArrayList* _tmp150_;
			gint _tmp151_;
			gint _tmp152_;
			gint _photo_index = 0;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp148_ = reimport_editable;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp149_ = _g_object_ref0 (_tmp148_);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp149_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp150_ = _photo_list;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp151_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp152_ = _tmp151_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp152_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 7057 "PhotoMonitor.c"
				gint _tmp153_;
				gint _tmp154_;
				gint _tmp155_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp156_;
				gint _tmp157_;
				gpointer _tmp158_;
				GeeHashMap* _tmp159_;
				LibraryPhoto* _tmp160_;
				PhotoMonitorReimportEditableJob* job = NULL;
				LibraryPhoto* _tmp161_;
				PhotoMonitorReimportEditableJob* _tmp162_;
				GeeHashMap* _tmp163_;
				LibraryPhoto* _tmp164_;
				PhotoMonitorReimportEditableJob* _tmp165_;
				Workers* _tmp166_;
				PhotoMonitorReimportEditableJob* _tmp167_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp153_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp153_ + 1;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp154_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp155_ = _photo_size;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp154_ < _tmp155_)) {
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 7087 "PhotoMonitor.c"
				}
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp156_ = _photo_list;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp157_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp158_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp157_);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp158_;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp159_ = self->priv->editable_reimport_pending;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp160_ = photo;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp160_), "!editable_reimport_pending.has_key(photo)");
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp161_ = photo;
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp162_ = photo_monitor_reimport_editable_job_new (self, _tmp161_);
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp162_;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp163_ = self->priv->editable_reimport_pending;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp164_ = photo;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp165_ = job;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp164_, _tmp165_);
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp166_ = self->priv->workers;
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp167_ = job;
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp166_, G_TYPE_CHECK_INSTANCE_CAST (_tmp167_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 7127 "PhotoMonitor.c"
			}
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7131 "PhotoMonitor.c"
		}
	}
#line 1048 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp168_ = reimport_raw_developments;
#line 1048 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp168_ != NULL) {
#line 7138 "PhotoMonitor.c"
		GeeArrayList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp169_ = reimport_raw_developments;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp170_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp171_ = _tmp170_;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp172_ = g_strdup_printf ("Reimporting %d raw developments", _tmp171_);
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp173_ = _tmp172_;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp173_);
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp173_);
#line 7158 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp174_;
			GeeArrayList* _tmp175_;
			gint _photo_size = 0;
			GeeArrayList* _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			gint _photo_index = 0;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp174_ = reimport_raw_developments;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp175_ = _g_object_ref0 (_tmp174_);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp175_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp176_ = _photo_list;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp177_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp176_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp178_ = _tmp177_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp178_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 7186 "PhotoMonitor.c"
				gint _tmp179_;
				gint _tmp180_;
				gint _tmp181_;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp182_;
				gint _tmp183_;
				gpointer _tmp184_;
				GeeHashMap* _tmp185_;
				LibraryPhoto* _tmp186_;
				PhotoMonitorReimportRawDevelopmentJob* job = NULL;
				LibraryPhoto* _tmp187_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp188_;
				GeeHashMap* _tmp189_;
				LibraryPhoto* _tmp190_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp191_;
				Workers* _tmp192_;
				PhotoMonitorReimportRawDevelopmentJob* _tmp193_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp179_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp179_ + 1;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp180_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp181_ = _photo_size;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp180_ < _tmp181_)) {
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 7216 "PhotoMonitor.c"
				}
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp182_ = _photo_list;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp183_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp184_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp183_);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp184_;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp185_ = self->priv->raw_developments_reimport_pending;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp186_ = photo;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp186_), "!raw_developments_reimport_pending.has_key(photo)");
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp187_ = photo;
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp188_ = photo_monitor_reimport_raw_development_job_new (self, _tmp187_);
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp188_;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp189_ = self->priv->raw_developments_reimport_pending;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp190_ = photo;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp191_ = job;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp190_, _tmp191_);
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp192_ = self->priv->workers;
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp193_ = job;
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp192_, G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 7256 "PhotoMonitor.c"
			}
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7260 "PhotoMonitor.c"
		}
	}
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_raw_developments);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_editable);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_master);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (revert_to_master);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_raw_developer_files);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_editable_file_info);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_editable_file);
#line 7277 "PhotoMonitor.c"
}


static gpointer
_background_job_ref0 (gpointer self)
{
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? background_job_ref (self) : NULL;
#line 7286 "PhotoMonitor.c"
}


static void
photo_monitor_on_master_reimported (PhotoMonitor* self,
                                    BackgroundJob* j)
{
	PhotoMonitorReimportMasterJob* job = NULL;
	PhotoMonitorReimportMasterJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportMasterJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PhotoMonitorReimportMasterJob* _tmp6_;
	GError* _tmp7_;
	PhotoMonitorReimportMasterJob* _tmp17_;
	gboolean _tmp18_;
	PhotoMonitorReimportMasterJob* _tmp26_;
	LibraryPhoto* _tmp27_;
	PhotoMonitorReimportMasterJob* _tmp30_;
	LibraryPhoto* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GError * _inner_error_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob));
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp0_;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = self->priv->master_reimport_pending;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = job;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_->photo;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp4_;
#line 1066 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = removed;
#line 1066 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp5_, "removed");
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = job;
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = _tmp6_->err;
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_ != NULL) {
#line 7343 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp8_;
		LibraryPhoto* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PhotoMonitorReimportMasterJob* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		PhotoMonitorReimportMasterJob* _tmp15_;
		LibraryPhoto* _tmp16_;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = job;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = _tmp8_->photo;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = _tmp10_;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = job;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_->err;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->message;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1069: Unable to reimport %s due to master file chang" \
"ing: %s", _tmp11_, _tmp14_);
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp11_);
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = job;
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = _tmp15_->photo;
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_MONITORABLE, Monitorable));
#line 1074 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1074 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7381 "PhotoMonitor.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp17_ = job;
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18_ = _tmp17_->mark_online;
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (!_tmp18_) {
#line 7389 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp19_;
		LibraryPhoto* _tmp20_;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = job;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = _tmp19_->photo;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MONITORABLE, Monitorable));
#line 1081 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1081 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7402 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportMasterJob* _tmp21_;
		LibraryPhoto* _tmp22_;
		PhotoMonitorReimportMasterJob* _tmp23_;
		PhotoReimportMasterState* _tmp24_;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp21_ = job;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = _tmp21_->photo;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = job;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = _tmp23_->reimport_state;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_PHOTO, Photo), _tmp24_, &_inner_error_);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7423 "PhotoMonitor.c"
				goto __catch597_database_error;
			}
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7434 "PhotoMonitor.c"
		}
	}
	goto __finally597;
	__catch597_database_error:
	{
		GError* err = NULL;
		GError* _tmp25_;
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1087 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp25_ = err;
#line 1087 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp25_);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7452 "PhotoMonitor.c"
	}
	__finally597:
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7465 "PhotoMonitor.c"
	}
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp26_ = job;
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp27_ = _tmp26_->photo;
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_MEDIA_SOURCE, MediaSource))) {
#line 7473 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp28_;
		LibraryPhoto* _tmp29_;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp28_ = job;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp29_ = _tmp28_->photo;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_MONITORABLE, Monitorable));
#line 7482 "PhotoMonitor.c"
	}
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp30_ = job;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp31_ = _tmp30_->photo;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp32_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_DATA_OBJECT, DataObject));
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp33_ = _tmp32_;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp34_ = g_strdup_printf ("Reimported master for %s", _tmp33_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp35_ = _tmp34_;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp35_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp35_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp33_);
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7504 "PhotoMonitor.c"
}


static void
photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self,
                                            BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	gboolean _tmp2_;
#line 1097 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1097 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->master_reimport_pending;
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob)->photo;
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp2_;
#line 1099 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7530 "PhotoMonitor.c"
}


static void
photo_monitor_on_editable_reimported (PhotoMonitor* self,
                                      BackgroundJob* j)
{
	PhotoMonitorReimportEditableJob* job = NULL;
	PhotoMonitorReimportEditableJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportEditableJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PhotoMonitorReimportEditableJob* _tmp6_;
	GError* _tmp7_;
	PhotoMonitorReimportEditableJob* _tmp20_;
	LibraryPhoto* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError * _inner_error_ = NULL;
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob));
#line 1103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp0_;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = self->priv->editable_reimport_pending;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = job;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_->photo;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp4_;
#line 1107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = removed;
#line 1107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp5_, "removed");
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = job;
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = _tmp6_->err;
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_ != NULL) {
#line 7583 "PhotoMonitor.c"
		PhotoMonitorReimportEditableJob* _tmp8_;
		LibraryPhoto* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PhotoMonitorReimportEditableJob* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = job;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = _tmp8_->photo;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = _tmp10_;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = job;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_->err;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->message;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1110: Unable to reimport editable %s: %s", _tmp11_, _tmp14_);
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp11_);
#line 1112 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1112 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7613 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportEditableJob* _tmp15_;
		LibraryPhoto* _tmp16_;
		PhotoMonitorReimportEditableJob* _tmp17_;
		PhotoReimportEditableState* _tmp18_;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = job;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = _tmp15_->photo;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = job;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = _tmp17_->state;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO, Photo), _tmp18_, &_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7634 "PhotoMonitor.c"
				goto __catch598_database_error;
			}
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7645 "PhotoMonitor.c"
		}
	}
	goto __finally598;
	__catch598_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = err;
#line 1118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp19_);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7663 "PhotoMonitor.c"
	}
	__finally598:
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7676 "PhotoMonitor.c"
	}
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp20_ = job;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = _tmp20_->photo;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp22_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23_ = _tmp22_;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24_ = g_strdup_printf ("Reimported editable for %s", _tmp23_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp25_ = _tmp24_;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp25_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp25_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp23_);
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7698 "PhotoMonitor.c"
}


static void
photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self,
                                              BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	gboolean _tmp2_;
#line 1124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->editable_reimport_pending;
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob)->photo;
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp2_;
#line 1126 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7724 "PhotoMonitor.c"
}


static void
photo_monitor_on_raw_development_reimported (PhotoMonitor* self,
                                             BackgroundJob* j)
{
	PhotoMonitorReimportRawDevelopmentJob* job = NULL;
	PhotoMonitorReimportRawDevelopmentJob* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp1_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp2_;
	LibraryPhoto* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp6_;
	GError* _tmp7_;
	PhotoMonitorReimportRawDevelopmentJob* _tmp20_;
	LibraryPhoto* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError * _inner_error_ = NULL;
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob));
#line 1130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp0_;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = self->priv->raw_developments_reimport_pending;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = job;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_->photo;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp4_;
#line 1134 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = removed;
#line 1134 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp5_, "removed");
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = job;
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = _tmp6_->err;
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_ != NULL) {
#line 7777 "PhotoMonitor.c"
		PhotoMonitorReimportRawDevelopmentJob* _tmp8_;
		LibraryPhoto* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = job;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = _tmp8_->photo;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = _tmp10_;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = job;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_->err;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->message;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1137: Unable to reimport raw development %s: %s", _tmp11_, _tmp14_);
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp11_);
#line 1139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7807 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportRawDevelopmentJob* _tmp15_;
		LibraryPhoto* _tmp16_;
		PhotoMonitorReimportRawDevelopmentJob* _tmp17_;
		PhotoReimportRawDevelopmentState* _tmp18_;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = job;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = _tmp15_->photo;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = job;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = _tmp17_->state;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO, Photo), _tmp18_, &_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7828 "PhotoMonitor.c"
				goto __catch599_database_error;
			}
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7839 "PhotoMonitor.c"
		}
	}
	goto __finally599;
	__catch599_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = err;
#line 1145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp19_);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7857 "PhotoMonitor.c"
	}
	__finally599:
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7870 "PhotoMonitor.c"
	}
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp20_ = job;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = _tmp20_->photo;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp22_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23_ = _tmp22_;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24_ = g_strdup_printf ("Reimported raw development for %s", _tmp23_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp25_ = _tmp24_;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp25_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp25_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp23_);
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7892 "PhotoMonitor.c"
}


static void
photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self,
                                                     BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	LibraryPhoto* _tmp1_;
	gboolean _tmp2_;
#line 1151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->raw_developments_reimport_pending;
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (j, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob)->photo;
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp2_;
#line 1153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7918 "PhotoMonitor.c"
}


static void
_photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job,
                                                         gpointer self)
{
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_master_reimported ((PhotoMonitor*) self, job);
#line 7928 "PhotoMonitor.c"
}


static void
_photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                   gpointer self)
{
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_master_reimport_cancelled ((PhotoMonitor*) self, job);
#line 7938 "PhotoMonitor.c"
}


static PhotoMonitorReimportMasterJob*
photo_monitor_reimport_master_job_construct (GType object_type,
                                             PhotoMonitor* owner,
                                             LibraryPhoto* photo)
{
	PhotoMonitorReimportMasterJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = g_cancellable_new ();
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportMasterJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_master_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_master_reimport_cancelled_cancellation_callback, owner, NULL);
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp1_);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (photo);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp2_;
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 7971 "PhotoMonitor.c"
}


static PhotoMonitorReimportMasterJob*
photo_monitor_reimport_master_job_new (PhotoMonitor* owner,
                                       LibraryPhoto* photo)
{
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_master_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, owner, photo);
#line 7981 "PhotoMonitor.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? g_error_copy (self) : NULL;
#line 7990 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_master_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportMasterJob * self;
	GError * _inner_error_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
#line 8001 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportMasterState* _tmp2_ = NULL;
		gboolean _tmp3_;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_master_state_unref0 (self->reimport_state);
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->reimport_state = _tmp2_;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8019 "PhotoMonitor.c"
			goto __catch600_g_error;
		}
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->mark_online = _tmp0_;
#line 8024 "PhotoMonitor.c"
	}
	goto __finally600;
	__catch600_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8046 "PhotoMonitor.c"
	}
	__finally600:
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8057 "PhotoMonitor.c"
	}
}


static void
photo_monitor_reimport_master_job_class_init (PhotoMonitorReimportMasterJobClass * klass)
{
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_master_job_parent_class = g_type_class_peek_parent (klass);
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_master_job_finalize;
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) photo_monitor_reimport_master_job_real_execute;
#line 8071 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_master_job_instance_init (PhotoMonitorReimportMasterJob * self)
{
#line 163 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_state = NULL;
#line 164 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->mark_online = FALSE;
#line 165 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8084 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_master_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportMasterJob * self;
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
#line 162 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 163 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_master_state_unref0 (self->reimport_state);
#line 165 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_master_job_parent_class)->finalize (obj);
#line 8102 "PhotoMonitor.c"
}


static GType
photo_monitor_reimport_master_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_master_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_master_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportMasterJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_master_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportMasterJob), 0, (GInstanceInitFunc) photo_monitor_reimport_master_job_instance_init, NULL };
		GType photo_monitor_reimport_master_job_type_id;
		photo_monitor_reimport_master_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportMasterJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_master_job_type_id__volatile, photo_monitor_reimport_master_job_type_id);
	}
	return photo_monitor_reimport_master_job_type_id__volatile;
}


static void
_photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job,
                                                           gpointer self)
{
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_editable_reimported ((PhotoMonitor*) self, job);
#line 8126 "PhotoMonitor.c"
}


static void
_photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                     gpointer self)
{
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_editable_reimport_cancelled ((PhotoMonitor*) self, job);
#line 8136 "PhotoMonitor.c"
}


static PhotoMonitorReimportEditableJob*
photo_monitor_reimport_editable_job_construct (GType object_type,
                                               PhotoMonitor* owner,
                                               LibraryPhoto* photo)
{
	PhotoMonitorReimportEditableJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = g_cancellable_new ();
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportEditableJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_editable_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_editable_reimport_cancelled_cancellation_callback, owner, NULL);
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp1_);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (photo);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp2_;
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 8169 "PhotoMonitor.c"
}


static PhotoMonitorReimportEditableJob*
photo_monitor_reimport_editable_job_new (PhotoMonitor* owner,
                                         LibraryPhoto* photo)
{
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_editable_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, owner, photo);
#line 8179 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportEditableJob * self;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
#line 8190 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportEditableState* _tmp2_ = NULL;
		gboolean _tmp3_;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_editable_state_unref0 (self->state);
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->state = _tmp2_;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8208 "PhotoMonitor.c"
			goto __catch601_g_error;
		}
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->success = _tmp0_;
#line 8213 "PhotoMonitor.c"
	}
	goto __finally601;
	__catch601_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8235 "PhotoMonitor.c"
	}
	__finally601:
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8246 "PhotoMonitor.c"
	}
}


static void
photo_monitor_reimport_editable_job_class_init (PhotoMonitorReimportEditableJobClass * klass)
{
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_editable_job_parent_class = g_type_class_peek_parent (klass);
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_editable_job_finalize;
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) photo_monitor_reimport_editable_job_real_execute;
#line 8260 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_editable_job_instance_init (PhotoMonitorReimportEditableJob * self)
{
#line 185 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->state = NULL;
#line 186 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->success = FALSE;
#line 187 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8273 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_editable_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportEditableJob * self;
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
#line 184 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 185 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_editable_state_unref0 (self->state);
#line 187 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_editable_job_parent_class)->finalize (obj);
#line 8291 "PhotoMonitor.c"
}


static GType
photo_monitor_reimport_editable_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_editable_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_editable_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportEditableJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_editable_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportEditableJob), 0, (GInstanceInitFunc) photo_monitor_reimport_editable_job_instance_init, NULL };
		GType photo_monitor_reimport_editable_job_type_id;
		photo_monitor_reimport_editable_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportEditableJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_editable_job_type_id__volatile, photo_monitor_reimport_editable_job_type_id);
	}
	return photo_monitor_reimport_editable_job_type_id__volatile;
}


static void
_photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job,
                                                                  gpointer self)
{
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_raw_development_reimported ((PhotoMonitor*) self, job);
#line 8315 "PhotoMonitor.c"
}


static void
_photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job,
                                                                            gpointer self)
{
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_raw_development_reimport_cancelled ((PhotoMonitor*) self, job);
#line 8325 "PhotoMonitor.c"
}


static PhotoMonitorReimportRawDevelopmentJob*
photo_monitor_reimport_raw_development_job_construct (GType object_type,
                                                      PhotoMonitor* owner,
                                                      LibraryPhoto* photo)
{
	PhotoMonitorReimportRawDevelopmentJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = g_cancellable_new ();
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _tmp0_;
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportRawDevelopmentJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _photo_monitor_on_raw_development_reimported_completion_callback, owner, _tmp1_, _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback, owner, NULL);
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp1_);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (photo);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 8358 "PhotoMonitor.c"
}


static PhotoMonitorReimportRawDevelopmentJob*
photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner,
                                                LibraryPhoto* photo)
{
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_raw_development_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, owner, photo);
#line 8368 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base)
{
	PhotoMonitorReimportRawDevelopmentJob * self;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
#line 8379 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_;
		PhotoReimportRawDevelopmentState* _tmp2_ = NULL;
		gboolean _tmp3_;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_raw_development_state_unref0 (self->state);
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->state = _tmp2_;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8397 "PhotoMonitor.c"
			goto __catch602_g_error;
		}
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->success = _tmp0_;
#line 8402 "PhotoMonitor.c"
	}
	goto __finally602;
	__catch602_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8424 "PhotoMonitor.c"
	}
	__finally602:
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8435 "PhotoMonitor.c"
	}
}


static void
photo_monitor_reimport_raw_development_job_class_init (PhotoMonitorReimportRawDevelopmentJobClass * klass)
{
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_raw_development_job_parent_class = g_type_class_peek_parent (klass);
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_raw_development_job_finalize;
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) photo_monitor_reimport_raw_development_job_real_execute;
#line 8449 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_raw_development_job_instance_init (PhotoMonitorReimportRawDevelopmentJob * self)
{
#line 207 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->state = NULL;
#line 208 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->success = FALSE;
#line 209 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8462 "PhotoMonitor.c"
}


static void
photo_monitor_reimport_raw_development_job_finalize (BackgroundJob * obj)
{
	PhotoMonitorReimportRawDevelopmentJob * self;
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
#line 206 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 207 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_raw_development_state_unref0 (self->state);
#line 209 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_raw_development_job_parent_class)->finalize (obj);
#line 8480 "PhotoMonitor.c"
}


static GType
photo_monitor_reimport_raw_development_job_get_type (void)
{
	static volatile gsize photo_monitor_reimport_raw_development_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_raw_development_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportRawDevelopmentJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_raw_development_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportRawDevelopmentJob), 0, (GInstanceInitFunc) photo_monitor_reimport_raw_development_job_instance_init, NULL };
		GType photo_monitor_reimport_raw_development_job_type_id;
		photo_monitor_reimport_raw_development_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportRawDevelopmentJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_raw_development_job_type_id__volatile, photo_monitor_reimport_raw_development_job_type_id);
	}
	return photo_monitor_reimport_raw_development_job_type_id__volatile;
}


static void
photo_monitor_class_init (PhotoMonitorClass * klass)
{
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_parent_class = g_type_class_peek_parent (klass);
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_type_class_add_private (klass, sizeof (PhotoMonitorPrivate));
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor *, Monitorable*)) photo_monitor_real_create_updates;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor *)) photo_monitor_real_get_media_source_collection;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor *, GFile*)) photo_monitor_real_is_file_represented;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->close = (void (*) (MediaMonitor *)) photo_monitor_real_close;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor *, GFile*, GFileInfo*, Monitorable* *)) photo_monitor_real_notify_file_discovered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor *, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) photo_monitor_real_candidates_for_unknown_file;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->get_auxilliary_backing_files = (GFile** (*) (MediaMonitor *, Monitorable*, int*)) photo_monitor_real_get_auxilliary_backing_files;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->update_backing_file_info = (void (*) (MediaMonitor *, Monitorable*, GFile*, GFileInfo*)) photo_monitor_real_update_backing_file_info;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_discovery_completing = (void (*) (MediaMonitor *)) photo_monitor_real_notify_discovery_completing;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor *, GFile*, GFileInfo*)) photo_monitor_real_notify_file_created;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor *, GFile*, GFile*, GFileInfo*)) photo_monitor_real_notify_file_moved;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor *, GFile*)) photo_monitor_real_notify_file_altered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor *, GFile*)) photo_monitor_real_notify_file_attributes_altered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor *, GFile*, GFileInfo*)) photo_monitor_real_notify_file_alteration_completed;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor *, GFile*)) photo_monitor_real_notify_file_deleted;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->on_media_source_destroyed = (void (*) (MediaMonitor *, DataSource*)) photo_monitor_real_on_media_source_destroyed;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor *, GeeCollection*, TransactionController*, gint*, GError**)) photo_monitor_real_process_updates;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = photo_monitor_finalize;
#line 8541 "PhotoMonitor.c"
}


static void
photo_monitor_instance_init (PhotoMonitor * self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv = PHOTO_MONITOR_GET_PRIVATE (self);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->matched_editables = _tmp0_;
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->matched_developments = _tmp1_;
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->master_reimport_pending = _tmp2_;
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->editable_reimport_pending = _tmp3_;
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->raw_developments_reimport_pending = _tmp4_;
#line 8575 "PhotoMonitor.c"
}


static void
photo_monitor_finalize (GObject * obj)
{
	PhotoMonitor * self;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 227 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->matched_editables);
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->matched_developments);
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->master_reimport_pending);
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->editable_reimport_pending);
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->raw_developments_reimport_pending);
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	G_OBJECT_CLASS (photo_monitor_parent_class)->finalize (obj);
#line 8599 "PhotoMonitor.c"
}


GType
photo_monitor_get_type (void)
{
	static volatile gsize photo_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitor), 0, (GInstanceInitFunc) photo_monitor_instance_init, NULL };
		GType photo_monitor_type_id;
		photo_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "PhotoMonitor", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_type_id__volatile, photo_monitor_type_id);
	}
	return photo_monitor_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



