/* MediaMetadata.c generated by valac 0.40.4, the Vala compiler
 * generated from MediaMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
typedef struct _ParamSpecMediaMetadata ParamSpecMediaMetadata;

#define TYPE_METADATA_RATIONAL (metadata_rational_get_type ())
typedef struct _MetadataRational MetadataRational;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MetadataDateTimePrivate MetadataDateTimePrivate;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef struct _ParamSpecMetadataDateTime ParamSpecMetadataDateTime;

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _ParamSpecMediaMetadata {
	GParamSpec parent_instance;
};

struct _MetadataRational {
	gint numerator;
	gint denominator;
};

typedef enum  {
	METADATA_DATE_TIME_ERROR_INVALID_FORMAT,
	METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT
} MetadataDateTimeError;
#define METADATA_DATE_TIME_ERROR metadata_date_time_error_quark ()
struct _MetadataDateTime {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MetadataDateTimePrivate * priv;
};

struct _MetadataDateTimeClass {
	GTypeClass parent_class;
	void (*finalize) (MetadataDateTime *self);
};

struct _MetadataDateTimePrivate {
	time_t timestamp;
};

struct _ParamSpecMetadataDateTime {
	GParamSpec parent_instance;
};


static gpointer media_metadata_parent_class = NULL;
static gpointer metadata_date_time_parent_class = NULL;

gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MediaMetadata* media_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error);
static void media_metadata_real_read_from_file (MediaMetadata* self,
                                         GFile* file,
                                         GError** error);
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
static MetadataDateTime* media_metadata_real_get_creation_date_time (MediaMetadata* self);
gchar* media_metadata_get_title (MediaMetadata* self);
static gchar* media_metadata_real_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
static gchar* media_metadata_real_get_comment (MediaMetadata* self);
static void media_metadata_finalize (MediaMetadata * obj);
GType metadata_rational_get_type (void) G_GNUC_CONST;
MetadataRational* metadata_rational_dup (const MetadataRational* self);
void metadata_rational_free (MetadataRational* self);
void metadata_rational_init (MetadataRational *self,
                             gint numerator,
                             gint denominator);
static gboolean metadata_rational_is_component_valid (MetadataRational *self,
                                               gint component);
gboolean metadata_rational_is_valid (MetadataRational *self);
gchar* metadata_rational_to_string (MetadataRational *self);
GQuark metadata_date_time_error_quark (void);
#define METADATA_DATE_TIME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_METADATA_DATE_TIME, MetadataDateTimePrivate))
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type,
                                                time_t timestamp);
MetadataDateTime* metadata_date_time_new_from_exif (const gchar* label,
                                                    GError** error);
MetadataDateTime* metadata_date_time_construct_from_exif (GType object_type,
                                                          const gchar* label,
                                                          GError** error);
gboolean metadata_date_time_from_exif_date_time (const gchar* date_time,
                                                 time_t* timestamp);
MetadataDateTime* metadata_date_time_new_from_iptc (const gchar* date,
                                                    const gchar* time,
                                                    GError** error);
MetadataDateTime* metadata_date_time_construct_from_iptc (GType object_type,
                                                          const gchar* date,
                                                          const gchar* time,
                                                          GError** error);
MetadataDateTime* metadata_date_time_new_from_xmp (const gchar* label,
                                                   GError** error);
MetadataDateTime* metadata_date_time_construct_from_xmp (GType object_type,
                                                         const gchar* label,
                                                         GError** error);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* metadata_date_time_get_exif_label (MetadataDateTime* self);
gchar* metadata_date_time_to_exif_date_time (time_t timestamp);
gchar* metadata_date_time_get_xmp_label (MetadataDateTime* self);
gchar* metadata_date_time_to_string (MetadataDateTime* self);
static void metadata_date_time_finalize (MetadataDateTime * obj);


MediaMetadata*
media_metadata_construct (GType object_type)
{
	MediaMetadata* self = NULL;
#line 8 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = (MediaMetadata*) g_type_create_instance (object_type);
#line 8 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return self;
#line 193 "MediaMetadata.c"
}


static void
media_metadata_real_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error)
{
#line 11 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `media_metadata_read_from_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 11 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return;
#line 206 "MediaMetadata.c"
}


void
media_metadata_read_from_file (MediaMetadata* self,
                               GFile* file,
                               GError** error)
{
#line 11 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_if_fail (IS_MEDIA_METADATA (self));
#line 11 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	MEDIA_METADATA_GET_CLASS (self)->read_from_file (self, file, error);
#line 219 "MediaMetadata.c"
}


static MetadataDateTime*
media_metadata_real_get_creation_date_time (MediaMetadata* self)
{
#line 13 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_creation_date_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 13 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 230 "MediaMetadata.c"
}


MetadataDateTime*
media_metadata_get_creation_date_time (MediaMetadata* self)
{
#line 13 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_MEDIA_METADATA (self), NULL);
#line 13 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return MEDIA_METADATA_GET_CLASS (self)->get_creation_date_time (self);
#line 241 "MediaMetadata.c"
}


static gchar*
media_metadata_real_get_title (MediaMetadata* self)
{
#line 15 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 15 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 252 "MediaMetadata.c"
}


gchar*
media_metadata_get_title (MediaMetadata* self)
{
#line 15 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_MEDIA_METADATA (self), NULL);
#line 15 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return MEDIA_METADATA_GET_CLASS (self)->get_title (self);
#line 263 "MediaMetadata.c"
}


static gchar*
media_metadata_real_get_comment (MediaMetadata* self)
{
#line 17 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 17 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 274 "MediaMetadata.c"
}


gchar*
media_metadata_get_comment (MediaMetadata* self)
{
#line 17 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_MEDIA_METADATA (self), NULL);
#line 17 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return MEDIA_METADATA_GET_CLASS (self)->get_comment (self);
#line 285 "MediaMetadata.c"
}


static void
value_media_metadata_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 294 "MediaMetadata.c"
}


static void
value_media_metadata_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		media_metadata_unref (value->data[0].v_pointer);
#line 305 "MediaMetadata.c"
	}
}


static void
value_media_metadata_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		dest_value->data[0].v_pointer = media_metadata_ref (src_value->data[0].v_pointer);
#line 318 "MediaMetadata.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 322 "MediaMetadata.c"
	}
}


static gpointer
value_media_metadata_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return value->data[0].v_pointer;
#line 332 "MediaMetadata.c"
}


static gchar*
value_media_metadata_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 344 "MediaMetadata.c"
		MediaMetadata * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 351 "MediaMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 355 "MediaMetadata.c"
		}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = media_metadata_ref (object);
#line 359 "MediaMetadata.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 363 "MediaMetadata.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 367 "MediaMetadata.c"
}


static gchar*
value_media_metadata_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	MediaMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 383 "MediaMetadata.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = NULL;
#line 389 "MediaMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 393 "MediaMetadata.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = media_metadata_ref (value->data[0].v_pointer);
#line 397 "MediaMetadata.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 401 "MediaMetadata.c"
}


GParamSpec*
param_spec_media_metadata (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecMediaMetadata* spec;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MEDIA_METADATA), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 421 "MediaMetadata.c"
}


gpointer
value_get_media_metadata (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA), NULL);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return value->data[0].v_pointer;
#line 432 "MediaMetadata.c"
}


void
value_set_media_metadata (GValue* value,
                          gpointer v_object)
{
	MediaMetadata * old;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_METADATA));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		media_metadata_ref (value->data[0].v_pointer);
#line 455 "MediaMetadata.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 459 "MediaMetadata.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		media_metadata_unref (old);
#line 465 "MediaMetadata.c"
	}
}


void
value_take_media_metadata (GValue* value,
                           gpointer v_object)
{
	MediaMetadata * old;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_METADATA));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 487 "MediaMetadata.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 491 "MediaMetadata.c"
	}
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		media_metadata_unref (old);
#line 497 "MediaMetadata.c"
	}
}


static void
media_metadata_class_init (MediaMetadataClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	media_metadata_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = media_metadata_finalize;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata *, GFile*, GError**)) media_metadata_real_read_from_file;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata *)) media_metadata_real_get_creation_date_time;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata *)) media_metadata_real_get_title;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata *)) media_metadata_real_get_comment;
#line 517 "MediaMetadata.c"
}


static void
media_metadata_instance_init (MediaMetadata * self)
{
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->ref_count = 1;
#line 526 "MediaMetadata.c"
}


static void
media_metadata_finalize (MediaMetadata * obj)
{
	MediaMetadata * self;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_METADATA, MediaMetadata);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_signal_handlers_destroy (self);
#line 538 "MediaMetadata.c"
}


GType
media_metadata_get_type (void)
{
	static volatile gsize media_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&media_metadata_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_media_metadata_init, value_media_metadata_free_value, value_media_metadata_copy_value, value_media_metadata_peek_pointer, "p", value_media_metadata_collect_value, "p", value_media_metadata_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MediaMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaMetadata), 0, (GInstanceInitFunc) media_metadata_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType media_metadata_type_id;
		media_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MediaMetadata", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&media_metadata_type_id__volatile, media_metadata_type_id);
	}
	return media_metadata_type_id__volatile;
}


gpointer
media_metadata_ref (gpointer instance)
{
	MediaMetadata * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return instance;
#line 567 "MediaMetadata.c"
}


void
media_metadata_unref (gpointer instance)
{
	MediaMetadata * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		MEDIA_METADATA_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 582 "MediaMetadata.c"
	}
}


void
metadata_rational_init (MetadataRational *self,
                        gint numerator,
                        gint denominator)
{
#line 24 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	memset (self, 0, sizeof (MetadataRational));
#line 25 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	(*self).numerator = numerator;
#line 26 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	(*self).denominator = denominator;
#line 598 "MediaMetadata.c"
}


static gboolean
metadata_rational_is_component_valid (MetadataRational *self,
                                      gint component)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 30 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (component >= 0) {
#line 30 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = component <= 1000000;
#line 612 "MediaMetadata.c"
	} else {
#line 30 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = FALSE;
#line 616 "MediaMetadata.c"
	}
#line 30 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 622 "MediaMetadata.c"
}


gboolean
metadata_rational_is_valid (MetadataRational *self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = (*self).numerator;
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (metadata_rational_is_component_valid (&(*self), _tmp1_)) {
#line 636 "MediaMetadata.c"
		gint _tmp2_;
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp2_ = (*self).denominator;
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = metadata_rational_is_component_valid (&(*self), _tmp2_);
#line 642 "MediaMetadata.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = FALSE;
#line 646 "MediaMetadata.c"
	}
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 652 "MediaMetadata.c"
}


gchar*
metadata_rational_to_string (MetadataRational *self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (metadata_rational_is_valid (&(*self))) {
#line 663 "MediaMetadata.c"
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp1_ = (*self).numerator;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp2_ = (*self).denominator;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp3_ = g_strdup_printf ("%d/%d", _tmp1_, _tmp2_);
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_g_free0 (_tmp0_);
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = _tmp3_;
#line 677 "MediaMetadata.c"
	} else {
		gchar* _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp4_ = g_strdup ("");
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_g_free0 (_tmp0_);
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = _tmp4_;
#line 686 "MediaMetadata.c"
	}
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 692 "MediaMetadata.c"
}


MetadataRational*
metadata_rational_dup (const MetadataRational* self)
{
	MetadataRational* dup;
#line 20 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	dup = g_new0 (MetadataRational, 1);
#line 20 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	memcpy (dup, self, sizeof (MetadataRational));
#line 20 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return dup;
#line 706 "MediaMetadata.c"
}


void
metadata_rational_free (MetadataRational* self)
{
#line 20 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_free (self);
#line 715 "MediaMetadata.c"
}


GType
metadata_rational_get_type (void)
{
	static volatile gsize metadata_rational_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_rational_type_id__volatile)) {
		GType metadata_rational_type_id;
		metadata_rational_type_id = g_boxed_type_register_static ("MetadataRational", (GBoxedCopyFunc) metadata_rational_dup, (GBoxedFreeFunc) metadata_rational_free);
		g_once_init_leave (&metadata_rational_type_id__volatile, metadata_rational_type_id);
	}
	return metadata_rational_type_id__volatile;
}


GQuark
metadata_date_time_error_quark (void)
{
	return g_quark_from_static_string ("metadata_date_time_error-quark");
}


MetadataDateTime*
metadata_date_time_construct (GType object_type,
                              time_t timestamp)
{
	MetadataDateTime* self = NULL;
#line 51 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = (MetadataDateTime*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->priv->timestamp = timestamp;
#line 51 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return self;
#line 750 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_new (time_t timestamp)
{
#line 51 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return metadata_date_time_construct (TYPE_METADATA_DATE_TIME, timestamp);
#line 759 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_construct_from_exif (GType object_type,
                                        const gchar* label,
                                        GError** error)
{
	MetadataDateTime* self = NULL;
	time_t _tmp0_ = 0;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (label != NULL, NULL);
#line 55 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = (MetadataDateTime*) g_type_create_instance (object_type);
#line 56 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = metadata_date_time_from_exif_date_time (label, &_tmp0_);
#line 56 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->priv->timestamp = _tmp0_;
#line 56 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!_tmp1_) {
#line 782 "MediaMetadata.c"
		GError* _tmp2_;
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp2_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not EXIF format date/time", label);
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_inner_error_ = _tmp2_;
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (_inner_error_->domain == METADATA_DATE_TIME_ERROR) {
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			_metadata_date_time_unref0 (self);
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return NULL;
#line 796 "MediaMetadata.c"
		} else {
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return NULL;
#line 804 "MediaMetadata.c"
		}
	}
#line 55 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return self;
#line 809 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_new_from_exif (const gchar* label,
                                  GError** error)
{
#line 55 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return metadata_date_time_construct_from_exif (TYPE_METADATA_DATE_TIME, label, error);
#line 819 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_construct_from_iptc (GType object_type,
                                        const gchar* date,
                                        const gchar* time,
                                        GError** error)
{
	MetadataDateTime* self = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (date != NULL, NULL);
#line 60 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (time != NULL, NULL);
#line 60 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = (MetadataDateTime*) g_type_create_instance (object_type);
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp0_ = g_error_new_literal (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT, "IPTC date/time format not currently supported");
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_inner_error_ = _tmp0_;
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_inner_error_->domain == METADATA_DATE_TIME_ERROR) {
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_metadata_date_time_unref0 (self);
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		return NULL;
#line 850 "MediaMetadata.c"
	} else {
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_clear_error (&_inner_error_);
#line 62 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		return NULL;
#line 858 "MediaMetadata.c"
	}
#line 60 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return self;
#line 862 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_new_from_iptc (const gchar* date,
                                  const gchar* time,
                                  GError** error)
{
#line 60 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return metadata_date_time_construct_from_iptc (TYPE_METADATA_DATE_TIME, date, time, error);
#line 873 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_construct_from_xmp (GType object_type,
                                       const gchar* label,
                                       GError** error)
{
	MetadataDateTime* self = NULL;
	GTimeVal time_val = {0};
	GTimeVal _tmp1_;
	glong _tmp2_;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (label != NULL, NULL);
#line 65 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = (MetadataDateTime*) g_type_create_instance (object_type);
#line 66 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_get_current_time (&time_val);
#line 67 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!g_time_val_from_iso8601 (label, &time_val)) {
#line 895 "MediaMetadata.c"
		GError* _tmp0_;
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not XMP format date/time", label);
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_inner_error_ = _tmp0_;
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (_inner_error_->domain == METADATA_DATE_TIME_ERROR) {
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			_metadata_date_time_unref0 (self);
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return NULL;
#line 909 "MediaMetadata.c"
		} else {
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			g_clear_error (&_inner_error_);
#line 68 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return NULL;
#line 917 "MediaMetadata.c"
		}
	}
#line 70 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = time_val;
#line 70 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp2_ = _tmp1_.tv_sec;
#line 70 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->priv->timestamp = (time_t) _tmp2_;
#line 65 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return self;
#line 928 "MediaMetadata.c"
}


MetadataDateTime*
metadata_date_time_new_from_xmp (const gchar* label,
                                 GError** error)
{
#line 65 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return metadata_date_time_construct_from_xmp (TYPE_METADATA_DATE_TIME, label, error);
#line 938 "MediaMetadata.c"
}


time_t
metadata_date_time_get_timestamp (MetadataDateTime* self)
{
	time_t result = 0;
	time_t _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), 0);
#line 74 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 74 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 955 "MediaMetadata.c"
}


gchar*
metadata_date_time_get_exif_label (MetadataDateTime* self)
{
	gchar* result = NULL;
	time_t _tmp0_;
	gchar* _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
#line 78 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 78 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = metadata_date_time_to_exif_date_time (_tmp0_);
#line 78 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 975 "MediaMetadata.c"
}


gchar*
metadata_date_time_get_xmp_label (MetadataDateTime* self)
{
	gchar* result = NULL;
	GTimeVal time_val = {0};
	time_t _tmp0_;
	gchar* _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
#line 84 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_get_current_time (&time_val);
#line 85 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 85 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	time_val.tv_sec = (glong) _tmp0_;
#line 86 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	time_val.tv_usec = (glong) 0;
#line 88 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = g_time_val_to_iso8601 (&time_val);
#line 88 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp1_;
#line 88 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 1002 "MediaMetadata.c"
}


gboolean
metadata_date_time_from_exif_date_time (const gchar* date_time,
                                        time_t* timestamp)
{
	time_t _vala_timestamp = 0;
	gboolean result = FALSE;
	struct tm tm = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	struct tm _tmp8_;
	gint _tmp9_;
	gint _tmp20_;
	gint _tmp21_;
#line 91 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (date_time != NULL, FALSE);
#line 92 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_vala_timestamp = (time_t) 0;
#line 94 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	memset (&tm, 0, sizeof (struct tm));
#line 97 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (sscanf (date_time, "%d:%d:%d %d:%d:%d", &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &tm.tm_hour, &tm.tm_min, &tm.tm_sec) != 6) {
#line 1030 "MediaMetadata.c"
		gchar* tmp = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 100 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp0_ = g_strdup (date_time);
#line 100 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		tmp = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp1_ = tmp;
#line 101 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_strcanon (_tmp1_, "0123456789", ' ');
#line 102 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp2_ = tmp;
#line 102 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (sscanf (_tmp2_, "%4d%2d%2d%2d%2d%2d", &tm.tm_year, &tm.tm_mon, &tm.tm_mday, &tm.tm_hour, &tm.tm_min, &tm.tm_sec) != 6) {
#line 104 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			result = FALSE;
#line 104 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			_g_free0 (tmp);
#line 104 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			if (timestamp) {
#line 104 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
				*timestamp = _vala_timestamp;
#line 1055 "MediaMetadata.c"
			}
#line 104 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return result;
#line 1059 "MediaMetadata.c"
		}
#line 97 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_g_free0 (tmp);
#line 1063 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp8_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp9_ = _tmp8_.tm_year;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp9_ <= 1900) {
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp7_ = TRUE;
#line 1073 "MediaMetadata.c"
	} else {
		struct tm _tmp10_;
		gint _tmp11_;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp10_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp11_ = _tmp10_.tm_mon;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp7_ = _tmp11_ <= 0;
#line 1083 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp7_) {
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp6_ = TRUE;
#line 1089 "MediaMetadata.c"
	} else {
		struct tm _tmp12_;
		gint _tmp13_;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp12_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp13_ = _tmp12_.tm_mday;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp6_ = _tmp13_ < 0;
#line 1099 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp6_) {
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp5_ = TRUE;
#line 1105 "MediaMetadata.c"
	} else {
		struct tm _tmp14_;
		gint _tmp15_;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp14_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp15_ = _tmp14_.tm_hour;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp5_ = _tmp15_ < 0;
#line 1115 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp5_) {
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp4_ = TRUE;
#line 1121 "MediaMetadata.c"
	} else {
		struct tm _tmp16_;
		gint _tmp17_;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp16_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp17_ = _tmp16_.tm_min;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp4_ = _tmp17_ < 0;
#line 1131 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp4_) {
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp3_ = TRUE;
#line 1137 "MediaMetadata.c"
	} else {
		struct tm _tmp18_;
		gint _tmp19_;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp18_ = tm;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp19_ = _tmp18_.tm_sec;
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		_tmp3_ = _tmp19_ < 0;
#line 1147 "MediaMetadata.c"
	}
#line 108 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (_tmp3_) {
#line 109 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		result = FALSE;
#line 109 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (timestamp) {
#line 109 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			*timestamp = _vala_timestamp;
#line 1157 "MediaMetadata.c"
		}
#line 109 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		return result;
#line 1161 "MediaMetadata.c"
	}
#line 111 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp20_ = tm.tm_year;
#line 111 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	tm.tm_year = _tmp20_ - 1900;
#line 112 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp21_ = tm.tm_mon;
#line 112 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	tm.tm_mon = _tmp21_ - 1;
#line 113 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	tm.tm_isdst = -1;
#line 115 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_vala_timestamp = mktime (&tm);
#line 117 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = TRUE;
#line 117 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (timestamp) {
#line 117 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*timestamp = _vala_timestamp;
#line 1181 "MediaMetadata.c"
	}
#line 117 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 1185 "MediaMetadata.c"
}


static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2866 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2866 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2867 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2867 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return;
#line 1203 "MediaMetadata.c"
}


static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
#line 2874 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, format, &(*self));
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = buffer;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2__length1 = buffer_length1;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1249 "MediaMetadata.c"
}


gchar*
metadata_date_time_to_exif_date_time (time_t timestamp)
{
	gchar* result = NULL;
	struct tm _tmp0_ = {0};
	gchar* _tmp1_;
#line 121 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_time_local (timestamp, &_tmp0_);
#line 121 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = g_time_format (&_tmp0_, "%Y:%m:%d %H:%M:%S");
#line 121 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp1_;
#line 121 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 1267 "MediaMetadata.c"
}


gchar*
metadata_date_time_to_string (MetadataDateTime* self)
{
	gchar* result = NULL;
	time_t _tmp0_;
	gchar* _tmp1_;
#line 124 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (IS_METADATA_DATE_TIME (self), NULL);
#line 125 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 125 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	_tmp1_ = metadata_date_time_to_exif_date_time (_tmp0_);
#line 125 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	result = _tmp1_;
#line 125 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return result;
#line 1287 "MediaMetadata.c"
}


static void
value_metadata_date_time_init (GValue* value)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1296 "MediaMetadata.c"
}


static void
value_metadata_date_time_free_value (GValue* value)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		metadata_date_time_unref (value->data[0].v_pointer);
#line 1307 "MediaMetadata.c"
	}
}


static void
value_metadata_date_time_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		dest_value->data[0].v_pointer = metadata_date_time_ref (src_value->data[0].v_pointer);
#line 1320 "MediaMetadata.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1324 "MediaMetadata.c"
	}
}


static gpointer
value_metadata_date_time_peek_pointer (const GValue* value)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return value->data[0].v_pointer;
#line 1334 "MediaMetadata.c"
}


static gchar*
value_metadata_date_time_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1346 "MediaMetadata.c"
		MetadataDateTime * object;
		object = collect_values[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1353 "MediaMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1357 "MediaMetadata.c"
		}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = metadata_date_time_ref (object);
#line 1361 "MediaMetadata.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1365 "MediaMetadata.c"
	}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 1369 "MediaMetadata.c"
}


static gchar*
value_metadata_date_time_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	MetadataDateTime ** object_p;
	object_p = collect_values[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!object_p) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1385 "MediaMetadata.c"
	}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = NULL;
#line 1391 "MediaMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1395 "MediaMetadata.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		*object_p = metadata_date_time_ref (value->data[0].v_pointer);
#line 1399 "MediaMetadata.c"
	}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return NULL;
#line 1403 "MediaMetadata.c"
}


GParamSpec*
param_spec_metadata_date_time (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecMetadataDateTime* spec;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_METADATA_DATE_TIME), NULL);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1423 "MediaMetadata.c"
}


gpointer
value_get_metadata_date_time (const GValue* value)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME), NULL);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return value->data[0].v_pointer;
#line 1434 "MediaMetadata.c"
}


void
value_set_metadata_date_time (GValue* value,
                              gpointer v_object)
{
	MetadataDateTime * old;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (v_object) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		metadata_date_time_ref (value->data[0].v_pointer);
#line 1457 "MediaMetadata.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1461 "MediaMetadata.c"
	}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (old) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		metadata_date_time_unref (old);
#line 1467 "MediaMetadata.c"
	}
}


void
value_take_metadata_date_time (GValue* value,
                               gpointer v_object)
{
	MetadataDateTime * old;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (v_object) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1489 "MediaMetadata.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1493 "MediaMetadata.c"
	}
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (old) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		metadata_date_time_unref (old);
#line 1499 "MediaMetadata.c"
	}
}


static void
metadata_date_time_class_init (MetadataDateTimeClass * klass)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	metadata_date_time_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	((MetadataDateTimeClass *) klass)->finalize = metadata_date_time_finalize;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_type_class_add_private (klass, sizeof (MetadataDateTimePrivate));
#line 1513 "MediaMetadata.c"
}


static void
metadata_date_time_instance_init (MetadataDateTime * self)
{
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->priv = METADATA_DATE_TIME_GET_PRIVATE (self);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self->ref_count = 1;
#line 1524 "MediaMetadata.c"
}


static void
metadata_date_time_finalize (MetadataDateTime * obj)
{
	MetadataDateTime * self;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METADATA_DATE_TIME, MetadataDateTime);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_signal_handlers_destroy (self);
#line 1536 "MediaMetadata.c"
}


GType
metadata_date_time_get_type (void)
{
	static volatile gsize metadata_date_time_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_date_time_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_metadata_date_time_init, value_metadata_date_time_free_value, value_metadata_date_time_copy_value, value_metadata_date_time_peek_pointer, "p", value_metadata_date_time_collect_value, "p", value_metadata_date_time_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MetadataDateTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_date_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataDateTime), 0, (GInstanceInitFunc) metadata_date_time_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType metadata_date_time_type_id;
		metadata_date_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MetadataDateTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&metadata_date_time_type_id__volatile, metadata_date_time_type_id);
	}
	return metadata_date_time_type_id__volatile;
}


gpointer
metadata_date_time_ref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	return instance;
#line 1565 "MediaMetadata.c"
}


void
metadata_date_time_unref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		METADATA_DATE_TIME_GET_CLASS (self)->finalize (self);
#line 47 "/home/jens/Source/shotwell/src/MediaMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1580 "MediaMetadata.c"
	}
}



