/* LibraryFiles.c generated by valac 0.40.4, the Vala compiler
 * generated from LibraryFiles.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;


extern gboolean library_files_use_fallback_copy_func;
gboolean library_files_use_fallback_copy_func = FALSE;

void library_files_select_copy_function (void);
GFile* app_dirs_get_import_dir (void);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GFile* library_files_generate_unique_file (const gchar* basename,
                                           MediaMetadata* metadata,
                                           time_t ts,
                                           gboolean* collision,
                                           GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
GFile* app_dirs_get_baked_import_dir (time_t tm);
gchar* library_files_convert_basename (const gchar* basename);
GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GError** error);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                void* progress_callback_target,
                                gboolean blacklist,
                                GError** error);
time_t query_file_modified (GFile* file,
                            GError** error);
gboolean video_reader_is_supported_video_file (GFile* file);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_video_reader (GValue* value,
                             gpointer v_object);
void value_take_video_reader (GValue* value,
                              gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type,
                                     GFile* file);
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self,
                                           GError** error);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
void library_files_fallback_copy (GFile* src,
                                  GFile* dst,
                                  GFileProgressCallback callback,
                                  void* callback_target,
                                  GError** error);
void library_monitor_unblacklist_file (GFile* file);
gchar* md5_file (GFile* file,
                 GError** error);


static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (self) {
#line 246 "LibraryFiles.c"
		gchar* _tmp0_;
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 254 "LibraryFiles.c"
	} else {
		gchar* _tmp1_;
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 263 "LibraryFiles.c"
	}
}


void
library_files_select_copy_function (void)
{
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = app_dirs_get_import_dir ();
#line 12 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	import_dir = _tmp0_;
#line 281 "LibraryFiles.c"
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = g_file_query_filesystem_info (import_dir, "filesystem::type", NULL, &_inner_error_);
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		info = _tmp1_;
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 293 "LibraryFiles.c"
			goto __catch471_g_error;
		}
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = g_file_info_get_attribute_as_string (info, "filesystem::type");
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = _tmp2_;
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_files_use_fallback_copy_func = g_strcmp0 (_tmp3_, "nfs") == 0;
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp3_);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (info);
#line 306 "LibraryFiles.c"
	}
	goto __finally471;
	__catch471_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_error_ = _inner_error_;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = _error_;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = _tmp4_->message;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:18: Failed to query fs type: %s", _tmp5_);
#line 19 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_files_use_fallback_copy_func = TRUE;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (_error_);
#line 328 "LibraryFiles.c"
	}
	__finally471:
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (import_dir);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_clear_error (&_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 341 "LibraryFiles.c"
	}
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp6_ = library_files_use_fallback_copy_func;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp7_ = bool_to_string (_tmp6_);
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp8_ = _tmp7_;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_info ("LibraryFiles.vala:22: Using fallback copy: %s", _tmp8_);
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp8_);
#line 11 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (import_dir);
#line 355 "LibraryFiles.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return self ? g_error_copy (self) : NULL;
#line 364 "LibraryFiles.c"
}


GFile*
library_files_generate_unique_file (const gchar* basename,
                                    MediaMetadata* metadata,
                                    time_t ts,
                                    gboolean* collision,
                                    GError** error)
{
	gboolean _vala_collision = FALSE;
	GFile* result = NULL;
	time_t timestamp = 0;
	GFile* dir = NULL;
	time_t _tmp5_;
	GFile* _tmp6_;
	gchar* newbasename = NULL;
	gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail ((metadata == NULL) || IS_MEDIA_METADATA (metadata), NULL);
#line 34 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = ts;
#line 35 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (metadata != NULL) {
#line 397 "LibraryFiles.c"
		MetadataDateTime* date_time = NULL;
		MetadataDateTime* _tmp0_;
		MetadataDateTime* _tmp1_;
#line 36 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = media_metadata_get_creation_date_time (metadata);
#line 36 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		date_time = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = date_time;
#line 37 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp1_ != NULL) {
#line 409 "LibraryFiles.c"
			MetadataDateTime* _tmp2_;
#line 38 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp2_ = date_time;
#line 38 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			timestamp = metadata_date_time_get_timestamp (_tmp2_);
#line 415 "LibraryFiles.c"
		} else {
			time_t _tmp3_;
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp3_ = timestamp;
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (_tmp3_ == ((time_t) 0)) {
#line 422 "LibraryFiles.c"
				time_t _tmp4_;
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp4_ = time (NULL);
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				timestamp = _tmp4_;
#line 428 "LibraryFiles.c"
			}
		}
#line 35 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_metadata_date_time_unref0 (date_time);
#line 433 "LibraryFiles.c"
	}
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp5_ = timestamp;
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp6_ = app_dirs_get_baked_import_dir (_tmp5_);
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dir = _tmp6_;
#line 441 "LibraryFiles.c"
	{
		GFile* _tmp7_;
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp7_ = dir;
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error_);
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 450 "LibraryFiles.c"
			goto __catch472_g_error;
		}
	}
	goto __finally472;
	__catch472_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp8_ = err;
#line 48 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!g_error_matches (_tmp8_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 467 "LibraryFiles.c"
			GError* _tmp9_;
			GError* _tmp10_;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp9_ = err;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp10_ = _g_error_copy0 (_tmp9_);
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = _tmp10_;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 478 "LibraryFiles.c"
			goto __finally472;
		}
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 483 "LibraryFiles.c"
	}
	__finally472:
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 494 "LibraryFiles.c"
	}
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp11_ = library_files_convert_basename (basename);
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	newbasename = _tmp11_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp13_ = dir;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp15_ = generate_unique_file (_tmp13_, newbasename, &_tmp14_, &_inner_error_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_vala_collision = _tmp14_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp12_ = _tmp15_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (newbasename);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 518 "LibraryFiles.c"
	}
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp16_ = _tmp12_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp12_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = _tmp16_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp12_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (newbasename);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (dir);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (collision) {
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		*collision = _vala_collision;
#line 536 "LibraryFiles.c"
	}
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 540 "LibraryFiles.c"
}


gchar*
library_files_convert_basename (const gchar* basename)
{
	gchar* result = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
#line 62 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = config_facade_get_instance ();
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp2_ = configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp1_);
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp2_) {
#line 563 "LibraryFiles.c"
		gchar* _tmp3_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = g_utf8_strdown (basename, (gssize) -1);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		result = _tmp3_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return result;
#line 571 "LibraryFiles.c"
	} else {
		gchar* _tmp4_;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = g_strdup (basename);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		result = _tmp4_;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return result;
#line 580 "LibraryFiles.c"
	}
}


GFile*
library_files_duplicate (GFile* src,
                         GFileProgressCallback progress_callback,
                         void* progress_callback_target,
                         gboolean blacklist,
                         GError** error)
{
	GFile* result = NULL;
	time_t timestamp = 0;
	MediaMetadata* metadata = NULL;
	gboolean collision = FALSE;
	GFile* dest = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	MediaMetadata* _tmp20_;
	time_t _tmp21_;
	gboolean _tmp22_ = FALSE;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GError * _inner_error_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (G_IS_FILE (src), NULL);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = (time_t) 0;
#line 610 "LibraryFiles.c"
	{
		time_t _tmp0_ = 0;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = query_file_modified (src, &_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 617 "LibraryFiles.c"
			goto __catch473_g_error;
		}
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		timestamp = _tmp0_;
#line 622 "LibraryFiles.c"
	}
	goto __finally473;
	__catch473_g_error:
	{
		GError* err = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = g_file_get_path (src);
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = err;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = _tmp3_->message;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:78: Unable to access file modification for %s: %s", _tmp2_, _tmp4_);
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp2_);
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 650 "LibraryFiles.c"
	}
	__finally473:
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 659 "LibraryFiles.c"
	}
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	metadata = NULL;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (video_reader_is_supported_video_file (src)) {
#line 665 "LibraryFiles.c"
		VideoReader* reader = NULL;
		VideoReader* _tmp5_;
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = video_reader_new (src);
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp5_;
#line 672 "LibraryFiles.c"
		{
			VideoMetadata* _tmp6_ = NULL;
			VideoReader* _tmp7_;
			VideoMetadata* _tmp8_;
			VideoMetadata* _tmp9_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp7_ = reader;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp8_ = video_reader_read_metadata (_tmp7_, &_inner_error_);
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp6_ = _tmp8_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 686 "LibraryFiles.c"
				goto __catch474_g_error;
			}
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp9_ = _tmp6_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp6_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp6_);
#line 699 "LibraryFiles.c"
		}
		goto __finally474;
		__catch474_g_error:
		{
			GError* err = NULL;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 711 "LibraryFiles.c"
		}
		__finally474:
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_video_reader_unref0 (reader);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 724 "LibraryFiles.c"
		}
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_video_reader_unref0 (reader);
#line 728 "LibraryFiles.c"
	} else {
		PhotoFileReader* reader = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		PhotoFileReader* _tmp12_;
		PhotoFileReader* _tmp13_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp10_ = g_file_get_path (src);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = _tmp10_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp12_ = photo_file_format_create_reader (photo_file_format_get_by_file_extension (src), _tmp11_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp13_ = _tmp12_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp11_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp13_;
#line 747 "LibraryFiles.c"
		{
			PhotoMetadata* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_;
			PhotoMetadata* _tmp16_;
			PhotoMetadata* _tmp17_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp15_ = reader;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp16_ = photo_file_reader_read_metadata (_tmp15_, &_inner_error_);
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = _tmp16_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 761 "LibraryFiles.c"
				goto __catch475_g_error;
			}
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp17_ = _tmp14_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = NULL;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp14_);
#line 774 "LibraryFiles.c"
		}
		goto __finally475;
		__catch475_g_error:
		{
			GError* err = NULL;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 786 "LibraryFiles.c"
		}
		__finally475:
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_photo_file_adapter_unref0 (reader);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 799 "LibraryFiles.c"
		}
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_photo_file_adapter_unref0 (reader);
#line 803 "LibraryFiles.c"
	}
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp18_ = g_file_get_basename (src);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp19_ = _tmp18_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp20_ = metadata;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp21_ = timestamp;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp23_ = library_files_generate_unique_file (_tmp19_, _tmp20_, _tmp21_, &_tmp22_, &_inner_error_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	collision = _tmp22_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp24_ = _tmp23_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp19_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dest = _tmp24_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 831 "LibraryFiles.c"
	}
#line 101 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp25_ = dest;
#line 101 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp25_ == NULL) {
#line 837 "LibraryFiles.c"
		GError* _tmp26_;
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp26_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Unable to generate unique pathname for destination");
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = _tmp26_;
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 851 "LibraryFiles.c"
	}
#line 104 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (blacklist) {
#line 855 "LibraryFiles.c"
		GFile* _tmp27_;
#line 105 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp27_ = dest;
#line 105 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_monitor_blacklist_file (_tmp27_, "LibraryFiles.duplicate");
#line 861 "LibraryFiles.c"
	}
	{
		gboolean _tmp28_;
#line 108 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp28_ = library_files_use_fallback_copy_func;
#line 108 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp28_) {
#line 869 "LibraryFiles.c"
			GFile* _tmp29_;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp29_ = dest;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_files_fallback_copy (src, _tmp29_, progress_callback, progress_callback_target, &_inner_error_);
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 877 "LibraryFiles.c"
				goto __catch476_g_error;
			}
		} else {
			GFile* _tmp30_;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp30_ = dest;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_file_copy (src, _tmp30_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, progress_callback, progress_callback_target, &_inner_error_);
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "LibraryFiles.c"
				goto __catch476_g_error;
			}
		}
#line 113 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (blacklist) {
#line 894 "LibraryFiles.c"
			GFile* _tmp31_;
#line 114 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp31_ = dest;
#line 114 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp31_);
#line 900 "LibraryFiles.c"
		}
	}
	goto __finally476;
	__catch476_g_error:
	{
		GError* err = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GError* _tmp34_;
		const gchar* _tmp35_;
		gboolean _tmp36_ = FALSE;
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp32_ = g_file_get_path (src);
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp33_ = _tmp32_;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp34_ = err;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp35_ = _tmp34_->message;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_message ("LibraryFiles.vala:116: There was a problem copying %s: %s", _tmp33_, _tmp35_);
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp33_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (blacklist) {
#line 930 "LibraryFiles.c"
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			gchar* _tmp39_ = NULL;
			GFile* _tmp40_;
			gchar* _tmp41_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp38_ = md5_file (src, &_inner_error_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp37_ = _tmp38_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 944 "LibraryFiles.c"
				goto __finally476;
			}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp40_ = dest;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp41_ = md5_file (_tmp40_, &_inner_error_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp39_ = _tmp41_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_free0 (_tmp37_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 959 "LibraryFiles.c"
				goto __finally476;
			}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp36_ = g_strcmp0 (_tmp37_, _tmp39_) != 0;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp39_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp37_);
#line 968 "LibraryFiles.c"
		} else {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp36_ = FALSE;
#line 972 "LibraryFiles.c"
		}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp36_) {
#line 976 "LibraryFiles.c"
			GFile* _tmp42_;
#line 118 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp42_ = dest;
#line 118 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp42_);
#line 982 "LibraryFiles.c"
		}
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 986 "LibraryFiles.c"
	}
	__finally476:
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 999 "LibraryFiles.c"
	}
	{
		GFileInfo* info = NULL;
		GFile* _tmp43_;
		GFileInfo* _tmp44_;
		guint32 mode = 0U;
		GFileInfo* _tmp45_;
		gboolean _tmp46_ = FALSE;
		GFile* _tmp47_;
		guint32 _tmp48_;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp43_ = dest;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp44_ = g_file_query_info (_tmp43_, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		info = _tmp44_;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1018 "LibraryFiles.c"
			goto __catch477_g_error;
		}
#line 124 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp45_ = info;
#line 124 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		mode = g_file_info_get_attribute_uint32 (_tmp45_, G_FILE_ATTRIBUTE_UNIX_MODE) | 0600;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp47_ = dest;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp48_ = mode;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp46_ = g_file_set_attribute_uint32 (_tmp47_, G_FILE_ATTRIBUTE_UNIX_MODE, _tmp48_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_object_unref0 (info);
#line 1035 "LibraryFiles.c"
			goto __catch477_g_error;
		}
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!_tmp46_) {
#line 126 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_warning ("LibraryFiles.vala:126: Could not make file writable");
#line 1042 "LibraryFiles.c"
		}
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (info);
#line 1046 "LibraryFiles.c"
	}
	goto __finally477;
	__catch477_g_error:
	{
		GError* err = NULL;
		GError* _tmp49_;
		const gchar* _tmp50_;
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp49_ = err;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp50_ = _tmp49_->message;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_warning ("LibraryFiles.vala:129: Could not make file writable: %s", _tmp50_);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 1066 "LibraryFiles.c"
	}
	__finally477:
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 1079 "LibraryFiles.c"
	}
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = dest;
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_media_metadata_unref0 (metadata);
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 1087 "LibraryFiles.c"
}


void
library_files_fallback_copy (GFile* src,
                             GFile* dst,
                             GFileProgressCallback callback,
                             void* callback_target,
                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	FILE* f = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	GError * _inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_if_fail ((src == NULL) || G_IS_FILE (src));
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_if_fail ((dst == NULL) || G_IS_FILE (dst));
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (src == NULL) {
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = TRUE;
#line 1114 "LibraryFiles.c"
	} else {
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = dst == NULL;
#line 1118 "LibraryFiles.c"
	}
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp0_) {
#line 137 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 1124 "LibraryFiles.c"
	}
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = g_file_get_path (src);
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp2_ = _tmp1_;
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp3_ = g_fopen (_tmp2_, "rb");
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp4_ = _tmp3_;
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp2_);
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	f = _tmp4_;
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp5_ = f;
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp5_ != NULL) {
#line 1142 "LibraryFiles.c"
		FILE* _tmp6_;
		glong size = 0L;
		FILE* _tmp7_;
		FILE* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		glong _tmp13_;
		FILE* g = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		FILE* _tmp16_;
		FILE* _tmp17_;
		FILE* _tmp18_;
#line 142 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp6_ = f;
#line 142 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		fseek (_tmp6_, (glong) 0, SEEK_END);
#line 143 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp7_ = f;
#line 143 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		size = ftell (_tmp7_);
#line 144 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp8_ = f;
#line 144 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		fseek (_tmp8_, (glong) 0, SEEK_SET);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp9_ = g_file_get_path (src);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp10_ = _tmp9_;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = g_file_get_path (dst);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp12_ = _tmp11_;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp13_ = size;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_debug ("LibraryFiles.vala:145: Copying %s to %s, size is %ld", _tmp10_, _tmp12_, _tmp13_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp12_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp10_);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp14_ = g_file_get_path (dst);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp15_ = _tmp14_;
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp16_ = g_fopen (_tmp15_, "wb");
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp17_ = _tmp16_;
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp15_);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g = _tmp17_;
#line 148 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp18_ = g;
#line 148 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp18_ != NULL) {
#line 1202 "LibraryFiles.c"
			guint8 buffer[4096] = {0};
			gsize written = 0UL;
#line 150 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			written = (gsize) 0;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			while (TRUE) {
#line 1209 "LibraryFiles.c"
				FILE* _tmp19_;
				gsize len = 0UL;
				FILE* _tmp20_;
				gsize _tmp21_;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp19_ = f;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				if (!(!feof (_tmp19_))) {
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					break;
#line 1220 "LibraryFiles.c"
				}
#line 153 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp20_ = f;
#line 153 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				len = fread (buffer, (gsize) 1, 4096, _tmp20_);
#line 154 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp21_ = len;
#line 154 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				if (_tmp21_ > ((gsize) 0)) {
#line 1230 "LibraryFiles.c"
					gsize out_len = 0UL;
					FILE* _tmp22_;
					gsize _tmp23_;
					gsize _tmp24_;
					gsize _tmp31_;
					gsize _tmp32_;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp22_ = g;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp23_ = len;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					out_len = fwrite (buffer + 0, (gsize) 1, ((gint) _tmp23_) - 0, _tmp22_);
#line 156 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp24_ = out_len;
#line 156 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (_tmp24_ < ((gsize) 0)) {
#line 1247 "LibraryFiles.c"
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						GError* _tmp29_;
						GError* _tmp30_;
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp25_ = g_file_get_path (dst);
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp26_ = _tmp25_;
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_critical ("LibraryFiles.vala:157: Failed to write to file %s: %m", _tmp26_);
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp26_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp27_ = g_file_get_path (dst);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp28_ = _tmp27_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp29_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to write to %s", _tmp28_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp30_ = _tmp29_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp28_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_inner_error_ = _tmp30_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (g);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (f);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						return;
#line 1282 "LibraryFiles.c"
					}
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp31_ = written;
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp32_ = len;
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					written = _tmp31_ + _tmp32_;
#line 162 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (callback != NULL) {
#line 1292 "LibraryFiles.c"
						gsize _tmp33_;
						glong _tmp34_;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp33_ = written;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp34_ = size;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						callback ((gint64) _tmp33_, (gint64) _tmp34_, callback_target);
#line 1301 "LibraryFiles.c"
					}
				} else {
					gsize _tmp35_;
#line 164 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp35_ = len;
#line 164 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (_tmp35_ < ((gsize) 0)) {
#line 1309 "LibraryFiles.c"
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						GError* _tmp40_;
						GError* _tmp41_;
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp36_ = g_file_get_path (src);
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp37_ = _tmp36_;
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_critical ("LibraryFiles.vala:165: Failed to read from file %s: %m", _tmp37_);
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp37_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp38_ = g_file_get_path (src);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp39_ = _tmp38_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp40_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read from %s", _tmp39_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp41_ = _tmp40_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp39_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_inner_error_ = _tmp41_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (g);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (f);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						return;
#line 1344 "LibraryFiles.c"
					}
				}
			}
		} else {
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GError* _tmp46_;
			GError* _tmp47_;
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp42_ = g_file_get_path (dst);
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp43_ = _tmp42_;
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_critical ("LibraryFiles.vala:170: Failed to open %s: %m", _tmp43_);
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp43_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp44_ = g_file_get_path (dst);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp45_ = _tmp44_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp46_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp45_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp47_ = _tmp46_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp45_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = _tmp47_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_fclose0 (g);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_fclose0 (f);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return;
#line 1383 "LibraryFiles.c"
		}
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_fclose0 (g);
#line 1387 "LibraryFiles.c"
	} else {
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		GError* _tmp52_;
		GError* _tmp53_;
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp48_ = g_file_get_path (src);
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp49_ = _tmp48_;
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:174: Failed to open %s: %m", _tmp49_);
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp49_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp50_ = g_file_get_path (src);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp51_ = _tmp50_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp52_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp51_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp53_ = _tmp52_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp51_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = _tmp53_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_fclose0 (f);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 1421 "LibraryFiles.c"
	}
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_fclose0 (f);
#line 1425 "LibraryFiles.c"
}



