#!/usr/bin/perl

use strict;
use warnings;
use File::Basename;
use File::Compare;
use File::Copy;
use Test::More;
use lib 't';
use pgsm;

# Get file name and CREATE out file name and dirs WHERE requried
PGSM::setup_files_dir(basename($0));

# CREATE new PostgreSQL node and do initdb
my $node = PGSM->pgsm_init_pg();
my $pgdata = $node->data_dir;

# UPDATE postgresql.conf to include/load pg_stat_monitor library
open my $conf, '>>', "$pgdata/postgresql.conf";
print $conf "shared_preload_libraries = 'pg_stat_monitor'\n";
print $conf "pg_stat_monitor.pgsm_enable_overflow = false\n";
print $conf "pg_stat_monitor.pgsm_max = 1\n";
print $conf "pg_stat_monitor.pgsm_query_shared_buffer = 1\n";
print $conf "pg_stat_monitor.pgsm_query_max_len =10000\n";
print $conf " pg_stat_monitor.pgsm_enable_query_plan = 'yes'\n";
print $conf "pg_stat_monitor.pgsm_track_planning = 'yes'\n";
print $conf "pg_stat_monitor.pgsm_track = 'top'\n";
print $conf "pg_stat_monitor.pgsm_extract_comments = 'no'\n";
close $conf;

# Start server
my $rt_value = $node->start;
ok($rt_value == 1, "Start Server");

# CREATE EXTENSION and change out file permissions
my ($cmdret, $stdout, $stderr) = $node->psql('postgres', 'CREATE EXTENSION pg_stat_monitor;', extra_params => ['-a']);
ok($cmdret == 0, "CREATE PGSM EXTENSION");
PGSM::append_to_file($stdout);

# Run required commands/queries and dump output to out file.

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'CREATE table foo (id int generated by default AS identity,col1 varchar(100) not null,primary key(id));', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "CREATE Table foo");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT pg_stat_monitor_reset();', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Reset PGSM EXTENSION");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', "SELECT name, setting, unit, context, vartype, source, min_val, max_val, enumvals, boot_val, reset_val, pending_restart FROM pg_settings WHERE name LIKE '%pg_stat_monitor%';", extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Print PGSM EXTENSION Settings");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', '\i scripts/data_1.sql' , extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Run sql file:  scripts/data.sql");
#PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT substr(query, 0, 50), length(query), bucket, queryid, calls, elevel, sqlcode, message FROM pg_stat_monitor;', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "SELECT substr(query, 0, 50), calls, message FROM pg_stat_monitor");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT count(queryid) FROM pg_stat_monitor;', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "SELECT count(queryid) FROM pg_stat_monitor");
PGSM::append_to_file($stdout);

$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_max = 100\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_query_max_len = 1024\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_track_utility = 'yes'\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_normalized_query = 'yes'\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_max_buckets = 10\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_bucket_time = 60\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_histogram_min = 0\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_histogram_max = 100000\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_histogram_buckets = 10\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_query_shared_buffer = 20\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_enable_overflow = true\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_enable_query_plan = 'no'\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_track = 'top'\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_extract_comments = 'no'\n");
$node->append_conf('postgresql.conf', "pg_stat_monitor.pgsm_track_planning = 'no'\n");
$node->restart();

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT pg_stat_monitor_reset();', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Reset PGSM EXTENSION");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', "SELECT name, setting, unit, context, vartype, source, min_val, max_val, enumvals, boot_val, reset_val, pending_restart FROM pg_settings WHERE name LIKE '%pg_stat_monitor%';", extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Print PGSM EXTENSION Settings");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', '\i scripts/data_2.sql' , extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Run sql file:  scripts/data2.sql");
#PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT substr(query, 0, 50), length(query), bucket, queryid, calls, elevel, sqlcode, message FROM pg_stat_monitor;', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "SELECT substr(query, 0, 50), calls, message FROM pg_stat_monitor");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', 'SELECT count(queryid) FROM pg_stat_monitor;', extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "SELECT count(queryid) FROM pg_stat_monitor");
PGSM::append_to_file($stdout);

($cmdret, $stdout, $stderr) = $node->psql('postgres', "SELECT name, setting, unit, context, vartype, source, min_val, max_val, enumvals, boot_val, reset_val, pending_restart FROM pg_settings WHERE name LIKE '%pg_stat_monitor%';", extra_params => ['-a', '-Pformat=aligned','-Ptuples_only=off']);
ok($cmdret == 0, "Print PGSM EXTENSION Settings");
PGSM::append_to_file($stdout);

# DROP EXTENSION
$stdout = $node->safe_psql('postgres', 'DROP EXTENSION pg_stat_monitor;', extra_params => ['-a']);
ok($cmdret == 0, "DROP PGSM EXTENSION");
PGSM::append_to_file($stdout);

# Stop the server
$node->stop;

# Done testing for this testcase file.
done_testing();
