/*
 * This file is part of EasyRPG Player.
 *
 * EasyRPG Player is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EasyRPG Player is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EasyRPG Player. If not, see <http://www.gnu.org/licenses/>.
 */

#include "rtp.h"

namespace RTP {
/*
RPG 2000 RTP Table
- Official Japanese
- Official English
- Don Miguel English Translation
- Don Miguel RTP Addon

RPG 2003 RTP Table
- Official Japanese
- Official English
- RPG Advocate English Translation
- Vlad Russian Translation
- RPG Universe Spanish/Portuguese Translation
- Korean Translation
- Official Traditional Chinese
*/

const char* const rtp_table_2k[][5] = {
	{"backdrop", "ダンジョン1", "dungeon1", "cave1", nullptr},
	{"backdrop", "ダンジョン2", "dungeon2", "lavacave2", nullptr},
	{"backdrop", "ダンジョン3", "dungeon3", "icecave3", nullptr},
	{"backdrop", "ダンジョン4", "dungeon4", "cave4", nullptr},
	{"backdrop", "ダンジョン5", "dungeon5", "brickcave5", nullptr},
	{"backdrop", "宇宙", "space", "galaxy", nullptr},
	{"backdrop", "山道", "mountainpath", "canyon", nullptr},
	{"backdrop", "岩場", "rockyarea", "snowcanyon", nullptr},
	{"backdrop", "廃墟", "ruins", "wasteruins", nullptr},
	{"backdrop", "森1", "forest1", "forest1", nullptr},
	{"backdrop", "森2", "forest2", "forest2", nullptr},
	{"backdrop", "橋", "bridge", "bridge", nullptr},
	{"backdrop", "毒沼", "poisonswamp", "swamp", nullptr},
	{"backdrop", "海", "sea", "sea", nullptr},
	{"backdrop", "玉座", "throne", "castle", nullptr},
	{"backdrop", "異空間", "strangespace", "lightspeed", nullptr},
	{"backdrop", "砂浜", "sandybeach", "seabeach", nullptr},
	{"backdrop", "砂漠", "desert", "desert", nullptr},
	{"backdrop", "神殿", "shrine", "greece", nullptr},
	{"backdrop", "空", "sky", "sky", nullptr},
	{"backdrop", "船上", "shipdeck", "ship", nullptr},
	{"backdrop", "草原", "grassland", "grass", nullptr},
	{"backdrop", "荒地", "wasteland", "wasteland", nullptr},
	{"backdrop", "街中", "downtown", "town", nullptr},
	{"backdrop", "雪原", "snowfield", "snow", nullptr},
	{"backdrop", nullptr, nullptr, nullptr, "cave9"},
	{"backdrop", nullptr, nullptr, nullptr, "dark3"},
	{"backdrop", nullptr, nullptr, nullptr, "desert5"},
	{"backdrop", nullptr, nullptr, nullptr, "dungeon1"},
	{"backdrop", nullptr, nullptr, nullptr, "dungeon2"},
	{"backdrop", nullptr, nullptr, nullptr, "falls2"},
	{"backdrop", nullptr, nullptr, nullptr, "forest4"},
	{"backdrop", nullptr, nullptr, nullptr, "future1"},
	{"backdrop", nullptr, nullptr, nullptr, "future3"},
	{"backdrop", nullptr, nullptr, nullptr, "mtn4"},
	{"backdrop", nullptr, nullptr, nullptr, "nbridge"},
	{"backdrop", nullptr, nullptr, nullptr, "plainsg"},
	{"backdrop", nullptr, nullptr, nullptr, "ship1"},
	{"backdrop", nullptr, nullptr, nullptr, "underw1"},
	{"battle", "その他", "other", "etc", nullptr},
	{"battle", "バリア", "barrier", "barrier", nullptr},
	{"battle", "ブレス", "breath", "poison", nullptr},
	{"battle", "上昇", "buff", "up", nullptr},
	{"battle", "下降", "debuff", "down", nullptr},
	{"battle", "冷気", "ice", "cold", nullptr},
	{"battle", "剣1", "sword1", "sword1", nullptr},
	{"battle", "剣2", "sword2", "sword2", nullptr},
	{"battle", "吸収", "bite", "absorption", nullptr},
	{"battle", "回復", "recovery", "sun", nullptr},
	{"battle", "大地", "earth", "earth", nullptr},
	{"battle", "打撃", "blow", "hit", nullptr},
	{"battle", "斧", "axe", "axe", nullptr},
	{"battle", "暗黒", "dark", "dark", nullptr},
	{"battle", "槍", "spear", "spear", nullptr},
	{"battle", "水", "water", "water", nullptr},
	{"battle", "治療", "treatment", "sphere", nullptr},
	{"battle", "炎1", "fire1", "fire1", nullptr},
	{"battle", "炎2", "fire2", "fire2", nullptr},
	{"battle", "爆発", "explosion", "explosion", nullptr},
	{"battle", "爪", "claw", "fang", nullptr},
	{"battle", "矢", "arrow", "arrow", nullptr},
	{"battle", "神聖", "holy", "holy", nullptr},
	{"battle", "蘇生", "ressurection", "ray", nullptr},
	{"battle", "雷", "thunder", "zip", nullptr},
	{"battle", "鞭", "whip", "whip", nullptr},
	{"battle", "風", "wind", "wind", nullptr},
	{"battle", "麻痺", "paralysis", "paralysis", nullptr},
	{"battle", nullptr, nullptr, nullptr, "enemyhp"},
	{"battle", nullptr, nullptr, nullptr, "qande"},
	{"charset", "オブジェクト1", "object1", "object1", nullptr},
	{"charset", "オブジェクト2", "object2", "object2", nullptr},
	{"charset", "モンスター1", "monster1", "monster1", nullptr},
	{"charset", "モンスター2", "monster2", "monster2", nullptr},
	{"charset", "一般1", "people1", "people1", nullptr},
	{"charset", "一般2", "people2", "people7", nullptr},
	{"charset", "一般3", "people3", "people3", nullptr},
	{"charset", "一般4", "people4", "people4", nullptr},
	{"charset", "一般5", "people5", "people5", nullptr},
	{"charset", "主人公1", "actor1", "chara1", nullptr},
	{"charset", "主人公2", "actor2", "chara2", nullptr},
	{"charset", "主人公3", "actor3", "chara3", nullptr},
	{"charset", "主人公4", "actor4", "chara4", nullptr},
	{"charset", "乗り物", "vehicles", "vehicle", nullptr},
	{"charset", "動物", "animal", "animal", nullptr},
	{"charset", nullptr, nullptr, "chubby1", nullptr},
	{"charset", nullptr, nullptr, "chubby2", nullptr},
	{"charset", nullptr, nullptr, "crown1", nullptr},
	{"charset", nullptr, nullptr, "crown2", nullptr},
	{"charset", nullptr, nullptr, "crown3", nullptr},
	{"charset", nullptr, nullptr, "crown4", nullptr},
	{"charset", nullptr, nullptr, "crown5", nullptr},
	{"charset", nullptr, nullptr, "crown6", nullptr},
	{"charset", nullptr, nullptr, "crown7", nullptr},
	{"charset", nullptr, nullptr, "future1", nullptr},
	{"charset", nullptr, nullptr, "future2", nullptr},
	{"charset", nullptr, nullptr, "future3", nullptr},
	{"charset", nullptr, nullptr, "men1", nullptr},
	{"charset", nullptr, nullptr, "women1", nullptr},
	{"charset", nullptr, nullptr, nullptr, "actraiser3.1"},
	{"charset", nullptr, nullptr, nullptr, "african"},
	{"charset", nullptr, nullptr, nullptr, "alex"},
	{"charset", nullptr, nullptr, nullptr, "alien3"},
	{"charset", nullptr, nullptr, nullptr, "alien4"},
	{"charset", nullptr, nullptr, nullptr, "angel"},
	{"charset", nullptr, nullptr, nullptr, "arquivo-x"},
	{"charset", nullptr, nullptr, nullptr, "bahamut_lagoon"},
	{"charset", nullptr, nullptr, nullptr, "bartender"},
	{"charset", nullptr, nullptr, nullptr, "bloodydoors"},
	{"charset", nullptr, nullptr, nullptr, "brats01"},
	{"charset", nullptr, nullptr, nullptr, "breathoffire4"},
	{"charset", nullptr, nullptr, nullptr, "brian"},
	{"charset", nullptr, nullptr, nullptr, "chara01"},
	{"charset", nullptr, nullptr, nullptr, "chara02"},
	{"charset", nullptr, nullptr, nullptr, "chara03"},
	{"charset", nullptr, nullptr, nullptr, "chara04"},
	{"charset", nullptr, nullptr, nullptr, "chara05"},
	{"charset", nullptr, nullptr, nullptr, "chara06"},
	{"charset", nullptr, nullptr, nullptr, "chara07"},
	{"charset", nullptr, nullptr, nullptr, "chara08"},
	{"charset", nullptr, nullptr, nullptr, "chara09"},
	{"charset", nullptr, nullptr, nullptr, "chara10"},
	{"charset", nullptr, nullptr, nullptr, "chara11"},
	{"charset", nullptr, nullptr, nullptr, "chara12"},
	{"charset", nullptr, nullptr, nullptr, "chara13"},
	{"charset", nullptr, nullptr, nullptr, "chara14"},
	{"charset", nullptr, nullptr, nullptr, "chara15"},
	{"charset", nullptr, nullptr, nullptr, "chara16"},
	{"charset", nullptr, nullptr, nullptr, "chara6gold"},
	{"charset", nullptr, nullptr, nullptr, "charaa1"},
	{"charset", nullptr, nullptr, nullptr, "charaa2"},
	{"charset", nullptr, nullptr, nullptr, "chara_c1"},
	{"charset", nullptr, nullptr, nullptr, "chara_c2"},
	{"charset", nullptr, nullptr, nullptr, "chara_h_9"},
	{"charset", nullptr, nullptr, nullptr, "chara_misc_1"},
	{"charset", nullptr, nullptr, nullptr, "chubby2b"},
	{"charset", nullptr, nullptr, nullptr, "crosshairandtargets"},
	{"charset", nullptr, nullptr, nullptr, "crystals"},
	{"charset", nullptr, nullptr, nullptr, "ctchar"},
	{"charset", nullptr, nullptr, nullptr, "ctportal"},
	{"charset", nullptr, nullptr, nullptr, "dbz_chara1"},
	{"charset", nullptr, nullptr, nullptr, "dbz_chara2"},
	{"charset", nullptr, nullptr, nullptr, "dbz_orig1"},
	{"charset", nullptr, nullptr, nullptr, "don_chara1"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_10"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_11"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_12"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_13"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_14"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_15"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_16"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_17"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_18"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_19"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_1"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_20"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_21"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_22"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_23"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_24"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_25"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_26"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_27"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_28"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_2"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_3"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_4"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_5"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_6"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_7"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_8"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_9"},
	{"charset", nullptr, nullptr, nullptr, "don_collection_mm"},
	{"charset", nullptr, nullptr, nullptr, "don_fish"},
	{"charset", nullptr, nullptr, nullptr, "don_pikachuu"},
	{"charset", nullptr, nullptr, nullptr, "don_pokeballz"},
	{"charset", nullptr, nullptr, nullptr, "don_xfiles"},
	{"charset", nullptr, nullptr, nullptr, "earthbound1"},
	{"charset", nullptr, nullptr, nullptr, "earthbound2"},
	{"charset", nullptr, nullptr, nullptr, "earthbound3"},
	{"charset", nullptr, nullptr, nullptr, "earthboundsheet"},
	{"charset", nullptr, nullptr, nullptr, "edit1"},
	{"charset", nullptr, nullptr, nullptr, "egyptian"},
	{"charset", nullptr, nullptr, nullptr, "eskimo"},
	{"charset", nullptr, nullptr, nullptr, "evil1"},
	{"charset", nullptr, nullptr, nullptr, "expression"},
	{"charset", nullptr, nullptr, nullptr, "ff3_soldiers"},
	{"charset", nullptr, nullptr, nullptr, "ff7_chara1"},
	{"charset", nullptr, nullptr, nullptr, "ff83"},
	{"charset", nullptr, nullptr, nullptr, "ff9chara"},
	{"charset", nullptr, nullptr, nullptr, "fft_archers"},
	{"charset", nullptr, nullptr, nullptr, "fft_thieves"},
	{"charset", nullptr, nullptr, nullptr, "flags_n_chests"},
	{"charset", nullptr, nullptr, nullptr, "free01"},
	{"charset", nullptr, nullptr, nullptr, "free02"},
	{"charset", nullptr, nullptr, nullptr, "free03"},
	{"charset", nullptr, nullptr, nullptr, "free04"},
	{"charset", nullptr, nullptr, nullptr, "future_soldiers1"},
	{"charset", nullptr, nullptr, nullptr, "fx_chara16"},
	{"charset", nullptr, nullptr, nullptr, "gohanssj1-2"},
	{"charset", nullptr, nullptr, nullptr, "goldendoors"},
	{"charset", nullptr, nullptr, nullptr, "greece"},
	{"charset", nullptr, nullptr, nullptr, "houshin5"},
	{"charset", nullptr, nullptr, nullptr, "illustset1"},
	{"charset", nullptr, nullptr, nullptr, "islander"},
	{"charset", nullptr, nullptr, nullptr, "items_1"},
	{"charset", nullptr, nullptr, nullptr, "items_2"},
	{"charset", nullptr, nullptr, nullptr, "items_3"},
	{"charset", nullptr, nullptr, nullptr, "link"},
	{"charset", nullptr, nullptr, nullptr, "linofull"},
	{"charset", nullptr, nullptr, nullptr, "mario"},
	{"charset", nullptr, nullptr, nullptr, "megaman1"},
	{"charset", nullptr, nullptr, nullptr, "minato_c"},
	{"charset", nullptr, nullptr, nullptr, "mk"},
	{"charset", nullptr, nullptr, nullptr, "mohawk"},
	{"charset", nullptr, nullptr, nullptr, "newaya"},
	{"charset", nullptr, nullptr, nullptr, "object3"},
	{"charset", nullptr, nullptr, nullptr, "object6"},
	{"charset", nullptr, nullptr, nullptr, "object9"},
	{"charset", nullptr, nullptr, nullptr, "objecta"},
	{"charset", nullptr, nullptr, nullptr, "objectb"},
	{"charset", nullptr, nullptr, nullptr, "objectc"},
	{"charset", nullptr, nullptr, nullptr, "objectd"},
	{"charset", nullptr, nullptr, nullptr, "objecte"},
	{"charset", nullptr, nullptr, nullptr, "objectf"},
	{"charset", nullptr, nullptr, nullptr, "objectg"},
	{"charset", nullptr, nullptr, nullptr, "objecth"},
	{"charset", nullptr, nullptr, nullptr, "objecti"},
	{"charset", nullptr, nullptr, nullptr, "objectj"},
	{"charset", nullptr, nullptr, nullptr, "objectk"},
	{"charset", nullptr, nullptr, nullptr, "objectl"},
	{"charset", nullptr, nullptr, nullptr, "objects3"},
	{"charset", nullptr, nullptr, nullptr, "omek"},
	{"charset", nullptr, nullptr, nullptr, "patrick"},
	{"charset", nullptr, nullptr, nullptr, "pirate"},
	{"charset", nullptr, nullptr, nullptr, "pose19"},
	{"charset", nullptr, nullptr, nullptr, "pose2"},
	{"charset", nullptr, nullptr, nullptr, "pose3"},
	{"charset", nullptr, nullptr, nullptr, "pose"},
	{"charset", nullptr, nullptr, nullptr, "poses_kirby_dolphin"},
	{"charset", nullptr, nullptr, nullptr, "pw_chara"},
	{"charset", nullptr, nullptr, nullptr, "robot"},
	{"charset", nullptr, nullptr, nullptr, "robots1"},
	{"charset", nullptr, nullptr, nullptr, "rolf'sarmy1"},
	{"charset", nullptr, nullptr, nullptr, "rolf'sarmy2"},
	{"charset", nullptr, nullptr, nullptr, "rs3_1"},
	{"charset", nullptr, nullptr, nullptr, "sailormoon1"},
	{"charset", nullptr, nullptr, nullptr, "savepoint"},
	{"charset", nullptr, nullptr, nullptr, "set_ggi1"},
	{"charset", nullptr, nullptr, nullptr, "set_hei1"},
	{"charset", nullptr, nullptr, nullptr, "set_ipa1"},
	{"charset", nullptr, nullptr, nullptr, "set_ipa2"},
	{"charset", nullptr, nullptr, nullptr, "set_ken1"},
	{"charset", nullptr, nullptr, nullptr, "set_mon1"},
	{"charset", nullptr, nullptr, nullptr, "simchara"},
	{"charset", nullptr, nullptr, nullptr, "simpsons"},
	{"charset", nullptr, nullptr, nullptr, "slime1"},
	{"charset", nullptr, nullptr, nullptr, "slime2"},
	{"charset", nullptr, nullptr, nullptr, "soldiers_brats"},
	{"charset", nullptr, nullptr, nullptr, "soldiers"},
	{"charset", nullptr, nullptr, nullptr, "sparkleitems_1"},
	{"charset", nullptr, nullptr, nullptr, "sparkleitems_2"},
	{"charset", nullptr, nullptr, nullptr, "sparkleitems_3"},
	{"charset", nullptr, nullptr, nullptr, "sparkleitems_4"},
	{"charset", nullptr, nullptr, nullptr, "ss4gku_futrbulma"},
	{"charset", nullptr, nullptr, nullptr, "staroc1"},
	{"charset", nullptr, nullptr, nullptr, "starwar1"},
	{"charset", nullptr, nullptr, nullptr, "starwar2"},
	{"charset", nullptr, nullptr, nullptr, "sv"},
	{"charset", nullptr, nullptr, nullptr, "tenchi"},
	{"charset", nullptr, nullptr, nullptr, "torch_1"},
	{"charset", nullptr, nullptr, nullptr, "torch"},
	{"charset", nullptr, nullptr, nullptr, "treasure"},
	{"charset", nullptr, nullptr, nullptr, "vegetable"},
	{"charset", nullptr, nullptr, nullptr, "vehicle3"},
	{"charset", nullptr, nullptr, nullptr, "window"},
	{"charset", nullptr, nullptr, nullptr, "wizard"},
	{"charset", nullptr, nullptr, nullptr, "x-files_lh"},
	{"charset", nullptr, nullptr, nullptr, "xfmainchars2"},
	{"charset", nullptr, nullptr, nullptr, "xfmainchars"},
	{"charset", nullptr, nullptr, nullptr, "xmas_chara1"},
	{"charset", nullptr, nullptr, nullptr, "x-men-movie"},
	{"charset", nullptr, nullptr, nullptr, "zlightup"},
	{"chipset", "ダンジョン", "dungeon", "dungeon", nullptr},
	{"chipset", "内装", "interior", "inner", nullptr},
	{"chipset", "基本", "world", "basis", nullptr},
	{"chipset", "外観", "exterior", "outline", nullptr},
	{"chipset", "船", "ship", "ship", nullptr},
	{"chipset", nullptr, nullptr, "chipset1", nullptr},
	{"chipset", nullptr, nullptr, "chipset2", nullptr},
	{"chipset", nullptr, nullptr, "chipset3", nullptr},
	{"chipset", nullptr, nullptr, nullptr, "2ktownset"},
	{"chipset", nullptr, nullptr, nullptr, "3d_castl"},
	{"chipset", nullptr, nullptr, nullptr, "3d_inner"},
	{"chipset", nullptr, nullptr, nullptr, "3d_town"},
	{"chipset", nullptr, nullptr, nullptr, "3d_town_"},
	{"chipset", nullptr, nullptr, nullptr, "airship1"},
	{"chipset", nullptr, nullptr, nullptr, "airship2"},
	{"chipset", nullptr, nullptr, nullptr, "airship4"},
	{"chipset", nullptr, nullptr, nullptr, "air_ship"},
	{"chipset", nullptr, nullptr, nullptr, "army"},
	{"chipset", nullptr, nullptr, nullptr, "bof22_b"},
	{"chipset", nullptr, nullptr, nullptr, "bof22"},
	{"chipset", nullptr, nullptr, nullptr, "bof2"},
	{"chipset", nullptr, nullptr, nullptr, "bof"},
	{"chipset", nullptr, nullptr, nullptr, "boxing_r"},
	{"chipset", nullptr, nullptr, nullptr, "casino"},
	{"chipset", nullptr, nullptr, nullptr, "castle_2_"},
	{"chipset", nullptr, nullptr, nullptr, "castle"},
	{"chipset", nullptr, nullptr, nullptr, "chipset10"},
	{"chipset", nullptr, nullptr, nullptr, "chipset11b"},
	{"chipset", nullptr, nullptr, nullptr, "chipset11"},
	{"chipset", nullptr, nullptr, nullptr, "chipset12"},
	{"chipset", nullptr, nullptr, nullptr, "chipset13b"},
	{"chipset", nullptr, nullptr, nullptr, "chipset13"},
	{"chipset", nullptr, nullptr, nullptr, "chipset14"},
	{"chipset", nullptr, nullptr, nullptr, "chipset15"},
	{"chipset", nullptr, nullptr, nullptr, "chipset17"},
	{"chipset", nullptr, nullptr, nullptr, "chipset18"},
	{"chipset", nullptr, nullptr, nullptr, "chipset19"},
	{"chipset", nullptr, nullptr, nullptr, "chipset1old"},
	{"chipset", nullptr, nullptr, nullptr, "chipset_1"},
	{"chipset", nullptr, nullptr, nullptr, "chipset20"},
	{"chipset", nullptr, nullptr, nullptr, "chipset2old"},
	{"chipset", nullptr, nullptr, nullptr, "chipset_2"},
	{"chipset", nullptr, nullptr, nullptr, "chipset_3"},
	{"chipset", nullptr, nullptr, nullptr, "chipset4"},
	{"chipset", nullptr, nullptr, nullptr, "chipset5b"},
	{"chipset", nullptr, nullptr, nullptr, "chipset5c"},
	{"chipset", nullptr, nullptr, nullptr, "chipset5"},
	{"chipset", nullptr, nullptr, nullptr, "chipset6b"},
	{"chipset", nullptr, nullptr, nullptr, "chipset6c"},
	{"chipset", nullptr, nullptr, nullptr, "chipset6"},
	{"chipset", nullptr, nullptr, nullptr, "chipset7"},
	{"chipset", nullptr, nullptr, nullptr, "chipset8"},
	{"chipset", nullptr, nullptr, nullptr, "chipset9"},
	{"chipset", nullptr, nullptr, nullptr, "chronohouses"},
	{"chipset", nullptr, nullptr, nullptr, "darktown"},
	{"chipset", nullptr, nullptr, nullptr, "darkworld"},
	{"chipset", nullptr, nullptr, nullptr, "dumalchipset01"},
	{"chipset", nullptr, nullptr, nullptr, "dungeon2"},
	{"chipset", nullptr, nullptr, nullptr, "dw3"},
	{"chipset", nullptr, nullptr, nullptr, "earthboundchips_2"},
	{"chipset", nullptr, nullptr, nullptr, "earthboundchips"},
	{"chipset", nullptr, nullptr, nullptr, "ebchip_00"},
	{"chipset", nullptr, nullptr, nullptr, "ebinnerchips"},
	{"chipset", nullptr, nullptr, nullptr, "ff62"},
	{"chipset", nullptr, nullptr, nullptr, "ff6_airship"},
	{"chipset", nullptr, nullptr, nullptr, "ff6_inner"},
	{"chipset", nullptr, nullptr, nullptr, "ff6"},
	{"chipset", nullptr, nullptr, nullptr, "ff6_town"},
	{"chipset", nullptr, nullptr, nullptr, "forest"},
	{"chipset", nullptr, nullptr, nullptr, "forest_t"},
	{"chipset", nullptr, nullptr, nullptr, "future_i"},
	{"chipset", nullptr, nullptr, nullptr, "future_w"},
	{"chipset", nullptr, nullptr, nullptr, "golden1"},
	{"chipset", nullptr, nullptr, nullptr, "grey_cas"},
	{"chipset", nullptr, nullptr, nullptr, "hell"},
	{"chipset", nullptr, nullptr, nullptr, "house2"},
	{"chipset", nullptr, nullptr, nullptr, "house3"},
	{"chipset", nullptr, nullptr, nullptr, "house4"},
	{"chipset", nullptr, nullptr, nullptr, "house5"},
	{"chipset", nullptr, nullptr, nullptr, "house"},
	{"chipset", nullptr, nullptr, nullptr, "japanese_town"},
	{"chipset", nullptr, nullptr, nullptr, "lufia2_b"},
	{"chipset", nullptr, nullptr, nullptr, "lufia2_d"},
	{"chipset", nullptr, nullptr, nullptr, "lufia2_house"},
	{"chipset", nullptr, nullptr, nullptr, "lufia2"},
	{"chipset", nullptr, nullptr, nullptr, "lufia2_t"},
	{"chipset", nullptr, nullptr, nullptr, "map_town01"},
	{"chipset", nullptr, nullptr, nullptr, "minato1"},
	{"chipset", nullptr, nullptr, nullptr, "modern2"},
	{"chipset", nullptr, nullptr, nullptr, "modern3"},
	{"chipset", nullptr, nullptr, nullptr, "modern_b"},
	{"chipset", nullptr, nullptr, nullptr, "modern_c"},
	{"chipset", nullptr, nullptr, nullptr, "modern"},
	{"chipset", nullptr, nullptr, nullptr, "modern_world"},
	{"chipset", nullptr, nullptr, nullptr, "modified"},
	{"chipset", nullptr, nullptr, nullptr, "outcastle"},
	{"chipset", nullptr, nullptr, nullptr, "phantasystar"},
	{"chipset", nullptr, nullptr, nullptr, "pocket_m"},
	{"chipset", nullptr, nullptr, nullptr, "pokemontiles"},
	{"chipset", nullptr, nullptr, nullptr, "ps4"},
	{"chipset", nullptr, nullptr, nullptr, "robotrektown"},
	{"chipset", nullptr, nullptr, nullptr, "rs3"},
	{"chipset", nullptr, nullptr, nullptr, "school_chipset"},
	{"chipset", nullptr, nullptr, nullptr, "sd3_b"},
	{"chipset", nullptr, nullptr, nullptr, "sd3_c"},
	{"chipset", nullptr, nullptr, nullptr, "sd3_d"},
	{"chipset", nullptr, nullptr, nullptr, "sd3"},
	{"chipset", nullptr, nullptr, nullptr, "sompalace2"},
	{"chipset", nullptr, nullptr, nullptr, "sompalace"},
	{"chipset", nullptr, nullptr, nullptr, "som"},
	{"chipset", nullptr, nullptr, nullptr, "space"},
	{"chipset", nullptr, nullptr, nullptr, "suik2heroshouse"},
	{"chipset", nullptr, nullptr, nullptr, "suik2house"},
	{"chipset", nullptr, nullptr, nullptr, "suik2inside"},
	{"chipset", nullptr, nullptr, nullptr, "suik2kyaroinside"},
	{"chipset", nullptr, nullptr, nullptr, "suik2kyaro"},
	{"chipset", nullptr, nullptr, nullptr, "terranig"},
	{"chipset", nullptr, nullptr, nullptr, "topcity"},
	{"chipset", nullptr, nullptr, nullptr, "top-totus"},
	{"chipset", nullptr, nullptr, nullptr, "town_21"},
	{"chipset", nullptr, nullptr, nullptr, "town2"},
	{"chipset", nullptr, nullptr, nullptr, "town3"},
	{"chipset", nullptr, nullptr, nullptr, "town4"},
	{"chipset", nullptr, nullptr, nullptr, "townset_greg"},
	{"chipset", nullptr, nullptr, nullptr, "underground"},
	{"chipset", nullptr, nullptr, nullptr, "village3"},
	{"chipset", nullptr, nullptr, nullptr, "village"},
	{"chipset", nullptr, nullptr, nullptr, "white"},
	{"chipset", nullptr, nullptr, nullptr, "woods"},
	{"chipset", nullptr, nullptr, nullptr, "world2"},
	{"chipset", nullptr, nullptr, nullptr, "world"},
	{"chipset", nullptr, nullptr, nullptr, "xfileschipset1"},
	{"chipset", nullptr, nullptr, nullptr, "zelda3_b"},
	{"chipset", nullptr, nullptr, nullptr, "zelda3_d"},
	{"chipset", nullptr, nullptr, nullptr, "zelda3"},
	{"chipset", nullptr, nullptr, nullptr, "zeldadw"},
	{"faceset", "モンスター", "monster", "monsters", nullptr},
	{"faceset", "一般1", "people1", "people1", nullptr},
	{"faceset", "一般2", "people2", "people2", nullptr},
	{"faceset", "主人公1", "actor1", "chara1", nullptr},
	{"faceset", "主人公2", "actor2", "chara2", nullptr},
	{"faceset", nullptr, nullptr, "face1", nullptr},
	{"faceset", nullptr, nullptr, "face2", nullptr},
	{"faceset", nullptr, nullptr, "face3", nullptr},
	{"faceset", nullptr, nullptr, "face4", nullptr},
	{"faceset", nullptr, nullptr, nullptr, "anime3"},
	{"faceset", nullptr, nullptr, nullptr, "atelier_b"},
	{"faceset", nullptr, nullptr, nullptr, "atelier"},
	{"faceset", nullptr, nullptr, nullptr, "bof2"},
	{"faceset", nullptr, nullptr, nullptr, "bulma"},
	{"faceset", nullptr, nullptr, nullptr, "ccfaces1"},
	{"faceset", nullptr, nullptr, nullptr, "ccfaces2"},
	{"faceset", nullptr, nullptr, nullptr, "ccfaces3"},
	{"faceset", nullptr, nullptr, nullptr, "cc"},
	{"faceset", nullptr, nullptr, nullptr, "ch01_all"},
	{"faceset", nullptr, nullptr, nullptr, "chrono_face"},
	{"faceset", nullptr, nullptr, nullptr, "cool"},
	{"faceset", nullptr, nullptr, nullptr, "ct2"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_b"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_c"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_face_1"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_face1"},
	{"faceset", nullptr, nullptr, nullptr, "dbzface1"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_face_2"},
	{"faceset", nullptr, nullptr, nullptr, "dbz_face_3"},
	{"faceset", nullptr, nullptr, nullptr, "dbz"},
	{"faceset", nullptr, nullptr, nullptr, "don_faces1"},
	{"faceset", nullptr, nullptr, nullptr, "don_faces2"},
	{"faceset", nullptr, nullptr, nullptr, "ebfacesx1"},
	{"faceset", nullptr, nullptr, nullptr, "expresion"},
	{"faceset", nullptr, nullptr, nullptr, "expression4"},
	{"faceset", nullptr, nullptr, nullptr, "expression5"},
	{"faceset", nullptr, nullptr, nullptr, "expression6"},
	{"faceset", nullptr, nullptr, nullptr, "expression7_b"},
	{"faceset", nullptr, nullptr, nullptr, "expression7"},
	{"faceset", nullptr, nullptr, nullptr, "expression"},
	{"faceset", nullptr, nullptr, nullptr, "face002"},
	{"faceset", nullptr, nullptr, nullptr, "face01"},
	{"faceset", nullptr, nullptr, nullptr, "face03"},
	{"faceset", nullptr, nullptr, nullptr, "ff4"},
	{"faceset", nullptr, nullptr, nullptr, "ff6_b"},
	{"faceset", nullptr, nullptr, nullptr, "ff7face"},
	{"faceset", nullptr, nullptr, nullptr, "ff7"},
	{"faceset", nullptr, nullptr, nullptr, "ff8_b"},
	{"faceset", nullptr, nullptr, nullptr, "ff8"},
	{"faceset", nullptr, nullptr, nullptr, "ff92"},
	{"faceset", nullptr, nullptr, nullptr, "ff9faceset"},
	{"faceset", nullptr, nullptr, nullptr, "ff9"},
	{"faceset", nullptr, nullptr, nullptr, "fire_emblem_b"},
	{"faceset", nullptr, nullptr, nullptr, "fire_emblem_c"},
	{"faceset", nullptr, nullptr, nullptr, "fire_emblem"},
	{"faceset", nullptr, nullptr, nullptr, "hourai"},
	{"faceset", nullptr, nullptr, nullptr, "image1"},
	{"faceset", nullptr, nullptr, nullptr, "item_b"},
	{"faceset", nullptr, nullptr, nullptr, "item_c"},
	{"faceset", nullptr, nullptr, nullptr, "item"},
	{"faceset", nullptr, nullptr, nullptr, "kof"},
	{"faceset", nullptr, nullptr, nullptr, "langrissa_b"},
	{"faceset", nullptr, nullptr, nullptr, "langrissa"},
	{"faceset", nullptr, nullptr, nullptr, "lodfaces"},
	{"faceset", nullptr, nullptr, nullptr, "lom_b"},
	{"faceset", nullptr, nullptr, nullptr, "lom_c"},
	{"faceset", nullptr, nullptr, nullptr, "lom"},
	{"faceset", nullptr, nullptr, nullptr, "marvel"},
	{"faceset", nullptr, nullptr, nullptr, "medieval2"},
	{"faceset", nullptr, nullptr, nullptr, "medieval"},
	{"faceset", nullptr, nullptr, nullptr, "megaman(face)"},
	{"faceset", nullptr, nullptr, nullptr, "mm2"},
	{"faceset", nullptr, nullptr, nullptr, "monster2"},
	{"faceset", nullptr, nullptr, nullptr, "piccoloface"},
	{"faceset", nullptr, nullptr, nullptr, "pokeface"},
	{"faceset", nullptr, nullptr, nullptr, "pokemon_2"},
	{"faceset", nullptr, nullptr, nullptr, "pokemon2"},
	{"faceset", nullptr, nullptr, nullptr, "ranmaface"},
	{"faceset", nullptr, nullptr, nullptr, "sailorfaces1"},
	{"faceset", nullptr, nullptr, nullptr, "sailor"},
	{"faceset", nullptr, nullptr, nullptr, "samurai_spirit4_b"},
	{"faceset", nullptr, nullptr, nullptr, "samurai_spirit4"},
	{"faceset", nullptr, nullptr, nullptr, "slayers_face_0"},
	{"faceset", nullptr, nullptr, nullptr, "slayers_face_1"},
	{"faceset", nullptr, nullptr, nullptr, "sonicface1"},
	{"faceset", nullptr, nullptr, nullptr, "sonicface2"},
	{"faceset", nullptr, nullptr, nullptr, "sonicface3"},
	{"faceset", nullptr, nullptr, nullptr, "srm95"},
	{"faceset", nullptr, nullptr, nullptr, "staroceanface"},
	{"faceset", nullptr, nullptr, nullptr, "star_wars_b"},
	{"faceset", nullptr, nullptr, nullptr, "star_wars"},
	{"faceset", nullptr, nullptr, nullptr, "suikoden_b"},
	{"faceset", nullptr, nullptr, nullptr, "suikoden_c"},
	{"faceset", nullptr, nullptr, nullptr, "suikoden"},
	{"faceset", nullptr, nullptr, nullptr, "teikyou_b"},
	{"faceset", nullptr, nullptr, nullptr, "teikyou"},
	{"faceset", nullptr, nullptr, nullptr, "top"},
	{"faceset", nullptr, nullptr, nullptr, "xenogears_b"},
	{"faceset", nullptr, nullptr, nullptr, "xenogears_c"},
	{"faceset", nullptr, nullptr, nullptr, "xenogears_d"},
	{"faceset", nullptr, nullptr, nullptr, "xenogears"},
	{"faceset", nullptr, nullptr, nullptr, "xeno"},
	{"faceset", nullptr, nullptr, nullptr, "zelda64"},
	{"gameover", "ゲームオーバー", "game over", "gameover", nullptr},
	{"monster", "ヴァンパイア", "vampire", "vampire", nullptr},
	{"monster", "オーク", "orc", "hog", nullptr},
	{"monster", "ガーゴイル", "gargoyle", "gargoyle", nullptr},
	{"monster", "キマイラ", "chimera", "chimera", nullptr},
	{"monster", "クラーケン", "kraken", "octopus", nullptr},
	{"monster", "グリフォン", "griffon", "griphon", nullptr},
	{"monster", "ケルベロス", "cerberus", "hellhound", nullptr},
	{"monster", "こうもり", "bat", "bat", nullptr},
	{"monster", "ゴースト", "ghost", "ghost", nullptr},
	{"monster", "ゴーレム", "golem", "golem", nullptr},
	{"monster", "コカトリス", "cockatorice", "rooster", nullptr},
	{"monster", "ゴブリン", "goblin", "troll", nullptr},
	{"monster", "コボルト", "kobold", "wolfman", nullptr},
	{"monster", "スケルトン", "skeleton", "skeleton", nullptr},
	{"monster", "スライム", "slime", "slime", nullptr},
	{"monster", "ゾンビ", "zombie", "zombie", nullptr},
	{"monster", "ダークエルフ", "dark elf", "darkelf", nullptr},
	{"monster", "デーモン", "demon", "flyingdemon", nullptr},
	{"monster", "ドラゴン", "dragona", "greendragon1", nullptr},
	{"monster", "ドラゴンナイト", "dragon knight", "dragonknight", nullptr},
	{"monster", "トルーパー", "knight", "darkrider", nullptr},
	{"monster", "トレント", "treant", "oak", nullptr},
	{"monster", "ハーピー", "harpy", "harpy", nullptr},
	{"monster", "ヒュドラ", "hydra", "hydra", nullptr},
	{"monster", "ブラックナイト", "black knight", "darkknight", nullptr},
	{"monster", "ホーネット", "hornet", "bee", nullptr},
	{"monster", "マーマン", "merman", "aquamen", nullptr},
	{"monster", "マミー", "mummy", "mummy", nullptr},
	{"monster", "ミノタウロス", "minotaur", "minotaur", nullptr},
	{"monster", "ミミック", "mimic", "ogrechest", nullptr},
	{"monster", "メデューサ", "medusa", "medusa", nullptr},
	{"monster", "リザードマン", "lizardman", "lizardmen", nullptr},
	{"monster", "リッチ", "lich", "darkspirit", nullptr},
	{"monster", "ワーウルフ", "werewolf", "wolf", nullptr},
	{"monster", "ワイバーン", "wyvern", "bluedragon", nullptr},
	{"monster", "一般人1", "people1", "boy1", nullptr},
	{"monster", "一般人2", "people2", "girl2", nullptr},
	{"monster", "一般人3", "people3", "boy3", nullptr},
	{"monster", "一般人4", "people4", "girl4", nullptr},
	{"monster", "一般人5", "people5", "man5", nullptr},
	{"monster", "一般人6", "people6", "girl6", nullptr},
	{"monster", "一般人7", "people7", "oldman7", nullptr},
	{"monster", "一般人8", "people8", "granny", nullptr},
	{"monster", "使い魔", "familiar", "imp", nullptr},
	{"monster", "兵士", "soldier", "warrior", nullptr},
	{"monster", "大グモ", "giant spider", "spider", nullptr},
	{"monster", "大サソリ", "giant scorpion", "redscorpion", nullptr},
	{"monster", "大蛇", "snake", "snake", nullptr},
	{"monster", "天使", "angel", "angel", nullptr},
	{"monster", "女王", "queen", "princess", nullptr},
	{"monster", "忍者", "ninja", "ninja", nullptr},
	{"monster", "怪魚", "monster fish", "fish", nullptr},
	{"monster", "戦士1", "warrior1", "hero1", nullptr},
	{"monster", "戦士2", "warrior2", "hero2", nullptr},
	{"monster", "武者", "warrior", "samurai", nullptr},
	{"monster", "死神", "reaper", "death", nullptr},
	{"monster", "海賊", "pirate", "gnome", nullptr},
	{"monster", "王", "king", "king", nullptr},
	{"monster", "盗賊", "thief", "thief", nullptr},
	{"monster", "鬼火", "wisp", "firescull", nullptr},
	{"monster", "魔王", "demon lord", "cloakdemon", nullptr},
	{"monster", "魔神", "demon god", "satan", nullptr},
	{"monster", "魔術師1", "magician1", "witch1", nullptr},
	{"monster", "魔術師2", "magician2", "witch2", nullptr},
	{"monster", "龍", "dragonb", "greendragon2", nullptr},
	{"monster", nullptr, nullptr, nullptr, "2souls"},
	{"monster", nullptr, nullptr, nullptr, "bloody_orb"},
	{"monster", nullptr, nullptr, nullptr, "damn_monkey"},
	{"monster", nullptr, nullptr, nullptr, "demon_king2"},
	{"monster", nullptr, nullptr, nullptr, "dlicker"},
	{"monster", nullptr, nullptr, nullptr, "dortylla"},
	{"monster", nullptr, nullptr, nullptr, "dragoon1"},
	{"monster", nullptr, nullptr, nullptr, "fire_fox"},
	{"monster", nullptr, nullptr, nullptr, "flaret"},
	{"monster", nullptr, nullptr, nullptr, "gekua"},
	{"monster", nullptr, nullptr, nullptr, "golem2"},
	{"monster", nullptr, nullptr, nullptr, "gugu"},
	{"monster", nullptr, nullptr, nullptr, "igogosha"},
	{"monster", nullptr, nullptr, nullptr, "kisser"},
	{"monster", nullptr, nullptr, nullptr, "ladyblue"},
	{"monster", nullptr, nullptr, nullptr, "leshi"},
	{"monster", nullptr, nullptr, nullptr, "mad_monkey"},
	{"monster", nullptr, nullptr, nullptr, "myss"},
	{"monster", nullptr, nullptr, nullptr, "napper"},
	{"monster", nullptr, nullptr, nullptr, "old_pirat"},
	{"monster", nullptr, nullptr, nullptr, "porker"},
	{"monster", nullptr, nullptr, nullptr, "pupsy"},
	{"monster", nullptr, nullptr, nullptr, "skeleton_magi"},
	{"monster", nullptr, nullptr, nullptr, "slime_death"},
	{"monster", nullptr, nullptr, nullptr, "torturle"},
	{"monster", nullptr, nullptr, nullptr, "zombie2"},
	{"movie", nullptr, nullptr, "babbit", nullptr},
	{"music", "jアイテム", "items", "item", nullptr},
	{"music", "jギャグ1", "gag1", "gag1", nullptr},
	{"music", "jギャグ2", "gag2", "gag2", nullptr},
	{"music", "jファンファーレ1", "fanfare1", "fanfare1", nullptr},
	{"music", "jファンファーレ2", "fanfare2", "fanfare2", nullptr},
	{"music", "jファンファーレ3", "fanfare3", "fanfare3", nullptr},
	{"music", "jファンファーレ4", "fanfare4", "fanfare4", nullptr},
	{"music", "jファンファーレ5", "fanfare5", "fanfare5", nullptr},
	{"music", "jファンファーレ6", "fanfare6", "fanfare6", nullptr},
	{"music", "j宿1", "inn1", "inn1", nullptr},
	{"music", "j宿2", "inn2", "inn2", nullptr},
	{"music", "j戦闘終了1", "battleend1", "battleend1", nullptr},
	{"music", "j戦闘終了2", "battleend2", "battleend2", nullptr},
	{"music", "j戦闘終了3", "battleend3", "battleend3", nullptr},
	{"music", "j戦闘終了4", "battleend4", "battleend4", nullptr},
	{"music", "j疑惑", "suspicion", "doubt", nullptr},
	{"music", "j謎", "mystery", "riddle", nullptr},
	{"music", "se地震", "earthquake", "seearthquake", nullptr},
	{"music", "se大雨", "rain2", "serain2", nullptr},
	{"music", "se時計", "clock", "seclock", nullptr},
	{"music", "se海", "sea", "sesea", nullptr},
	{"music", "se雨", "rain1", "serain", nullptr},
	{"music", "エンディング1", "ending1", "ending1", nullptr},
	{"music", "エンディング2", "ending2", "ending2", nullptr},
	{"music", "エンディング3", "ending3", "ending3", nullptr},
	{"music", "オープニング1", "opening1", "opening1", nullptr},
	{"music", "オープニング2", "opening2", "opening2", nullptr},
	{"music", "オープニング3", "opening3", "opening3", nullptr},
	{"music", "ゲームオーバー1", "gameover1", "gameover1", nullptr},
	{"music", "ゲームオーバー2", "gameover2", "gameover2", nullptr},
	{"music", "ゲームオーバー3", "gameover3", "gameover3", nullptr},
	{"music", "ゴーストタウン1", "ghosttown1", "gosttown1", nullptr},
	{"music", "ゴーストタウン2", "ghosttown2", "gosttown2", nullptr},
	{"music", "ダンジョン1", "dungeon1", "dungeon1", nullptr},
	{"music", "ダンジョン2", "dungeon2", "dungeon2", nullptr},
	{"music", "ダンジョン3", "dungeon3", "dungeon3", nullptr},
	{"music", "ダンジョン4", "dungeon4", "dungeon4", nullptr},
	{"music", "ダンジョン5", "dungeon5", "dungeon5", nullptr},
	{"music", "ピンチ", "crisis", "crisis", nullptr},
	{"music", "フィールド1", "field1", "field1", nullptr},
	{"music", "フィールド2", "field2", "field2", nullptr},
	{"music", "フィールド3", "field3", "field3", nullptr},
	{"music", "フィールド4", "field4", "field4", nullptr},
	{"music", "ボス1", "boss1", "boss1", nullptr},
	{"music", "ボス2", "boss2", "boss2", nullptr},
	{"music", "ボス3", "boss3", "boss3", nullptr},
	{"music", "ボス4", "boss4", "boss4", nullptr},
	{"music", "乗り物1", "vehicle1", "ride1", nullptr},
	{"music", "乗り物2", "vehicle2", "ride2", nullptr},
	{"music", "乗り物3", "vehicle3", "ride3", nullptr},
	{"music", "別れ1", "farewell1", "farewell1", nullptr},
	{"music", "別れ2", "farewell2", "farewell2", nullptr},
	{"music", "勇者1", "hero1", "hero1", nullptr},
	{"music", "勇者2", "hero2", "hero2", nullptr},
	{"music", "動物", "animal", "animal", nullptr},
	{"music", "勝利", "victory", "get", nullptr},
	{"music", "城1", "castle1", "castle1", nullptr},
	{"music", "城2", "castle2", "castle2", nullptr},
	{"music", "城3", "castle3", "castle3", nullptr},
	{"music", "塔1", "tower1", "tower1", nullptr},
	{"music", "塔2", "tower2", "tower2", nullptr},
	{"music", "塔3", "tower3", "tower3", nullptr},
	{"music", "妖精1", "fairy1", "fairy1", nullptr},
	{"music", "妖精2", "fairy2", "fairy2", nullptr},
	{"music", "安らぎ1", "peace1", "peace1", nullptr},
	{"music", "安らぎ2", "peace2", "peace2", nullptr},
	{"music", "安らぎ3", "peace3", "peace3", nullptr},
	{"music", "店1", "store1", "shop1", nullptr},
	{"music", "店2", "store2", "shop2", nullptr},
	{"music", "店3", "store3", "shop3", nullptr},
	{"music", "怒り", "anger", "anger", nullptr},
	{"music", "悲しみ", "sorrow", "sad", nullptr},
	{"music", "戦闘1", "battle1", "battle1", nullptr},
	{"music", "戦闘2", "battle2", "battle2", nullptr},
	{"music", "戦闘3", "battle3", "battle3", nullptr},
	{"music", "探索", "search", "search", nullptr},
	{"music", "敗北", "defeat", "lose", nullptr},
	{"music", "教会", "church", "church", nullptr},
	{"music", "明るい市場", "marketplace", "fiesta", nullptr},
	{"music", "村1", "village1", "village1", nullptr},
	{"music", "村2", "village2", "village2", nullptr},
	{"music", "村3", "village3", "village3", nullptr},
	{"music", "泥棒", "thief", "thief", nullptr},
	{"music", "活気", "energy", "energy", nullptr},
	{"music", "町1", "town1", "town1", nullptr},
	{"music", "町2", "town2", "town2", nullptr},
	{"music", "町3", "town3", "town3", nullptr},
	{"music", "神秘1", "mystery1", "mystery1", nullptr},
	{"music", "神秘2", "mystery2", "mystery2", nullptr},
	{"music", "神秘3", "mystery3", "mystery3", nullptr},
	{"music", "秘宝", "treasure", "treasure", nullptr},
	{"music", "船1", "ship1", "ship1", nullptr},
	{"music", "船2", "ship2", "ship2", nullptr},
	{"music", "船3", "ship3", "ship3", nullptr},
	{"music", "試練", "trial", "trial", nullptr},
	{"music", "闇市", "blackmarket", "dark", nullptr},
	{"music", "魔王", "devil", "devil", nullptr},
	{"music", nullptr, nullptr, "dungeon6", nullptr},
	{"music", nullptr, nullptr, "dungeon7", nullptr},
	{"music", nullptr, nullptr, "farewell3", nullptr},
	{"music", nullptr, nullptr, "farewell4", nullptr},
	{"music", nullptr, nullptr, "inn3", nullptr},
	{"music", nullptr, nullptr, "mystery4", nullptr},
	{"music", nullptr, nullptr, "night", nullptr},
	{"music", nullptr, nullptr, "pirate1", nullptr},
	{"music", nullptr, nullptr, "pirate2", nullptr},
	{"music", nullptr, nullptr, "pirate3", nullptr},
	{"music", nullptr, nullptr, "pirate4", nullptr},
	{"music", nullptr, nullptr, "ride4", nullptr},
	{"music", nullptr, nullptr, "shop4", nullptr},
	{"music", nullptr, nullptr, "snow", nullptr},
	{"music", nullptr, nullptr, nullptr, "casino"},
	{"music", nullptr, nullptr, nullptr, "castle4"},
	{"music", nullptr, nullptr, nullptr, "castle5"},
	{"music", nullptr, nullptr, nullptr, "done"},
	{"music", nullptr, nullptr, nullptr, "fairy3"},
	{"music", nullptr, nullptr, nullptr, "friends1"},
	{"music", nullptr, nullptr, nullptr, "meanwhile1"},
	{"music", nullptr, nullptr, nullptr, "meanwhile2"},
	{"music", nullptr, nullptr, nullptr, "morning1"},
	{"music", nullptr, nullptr, nullptr, "shop5"},
	{"music", nullptr, nullptr, nullptr, "sorrow"},
	{"music", nullptr, nullptr, nullptr, "spirit"},
	{"music", nullptr, nullptr, nullptr, "town4"},
	{"music", nullptr, nullptr, nullptr, "town5"},
	{"music", nullptr, nullptr, nullptr, "village4"},
	{"music", nullptr, nullptr, nullptr, "village5"},
	{"panorama", "夕焼け1", "sunset1", "dawn1", nullptr},
	{"panorama", "夕焼け2", "sunset2", "dawn2", nullptr},
	{"panorama", "夜明け1", "dawn1", "evening1", nullptr},
	{"panorama", "夜明け2", "dawn2", "evening2", nullptr},
	{"panorama", "夜空1", "night sky1", "night1", nullptr},
	{"panorama", "夜空2", "night sky2", "night2", nullptr},
	{"panorama", "宇宙", "cosmos1", "galaxy", nullptr},
	{"panorama", "惑星1", "planet1", "planet1", nullptr},
	{"panorama", "惑星2", "planet2", "planet2", nullptr},
	{"panorama", "惑星3", "planet3", "planet3", nullptr},
	{"panorama", "異空間", "dimension rift", "weird", nullptr},
	{"panorama", "空1", "sky1", "morning1", nullptr},
	{"panorama", "空2", "sky2", "morning2", nullptr},
	{"panorama", nullptr, nullptr, nullptr, "beach1"},
	{"picture", nullptr, nullptr, "cloud", nullptr},
	{"sound", "アイテム1", "item1", "item1", nullptr},
	{"sound", "アイテム2", "item2", "item2", nullptr},
	{"sound", "あたり1", "chime1", "success1", nullptr},
	{"sound", "あたり2", "chime2", "success2", nullptr},
	{"sound", "アップ", "buff", "up", nullptr},
	{"sound", "イヌ", "dog", "dog", nullptr},
	{"sound", "ウシ", "cow", "cow", nullptr},
	{"sound", "ウマ", "horse", "horse", nullptr},
	{"sound", "おたけび", "roar", "roar", nullptr},
	{"sound", "カーソル1", "cursor1", "cursor1", nullptr},
	{"sound", "カーソル2", "cursor2", "cursor2", nullptr},
	{"sound", "ガシャン", "glassshatter", "glass", nullptr},
	{"sound", "キャンセル1", "cancel1", "cansel1", nullptr},
	{"sound", "キャンセル2", "cancel2", "cansel2", nullptr},
	{"sound", "しびれ1", "paralyze1", "numbness1", nullptr},
	{"sound", "しびれ2", "paralyze2", "numbness2", nullptr},
	{"sound", "しびれ3", "paralyze3", "numbness3", nullptr},
	{"sound", "ジャンプ1", "jump1", "jump1", nullptr},
	{"sound", "ジャンプ2", "jump2", "jump2", nullptr},
	{"sound", "ショット1", "shot1", "shot1", nullptr},
	{"sound", "ショット2", "shot2", "shot2", nullptr},
	{"sound", "ショット3", "shot3", "shot3", nullptr},
	{"sound", "スイッチ1", "switch1", "switch1", nullptr},
	{"sound", "スイッチ2", "switch2", "switch2", nullptr},
	{"sound", "ダウン", "debuff", "down", nullptr},
	{"sound", "ダメージ1", "damage1", "damage1", nullptr},
	{"sound", "ダメージ2", "damage2", "damage2", nullptr},
	{"sound", "テレポート1", "teleport1", "teleport1", nullptr},
	{"sound", "テレポート2", "teleport2", "teleport2", nullptr},
	{"sound", "トラ", "tiger", "tiger", nullptr},
	{"sound", "にらみ", "glare", "power", nullptr},
	{"sound", "にわとり", "chicken", "chicken", nullptr},
	{"sound", "ネコ", "cat", "cat", nullptr},
	{"sound", "ノック", "knock", "knock", nullptr},
	{"sound", "はずれ1", "buzzer1", "failure1", nullptr},
	{"sound", "はずれ2", "buzzer2", "failure2", nullptr},
	{"sound", "バリア", "barrier", "barrier", nullptr},
	{"sound", "ひつじ", "sheep", "sheep", nullptr},
	{"sound", "ブザー1", "buzzer3", "buzzer1", nullptr},
	{"sound", "ブザー2", "buzzer4", "buzzer2", nullptr},
	{"sound", "フラッシュ1", "flash1", "flash1", nullptr},
	{"sound", "フラッシュ2", "flash2", "flash2", nullptr},
	{"sound", "フラッシュ3", "flash3", "flash3", nullptr},
	{"sound", "ブレス", "breath", "breast", nullptr},
	{"sound", "モンスター1", "monster1", "monster1", nullptr},
	{"sound", "モンスター2", "monster2", "monster2", nullptr},
	{"sound", "ライオン", "lion", "lion", nullptr},
	{"sound", "冷気1", "ice1", "cold1", nullptr},
	{"sound", "冷気2", "ice2", "cold2", nullptr},
	{"sound", "冷気3", "ice3", "cold3", nullptr},
	{"sound", "冷気4", "ice4", "cold4", nullptr},
	{"sound", "冷気5", "ice5", "cold5", nullptr},
	{"sound", "冷気6", "ice6", "cold6", nullptr},
	{"sound", "冷気7", "ice7", "cold7", nullptr},
	{"sound", "冷気8", "ice8", "cold8", nullptr},
	{"sound", "冷気9", "ice9", "cold9", nullptr},
	{"sound", "冷気10", "ice10", "cold10", nullptr},
	{"sound", "冷気11", "ice11", "cold11", nullptr},
	{"sound", "剣1", "sword1", "sword1", nullptr},
	{"sound", "剣2", "sword2", "sword2", nullptr},
	{"sound", "剣3", "sword3", "sword3", nullptr},
	{"sound", "吸収1", "absorb1", "absorption1", nullptr},
	{"sound", "吸収2", "absorb2", "absorption2", nullptr},
	{"sound", "噛む", "bite", "bite", nullptr},
	{"sound", "回復1", "recovery1", "recovery1", nullptr},
	{"sound", "回復2", "recovery2", "recovery2", nullptr},
	{"sound", "回復3", "recovery3", "recovery3", nullptr},
	{"sound", "回復4", "recovery4", "recovery4", nullptr},
	{"sound", "回復5", "recovery5", "recovery5", nullptr},
	{"sound", "回復6", "recovery6", "recovery6", nullptr},
	{"sound", "回復7", "recovery7", "recovery7", nullptr},
	{"sound", "回復8", "recovery8", "recovery8", nullptr},
	{"sound", "回避1", "evade1", "evasion1", nullptr},
	{"sound", "回避2", "evade2", "evasion2", nullptr},
	{"sound", "地震1", "earthquake1", "earthquake1", nullptr},
	{"sound", "地震2", "earthquake2", "earthquake2", nullptr},
	{"sound", "壁1", "barrier1", nullptr, nullptr},
	{"sound", "壁2", "barrier2", nullptr, nullptr},
	{"sound", "大地1", "earth1", "earth1", nullptr},
	{"sound", "大地2", "earth2", "earth2", nullptr},
	{"sound", "大地3", "earth3", "earth3", nullptr},
	{"sound", "大地4", "earth4", "earth4", nullptr},
	{"sound", "大地5", "earth5", "earth5", nullptr},
	{"sound", "大地6", "earth6", "earth6", nullptr},
	{"sound", "大地7", "earth7", "earth7", nullptr},
	{"sound", "大地8", "earth8", "earth8", nullptr},
	{"sound", "大地9", "earth9", "earth9", nullptr},
	{"sound", "大地10", "earth10", "earth10", nullptr},
	{"sound", "巻き付き", "ensnare", "refer book", nullptr},
	{"sound", "弓1", "bow1", "bow1", nullptr},
	{"sound", "弓2", "bow2", "bow2", nullptr},
	{"sound", "戦闘1", "combat1", "fight1", nullptr},
	{"sound", "戦闘2", "combat2", "fight2", nullptr},
	{"sound", "打撃1", "blow1", "blow1", nullptr},
	{"sound", "打撃2", "blow2", "blow2", nullptr},
	{"sound", "打撃3", "blow3", "blow3", nullptr},
	{"sound", "打撃4", "blow4", "blow4", nullptr},
	{"sound", "打撃5", "blow5", "blow5", nullptr},
	{"sound", "打撃6", "blow6", "blow6", nullptr},
	{"sound", "打撃7", "blow7", "blow7", nullptr},
	{"sound", "攻撃1", "attack1", "attack1", nullptr},
	{"sound", "攻撃2", "attack2", "attack2", nullptr},
	{"sound", "斬る1", "slash1", "kill1", nullptr},
	{"sound", "斬る2", "slash2", "kill2", nullptr},
	{"sound", "斬る3", "slash3", "kill3", nullptr},
	{"sound", "斬る4", "slash4", "kill4", nullptr},
	{"sound", "斬る5", "slash5", "kill5", nullptr},
	{"sound", "斬る6", "slash6", nullptr, nullptr},
	{"sound", "斬る7", "slash7", "kill7", nullptr},
	{"sound", "斬る8", "slash8", "kill8", nullptr},
	{"sound", "斬る9", "slash9", "kill9", nullptr},
	{"sound", "斬る10", "slash10", "kill10", nullptr},
	{"sound", "斬る11", "slash11", "kill11", nullptr},
	{"sound", "時計", "clock", "clock", nullptr},
	{"sound", "暗闇", "blind", "darkness", nullptr},
	{"sound", "暗黒1", "darkness1", "dark1", nullptr},
	{"sound", "暗黒2", "darkness2", "dark2", nullptr},
	{"sound", "暗黒3", "darkness3", "dark3", nullptr},
	{"sound", "暗黒4", "darkness4", "dark4", nullptr},
	{"sound", "暗黒5", "darkness5", "dark5", nullptr},
	{"sound", "暗黒6", "darkness6", "kill6", nullptr},
	{"sound", "歌", "song", "song", nullptr},
	{"sound", "毒", "poison", "poison", nullptr},
	{"sound", "水1", "water1", "water1", nullptr},
	{"sound", "水2", "water2", "water2", nullptr},
	{"sound", "水3", "water3", "water3", nullptr},
	{"sound", "水4", "water4", "water4", nullptr},
	{"sound", "水5", "water5", "water5", nullptr},
	{"sound", "水6", "water6", "water6", nullptr},
	{"sound", "決定1", "decision1", "decision1", nullptr},
	{"sound", "決定2", "decision2", "decision2", nullptr},
	{"sound", "沈黙", "silence", "silence", nullptr},
	{"sound", "海1", "sea1", "sea1", nullptr},
	{"sound", "海2", "sea2", "sea2", nullptr},
	{"sound", "消滅1", "collapse1", "annihilation1", nullptr},
	{"sound", "消滅2", "collapse2", "annihilation2", nullptr},
	{"sound", "混乱", "confusion", "chaos", nullptr},
	{"sound", "炎1", "fire1", "flame1", nullptr},
	{"sound", "炎2", "fire2", "flame2", nullptr},
	{"sound", "炎3", "fire3", "flame3", nullptr},
	{"sound", "炎4", "fire4", "flame4", nullptr},
	{"sound", "炎5", "fire5", "flame5", nullptr},
	{"sound", "炎6", "fire6", "flame6", nullptr},
	{"sound", "炎7", "fire7", "flame7", nullptr},
	{"sound", "炎8", "fire8", "flame8", nullptr},
	{"sound", "爆発1", "explosion1", "explosion1", nullptr},
	{"sound", "爆発2", "explosion2", "explosion2", nullptr},
	{"sound", "爆発3", "explosion3", "explosion3", nullptr},
	{"sound", "爆発4", "explosion4", "explosion4", nullptr},
	{"sound", "爆発5", "explosion5", "explosion5", nullptr},
	{"sound", "爆発6", "explosion6", "explosion6", nullptr},
	{"sound", "爆発7", "explosion7", "explosion7", nullptr},
	{"sound", "睡眠", "sleep", "sleep", nullptr},
	{"sound", "砂けむり", "sandstorm", "sand storm", nullptr},
	{"sound", "神聖1", "holy1", "holy1", nullptr},
	{"sound", "神聖2", "holy2", "holy2", nullptr},
	{"sound", "神聖3", "holy3", "holy3", nullptr},
	{"sound", "神聖4", "holy4", "holy4", nullptr},
	{"sound", "神聖5", "holy5", "holy5", nullptr},
	{"sound", "神聖6", "holy6", "holy6", nullptr},
	{"sound", "神聖7", "holy7", "holy7", nullptr},
	{"sound", "神聖8", "holy8", "holy8", nullptr},
	{"sound", "神聖9", "holy9", "holy9", nullptr},
	{"sound", "移動", "move", "movement", nullptr},
	{"sound", "花粉", "pollen", "pollen", nullptr},
	{"sound", "落ちる1", "fall1", "fall1", nullptr},
	{"sound", "落ちる2", "fall2", "fall2", nullptr},
	{"sound", "蘇生1", "raise1", "rebirth1", nullptr},
	{"sound", "蘇生2", "raise2", "rebirth2", nullptr},
	{"sound", "蘇生3", "raise3", "rebirth3", nullptr},
	{"sound", "逃走", "escape", "escape", nullptr},
	{"sound", "鍵", "key", "key", nullptr},
	{"sound", "鐘", "bell", "bell", nullptr},
	{"sound", "閉める1", "close1", "close1", nullptr},
	{"sound", "閉める2", "close2", "close2", nullptr},
	{"sound", "開ける1", "open1", "open1", nullptr},
	{"sound", "開ける2", "open2", "open2", nullptr},
	{"sound", "雨1", "rain1", "rain1", nullptr},
	{"sound", "雨2", "rain2", "rain2", nullptr},
	{"sound", "雷1", "thunder1", "thunder1", nullptr},
	{"sound", "雷2", "thunder2", "thunder2", nullptr},
	{"sound", "雷3", "thunder3", "thunder3", nullptr},
	{"sound", "雷4", "thunder4", "thunder4", nullptr},
	{"sound", "雷5", "thunder5", "thunder5", nullptr},
	{"sound", "雷6", "thunder6", "thunder6", nullptr},
	{"sound", "雷7", "thunder7", "thunder7", nullptr},
	{"sound", "雷8", "thunder8", "thunder8", nullptr},
	{"sound", "雷9", "thunder9", "thunder9", nullptr},
	{"sound", "雷10", "thunder10", "thunder10", nullptr},
	{"sound", "霧1", "fog1", "fog1", nullptr},
	{"sound", "霧2", "fog2", "fog2", nullptr},
	{"sound", "音波1", "wave1", "sonic1", nullptr},
	{"sound", "音波2", "wave2", "sonic2", nullptr},
	{"sound", "風1", "wind1", "wind1", nullptr},
	{"sound", "風2", "wind2", "wind2", nullptr},
	{"sound", "風3", "wind3", "wind3", nullptr},
	{"sound", "風4", "wind4", "wind4", nullptr},
	{"sound", "風5", "wind5", "wind5", nullptr},
	{"sound", "風6", "wind6", "wind6", nullptr},
	{"sound", "風7", "wind7", "wind7", nullptr},
	{"sound", "風8", "wind8", "wind8", nullptr},
	{"sound", "風9", "wind9", "wind9", nullptr},
	{"sound", "風10", "wind10", "wind10", nullptr},
	{"sound", "風11", "wind11", "wind11", nullptr},
	{"sound", "魔法1", "magic1", "wall1", nullptr},
	{"sound", "魔法2", "magic2", "wall2", nullptr},
	{"sound", nullptr, nullptr, nullptr, "anvil"},
	{"sound", nullptr, nullptr, nullptr, "camera"},
	{"sound", nullptr, nullptr, nullptr, "clap"},
	{"sound", nullptr, nullptr, nullptr, "comp"},
	{"sound", nullptr, nullptr, nullptr, "doorbell"},
	{"sound", nullptr, nullptr, nullptr, "drip"},
	{"sound", nullptr, nullptr, nullptr, "flush"},
	{"sound", nullptr, nullptr, nullptr, "glassbreak"},
	{"sound", nullptr, nullptr, nullptr, "gong"},
	{"sound", nullptr, nullptr, nullptr, "kiss"},
	{"sound", nullptr, nullptr, nullptr, "phone"},
	{"sound", nullptr, nullptr, nullptr, "pop"},
	{"sound", nullptr, nullptr, nullptr, "sneezing"},
	{"sound", nullptr, nullptr, nullptr, "snoring"},
	{"sound", nullptr, nullptr, nullptr, "ugh"},
	{"sound", nullptr, nullptr, nullptr, "whistle"},
	{"system", "システム", "system", "system", nullptr},
	{"system", nullptr, nullptr, "royal", nullptr},
	{"system", nullptr, nullptr, nullptr, "blue"},
	{"system", nullptr, nullptr, nullptr, "bof2sys"},
	{"system", nullptr, nullptr, nullptr, "bubbles"},
	{"system", nullptr, nullptr, nullptr, "don_system"},
	{"system", nullptr, nullptr, nullptr, "ff2"},
	{"system", nullptr, nullptr, nullptr, "ff3"},
	{"system", nullptr, nullptr, nullptr, "incomsys"},
	{"system", nullptr, nullptr, nullptr, "lightbluesystem"},
	{"system", nullptr, nullptr, nullptr, "lines"},
	{"system", nullptr, nullptr, nullptr, "lufia2"},
	{"system", nullptr, nullptr, nullptr, "mint"},
	{"system", nullptr, nullptr, nullptr, "ogre_battle"},
	{"system", nullptr, nullptr, nullptr, "purple"},
	{"system", nullptr, nullptr, nullptr, "red_future"},
	{"system", nullptr, nullptr, nullptr, "redmenu3"},
	{"system", nullptr, nullptr, nullptr, "sf2sys"},
	{"system", nullptr, nullptr, nullptr, "shoddy"},
	{"system", nullptr, nullptr, nullptr, "system01"},
	{"system", nullptr, nullptr, nullptr, "system02"},
	{"system", nullptr, nullptr, nullptr, "system03"},
	{"system", nullptr, nullptr, nullptr, "windows01"},
	{"system", nullptr, nullptr, nullptr, "windows02"},
	{"title", "タイトル1", "title1", "title1", nullptr},
	{"title", "タイトル2", "title2", "title2", nullptr},
	{"title", "タイトル3", "title3", "title3", nullptr},
	{"title", "タイトル4", "title4", "title4", nullptr},
	{nullptr, nullptr, nullptr, nullptr, nullptr}
};

const char* const rtp_table_2k_categories[15] = {
	"backdrop",
	"battle",
	"charset",
	"chipset",
	"faceset",
	"gameover",
	"monster",
	"movie",
	"music",
	"panorama",
	"picture",
	"sound",
	"system",
	"title",
	nullptr
};

const int rtp_table_2k_categories_idx[15] = {
	0,
	39,
	69,
	282,
	418,
	521,
	522,
	613,
	614,
	741,
	755,
	756,
	978,
	1002,
	1006
};

const char* const rtp_table_2k3[][8] = {
	{"backdrop", "お墓", "graveyard", "graveyard", "grave", "grave", "바닥", "墳場"},
	{"backdrop", "お寺", "temple1", "shrine", "temple", "temple", "절", "寺廟"},
	{"backdrop", "ダンジョン１", "dungeon1", "dungeon1", "cave", "donjohn1", "던젼１", "迷宮1"},
	{"backdrop", "ダンジョン２", "dungeon2", "dungeon2", "lavacave", "donjohnq", "던젼２", "迷宮2"},
	{"backdrop", "ダンジョン３", "dungeon3", "dungeon3", "icecave", "donjohnr", "던젼３", "迷宮3"},
	{"backdrop", "ダンジョン４", "dungeon4", "dungeon4", "stalagmites", "donjohns", "던젼４", "迷宮4"},
	{"backdrop", "ダンジョン５", "dungeon5", "dungeon5", "labyrinth", "donjohnt", "던젼５", "迷宮5"},
	{"backdrop", "ダンジョン６", "dungeon6", "dungeon6", "traininghall", "donjohnu", "던젼６", "迷宮6"},
	{"backdrop", "宇宙", "universe", "space", "space", "space", "우주", "宇宙"},
	{"backdrop", "山道", "mountain road", "mountain", "mountain", "mountainpath", "산길", "山路"},
	{"backdrop", "岩場", "rocky road", "rockbed", "rocks", "rocks", "바위", "岩壁"},
	{"backdrop", "廃墟", "ruins1", "wasteland", "ruins", "wasteland", "폐허", "廢墟"},
	{"backdrop", "旧市街", "old town", "ghost-town", "city", "oldurban", "구시가지", "老街"},
	{"backdrop", "森１", "forest1", "forest1", "forest1", "forestp", "숲１", "森林1"},
	{"backdrop", "森２", "forest2", "forest2", "forest2", "forestq", "숲２", "森林2"},
	{"backdrop", "橋", "bridge", "bridge", "bridge", "bridge", "다리", "橋"},
	{"backdrop", "毒沼", "swamp", "swamp", "swamp", "poisonswamp", "독연못", "毒沼"},
	{"backdrop", "洋館", "mansion", "building", "insidecastle", "westernstylebuilding", "양관(서양식집)", "洋館"},
	{"backdrop", "海", "sea", "ocean", "sea", "sea", "바다", "海"},
	{"backdrop", "玉座", "castle", "castle", "ballseat", "ballseat", "옥좌", "王位"},
	{"backdrop", "異空間", "space", "strange", "spacelight", "strangespacial", "이공간", "異次元空間"},
	{"backdrop", "砂浜", "beach", "beach", "beach", "sandybeach", "사구", "淺灘"},
	{"backdrop", "砂漠", "desert", "desert", "desert", "desert", "사막", "沙漠"},
	{"backdrop", "神殿", "temple2", "ruins1", "sanctuary", "sanctuary", "신전", "神殿"},
	{"backdrop", "空", "sky", "sky", "clouds", "empty", "하늘", "天空"},
	{"backdrop", "船上", "ship", "shipdeck", "ship", "onboat", "선상", "船上"},
	{"backdrop", "草原", "grassland", "plains", "grass", "grassyplain", "초원", "草原"},
	{"backdrop", "荒地", "wasteland", "barren", "roughforging", "roughforging", "황야", "荒地"},
	{"backdrop", "街中", "town", "town", "cityhouse", "city", "길가운데", "街道"},
	{"backdrop", "路上", "road", "road", "road", "road", "도로 위", "道路"},
	{"backdrop", "遺跡", "ruins2", "ruins2", "insidepyramid", "ruins", "유적", "遺跡"},
	{"backdrop", "銭湯", "bathhouse", "bath", "bathhouse", "bathhouse", "공중 목욕탕", "澡堂"},
	{"backdrop", "闘技場", "arena", "arena", "competitionplace", "competitionplace", "투기장", "競技場"},
	{"backdrop", "雪原", "snow field", "snowfield", "snow", "snowfield", "설원", "雪原"},
	{"battle", "2003その他1", "2003 other1", "misc1", "2003-other1", "2003addition1", "2003기타1", "2003其他1"},
	{"battle", "2003その他2", "2003 other2", "misc2", "2003-other2", "2003addition2", "2003기타2", "2003其他2"},
	{"battle", "2003バリア", "2003 barrier", "barrier1", "2003-barrier", "2003barrier", "2003베리어", "2003護罩"},
	{"battle", "2003ブレス", "2003 breath", "breath1", "2003-poison", "2003breath", "2003브레스", "2003氣息"},
	{"battle", "2003光柱", "2003 light pillar", "lightray", "2003-lines", "2003luminouspillar", "2003주위의 빛", "2003光柱"},
	{"battle", "2003冷気", "2003 cold", "ice1", "2003-cold", "2003coldair", "2003냉기", "2003冰"},
	{"battle", "2003剣", "2003 sword", "sword1", "2003-sword", "2003sword", "2003검", "2003劍"},
	{"battle", "2003吸収", "2003 absorb", "absorb1", "2003-absorption", "2003absorption", "2003흡수", "2003吸收"},
	{"battle", "2003回復", "2003 recovery", "healing1", "2003-sun", "2003recovery", "2003회복", "2003回復"},
	{"battle", "2003大地", "2003 earth", "earth1", "2003-earth", "2003ground", "2003대지", "2003大地"},
	{"battle", "2003弓", "2003 bow", "bow1", "2003-arrow", "2003bow", "2003화살", "2003弓"},
	{"battle", "2003打撃", "2003 blow", "strike", "2003-hit", "2003shock", "2003타격", "2003打擊"},
	{"battle", "2003斧", "2003 axe", "axe1", "2003-axe", "2003ax", "2003도끼", "2003斧"},
	{"battle", "2003暗黒", "2003 dark", "dark1", "2003-dark", "2003dark", "2003암흑", "2003暗黑"},
	{"battle", "2003槍", "2003 spear", "spear1", "2003-spear", "2003spear", "2003창", "2003槍"},
	{"battle", "2003水", "2003 water", "water1", "2003-water", "2003water", "2003물", "2003水"},
	{"battle", "2003治療", "2003 cure", "cure1", "2003-sphere", "2003remedy", "2003치료", "2003治療"},
	{"battle", "2003炎", "2003 fire", "fire1", "2003-fire", "2003flame", "2003화염", "2003炎"},
	{"battle", "2003爆発", "2003 explosion", "explode1", "2003-explosion", "2003explosive", "2003폭발", "2003爆發"},
	{"battle", "2003爪", "2003 claw", "claw1", "2003-claws", "2003nail", "2003손톱", "2003爪"},
	{"battle", "2003神聖", "2003 holy", "holy1", "2003-holy", "2003holy", "2003신성", "2003神聖"},
	{"battle", "2003蘇生", "2003 revive", "revive1", "2003-angel", "2003revival", "2003소생", "2003復活"},
	{"battle", "2003雷", "2003 thunder", "bolt1", "2003-zip", "2003thunder", "2003전격", "2003雷"},
	{"battle", "2003鞭", "2003 whip", "whip1", "2003-whip", "2003rod", "2003채찍", "2003鞭"},
	{"battle", "2003風", "2003 wind", "wind1", "2003-wind", "2003wind", "2003바람", "2003風"},
	{"battle", "2003麻痺", "2003 paralysis", "paralyze1", "2003-paralysis", "2003paralysis", "2003마비", "2003麻痺"},
	{"battle", "その他", "other", "misc3", nullptr, "addition", "기타", "其他"},
	{"battle", "バリア", "barrier", "barrier2", nullptr, "barrier", "배리어", "護罩"},
	{"battle", "ブレス", "breath", "breath2", nullptr, "breath", "호흡", "氣息"},
	{"battle", "上昇", "buff", "increase", nullptr, "rise", "상승", "上昇"},
	{"battle", "下降", "debuff", "decrease", nullptr, "drop", "하강", "下降"},
	{"battle", "冷気", "ice", "ice2", nullptr, "coldair", "냉기", "冰"},
	{"battle", "剣1", "sword1", "sword2", nullptr, "sword1", "검1", "劍1"},
	{"battle", "剣2", "sword2", "sword3", nullptr, "sword2", "검2", "劍2"},
	{"battle", "吸収", "bite", "absorb2", nullptr, "absorption", "흡수", "吸收"},
	{"battle", "回復", "recovery", "healing2", nullptr, "recovery", "회복", "回復"},
	{"battle", "大地", "earth", "earth2", nullptr, "ground", "대지", "大地"},
	{"battle", "打撃", "blow", "attack", nullptr, "shock", "타격", "打擊"},
	{"battle", "斧", "axe", "axe2", nullptr, "ax", "도끼", "斧"},
	{"battle", "暗黒", "dark", "dark2", nullptr, "dark", "암흑", "暗黑"},
	{"battle", "槍", "spear", "spear2", nullptr, "spear", "창", "槍"},
	{"battle", "水", "water", "water2", nullptr, "water", "물", "水"},
	{"battle", "治療", "treatment", "cure2", nullptr, "remedy", "치료", "治療"},
	{"battle", "炎1", "fire1", "fire2", nullptr, "flame1", "화염1", "炎1"},
	{"battle", "炎2", "fire2", "fire3", nullptr, "flame2", "화염2", "炎2"},
	{"battle", "爆発", "explosion", "explode2", nullptr, "explosive", "폭발", "爆發"},
	{"battle", "爪", "claw", "claw2", nullptr, "nail", "손톱", "爪"},
	{"battle", "矢", "arrow", "bow2", nullptr, "bow", "화살", "箭"},
	{"battle", "神聖", "holy", "holy2", nullptr, "holy", "신성", "神聖"},
	{"battle", "蘇生", "ressurection", "revive2", nullptr, "revivial", "소생", "復活"},
	{"battle", "雷", "thunder", "bolt2", nullptr, "thunder", "전격", "雷"},
	{"battle", "鞭", "whip", "whip2", nullptr, "rod", "채찍", "鞭"},
	{"battle", "風", "wind", "wind2", nullptr, "wind", "바람", "風"},
	{"battle", "麻痺", "paralysis", "paralyze2", nullptr, "paralysis", "마비", "麻痺"},
	{"battlecharset", "エルフ女a", "female elf a", "elf-f-1", "tuanaa", "elfwomana", "엘프女 a", "妖精女a"},
	{"battlecharset", "エルフ女b", "female elf b", "elf-f-2", "tuanab", "elfwomanb", "엘프女 b", "妖精女b"},
	{"battlecharset", "エルフ男a", "male elf a", "elf-m-1", "temmada", "elfmana", "엘프男 a", "妖精男a"},
	{"battlecharset", "エルフ男b", "male elf b", "elf-m-2", "temmadb", "elfmanb", "엘프男 b", "妖精男b"},
	{"battlecharset", "中華女a", "chinese woman a", "chinese-f-1", "chuzaa", "chinesewomana", "중화女a", "中華女a"},
	{"battlecharset", "中華女b", "chinese woman b", "chinese-f-2", "chuzab", "chinesewomanb", "중화女b", "中華女b"},
	{"battlecharset", "中華男a", "chinese man a", "chinese-m-1", "chinga", "chinesemana", "중화男a", "中華男a"},
	{"battlecharset", "中華男b", "chinese man b", "chinese-m-2", "chingb", "chinesemanb", "중화男b", "中華男b"},
	{"battlecharset", "侍a", "samurai a", "samurai1", "garrea", "samuraia", "사무라이a", "武士a"},
	{"battlecharset", "侍b", "samurai b", "samurai2", "garreb", "samuraib", "사무라이b", "武士b"},
	{"battlecharset", "僧侶女a", "female monk a", "priestess1", "kloria", "monkwomana", "승려女a", "僧侶女a"},
	{"battlecharset", "僧侶女b", "female monk b", "priestess2", "klorib", "monkwomanb", "승려女b", "僧侶女b"},
	{"battlecharset", "僧侶男a", "male monk a", "priest1", "siossa", "monkmana", "승려男a", "僧侶男a"},
	{"battlecharset", "僧侶男b", "male monk b", "priest2", "siossb", "monkmanb", "승려男b", "僧侶男b"},
	{"battlecharset", "勇者女a", "female hero a", "hero-f-1", "noddaa", "herowomana", "용자女a", "勇者女a"},
	{"battlecharset", "勇者女b", "female hero b", "hero-f-2", "noddab", "herowomanb", "용자女b", "勇者女b"},
	{"battlecharset", "勇者男a", "male hero a", "hero-m-1", "jemmona", "heromana", "용자男a", "勇者男a"},
	{"battlecharset", "勇者男b", "male hero b", "hero-m-2", "jemmonb", "heromanb", "용자男b", "勇者男b"},
	{"battlecharset", "女性１a", "woman1 a", "woman1-1", "cletoa", "womanépa", "여성１a", "女性1a"},
	{"battlecharset", "女性１b", "woman1 b", "woman1-2", "cletob", "womanépb", "여성１b", "女性1b"},
	{"battlecharset", "女性２a", "woman2 a", "woman2-1", "jikuaa", "womanéqa", "여성２a", "女性2a"},
	{"battlecharset", "女性２b", "woman2 b", "woman2-2", "jikuab", "womanéqb", "여성２b", "女性2b"},
	{"battlecharset", "女性３a", "woman3 a", "woman3-1", "irregiaa", "womanéra", "여성３a", "女性3a"},
	{"battlecharset", "女性３b", "woman3 b", "woman3-2", "irregiab", "womanérb", "여성３b", "女性3b"},
	{"battlecharset", "女性４a", "woman4 a", "woman4-1", "nysmaa", "womanésa", "여성４a", "女性4a"},
	{"battlecharset", "女性４b", "woman4 b", "woman4-2", "nysmab", "womanésb", "여성４b", "女性4b"},
	{"battlecharset", "女性５a", "woman5 a", "woman5-1", "beruaa", "womanéta", "여성５a", "女性5a"},
	{"battlecharset", "女性５b", "woman5 b", "woman5-2", "beruab", "womanétb", "여성５b", "女性5b"},
	{"battlecharset", "忍者女a", "female ninja a", "ninja-f-1", "ginnya", "ninjawomana", "닌자女a", "忍者女a"},
	{"battlecharset", "忍者女b", "female ninja b", "ninja-f-2", "ginnyb", "ninjawomanb", "닌자女b", "忍者女b"},
	{"battlecharset", "忍者男a", "male ninja a", "ninja-m-1", "xeoda", "ninjamana", "닌자男a", "忍者男a"},
	{"battlecharset", "忍者男b", "male ninja b", "ninja-m-2", "xeodb", "ninjamanb", "닌자男b", "忍者男b"},
	{"battlecharset", "戦士女a", "female warrior a", "soldier-f-1", "eljeaa", "soldierwomana", "전사女a", "戰士女a"},
	{"battlecharset", "戦士女b", "female warrior b", "soldier-f-2", "eljeab", "soldierwomanb", "전사女b", "戰士女b"},
	{"battlecharset", "戦士男a", "male warrior a", "soldier-m-1", "raglea", "soldiermana", "전사男a", "戰士男a"},
	{"battlecharset", "戦士男b", "male warrior b", "solider-m-2", "ragleb", "soldiermanb", "전사男b", "戰士男b"},
	{"battlecharset", "格闘家女a", "female fighter a", "monk-f-1", "phesaa", "grapplehousewomana", "격투가女a", "格鬥家女a"},
	{"battlecharset", "格闘家女b", "female fighter b", "monk-f-2", "phesab", "grapplehousewomanb", "격투가女b", "格鬥家女b"},
	{"battlecharset", "格闘家男a", "male fighter a", "monk-m-1", "rasnena", "grapplehousemana", "격투가男a", "格鬥家男a"},
	{"battlecharset", "格闘家男b", "male fighter b", "monk-m-2", "rasnenb", "grapplehousemanb", "격투가男b", "格鬥家男b"},
	{"battlecharset", "海賊女a", "female pirate a", "pirate-f-1", "rennaa", "piratewomana", "해적女a", "海賊女a"},
	{"battlecharset", "海賊女b", "female pirate b", "pirate-f-2", "rennab", "piratewomanb", "해적女b", "海賊女b"},
	{"battlecharset", "海賊男a", "male pirate a", "pirate-m-1", "goxana", "piratemana", "해적男a", "海賊男a"},
	{"battlecharset", "海賊男b", "male pirate b", "pirate-m-2", "goxanb", "pirateb", "해적男b", "海賊男b"},
	{"battlecharset", "男性１a", "man1 a", "man1-1", "jidada", "manépa", "남성１a", "男性1a"},
	{"battlecharset", "男性１b", "man1 b", "man1-2", "jidadb", "manépb", "남성１b", "男性1b"},
	{"battlecharset", "男性２a", "man2 a", "man2-1", "mjitta", "manéqa", "남성２a", "男性2a"},
	{"battlecharset", "男性２b", "man2 b", "man2-2", "mjittb", "manéqb", "남성２b", "男性2b"},
	{"battlecharset", "男性３a", "man3 a", "man3-1", "chuaza", "manéra", "남성３a", "男性3a"},
	{"battlecharset", "男性３b", "man3 b", "man3-2", "chuazb", "manérb", "남성３b", "男性3b"},
	{"battlecharset", "男性４a", "man4 a", "man4-1", "shella", "manésa", "남성４a", "男性4a"},
	{"battlecharset", "男性４b", "man4 b", "man4-2", "shellb", "manésb", "남성４b", "男性4b"},
	{"battlecharset", "男性５a", "man5 a", "man5-1", "frossa", "manéta", "남성５a", "男性5a"},
	{"battlecharset", "男性５b", "man5 b", "man5-2", "frossb", "manétb", "남성５b", "男性5b"},
	{"battlecharset", "盗賊女a", "female bandit a", "thief-f-1", "otipaa", "thiefwomana", "도적女a", "盜賊女a"},
	{"battlecharset", "盗賊女b", "female bandit b", "thief-f-2", "otipab", "thiefwomanb", "도적女b", "盜賊女b"},
	{"battlecharset", "盗賊男a", "male bandit a", "thief-m-1", "unnona", "thiefmana", "도적男a", "盜賊男a"},
	{"battlecharset", "盗賊男b", "male bandit b", "thief-m-2", "unnonb", "thiefmanb", "도적男b", "盜賊男b"},
	{"battlecharset", "鎧武者a", "armored warror a", "armor1", "joegoa", "armourwarriora", "갑옷무사a", "鎧甲武者a"},
	{"battlecharset", "鎧武者b", "armored warror b", "armor2", "joegob", "armourwarriorb", "갑옷무사b", "鎧甲武者b"},
	{"battlecharset", "魔術師女a", "female mage a", "mage-f-1", "ljitia", "magicteacherwomana", "마술사女a", "魔術師女a"},
	{"battlecharset", "魔術師女b", "female mage b", "mage-f-2", "ljitib", "magicteacherwomanb", "마술사女b", "魔術師女b"},
	{"battlecharset", "魔術師男a", "male mage a", "mage-m-1", "rivraa", "magicteachermana", "마술사男a", "魔術師男a"},
	{"battlecharset", "魔術師男b", "male mage b", "mage-m-2", "rivrab", "magicteachermanb", "마술사男b", "魔術師男b"},
	{"battleweapon", "武器", "weapon", "weapons", "standart", "weapon", "무기", "武器"},
	{"charset", "オブジェクト1", "object1", "object1", "objects1", "object1", "오브젝트1", "物件1"},
	{"charset", "オブジェクト2", "object2", "object2", "objects2", "object2", "오브젝트2", "物件2"},
	{"charset", "モンスター1", "monster1", "monster1", "monsters1", "monster1", "몬스터1", "怪物1"},
	{"charset", "モンスター2", "monster2", "monster2", "monsters2", "monster2", "몬스터2", "怪物2"},
	{"charset", "一般1", "people1", "char1", "people1", "general1", "일반1", "一般1"},
	{"charset", "一般2", "people2", "char2", "people2", "general2", "일반2", "一般2"},
	{"charset", "一般3", "people3", "char3", "people3", "general3", "일반3", "一般3"},
	{"charset", "一般4", "people4", "char4", "people4", "general4", "일반4", "一般4"},
	{"charset", "一般5", "people5", "char5", "people5", "general5", "일반5", "一般5"},
	{"charset", "主人公1", "actor1", "hero1", "chara1", "protagonist1", "주인공1", "主角1"},
	{"charset", "主人公2", "actor2", "hero2", "chara2", "protagonist2", "주인공2", "主角2"},
	{"charset", "主人公3", "actor3", "hero3", "chara3", "protagonist3", "주인공3", "主角3"},
	{"charset", "主人公4", "actor4", "hero4", "chara4", "protagonist4", "주인공4", "主角4"},
	{"charset", "乗り物", "vehicles", "vehicle", "vehicles", "vehicle", "탈것", "交通工具"},
	{"charset", "動物", "animal", "animal", "animals", "animal", "동물", "動物"},
	{"chipset", "ダンジョン", "dungeon", "dungeon", "internal1", "donjohn", "던젼", "迷宮"},
	{"chipset", "内装", "interior", "building", "internal2", "interior", "내부", "內部"},
	{"chipset", "基本", "world", "main", "world", "basic", "기본", "基本"},
	{"chipset", "外観", "exterior", "town", "village", "appearance", "외견", "外部"},
	{"chipset", "船", "ship", "ship", "ship", "boat", "배", "船"},
	{"faceset", "モンスター", "monster", "monster", "monsters", "monster", "몬스터", "怪物"},
	{"faceset", "一般1", "people1", "faces1", "people", "general1", "일반1", "一般1"},
	{"faceset", "一般2", "people2", "faces2", "peopleanimal", "general2", "일반2", "一般2"},
	{"faceset", "主人公1", "actor1", "hero1", "face1", "protagonist1", "주인공1", "主角1"},
	{"faceset", "主人公2", "actor2", "hero2", "face2", "protagonist2", "주인공2", "主角2"},
	{"gameover", "ゲームオーバー", "game over", "gameover", "gameover", "gameover", "게임오버", "遊戲結束"},
	{"gameover", nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, "遊戲結束2"},
	{"monster", "アーリマン", "ahriman", "ariman", "maliciousflower", "ahriman", "아리맨", "阿利曼"},
	{"monster", "アスラ", "asura", "asura", "weaponmaster", "multiarmdemon", "아수라", "阿蘇拉"},
	{"monster", "アナコンダ", "anaconda", "anaconda", "snake", "anaconda", "아나콘다", "巨蟒"},
	{"monster", "アリゲーター", "alligator", "alligator", "crocodile", "alligator", "엘리게이터", "短吻鱷"},
	{"monster", "アンデッドナイト", "undead knight", "u-knight", "deadpirate", "pimpskeleton", "언데드 나이트", "不死騎士"},
	{"monster", "イフリート", "ifreet", "efreet", "efrit", "ifrit", "이프리트", "伊弗利特"},
	{"monster", "インプ", "imp", "imp", "features", "littledemon", "임프", "小魔鬼"},
	{"monster", "ヴァンパイア", "vampire", "vampire", "vampire", "vampire", "뱀파이어", "吸血鬼"},
	{"monster", "ウロボロス", "ouroboros", "oroboros", "levitan", "dragon", "우로보로스", "吞尾蛇"},
	{"monster", "エルフ", "elf", "elf", "archer", "elf", "엘프", "妖精"},
	{"monster", "オーガ", "ogre", "ogre", "primitiveman", "auger", "오거", "食人魔"},
	{"monster", "オーク", "orc", "orc", "pigsoldier", "ork", "오크", "獸人戰士"},
	{"monster", "オーディン", "odin", "odin", "dangeroussoldier", "odin", "오딘", "奧丁"},
	{"monster", "オクトパス", "octopus", "octopus", "octopus", "octopus", "옥토퍼스", "八爪章魚"},
	{"monster", "ガーゴイル", "gargoyle", "gargoyle", "gargoyle", "gargoyle", "가고일", "石像獸"},
	{"monster", "カーバンクル", "carbuncle", "carbuncle", "rubyfox", "carbunkle", "카방클", "紅寶石"},
	{"monster", "カーミラ", "carmilla", "cojurer", "murdererwoman", "carmira", "카미라", "卡美拉"},
	{"monster", "カッパ", "kappa", "kappa", "morloc", "raincoat", "카트바", "河童"},
	{"monster", "カトブレパス", "catoblepas", "catoblepas", "curvebull", "demonhorsething", "카토부레바트", "卡托布里帕斯"},
	{"monster", "ガルーダ", "garuda", "garuda", "flyingwarrior", "garuda", "가루다", "揭路荼"},
	{"monster", "キメラ", "chimera", "chimera", "chimera", "chimera", "키메라", "吐火獸"},
	{"monster", "グール", "ghoul", "ghoul", "zombie", "ghoul", "구울", "食屍鬼"},
	{"monster", "クラーケン", "kraken", "kraken", "seabowl", "seamonster", "크라켄", "克拉坎"},
	{"monster", "クラブ", "crab", "cancer", "crab", "crab", "크랩", "巨蟹"},
	{"monster", "グリフォン", "griffon", "griffon", "griphon", "griffin", "그리폰", "葛里芬"},
	{"monster", "グレル", "grell", "grell", "robot", "jellyfish", "구렐", "毛面蟲"},
	{"monster", "クロウラー", "crawler", "crawler", "worm", "crowera", "쿠로우라", "爬蟲"},
	{"monster", "ゲイザー", "gazer", "deathgaze", "eye", "eyestalk", "게이져", "看守者"},
	{"monster", "ケツアルクアトル", "quetzalcoatl", "quezal", "flyingworm", "birdsnake", "케이시아르크 아토르", "羽蛇神"},
	{"monster", "ケットシー", "cait sith", "caitsith", "eremite", "ketsea", "캐트시", "貓靈"},
	{"monster", "ケルベロス", "cerberus", "cerberus", "cerberus", "cerebus", "켈베로스", "地獄犬"},
	{"monster", "ケンタウロス", "centaur", "centaur", "centaur", "centaur", "켄타우르스", "半人馬"},
	{"monster", "ゴーゴン", "gorgon", "gorgon", "infernalbull", "bull", "고곤", "戈耳戈"},
	{"monster", "ゴースト", "ghost", "ghost", "witchphantom", "ghost", "고스트", "鬼魂"},
	{"monster", "ゴーレム", "golem", "golem", "golem", "golem", "골렘", "高崙"},
	{"monster", "コカトリス", "cockatorice", "cockatrice", "rooster", "cockatrice", "코카트리스", "雞蛇獸"},
	{"monster", "ゴブリン", "goblin", "goblin", "littledemon", "imp", "고블린", "小妖精"},
	{"monster", "コボルト", "kobold", "kobold", "wolf", "kobold", "코볼트", "地精"},
	{"monster", "サイクロプス", "cyclops", "cyclops", "cyclops", "giant", "사이클롭스", "獨眼巨人"},
	{"monster", "サタナエル", "satan", "satan", "darkangel", "darkangel", "사타나엘", "撒旦尼爾"},
	{"monster", "サハギン", "sahagin", "sahagin", "triton", "merman", "사하킨", "半魚人撒哈奇"},
	{"monster", "サラマンダー", "salamander", "salamander", "burninglizard", "salamander", "사라멘더", "火蜥蜴"},
	{"monster", "シャーク", "shark", "shark", "shark", "shark", "샤크", "鯊魚"},
	{"monster", "ジャイアント", "giant", "giant", "cannibal", "giant-2", "자이언트", "巨人"},
	{"monster", "ジャック・オー・ランタン", "jack-o-lantern", "jack", "pumpkin", "jackolantern", "잭-오-랜턴", "燈籠怪"},
	{"monster", "シャドウ", "shadow", "shadow", "lostshadow", "shadow", "셰도우", "幻影"},
	{"monster", "シルフ", "sylph", "sylph", "fairy", "fairy", "실프", "風之精靈－絲芙"},
	{"monster", "スキュラ", "scylla", "scylla", "medusa", "gorgon", "스쿨라", "斯庫拉"},
	{"monster", "スケルトン", "skeleton", "skeleton", "skeleton", "skeleton", "스켈톤", "骷髏"},
	{"monster", "スコーピオン", "scorpion", "scorpion", "cancer", "scorpion", "스콜피온", "天蠍"},
	{"monster", "スネーク", "snake", "snake", "dangeroussnake", "snake", "스테이크", "蛇"},
	{"monster", "スピリッツ", "spirit", "spirit", "laughingspirit", "spirit", "스피릿츠", "靈魂"},
	{"monster", "スフィンクス", "sphinx", "sphinx", "sphynx", "sphinx", "스핑크스", "斯芬克司"},
	{"monster", "スペクター", "spectre", "specter", "magicskull", "lostsoul", "스펙터", "幽靈"},
	{"monster", "スライム", "slime", "slime", "slime", "slime", "슬라임", "史萊姆"},
	{"monster", "セイレーン", "siren", "siren", "flyingmermaid", "merangel", "세이렌", "賽倫女妖"},
	{"monster", "セラフィム", "seraphim", "seraph", "sephiroth", "angel", "세라핌", "撒拉弗"},
	{"monster", "センチピード", "centipede", "centipede", "multileg", "catterpillar", "센티피드", "百腳蜈蚣"},
	{"monster", "ソーサラー", "sorcerer", "sorcerer", "magician", "wizard", "소서러", "巫師"},
	{"monster", "ゾンビ", "zombie", "zombie", "poisonzombie", "zombie", "좀비", "殭屍"},
	{"monster", "ダークエルフ", "dark elf", "darkelf", "fencer", "darkelf", "다크 엘프", "黑暗妖精"},
	{"monster", "ダークナイト", "dark knight", "darkknight", "knight", "darkknight", "다크 나이트", "暗黑騎士"},
	{"monster", "タイタン", "titan", "titan", "titan", "titan", "타이탄", "泰坦巨人"},
	{"monster", "タランチュラ", "tarantula", "spider", "spider", "spider", "타란튤라", "狼蛛"},
	{"monster", "ティアマット", "tiamat", "tiamat", "many-domeddragon", "tiamat", "데어 매트", "塔亞瑪特邪龍"},
	{"monster", "デーモン", "demon", "demon", "horngoat", "daemon", "데몬", "惡魔"},
	{"monster", "トード", "toad", "toad", "toad", "frog", "토드", "蟾蜍"},
	{"monster", "ドラゴン", "dragon", "dragon", "bluedragon", "dragon-2", "드래곤", "龍"},
	{"monster", "ドラゴンナイト", "dragon knight", "dragonknight", "dragonwarrior", "dragonknight", "드래곤 나이트", "龍騎士"},
	{"monster", "トレント", "treant", "treant", "dendrid", "tree", "트렌트", "樹精"},
	{"monster", "トロール", "troll", "troll", "orc", "troll", "트롤", "山怪"},
	{"monster", "ネクロマンサー", "necromancer", "necromancer", "necromant", "necromancer", "네크로맨서", "死靈法師"},
	{"monster", "ネペンテス", "nepenthes", "nepenthe", "multirootflower", "killerplant", "네벤테스", "豬籠草怪"},
	{"monster", "バーサーカー", "berserker", "berserker", "barbarian", "barbarian", "버저커", "狂暴戰士"},
	{"monster", "ハーピー", "harpy", "harpy", "harpy", "harpy", "하피", "鳥人哈比"},
	{"monster", "バジリスク", "basilisk", "basilisk", "horned", "earwig", "바실리크스", "蛇怪"},
	{"monster", "バット", "bat", "bat", "bat", "bat", "배트", "蝙蝠"},
	{"monster", "バハムート", "bahamut", "bahamut", "dragon", "lizarddemon", "바하무트", "巴哈姆特"},
	{"monster", "パラサイト", "parasite", "parasite", "all-knowing", "parasite", "페러사이트", "寄生蟲"},
	{"monster", "ビッグフット", "big foot", "bigfoot", "yeti", "yeti", "빅풋", "大腳怪"},
	{"monster", "ヒュドラ", "hydra", "hydra", "many-domeduglycreature", "hydra", "히드라", "九頭蛇"},
	{"monster", "フェニックス", "phoenix", "phoenix", "phoenix", "phoenix", "피닉스", "鳳凰鳥"},
	{"monster", "フェンリル", "fenrir", "fenrir", "realwolf", "wolf", "펜릴", "大天狼"},
	{"monster", "ベヒーモス", "behemoth", "behemoth", "infernaldog", "behemoth", "배히모스", "巨獸"},
	{"monster", "ホーネット", "hornet", "hornet", "bee", "bea", "호넷", "大黃蜂"},
	{"monster", "マンティコア", "manticore", "manticore", "crossedbeast", "monster", "만티코어", "蒙特寇爾"},
	{"monster", "マンティス", "mantis", "mantis", "insect", "preyingmantis", "만티스", "螳螂怪"},
	{"monster", "マンモス", "mammoth", "mammoth", "mamont", "mammoth", "맘모스", "長毛象"},
	{"monster", "ミイラ男", "mummy", "mummy", "mummy", "mummy", "미이라 男", "木乃伊"},
	{"monster", "ミドガルズオルム", "midgardsormr", "midgard-serp", "creepingcreature", "monster-2", "미드갈즈 오르무", "米嘉巨蟒"},
	{"monster", "ミノタウロス", "minotaur", "minotaur", "minotaur", "minotaur", "미노타우르스", "邁諾陶"},
	{"monster", "ミミック", "mimic", "mimic", "ogrechest", "mimic", "미믹", "變形怪"},
	{"monster", "メデューサ", "medusa", "medusa", "hypermedusa", "medusa", "메두사", "梅杜莎"},
	{"monster", "ユニコーン", "unicorn", "unicorn", "unicorn", "unicorn", "유니콘", "獨角獸"},
	{"monster", "ラクシュミ", "lakshmi", "rakashimi", "prophet", "mystic", "라쿠슈미", "吉祥天"},
	{"monster", "ラミア", "lamia", "lamia", "mermaid", "gorgon-2", "라미아", "拉米亞"},
	{"monster", "リヴァイアサン", "leviathan", "leviathan", "levitanwithahorn", "leviathan", "리바이어던", "大海獸"},
	{"monster", "リザード", "lizard", "lizard", "monitorlizard", "lizard", "리자드", "蜥蜴"},
	{"monster", "リザードマン", "lizardman", "lizardman", "lizardsoldier", "lizardman", "리자드맨", "蜥蜴人"},
	{"monster", "リッチ", "lich", "lich", "powerfulnecromant", "lich", "리치", "妖巫"},
	{"monster", "リリス", "lilith", "lillith", "multihandswarrior", "lilith", "리리스", "莉莉斯"},
	{"monster", "レイス", "wraith", "wraith", "phantom", "spectre", "레이스", "死靈"},
	{"monster", "レモラ", "remora", "remora", "sharpfish", "flyingfish", "레모라", "怪魚雷莫拉"},
	{"monster", "ワーウルフ", "werewolf", "werewolf", "werwolf", "werewolf", "워울프", "狼人"},
	{"monster", "ワーム", "worm", "worm", "toothworm", "worm", "웜", "蟲"},
	{"monster", "ワイト", "wight", "wight", "seizedsoldier", "yto", "와이트", "屍妖"},
	{"monster", "ワイバーン", "wyvern", "wyvern", "browndragon", "yburning", "와이번", "飛龍"},
	{"monster", "九尾の狐", "kyuubi", "ninetail", "magicfox", "foxofninetails", "구미호", "九尾狐狸"},
	{"monster", "朱雀", "suzaku", "redsparrow", "vainbird", "redsparrow", "주작", "朱雀"},
	{"monster", "玄武", "genbu", "blackturtle", "turtlesnake", "monster-3", "현무", "玄武"},
	{"monster", "白虎", "byakko", "whitetiger", "polartiger", "whitetiger", "백호", "白虎"},
	{"monster", "馬", "horse", "nightmare", "darkhorse", "horse", "말", "馬"},
	{"monster", "鬼", "oni", "oni", "ogre", "ogre", "도깨비(鬼)", "惡鬼"},
	{"monster", "麒麟", "kirin", "ki-rin", "fairytalehorse", "giraffe", "기린", "麒麟"},
	{"monster", "龍", "ryuu", "bluedragon", "longdragon", "bluedragon", "청룡", "青龍"},
	{"music", "2003いやしの泉", "2003healing spring", "spring", "2003happiness", "2003spring", "2003회복의 샘", "2003治癒之泉"},
	{"music", "2003カジノ三昧", "2003casino indulgence", "casino", "2003research", "2003casino", "2003카지노", "2003賭場"},
	{"music", "2003コロシアム", "2003colosseum", "arena", "2003piracy", "2003colloseum", "2003콜로세움", "2003競技場"},
	{"music", "2003サイバーシティ", "2003cyber city", "bustling-city", "2003joyfulnews", "2003rhinobarcity", "2003사이버 시티", "2003異次元城市"},
	{"music", "2003スノータウン", "2003snow town", "snowtown", "2003lullaby", "2003snowtown", "2003스노우 타운", "2003下雪的城鎮"},
	{"music", "2003パニック", "2003panic", "panic", "2003warning", "2003panic", "2003패닉", "2003恐慌"},
	{"music", "2003マキシマム・バトル", "2003maximum battle", "fierce-battle", "2003pursuit", "2003maximumsbattle", "2003맥시멈·전투", "2003極限戰鬥"},
	{"music", "2003一獲千金の夢", "2003dream of striking it rich", "jackpot", "2003silentpleasure", "2003dream-catchlotsofmoney", "2003일획천금의 꿈", "2003一獲千金之夢"},
	{"music", "2003冒険者たち", "2003adventurers", "adventure", "2003farewell", "2003venturepeople", "2003여행자 서고", "2003冒險者們"},
	{"music", "2003勇者の凱旋", "2003hero's return", "triumph", "2003bigpalace", "2003triumphalreturn", "2003용사의 개선", "2003勇者的凱旋"},
	{"music", "2003古城", "2003ancient city", "ancient-castle", "2003glory", "2003oldcastle", "2003고성", "2003古城"},
	{"music", "2003地下迷宮", "2003subterranean maze", "labyrinth", "2003fast", "2003undergroundlabyrinth", "2003지하미궁", "2003地下迷宮"},
	{"music", "2003夢幻の森", "2003dream forest", "forest", "2003worldsound", "2003forestoffantasy", "2003몽환의 숲", "2003夢幻之森"},
	{"music", "2003夢見心地", "2003dreaminess", "moonlight", "2003serenity", "2003mooniness", "2003꿈을 꾸는 기분", "2003夢幻心境"},
	{"music", "2003大混戦", "2003free for all", "armyclash", "2003gangster", "2003largeconfoundcombat", "2003대혼전", "2003大混戰"},
	{"music", "2003大空への翼", "2003wings to the sky", "airborne", "2003fanfares", "2003wingtoskies", "2003대공의 날개", "2003空中的羽翼"},
	{"music", "2003大聖堂", "2003cathedral", "hallowed-halls", "2003grief", "2003largesaintlyhall", "2003대성당", "2003大聖堂"},
	{"music", "2003妖精の森", "2003fairy forest", "fairies", "2003workingmusic", "2003fairyforest", "2003요정의 숲", "2003妖精之森"},
	{"music", "2003孤独な旅立ち", "2003lonesome journey", "lonewolf", "2003memoirs", "2003lonelyjourney", "2003고독한 여행", "2003孤獨的旅行"},
	{"music", "2003小さな兵隊のマーチ", "2003little army's march", "march", "2003parade", "2003marchofsmallsoldiers", "2003작은 군대의 행진곡", "2003小軍隊進行曲"},
	{"music", "2003山あいの村", "2003village in the valley", "mtn-village", "2003eaststyle", "2003villageofravines", "2003산골짜기 마을", "2003山中部落"},
	{"music", "2003帝国～エンパイア", "2003empire", "empire", "2003andagainpleasure", "2003enpire", "2003제국", "2003帝國"},
	{"music", "2003幼少の記憶", "2003young memories", "memories", "2003fairytale", "2003memoryofinfancy", "2003유소의 기억", "2003年少記憶"},
	{"music", "2003忍び寄る闇", "2003creeping darkness", "foreboding", "2003threat", "2003approachingdarkness", "2003살며시 다가옴", "2003悄然黑夜"},
	{"music", "2003悠久の時の流れに", "2003in the eternal flow of time", "eternal", "2003calm", "2003theeternalflow", "2003유구의 흐름", "2003悠久時光的流轉"},
	{"music", "2003悲しみ", "2003sorrow", "sadness", "2003calm2", "2003sorrow", "2003슬퍼하고", "2003悲傷"},
	{"music", "2003戦いの幕開け", "2003beginning of a war", "intro", "2003dangerousfog", "2003fightopening", "2003싸움의 개막", "2003戰爭的序幕"},
	{"music", "2003教会", "2003church", "church1", "2003church", "2003church", "2003교회", "2003教會"},
	{"music", "2003日だまりの村", "2003sunnyvillage", "village4", "2003farmer", "2003villageball", "2003양지의 마을", "2003日光村落"},
	{"music", "2003暗黒の祭壇", "2003darkaltar", "evil-temple", "2003globalfrustration", "2003altarofdarkness", "2003암흑의 제단", "2003暗黑祭壇"},
	{"music", "2003未開の集落", "2003village of savages", "strangetown", "2003witchsong", "2003unexploredvillage", "2003미개한 취락", "2003未開化部落"},
	{"music", "2003極東の地", "2003far eastern land", "far-east", "2003flight", "2003fareasternarea", "2003극동의 땅", "2003極東之地"},
	{"music", "2003機械要塞", "2003machine fortress", "mecha-base", "2003sadend", "2003machinefortress", "2003기계 요새", "2003機械要塞"},
	{"music", "2003氷のラビリンス", "2003ice labyrinth", "icecave", "2003drops", "2003icelabyrinth", "2003얼음의 래비런스", "2003冰之迷宮"},
	{"music", "2003決戦の地", "2003final battleground", "showdown", "2003battlefield", "2003areaofdecisivebattles", "2003결전의 땅", "2003決戰之地"},
	{"music", "2003無人の館", "2003deserted mansion", "haunted", "2003silentcrying", "2003unmannedmansion", "2003무인 저택", "2003無人別館"},
	{"music", "2003王宮のパーティー", "2003palace party", "royal-ball", "2003dance", "2003courtparty", "2003왕궁의 파티", "2003皇宮盛會"},
	{"music", "2003異次元回廊", "2003otherworldly corridor", "dimension", "2003fastbattle", "2003strangedimensionalcorridor", "2003차원의 길", "2003異次元迴廊"},
	{"music", "2003祝福ワルツ", "2003waltz of blessings", "waltz", "2003waltz", "2003blessingwaltz", "2003축복 왈츠", "2003祝福的華爾滋"},
	{"music", "2003穏やかな風", "2003steady breeze", "interlude", "2003summer", "2003calmwind", "2003온화한 바람", "2003徐徐微風"},
	{"music", "2003緊迫", "2003tension", "tension", "2003terribledream", "2003tension", "2003긴박", "2003緊迫"},
	{"music", "2003繰り返される戦い", "2003repeated wars", "endless-fight", "2003fastbattle2", "2003thefightwhichisrepeated", "2003반복된 싸움", "2003反覆的戰鬥"},
	{"music", "2003街の賑わい", "2003city bustle", "town-square", "2003pleasure", "2003towncrowd", "2003거리의 북적임", "2003熱鬧街道"},
	{"music", "2003街の酒場", "2003tavern", "bar", "2003travel", "2003townbar", "2003거리의 술집", "2003街上的酒館"},
	{"music", "2003記憶の彼方に", "2003deep memory", "memories2", "2003morning", "2003onthefarsideofmemories", "2003기억의 저쪽에", "2003記憶中的彼方"},
	{"music", "2003遺跡探索", "2003exploring ruins", "ruins", "2003infiniteidea", "2003ruinssearch", "2003유적 탐색", "2003遺跡探索"},
	{"music", "2003邪神との戦い", "2003battle with an evil god", "godslayer", "2003chaos", "2003wickedgodfight", "2003사신과의 싸움", "2003與邪神一戰"},
	{"music", "2003静寂", "2003silence", "calm", "2003underwater", "2003calmness", "2003정적", "2003靜寂"},
	{"music", "j2003ホルン", "j2003horn", "horns", "2003win", "j2003horn", "j2003호른", "j2003號角"},
	{"music", "jアイテム", "jitem", "item", nullptr, "jitem", "j아이템", "j物品"},
	{"music", "jギャグ1", "jjoke 1", "mischief1", nullptr, "jgag1", "j개그1", "j鬧劇1"},
	{"music", "jギャグ2", "jjoke 2", "mischief2", nullptr, "jgag2", "j개그2", "j鬧劇2"},
	{"music", "jファンファーレ1", "jfanfare 1", "fanfare1", nullptr, "jfanfare1", "j팡파르1", "j吹奏樂1"},
	{"music", "jファンファーレ2", "jfanfare 2", "fanfare2", nullptr, "jfanfare2", "j팡파르2", "j吹奏樂2"},
	{"music", "jファンファーレ3", "jfanfare 3", "fanfare3", nullptr, "jfanfare3", "j팡파르3", "j吹奏樂3"},
	{"music", "jファンファーレ4", "jfanfare 4", "fanfare4", nullptr, "jfanfare4", "j팡파르4", "j吹奏樂4"},
	{"music", "jファンファーレ5", "jfanfare 5", "fanfare5", nullptr, "jfanfare5", "j팡파르5", "j吹奏樂5"},
	{"music", "jファンファーレ6", "jfanfare 6", "fanfare6", nullptr, "jfanfare6", "j팡파르6", "j吹奏樂6"},
	{"music", "j宿1", "jinn 1", "inn1", nullptr, "jinn1", "j숙소1", "j住宿1"},
	{"music", "j宿2", "jinn 2", "inn2", nullptr, "jinn2", "j숙소2", "j住宿2"},
	{"music", "j戦闘終了1", "jend of battle 1", "victory1", nullptr, "jaggressiveend1", "j전투종료1", "j戰鬥結束1"},
	{"music", "j戦闘終了2", "jend of battle 2", "victory2", nullptr, "jaggressiveend2", "j전투종료2", "j戰鬥結束2"},
	{"music", "j戦闘終了3", "jend of battle 3", "victory3", nullptr, "jaggressiveend3", "j전투종료3", "j戰鬥結束3"},
	{"music", "j戦闘終了4", "jend of battle 4", "victory4", nullptr, "jaggressiveend4", "j전투종료4", "j戰鬥結束4"},
	{"music", "j疑惑", "jdoubt", "surprise", nullptr, "jdoubt", "j의혹", "j疑惑"},
	{"music", "j謎", "jmystery", "riddle", nullptr, "jpuzzle", "j수수께기", "j謎"},
	{"music", "se2003アラーム", "se2003alarm", "se-alarm", "se2003ding", "se2003alarm", "se2003알람", "se2003警報"},
	{"music", "se2003ジャングル", "se2003jungle", "se-jungle", "se2003jungle", "se2003jungle", "se2003정글", "se2003叢林"},
	{"music", "se2003雑踏", "se2003bustle", "se-crowd", "se2003people", "se2003bustle", "se2003혼잡", "se2003雜沓"},
	{"music", "se2003風", "se2003wind", "se-gale", "se2003winter", "se2003wind", "se2003바람", "se2003風"},
	{"music", "se2003鳥", "se2003bird", "se-bird", "se2003birds", "se2003bird", "se2003새", "se2003鳥"},
	{"music", "se地震", "seearthquake", "se-quake", "seearthquake", "seearthquake", "se지진", "se地震"},
	{"music", "se大雨", "sedownpour", "se-torrent", "serain2", "seheavyrain", "se호우", "se大雨"},
	{"music", "se時計", "seclock", "se-clock", "seclock", "seclock", "se시계", "se鐘"},
	{"music", "se海", "sesea", "se-ocean", "sesea", "sesea", "se바다", "se海"},
	{"music", "se雨", "serain", "se-rain", "serain", "serainy", "se비", "se雨"},
	{"music", "エンディング1", "ending 1", "ending1", nullptr, nullptr, "끝1", "結束1"},
	{"music", "エンディング2", "ending 2", "ending2", nullptr, nullptr, "끝2", "結束2"},
	{"music", "エンディング3", "ending 3", "ending3", nullptr, nullptr, "끝3", "結束3"},
	{"music", "オープニング1", "opening 1", "opening1", nullptr, nullptr, "오프닝1", "開始1"},
	{"music", "オープニング2", "opening 2", "opening2", nullptr, nullptr, "오프닝2", "開始2"},
	{"music", "オープニング3", "opening 3", "opening3", nullptr, nullptr, "오프닝3", "開始3"},
	{"music", "ゲームオーバー1", "game over 1", "gameover1", nullptr, nullptr, "게임오버1", "遊戲結束1"},
	{"music", "ゲームオーバー2", "game over 2", "gameover2", nullptr, nullptr, "게임오버2", "遊戲結束2"},
	{"music", "ゲームオーバー3", "game over 3", "gameover3", nullptr, nullptr, "게임오버3", "遊戲結束3"},
	{"music", "ゴーストタウン1", "ghost town 1", "ghost-town1", nullptr, nullptr, "고스트 타운1", "鬼城1"},
	{"music", "ゴーストタウン2", "ghost town 2", "ghost-town2", nullptr, nullptr, "고스트 타운2", "鬼城2"},
	{"music", "ダンジョン1", "dungeon 1", "dungeon1", nullptr, nullptr, "지하감옥1", "迷宮1"},
	{"music", "ダンジョン2", "dungeon 2", "dungeon2", nullptr, nullptr, "지하감옥2", "迷宮2"},
	{"music", "ダンジョン3", "dungeon 3", "dungeon3", nullptr, nullptr, "지하감옥3", "迷宮3"},
	{"music", "ダンジョン4", "dungeon 4", "dungeon4", nullptr, nullptr, "지하감옥4", "迷宮4"},
	{"music", "ダンジョン5", "dungeon 5", "dungeon5", nullptr, nullptr, "지하감옥5", "迷宮5"},
	{"music", "ピンチ", "in a pinch", "tightspot", nullptr, nullptr, "핀치", "危機"},
	{"music", "フィールド1", "field 1", "field1", nullptr, nullptr, "필드1", "原野1"},
	{"music", "フィールド2", "field 2", "field2", nullptr, nullptr, "필드2", "原野2"},
	{"music", "フィールド3", "field 3", "field3", nullptr, nullptr, "필드3", "原野3"},
	{"music", "フィールド4", "field 4", "field4", nullptr, nullptr, "필드4", "原野4"},
	{"music", "ボス1", "boss 1", "boss1", nullptr, nullptr, "보스1", "boss1"},
	{"music", "ボス2", "boss 2", "boss2", nullptr, nullptr, "보스2", "boss2"},
	{"music", "ボス3", "boss 3", "boss3", nullptr, nullptr, "보스3", "boss3"},
	{"music", "ボス4", "boss 4", "boss4", nullptr, nullptr, "보스4", "boss4"},
	{"music", "乗り物1", "vehicle 1", "vehicle1", nullptr, nullptr, "차량1", "交通工具1"},
	{"music", "乗り物2", "vehicle 2", "vehicle2", nullptr, nullptr, "차량2", "交通工具2"},
	{"music", "乗り物3", "vehicle 3", "vehicle3", nullptr, nullptr, "차량3", "交通工具3"},
	{"music", "別れ1", "parting 1", "parting1", nullptr, nullptr, "이별1", "別離1"},
	{"music", "別れ2", "parting 2", "parting2", nullptr, nullptr, "이별2", "別離2"},
	{"music", "勇者1", "hero 1", "hero1", nullptr, nullptr, "용사1", "勇者1"},
	{"music", "勇者2", "hero 2", "hero2", nullptr, nullptr, "용사2", "勇者2"},
	{"music", "動物", "animal", "animal", nullptr, nullptr, "동물", "動物"},
	{"music", "勝利", "victory", "success", nullptr, nullptr, "승리", "勝利"},
	{"music", "城1", "castle 1", "castle1", nullptr, nullptr, "성1", "城1"},
	{"music", "城2", "castle 2", "castle2", nullptr, nullptr, "성2", "城2"},
	{"music", "城3", "castle 3", "castle3", nullptr, nullptr, "성3", "城3"},
	{"music", "塔1", "tower 1", "tower1", nullptr, nullptr, "탑1", "塔1"},
	{"music", "塔2", "tower 2", "tower2", nullptr, nullptr, "탑2", "塔2"},
	{"music", "塔3", "tower 3", "tower3", nullptr, nullptr, "탑3", "塔3"},
	{"music", "妖精1", "fairy 1", "fairy1", nullptr, nullptr, "요정1", "妖精1"},
	{"music", "妖精2", "fairy 2", "fairy2", nullptr, nullptr, "요정2", "妖精2"},
	{"music", "安らぎ1", "repose 1", "solace1", nullptr, nullptr, "편안해짐1", "安樂1"},
	{"music", "安らぎ2", "repose 2", "solace2", nullptr, nullptr, "편안해짐2", "安樂2"},
	{"music", "安らぎ3", "repose 3", "solace3", nullptr, nullptr, "편안해짐3", "安樂3"},
	{"music", "店1", "shop 1", "shop1", nullptr, nullptr, "점1", "店1"},
	{"music", "店2", "shop 2", "shop2", nullptr, nullptr, "점2", "店2"},
	{"music", "店3", "shop 3", "shop3", nullptr, nullptr, "점3", "店3"},
	{"music", "怒り", "wrath", "malice", nullptr, nullptr, "화내다", "怒"},
	{"music", "悲しみ", "sorrow", "sad", nullptr, nullptr, "슬퍼하다", "悲傷"},
	{"music", "戦闘1", "battle 1", "battle1", nullptr, nullptr, "전투1", "戰鬥1"},
	{"music", "戦闘2", "battle 2", "battle2", nullptr, nullptr, "전투2", "戰鬥2"},
	{"music", "戦闘3", "battle 3", "battle3", nullptr, nullptr, "전투3", "戰鬥3"},
	{"music", "探索", "exploration", "explore", nullptr, nullptr, "탐색", "探索"},
	{"music", "敗北", "defeat", "defeat", nullptr, nullptr, "패배", "敗北"},
	{"music", "教会", "church", "church2", nullptr, nullptr, "교회", "教會"},
	{"music", "明るい市場", "lively market", "bazaar", nullptr, nullptr, "밝은 시장", "明亮的市集"},
	{"music", "村1", "village 1", "village1", nullptr, nullptr, "촌1", "村1"},
	{"music", "村2", "village 2", "village2", nullptr, nullptr, "촌2", "村2"},
	{"music", "村3", "village 3", "village3", nullptr, nullptr, "촌3", "村3"},
	{"music", "泥棒", "thief", "thief", nullptr, nullptr, "도둑", "泥棒"},
	{"music", "活気", "liveliness", "strength", nullptr, nullptr, "활기", "朝氣"},
	{"music", "町1", "town 1", "town1", nullptr, nullptr, "밭두둑1", "街1"},
	{"music", "町2", "town 2", "town2", nullptr, nullptr, "밭두둑2", "街2"},
	{"music", "町3", "town 3", "town3", nullptr, nullptr, "밭두둑3", "街3"},
	{"music", "神秘1", "mystery 1", "mystery1", nullptr, nullptr, "신비1", "神秘1"},
	{"music", "神秘2", "mystery 2", "mystery2", nullptr, nullptr, "신비2", "神秘2"},
	{"music", "神秘3", "mystery 3", "mystery3", nullptr, nullptr, "신비3", "神秘3"},
	{"music", "秘宝", "secret treasure", "treasure", nullptr, nullptr, "바보", "神秘寶藏"},
	{"music", "船1", "ship 1", "boat1", nullptr, nullptr, "배1", "船1"},
	{"music", "船2", "ship 2", "boat2", nullptr, nullptr, "배2", "船2"},
	{"music", "船3", "ship 3", "boat3", nullptr, nullptr, "배3", "船3"},
	{"music", "試練", "trial", "ordeal", nullptr, nullptr, "시련", "試煉"},
	{"music", "闇市", "black market", "eviltown", nullptr, nullptr, "암시장", "黑市"},
	{"music", "魔王", "demon lord", "demonic", nullptr, nullptr, "마왕", "魔王"},
	{"panorama", "夕焼け1", "sunset1", "dusk1", "dawn1", "eveningglow1", "석양1", "夕陽1"},
	{"panorama", "夕焼け2", "sunset2", "dusk2", "dawn2", "eveningglow2", "석양2", "夕陽2"},
	{"panorama", "夜明け1", "dawn1", "dawn1", "evening1", "dawn1", "새벽1", "黎明1"},
	{"panorama", "夜明け2", "dawn2", "dawn2", "evening2", "dawn2", "새벽2", "黎明2"},
	{"panorama", "夜空1", "night sky1", "night1", "night1", "nightempty1", "밤하늘1", "夜空1"},
	{"panorama", "夜空2", "night sky2", "night2", "night2", "nightempty2", "밤하늘2", "夜空2"},
	{"panorama", "宇宙", "cosmos1", "space", "galaxy", "space", "우주", "宇宙"},
	{"panorama", "惑星1", "planet1", "planet1", "planet1", "planetary1", "혹성1", "惑星1"},
	{"panorama", "惑星2", "planet2", "planet2", "planet2", "planetary2", "혹성2", "惑星2"},
	{"panorama", "惑星3", "planet3", "planet3", "planet3", "planetary3", "혹성3", "惑星3"},
	{"panorama", "異空間", "dimension rift", "strange", "weird", "strangespacial", "이공간", "異次元空間"},
	{"panorama", "空1", "sky1", "sky1", "morning1", "empty1", "하늘1", "天空1"},
	{"panorama", "空2", "sky2", "sky2", "morning2", "empty2", "하늘2", "天空2"},
	{"sound", "アイテム1", "item1", "item1", nullptr, "item1", "아이템1", "物品1"},
	{"sound", "アイテム2", "item2", "item2", nullptr, "item2", "아이템2", "物品2"},
	{"sound", "あたり1", "chime1", "jingle1", nullptr, "around1", "즈음하고1", "碰撞1"},
	{"sound", "あたり2", "chime2", "jingle2", nullptr, "around2", "즈음하고2", "碰撞2"},
	{"sound", "アップ", "buff", "increase", nullptr, "upgrade", "업", "上昇"},
	{"sound", "イヌ", "dog", "dog", nullptr, "dog", "강아지", "狗"},
	{"sound", "ウシ", "cow", "cow", nullptr, "cow", "소", "牛"},
	{"sound", "ウマ", "horse", "horse", nullptr, "horse", "발판", "馬"},
	{"sound", "おたけび", "roar", "roar", nullptr, "roar", "우렁찬 외침", "吶喊"},
	{"sound", "カーソル1", "cursor1", "cursor1", nullptr, "cursor1", "커서1", "游標1"},
	{"sound", "カーソル2", "cursor2", "cursor2", nullptr, "cursor2", "커서2", "游標2"},
	{"sound", "ガシャン", "glassshatter", "shatter", nullptr, "glass", "가샨", "裂開"},
	{"sound", "キャンセル1", "cancel1", "cancel1", nullptr, "cancel1", "취소1", "取消1"},
	{"sound", "キャンセル2", "cancel2", "cancel2", nullptr, "cancel2", "취소2", "取消2"},
	{"sound", "しびれ1", "paralyze1", "paralyze1", nullptr, "paralyze1", "마비1", "麻痺1"},
	{"sound", "しびれ2", "paralyze2", "paralyze2", nullptr, "paralyze2", "마비2", "麻痺2"},
	{"sound", "しびれ3", "paralyze3", "paralyze3", nullptr, "paralyze3", "마비3", "麻痺3"},
	{"sound", "ジャンプ1", "jump1", "jump1", nullptr, "jump1", "점프1", "跳躍1"},
	{"sound", "ジャンプ2", "jump2", "jump2", nullptr, "jump2", "점프2", "跳躍2"},
	{"sound", "ショット1", "shot1", "shot1", nullptr, "laser1", "쇼트1", "發射1"},
	{"sound", "ショット2", "shot2", "shot2", nullptr, "laser2", "쇼트2", "發射2"},
	{"sound", "ショット3", "shot3", "shot3", nullptr, "laser3", "쇼트3", "發射3"},
	{"sound", "スイッチ1", "switch1", "switch1", nullptr, "switch1", "스위치1", "開關1"},
	{"sound", "スイッチ2", "switch2", "switch2", nullptr, "switch2", "스위치2", "開關2"},
	{"sound", "ダウン", "debuff", "decrease", nullptr, "downgrade", "다운", "下降"},
	{"sound", "ダメージ1", "damage1", "damage1", nullptr, "damege1", "데미지1", "傷害1"},
	{"sound", "ダメージ2", "damage2", "damage2", nullptr, "damege2", "데미지2", "傷害2"},
	{"sound", "テレポート1", "teleport1", "teleport1", nullptr, "teleport1", "텔레포트1", "傳送1"},
	{"sound", "テレポート2", "teleport2", "teleport2", nullptr, "teleport2", "텔레포트2", "傳送2"},
	{"sound", "トラ", "tiger", "tiger", nullptr, "tiger", "트럭", "虎"},
	{"sound", "にらみ", "glare", "gaze", nullptr, "glare", "노려봄", "凝視"},
	{"sound", "にわとり", "chicken", "chicken", nullptr, "chicken", "닭", "雞"},
	{"sound", "ネコ", "cat", "cat", nullptr, "cat", "고양이", "貓"},
	{"sound", "ノック", "knock", "knock", nullptr, "knock", "노크", "敲"},
	{"sound", "はずれ1", "buzzer1", "failure1", nullptr, "end1", "잘라내기1", "磨擦1"},
	{"sound", "はずれ2", "buzzer2", "failure2", nullptr, "end2", "잘라내기2", "磨擦2"},
	{"sound", "バリア", "barrier", "barrier", nullptr, "barrier", "배리어", "護罩"},
	{"sound", "ひつじ", "sheep", "sheep", nullptr, "sheep", "양", "羊"},
	{"sound", "ブザー1", "buzzer3", "buzzer1", nullptr, "buzzer1", "버저1", "汽笛1"},
	{"sound", "ブザー2", "buzzer4", "buzzer2", nullptr, "buzzer2", "버저2", "汽笛2"},
	{"sound", "フラッシュ1", "flash1", "flash1", nullptr, "flashlight1", "플래시1", "閃爍1"},
	{"sound", "フラッシュ2", "flash2", "flash2", nullptr, "flashlight2", "플래시2", "閃爍2"},
	{"sound", "フラッシュ3", "flash3", "flash3", nullptr, "flashlight3", "플래시3", "閃爍3"},
	{"sound", "ブレス", "breath", "breath", nullptr, "breath", "호흡", "氣息"},
	{"sound", "モンスター1", "monster1", "monster1", nullptr, "monster1", "몬스터1", "怪物1"},
	{"sound", "モンスター2", "monster2", "monster2", nullptr, "monster2", "몬스터2", "怪物2"},
	{"sound", "ライオン", "lion", "lion", nullptr, "lion", "사자", "獅"},
	{"sound", "冷気1", "ice1", "ice01", nullptr, "ice1", "냉기1", "冰1"},
	{"sound", "冷気2", "ice2", "ice04", nullptr, "ice2", "냉기2", "冰2"},
	{"sound", "冷気3", "ice3", "ice05", nullptr, "ice3", "냉기3", "冰3"},
	{"sound", "冷気4", "ice4", "ice06", nullptr, "ice4", "냉기4", "冰4"},
	{"sound", "冷気5", "ice5", "ice07", nullptr, "ice5", "냉기5", "冰5"},
	{"sound", "冷気6", "ice6", "ice08", nullptr, "ice6", "냉기6", "冰6"},
	{"sound", "冷気7", "ice7", "ice09", nullptr, "ice7", "냉기7", "冰7"},
	{"sound", "冷気8", "ice8", "ice10", nullptr, "ice8", "냉기8", "冰8"},
	{"sound", "冷気9", "ice9", "ice11", nullptr, "ice9", "냉기9", "冰9"},
	{"sound", "冷気10", "ice10", "ice02", nullptr, "ice10", "냉기10", "冰10"},
	{"sound", "冷気11", "ice11", "ice03", nullptr, "ice11", "냉기11", "冰11"},
	{"sound", "剣1", "sword1", "sword1", nullptr, "sword1", "검1", "劍1"},
	{"sound", "剣2", "sword2", "sword2", nullptr, "sword2", "검2", "劍2"},
	{"sound", "剣3", "sword3", "sword3", nullptr, "sword3", "검3", "劍3"},
	{"sound", "吸収1", "absorb1", "absorb1", nullptr, "absorption1", "흡수1", "吸收1"},
	{"sound", "吸収2", "absorb2", "absorb2", nullptr, "absorption2", "흡수2", "吸收2"},
	{"sound", "噛む", "bite", "bloodsuck", nullptr, "bite", "물다", "咬"},
	{"sound", "回復1", "recovery1", "heal1", nullptr, "recovery1", "회복1", "回復1"},
	{"sound", "回復2", "recovery2", "heal2", nullptr, "recovery2", "회복2", "回復2"},
	{"sound", "回復3", "recovery3", "heal3", nullptr, "recovery3", "회복3", "回復3"},
	{"sound", "回復4", "recovery4", "heal4", nullptr, "recovery4", "회복4", "回復4"},
	{"sound", "回復5", "recovery5", "heal5", nullptr, "recovery5", "회복5", "回復5"},
	{"sound", "回復6", "recovery6", "heal6", nullptr, "recovery6", "회복6", "回復6"},
	{"sound", "回復7", "recovery7", "heal7", nullptr, "recovery7", "회복7", "回復7"},
	{"sound", "回復8", "recovery8", "heal8", nullptr, "recovery8", "회복8", "回復8"},
	{"sound", "回避1", "evade1", "evade1", nullptr, "evasion1", "회피1", "迴避1"},
	{"sound", "回避2", "evade2", "evade2", nullptr, "evasion2", "회피2", "迴避2"},
	{"sound", "地震1", "earthquake1", "quake1", nullptr, "earthquake1", "지진1", "地震1"},
	{"sound", "地震2", "earthquake2", "quake2", nullptr, "earthquake2", "지진2", "地震2"},
	{"sound", "壁1", "barrier1", "bump1", nullptr, "wall1", "벽1", "壁1"},
	{"sound", "壁2", "barrier2", "bump2", nullptr, "wall2", "벽2", "壁2"},
	{"sound", "大地1", "earth1", "earth01", nullptr, "earth1", "대지1", "大地1"},
	{"sound", "大地2", "earth2", "earth02", nullptr, "earth2", "대지2", "大地2"},
	{"sound", "大地3", "earth3", "earth03", nullptr, "earth3", "대지3", "大地3"},
	{"sound", "大地4", "earth4", "earth04", nullptr, "earth4", "대지4", "大地4"},
	{"sound", "大地5", "earth5", "earth05", nullptr, "earth5", "대지5", "大地5"},
	{"sound", "大地6", "earth6", "earth06", nullptr, "earth6", "대지6", "大地6"},
	{"sound", "大地7", "earth7", "earth07", nullptr, "earth7", "대지7", "大地7"},
	{"sound", "大地8", "earth8", "earth08", nullptr, "earth8", "대지8", "大地8"},
	{"sound", "大地9", "earth9", "earth09", nullptr, "earth9", "대지9", "大地9"},
	{"sound", "大地10", "earth10", "earth10", nullptr, "earth10", "대지10", "大地10"},
	{"sound", "巻き付き", "ensnare", "ensnare", nullptr, "vortex", "달라붙기", "捲襲"},
	{"sound", "弓1", "bow1", "bow1", nullptr, "bow1", "활1", "弓1"},
	{"sound", "弓2", "bow2", "bow2", nullptr, "bow2", "활2", "弓2"},
	{"sound", "戦闘1", "combat1", "battle1", nullptr, "battle1", "전투1", "戰鬥1"},
	{"sound", "戦闘2", "combat2", "battle2", nullptr, "battle2", "전투2", "戰鬥2"},
	{"sound", "打撃1", "blow1", "punch1", nullptr, "blow1", "타격1", "打擊1"},
	{"sound", "打撃2", "blow2", "punch2", nullptr, "blow2", "타격2", "打擊2"},
	{"sound", "打撃3", "blow3", "punch3", nullptr, "blow3", "타격3", "打擊3"},
	{"sound", "打撃4", "blow4", "punch4", nullptr, "blow4", "타격4", "打擊4"},
	{"sound", "打撃5", "blow5", "punch5", nullptr, "blow5", "타격5", "打擊5"},
	{"sound", "打撃6", "blow6", "punch6", nullptr, "blow6", "타격6", "打擊6"},
	{"sound", "打撃7", "blow7", "punch7", nullptr, "blow7", "타격7", "打擊7"},
	{"sound", "攻撃1", "attack1", "attack1", nullptr, "attack1", "공격1", "攻擊1"},
	{"sound", "攻撃2", "attack2", "attack2", nullptr, "attack2", "공격2", "攻擊2"},
	{"sound", "斬る1", "slash1", "strike01", nullptr, "cut1", "벤다1", "斬1"},
	{"sound", "斬る10", "slash10", "strike10", nullptr, "cut10", "벤다10", "斬10"},
	{"sound", "斬る11", "slash11", "strike11", nullptr, "cut11", "벤다11", "斬11"},
	{"sound", "斬る2", "slash2", "strike02", nullptr, "cut2", "벤다2", "斬2"},
	{"sound", "斬る3", "slash3", "strike03", nullptr, "cut3", "벤다3", "斬3"},
	{"sound", "斬る4", "slash4", "strike04", nullptr, "cut4", "벤다4", "斬4"},
	{"sound", "斬る5", "slash5", "strike05", nullptr, "cut5", "벤다5", "斬5"},
	{"sound", "斬る6", "slash6", "strike06", nullptr, "cut6", "벤다6", "斬6"},
	{"sound", "斬る7", "slash7", "strike07", nullptr, "cut7", "벤다7", "斬7"},
	{"sound", "斬る8", "slash8", "strike08", nullptr, "cut8", "벤다8", "斬8"},
	{"sound", "斬る9", "slash9", "strike09", nullptr, "cut9", "벤다9", "斬9"},
	{"sound", "時計", "clock", "clock", nullptr, "clock", "시계", "時鐘"},
	{"sound", "暗闇", "blind", "night", nullptr, "darkness", "안보임", "黑暗"},
	{"sound", "暗黒1", "darkness1", "dark1", nullptr, "darkness1", "암흑1", "暗黑1"},
	{"sound", "暗黒2", "darkness2", "dark2", nullptr, "darkness2", "암흑2", "暗黑2"},
	{"sound", "暗黒3", "darkness3", "dark3", nullptr, "darkness3", "암흑3", "暗黑3"},
	{"sound", "暗黒4", "darkness4", "dark4", nullptr, "darkness4", "암흑4", "暗黑4"},
	{"sound", "暗黒5", "darkness5", "dark5", nullptr, "darkness5", "암흑5", "暗黑5"},
	{"sound", "暗黒6", "darkness6", "dark6", "dark6", "darkness6", "암흑6", "暗黑6"},
	{"sound", "歌", "song", "song", nullptr, "song", "노래", "歌"},
	{"sound", "毒", "poison", "poison", nullptr, "poison", "독", "毒"},
	{"sound", "水1", "water1", "water1", nullptr, "water1", "물1", "水1"},
	{"sound", "水2", "water2", "water2", nullptr, "water2", "물2", "水2"},
	{"sound", "水3", "water3", "water3", nullptr, "water3", "물3", "水3"},
	{"sound", "水4", "water4", "water4", nullptr, "water4", "물4", "水4"},
	{"sound", "水5", "water5", "water5", nullptr, "water5", "물5", "水5"},
	{"sound", "水6", "water6", "water6", nullptr, "water6", "물6", "水6"},
	{"sound", "決定1", "decision1", "choice1", nullptr, "decision1", "결정1", "決定1"},
	{"sound", "決定2", "decision2", "choice2", nullptr, "decision2", "결정2", "決定2"},
	{"sound", "沈黙", "silence", "silence", nullptr, "silence", "침묵", "沉默"},
	{"sound", "海1", "sea1", "sea1", nullptr, "sea1", "바다1", "海1"},
	{"sound", "海2", "sea2", "sea2", nullptr, "sea2", "바다2", "海2"},
	{"sound", "消滅1", "collapse1", "vanish1", nullptr, "disappearance1", "소멸1", "消滅1"},
	{"sound", "消滅2", "collapse2", "vanish2", nullptr, "disappearance2", "소멸2", "消滅2"},
	{"sound", "混乱", "confusion", "confuse", nullptr, "caos", "혼란", "混亂"},
	{"sound", "炎1", "fire1", "fire1", nullptr, "flame1", "화염1", "炎1"},
	{"sound", "炎2", "fire2", "fire2", nullptr, "flame2", "화염2", "炎2"},
	{"sound", "炎3", "fire3", "fire3", nullptr, "flame3", "화염3", "炎3"},
	{"sound", "炎4", "fire4", "fire4", nullptr, "flame4", "화염4", "炎4"},
	{"sound", "炎5", "fire5", "fire5", nullptr, "flame5", "화염5", "炎5"},
	{"sound", "炎6", "fire6", "fire6", nullptr, "flame6", "화염6", "炎6"},
	{"sound", "炎7", "fire7", "fire7", nullptr, "flame7", "화염7", "炎7"},
	{"sound", "炎8", "fire8", "fire8", nullptr, "flame8", "화염8", "炎8"},
	{"sound", "爆発1", "explosion1", "explode1", nullptr, "explosion1", "폭발1", "爆發1"},
	{"sound", "爆発2", "explosion2", "explode2", nullptr, "explosion2", "폭발2", "爆發2"},
	{"sound", "爆発3", "explosion3", "explode3", nullptr, "explosion3", "폭발3", "爆發3"},
	{"sound", "爆発4", "explosion4", "explode4", nullptr, "explosion4", "폭발4", "爆發4"},
	{"sound", "爆発5", "explosion5", "explode5", nullptr, "explosion5", "폭발5", "爆發5"},
	{"sound", "爆発6", "explosion6", "explode6", nullptr, "explosion6", "폭발6", "爆發6"},
	{"sound", "爆発7", "explosion7", "explode7", nullptr, "explosion7", "폭발7", "爆發7"},
	{"sound", "睡眠", "sleep", "sleep", nullptr, "sleep", "수면", "睡眠"},
	{"sound", "砂けむり", "sandstorm", "sandstorm", nullptr, "sandmind", "모래 연기", "沙塵暴"},
	{"sound", "神聖1", "holy1", "holy1", nullptr, "holy1", "신성1", "神聖1"},
	{"sound", "神聖2", "holy2", "holy2", nullptr, "holy2", "신성2", "神聖2"},
	{"sound", "神聖3", "holy3", "holy3", nullptr, "holy3", "신성3", "神聖3"},
	{"sound", "神聖4", "holy4", "holy4", nullptr, "holy4", "신성4", "神聖4"},
	{"sound", "神聖5", "holy5", "holy5", nullptr, "holy5", "신성5", "神聖5"},
	{"sound", "神聖6", "holy6", "holy6", nullptr, "holy6", "신성6", "神聖6"},
	{"sound", "神聖7", "holy7", "holy7", nullptr, "holy7", "신성7", "神聖7"},
	{"sound", "神聖8", "holy8", "holy8", nullptr, "holy8", "신성8", "神聖8"},
	{"sound", "神聖9", "holy9", "holy9", nullptr, "holy9", "신성9", "神聖9"},
	{"sound", "移動", "move", "footstep", nullptr, "run", "이동", "移動"},
	{"sound", "花粉", "pollen", "pollen", nullptr, "pollen", "꽃가루", "花粉"},
	{"sound", "落ちる1", "fall1", "fall1", nullptr, "fall1", "떨어진다1", "落下1"},
	{"sound", "落ちる2", "fall2", "fall2", nullptr, "fall2", "떨어진다2", "落下2"},
	{"sound", "蘇生1", "raise1", "revive1", nullptr, "revival1", "소생1", "復活1"},
	{"sound", "蘇生2", "raise2", "revive2", nullptr, "revival2", "소생2", "復活2"},
	{"sound", "蘇生3", "raise3", "revive3", nullptr, "revival3", "소생3", "復活3"},
	{"sound", "逃走", "escape", "flee", nullptr, "escape", "도주", "逃走"},
	{"sound", "鍵", "key", "key", nullptr, "key", "자물쇠", "鑰匙"},
	{"sound", "鐘", "bell", "gong", nullptr, "bell", "종", "鐘"},
	{"sound", "閉める1", "close1", "close1", nullptr, "close1", "닫는다1", "關閉1"},
	{"sound", "閉める2", "close2", "close2", nullptr, "close2", "닫는다2", "關閉2"},
	{"sound", "開ける1", "open1", "open1", nullptr, "open1", "열다1", "開啟1"},
	{"sound", "開ける2", "open2", "open2", nullptr, "open2", "열다2", "開啟2"},
	{"sound", "雨1", "rain1", "rain1", nullptr, "rain1", "비1", "雨1"},
	{"sound", "雨2", "rain2", "rain2", nullptr, "rain2", "비2", "雨2"},
	{"sound", "雷1", "thunder1", "bolt01", nullptr, "thunder1", "전격1", "雷1"},
	{"sound", "雷2", "thunder2", "bolt02", nullptr, "thunder2", "전격2", "雷2"},
	{"sound", "雷3", "thunder3", "bolt03", nullptr, "thunder3", "전격3", "雷3"},
	{"sound", "雷4", "thunder4", "bolt04", nullptr, "thunder4", "전격4", "雷4"},
	{"sound", "雷5", "thunder5", "bolt05", nullptr, "thunder5", "전격5", "雷5"},
	{"sound", "雷6", "thunder6", "bolt06", nullptr, "thunder6", "전격6", "雷6"},
	{"sound", "雷7", "thunder7", "bolt07", nullptr, "thunder7", "전격7", "雷7"},
	{"sound", "雷8", "thunder8", "bolt08", nullptr, "thunder8", "전격8", "雷8"},
	{"sound", "雷9", "thunder9", "bolt09", nullptr, "thunder9", "전격9", "雷9"},
	{"sound", "雷10", "thunder10", "bolt10", nullptr, "thunder10", "전격10", "雷10"},
	{"sound", "霧1", "fog1", "fog1", nullptr, "fog1", "안개1", "霧1"},
	{"sound", "霧2", "fog2", "fog2", nullptr, "fog2", "안개2", "霧2"},
	{"sound", "音波1", "wave1", "wave1", nullptr, "sound wave1", "음파1", "音波1"},
	{"sound", "音波2", "wave2", "wave2", nullptr, "sound wave2", "음파2", "音波2"},
	{"sound", "風1", "wind1", "wind01", nullptr, "wind1", "바람1", "風1"},
	{"sound", "風2", "wind2", "wind02", nullptr, "wind2", "바람2", "風2"},
	{"sound", "風3", "wind3", "wind03", nullptr, "wind3", "바람3", "風3"},
	{"sound", "風4", "wind4", "wind04", nullptr, "wind4", "바람4", "風4"},
	{"sound", "風5", "wind5", "wind05", nullptr, "wind5", "바람5", "風5"},
	{"sound", "風6", "wind6", "wind06", nullptr, "wind6", "바람6", "風6"},
	{"sound", "風7", "wind7", "wind07", nullptr, "wind7", "바람7", "風7"},
	{"sound", "風8", "wind8", "wind08", nullptr, "wind8", "바람8", "風8"},
	{"sound", "風9", "wind9", "wind09", nullptr, "wind9", "바람9", "風9"},
	{"sound", "風10", "wind10", "wind10", nullptr, "wind10", "바람10", "風10"},
	{"sound", "風11", "wind11", "wind11", nullptr, "wind11", "바람11", "風11"},
	{"sound", "魔法1", "magic1", "magic1", nullptr, "magic1", "마법1", "魔法1"},
	{"sound", "魔法2", "magic2", "magic2", nullptr, "magic2", "마법2", "魔法2"},
	{"system", "システム", "system", "system1", "system", "system", "시스템", "系統"},
	{"system", "システムa", "systema", "system2", "systema", "systema", "시스템a", "系統a"},
	{"system", "システムb", "systemb", "system3", "systemb", "systemb", "시스템b", "系統b"},
	{"system", "システムc", "systemc", "system4", "systemc", "systemc", "시스템c", "系統c"},
	{"system2", "システム２a", "system2a", "system2a", "system2a", "systeméqa", "시스템２a", "系統2a"},
	{"system2", "システム２b", "system2b", "system2b", "system2b", "systeméqb", "시스템２b", "系統2b"},
	{"system2", "システム２c", "system2c", "system2c", "system2c", "systeméqc", "시스템２c", "系統2c"},
	{"title", "タイトル1", "title1", "title1", "title1", "title1", "타이틀1", "標題1"},
	{"title", "タイトル2", "title2", "title2", "title2", "title2", "타이틀2", "標題2"},
	{"title", "タイトル3", "title3", "title3", "title3", "title3", "타이틀3", "標題3"},
	{"title", "タイトル4", "title4", "title4", "title4", "title4", "타이틀4", "標題4"},
	{nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr}
};

const char* const rtp_table_2k3_categories[16] = {
	"backdrop",
	"battle",
	"battlecharset",
	"battleweapon",
	"charset",
	"chipset",
	"faceset",
	"gameover",
	"monster",
	"music",
	"panorama",
	"sound",
	"system",
	"system2",
	"title",
	nullptr
};

const int rtp_table_2k3_categories_idx[16] = {
	0,
	34,
	88,
	152,
	153,
	168,
	173,
	178,
	180,
	295,
	446,
	459,
	665,
	669,
	672,
	676
};

}
