#!/bin/bash

# Bestätigt, dass der geänderte Repository-Pfad in Ordnung ist.
export BORG_RELOCATED_REPO_ACCESS_IS_OK=yes

# Define the repository and archive name
REPO="/mnt/borgbackup"

# Distribution-ID aus der os-release-Datei extrahieren
DISTRIB_ID=$(grep '^ID=' /etc/os-release | cut -d= -f2 | tr -d '"')

# Versionsnummer aus der os-release-Datei extrahieren
VERSION_ID=$(grep '^VERSION_ID=' /etc/os-release | cut -d= -f2 | tr -d '"')

# Archivnamen mit allen Variablen erstellen
ARCHIVE_NAME="{hostname}_root_${DISTRIB_ID}-${VERSION_ID}_{now}"

# Define the source directory to back up
SOURCE_DIR="/"

# Define the exclude file
EXCLUDE_FILE="/etc/htmborgbackup.list"

# Define the borg options
BORG_OPTIONS="--list --exclude-from $EXCLUDE_FILE -p --stats --compression=zstd"

# Clear lock flag
borg break-lock $REPO

# Parse command-line options
DRY_RUN=0
for arg in "$@"; do
    case "$arg" in
        --dry-run)
            DRY_RUN=1
            shift
            ;;
        *)
            # Ignore other arguments for now
            ;;
    esac
done

# Perform the backup
if [ $DRY_RUN -eq 1 ]; then
    echo "Dry run enabled. The following command would be executed:"
    borg create --dry-run $BORG_OPTIONS $REPO::$ARCHIVE_NAME $SOURCE_DIR
else
    borg create $BORG_OPTIONS $REPO::$ARCHIVE_NAME $SOURCE_DIR
fi
